/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.authentication.ExternalAuthToken;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.base.UserInfo;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.catalina.realm.GenericPrincipal;
import org.dogtagpki.server.authentication.AuthToken;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class SessionContextInterceptor
implements ContainerRequestFilter {
    public static Logger logger = LoggerFactory.getLogger(SessionContextInterceptor.class);
    @Context
    HttpServletRequest servletRequest;
    @Context
    SecurityContext securityContext;

    public Locale getLocale(HttpServletRequest req) {
        String lang = req.getHeader("accept-language");
        if (lang == null) {
            return Locale.getDefault();
        }
        return new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        Method method = methodInvoker.getMethod();
        Class clazz = methodInvoker.getResourceClass();
        logger.debug("SessionContextInterceptor: " + clazz.getSimpleName() + "." + method.getName() + "()");
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal == null) {
            logger.debug("SessionContextInterceptor: Not authenticated.");
            SessionContext.releaseContext();
            return;
        }
        logger.debug("SessionContextInterceptor: principal: " + principal.getName());
        AuthToken authToken = null;
        if (principal instanceof PKIPrincipal) {
            authToken = ((PKIPrincipal)((Object)principal)).getAuthToken();
        } else if (principal instanceof GenericPrincipal) {
            authToken = new ExternalAuthToken((GenericPrincipal)principal);
        }
        if (authToken == null) {
            logger.warn("SessionContextInterceptor: No authorization token present.");
            throw new ForbiddenException("No authorization token present.");
        }
        SessionContext context = SessionContext.getContext();
        String ip = this.servletRequest.getRemoteAddr();
        context.put((Object)"ipAddress", (Object)ip);
        Locale locale = this.getLocale(this.servletRequest);
        context.put((Object)"locale", (Object)locale);
        context.put((Object)"AuthToken", (Object)authToken);
        context.put((Object)"userid", (Object)principal.getName());
        if (principal instanceof PKIPrincipal) {
            context.put((Object)"user", (Object)((PKIPrincipal)((Object)principal)).getUser());
        }
    }
}

