/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import java.util.HashMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ReformatContentTypeResponseFilter
implements ContainerResponseFilter {
    private static Logger logger = LoggerFactory.getLogger(ReformatContentTypeResponseFilter.class);
    private static String[] verbatim = new String[]{"application/pkcs7-mime; smime-type=certs-only"};
    private static HashMap<MediaType, String> substitutions = new HashMap();

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        logger.debug("ReformatContentTypeResponseFilter: inspecting response");
        Object v = responseContext.getHeaders().getFirst((Object)"Content-Type");
        if (v != null && v instanceof MediaType && substitutions.containsKey(v)) {
            responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)substitutions.get(v));
        }
    }

    static {
        for (String s : verbatim) {
            substitutions.put(MediaType.valueOf((String)s), s);
        }
    }
}

