#line 2 "pgc.c"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 * The ecpg scanner is not backup-free, so the fail rules are
 * only here to simplify syncing this file with scan.l.
 *
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <limits.h>

#include "common/string.h"

#include "preproc_extern.h"
#include "preproc.h"

#line 32 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer base_yy_create_buffer
#define yy_delete_buffer base_yy_delete_buffer
#define yy_scan_buffer base_yy_scan_buffer
#define yy_scan_string base_yy_scan_string
#define yy_scan_bytes base_yy_scan_bytes
#define yy_init_buffer base_yy_init_buffer
#define yy_flush_buffer base_yy_flush_buffer
#define yy_load_buffer_state base_yy_load_buffer_state
#define yy_switch_to_buffer base_yy_switch_to_buffer
#define yypush_buffer_state base_yypush_buffer_state
#define yypop_buffer_state base_yypop_buffer_state
#define yyensure_buffer_stack base_yyensure_buffer_stack
#define yy_flex_debug base_yy_flex_debug
#define yyin base_yyin
#define yyleng base_yyleng
#define yylex base_yylex
#define yylineno base_yylineno
#define yyout base_yyout
#define yyrestart base_yyrestart
#define yytext base_yytext
#define yywrap base_yywrap
#define yyalloc base_yyalloc
#define yyrealloc base_yyrealloc
#define yyfree base_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define base_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer base_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define base_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer base_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define base_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer base_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define base_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string base_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define base_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes base_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define base_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer base_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define base_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer base_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define base_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state base_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define base_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer base_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define base_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state base_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define base_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state base_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define base_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack base_yyensure_buffer_stack
#endif

#ifdef yylex
#define base_yylex_ALREADY_DEFINED
#else
#define yylex base_yylex
#endif

#ifdef yyrestart
#define base_yyrestart_ALREADY_DEFINED
#else
#define yyrestart base_yyrestart
#endif

#ifdef yylex_init
#define base_yylex_init_ALREADY_DEFINED
#else
#define yylex_init base_yylex_init
#endif

#ifdef yylex_init_extra
#define base_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra base_yylex_init_extra
#endif

#ifdef yylex_destroy
#define base_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy base_yylex_destroy
#endif

#ifdef yyget_debug
#define base_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug base_yyget_debug
#endif

#ifdef yyset_debug
#define base_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug base_yyset_debug
#endif

#ifdef yyget_extra
#define base_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra base_yyget_extra
#endif

#ifdef yyset_extra
#define base_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra base_yyset_extra
#endif

#ifdef yyget_in
#define base_yyget_in_ALREADY_DEFINED
#else
#define yyget_in base_yyget_in
#endif

#ifdef yyset_in
#define base_yyset_in_ALREADY_DEFINED
#else
#define yyset_in base_yyset_in
#endif

#ifdef yyget_out
#define base_yyget_out_ALREADY_DEFINED
#else
#define yyget_out base_yyget_out
#endif

#ifdef yyset_out
#define base_yyset_out_ALREADY_DEFINED
#else
#define yyset_out base_yyset_out
#endif

#ifdef yyget_leng
#define base_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng base_yyget_leng
#endif

#ifdef yyget_text
#define base_yyget_text_ALREADY_DEFINED
#else
#define yyget_text base_yyget_text
#endif

#ifdef yyget_lineno
#define base_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno base_yyget_lineno
#endif

#ifdef yyset_lineno
#define base_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno base_yyset_lineno
#endif

#ifdef yywrap
#define base_yywrap_ALREADY_DEFINED
#else
#define yywrap base_yywrap
#endif

#ifdef yyalloc
#define base_yyalloc_ALREADY_DEFINED
#else
#define yyalloc base_yyalloc
#endif

#ifdef yyrealloc
#define base_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc base_yyrealloc
#endif

#ifdef yyfree
#define base_yyfree_ALREADY_DEFINED
#else
#define yyfree base_yyfree
#endif

#ifdef yytext
#define base_yytext_ALREADY_DEFINED
#else
#define yytext base_yytext
#endif

#ifdef yyleng
#define base_yyleng_ALREADY_DEFINED
#else
#define yyleng base_yyleng
#endif

#ifdef yyin
#define base_yyin_ALREADY_DEFINED
#else
#define yyin base_yyin
#endif

#ifdef yyout
#define base_yyout_ALREADY_DEFINED
#else
#define yyout base_yyout
#endif

#ifdef yy_flex_debug
#define base_yy_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug base_yy_flex_debug
#endif

#ifdef yylineno
#define base_yylineno_ALREADY_DEFINED
#else
#define yylineno base_yylineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define base_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 142
#define YY_END_OF_BUFFER 143
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[578] =
    {   0,
        0,    0,   10,   10,    0,    0,    0,    0,    0,    0,
        9,    9,    0,    0,    0,    0,   19,   19,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  143,  141,   10,   17,    5,    5,
        6,    6,   42,   38,   44,   39,   44,    9,   23,   17,
       20,   19,   19,   19,   19,   24,   24,   17,   29,   23,
       33,   33,   35,   40,  132,  132,  130,   89,   89,  130,
      130,  111,   89,   89,  111,   43,  111,   71,   83,  111,
       12,   87,   88,   82,   85,   81,   86,  111,   84,   59,

       59,   79,   80,  111,   94,  111,   77,   77,   92,   93,
       90,  111,   91,   69,    1,    1,   55,   36,   55,   53,
       54,   55,   14,   54,   54,   54,   54,   59,   54,   54,
       54,   54,   68,   68,   68,   68,   68,   68,  140,  140,
      140,  140,  136,  136,  135,  134,  133,  117,  117,   10,
        5,    7,    4,    3,   42,   41,   44,    9,   23,   21,
       19,   19,   19,   19,   18,   19,   19,   24,   26,   27,
       26,   26,   26,   22,   33,   32,   34,    0,    0,  131,
        0,    0,    0,    0,    0,  103,    0,    0,    0,    0,
        0,    0,  108,   99,    0,   78,  106,  100,  104,  101,

      105,   95,  110,   60,    2,    0,  107,   60,   59,    0,
       73,   97,  102,   96,   77,   77,   98,    1,    0,   55,
       52,   55,    0,    0,   30,   56,   31,    1,   46,   60,
        2,   60,   59,   64,   64,   45,   47,   67,   49,   51,
       48,   50,   68,    8,   15,   13,    0,   11,    0,  139,
        0,    0,    0,  135,  133,    0,    0,  116,    3,   19,
       19,   19,   19,   27,    0,    0,   28,   34,    0,    0,
        0,    0,    0,   76,   76,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  109,    2,    0,
       72,   61,   60,   63,   62,   73,   77,   55,   55,   57,

       31,    1,    1,   65,   65,    2,   60,   59,   63,   62,
       67,    0,    0,    0,   37,   16,  138,  137,   19,   19,
       18,   19,   19,   27,    0,    0,   28,    0,    0,    0,
        0,    0,    0,    0,    0,   76,   76,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   77,   55,
        0,   60,   59,   66,   67,    0,    0,    0,   67,  138,
      138,  137,  137,   19,    0,    0,  125,    0,    0,    0,
        0,    0,    0,    0,   76,   76,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       77,   55,   55,    0,   60,   60,   67,    0,    0,    0,

        0,    0,   25,  125,    0,  127,    0,  121,    0,    0,
        0,    0,    0,    0,   76,   76,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  115,    0,   77,   55,
        0,    0,   60,    0,    0,    0,    0,   67,   67,    0,
        0,  129,  121,  123,    0,    0,    0,    0,  113,    0,
      115,    0,   70,   58,    0,    0,    0,    0,    0,   67,
        0,  123,    0,    0,    0,   74,   74,  113,  119,   70,
       70,   77,   77,   77,   77,   58,   67,    0,    0,    0,
        0,   74,   74,   74,    0,   74,    0,  119,    0,    0,
        0,   77,   77,   77,   77,   77,   77,   58,   67,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,   77,
       77,   77,   77,   77,   77,   77,   77,  124,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   77,   77,   77,
       77,   77,   77,   77,   77,  124,    0,  126,    0,  120,
        0,    0,    0,    0,    0,    0,   77,   77,   77,   77,
       77,   77,    0,  128,  120,  122,   75,   75,    0,    0,
      114,   77,   77,   77,  114,  122,   75,   75,   75,   75,
      112,    0,  112,   77,  118,  118,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   28,   29,   30,   31,   32,   33,   34,
       35,   35,   36,   35,   35,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   35,   35,   47,   35,   35,
       48,   49,   50,   51,   52,   28,   29,   30,   31,   32,

       33,   34,   35,   35,   53,   35,   35,   37,   38,   39,
       40,   41,   42,   43,   44,   45,   54,   35,   35,   55,
       35,   35,   56,   57,   58,   28,    1,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59
    } ;

static const YY_CHAR yy_meta[60] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   13,   14,
       14,   14,   15,   16,   17,   18,   19,    4,   20,   20,
       20,   20,   20,   20,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   22,   23,    9,
        4,   21,   21,   21,   21,    1,    4,    1,   21
    } ;

static const flex_int16_t yy_base[654] =
    {   0,
        0,    0, 2225, 2218,    0,   53, 2222, 2221,    0,    5,
     2215, 2214, 2212, 2211, 2210, 2209,   18,   27,    1,   34,
        7,   12,    0,   30, 2213, 2212, 2206, 2202,  110,    0,
       38,  168,  201,    0,  260,    0,   28,   60,   71,  171,
      319,    0,  378,    0, 2211, 2785,    0, 2785,    0,    0,
       29, 2196,    0, 2200, 2785, 2785,   10,    0,    0, 2194,
     2785,   86,   89,  175, 2187,    0,    0, 2192,  418, 2191,
        0,    0, 2192, 2190, 2785,  438, 2785, 2785, 2785,  147,
       22, 2785,   94,  186, 2169, 2785,   11,  412, 2168, 2183,
     2785, 2785, 2785,  168,   50, 2785,   82,  177,  433,  435,

      456, 2785, 2785, 2167, 2164, 2162,    0,   39, 2785, 2785,
     2785, 2131, 2785, 2785,  447,  477, 2161, 2785,  486,  477,
        0,    0, 2785, 2785, 2169,  449, 2171,  486,   13,  158,
     2157, 2153,    0, 2167, 2166, 2164, 2162, 2160, 2145,    0,
     2785,    0, 2785,  514, 2785, 2785,    0, 2785,  521,    0,
        0,   88, 2785,    0,    0, 2785, 2785,    0,    0, 2785,
      524,  529, 2151,  545, 2785, 2147,  548,    0, 2785,  440,
        0,    0,    0, 2785,    0, 2785, 2155,  551,  555, 2785,
      449, 2128, 2128,  564,  410, 2785,  579,  496,  535, 2127,
      453, 2119, 2785, 2785,  496, 2785, 2785, 2785, 2785, 2785,

     2785, 2143, 2785,  619,    0, 2153, 2785,  624,  629,  638,
        0, 2785, 2785, 2785,    0, 2122, 2785,  661,  508,    0,
        0,  664,  526,  538, 2785,  655, 2146,  717, 2785,  664,
        0,  678,  683, 2785,  692, 2785, 2785,  670,    0,    0,
        0,    0,    0, 2785, 2785, 2785,  637, 2785, 2129, 2785,
     2146, 2098,  726, 2785,    0,  735,  745, 2785,    0,  691,
      749,  753,  758,  500,    0,    0,    0, 2116,  710, 2091,
      470, 2090,  747, 2785,    0, 2105,    0,  769,  497, 2077,
     2086,  531, 2075, 2084, 2080, 2082, 2079, 2785,    0, 2107,
     2785, 2785,  775,  783,  789,    0, 2059,  807, 2033, 2785,

     2016,    0,  860, 2785,  798,    0,  807,  821,  816,  824,
      813, 1974,    0,  845, 2785, 2785,  848,  878,  887,  890,
      910,  920,  916, 2785,    0,    0, 2785, 1941, 1927,  670,
     1924, 1900,  853,  896,  926,  932,  936, 1531, 1531, 1522,
     1524, 1527, 1527, 1517, 1517,  705, 1515, 1518,  939,  981,
      926,  931,  936, 2785,  944,  963,  970,  999, 1008,  973,
     2785, 1015, 2785, 1020,    0,    0, 1025, 1031, 1505, 1504,
     1503, 1038, 1470, 1040, 1496, 1043,  642, 1049, 1475, 1441,
     1428,  429, 1422, 1385, 1370,  626, 1371,  671, 1345, 1062,
     1335,    0,  721, 1049, 1054, 1063,  997, 1106, 1076, 1163,

     1097,    0, 2785, 1116, 1134, 2785, 1137, 1140, 1322, 1317,
     1339,  849, 1323, 1217, 1221, 1224,    0, 1302, 1283, 1289,
        0, 1286, 1262, 1271, 1262, 1236, 1146, 1225, 1213, 1228,
     1131, 1212, 1224, 1273,    0,    0, 1224, 1043, 1330,    0,
     1245, 2785, 1166, 1184, 1249, 1206,    0, 1204, 1252, 1196,
     1256, 1177, 1379, 1241, 1194, 1174,  693, 1405,    0, 1463,
        0, 1284, 1302,  728, 1155, 1289, 1306, 1309, 1312, 1512,
        0, 1141,  834,  844, 1120, 1297, 1566,    0,  872, 1114,
      767, 1323, 1348, 1357, 1106, 1360, 1096, 1363, 1095,  916,
     1086, 1090, 1228, 1073,  821, 1073, 1070, 2785,    0, 1063,

     1062,  823, 1057, 1054, 1044, 1040, 1016, 1017, 1004,  873,
      971,  926,  946,  911,  900,  869,  872, 1366, 1369,  869,
      862,  851,  913,  916,  968,  829,  790,  768, 1372, 1382,
      764,  730,  700,  924,  685, 1385, 1392, 2785, 1395, 1388,
      648,  625,  622,  627,  935,  620,  509, 1398, 1401,  460,
      411, 1405, 1459, 2785, 1424, 1427, 1451, 1466,  163,  149,
     1482, 1485, 1489,   72, 1492, 1495, 1498, 1501, 1504, 1515,
     1518,   49, 1521, 1524, 1527, 1530, 2785, 1625, 1648, 1671,
     1694, 1717, 1740, 1763, 1786, 1809, 1832, 1855, 1878, 1901,
     1924, 1947, 1970, 1993, 2016, 2039, 2061, 2084,  973, 2106,

     2127, 2145, 2163, 2177, 2187, 2194, 2210, 2231, 2254, 2277,
     2295, 2315, 2333, 2352, 1074, 1101, 1113, 2370, 2388, 2407,
     1140, 1400, 2425, 2446, 1403, 2466, 2474, 2490, 2507, 2528,
     2551, 2574, 2592, 2612, 2633, 1159, 1251, 1280, 1521,  557,
     2655, 1326, 1459, 2677, 2695, 1523, 1526, 2717, 2740, 1533,
     2762, 1535, 1536
    } ;

static const flex_int16_t yy_def[654] =
    {   0,
      578,  578,  579,  579,  580,  580,  581,  581,  582,  582,
      583,  583,  584,  584,  584,  584,  585,  585,  586,  586,
      584,  584,  587,  587,  581,  581,  584,  584,  577,   29,
      588,  588,  577,   33,  577,   35,  589,  589,  590,  590,
      577,   41,  577,   43,  577,  577,  591,  577,  592,  592,
      577,  577,  593,  577,  577,  577,  577,  594,  595,  577,
      577,  577,  577,  577,  577,  596,  596,  577,  597,  595,
      598,  598,  599,  577,  577,  600,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  601,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,

      577,  577,  577,  577,  577,  577,  602,  602,  577,  577,
      577,  577,  577,  577,  577,  577,  603,  577,  601,  604,
      603,  603,  577,  577,  603,  577,  603,  605,  606,  603,
      603,  603,  607,  607,  607,  607,  607,  607,  608,  609,
      577,  610,  577,  577,  577,  577,  611,  577,  612,  591,
      592,  577,  577,  613,  593,  577,  577,  594,  595,  577,
      577,  577,  577,  577,  577,  577,  614,  596,  577,  577,
      615,  616,  617,  577,  598,  577,  618,  577,  600,  577,
      577,  577,  577,  577,  601,  577,  577,  187,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,

      577,  577,  577,  577,  619,  620,  577,  577,  577,  577,
      621,  577,  577,  577,  602,  602,  577,  577,  601,  603,
      603,  187,  187,  577,  577,  622,  623,  624,  577,  625,
      626,  625,  627,  577,  577,  577,  577,  628,  603,  603,
      603,  603,  629,  577,  577,  577,  577,  577,  630,  577,
      631,  632,  577,  577,  633,  577,  634,  577,  613,  635,
      614,  614,  614,  577,  636,  637,  638,  618,  577,  577,
      577,  577,  187,  577,  273,  273,  187,  273,  187,  187,
      187,  273,  577,  577,  577,  577,  577,  577,  619,  620,
      577,  577,  577,  577,  577,  621,  602,  273,  298,  577,

      623,  624,  624,  577,  577,  626,  625,  627,  577,  639,
      628,  577,  640,  641,  577,  577,  577,  577,  635,  635,
      635,  635,  614,  577,  642,  643,  577,  577,  577,  577,
      577,  577,  577,  644,  273,  273,  273,  187,  187,  187,
      187,  273,  273,  577,  577,  577,  577,  577,  602,  644,
      577,  625,  627,  577,  645,  641,  641,  641,  641,  577,
      577,  577,  577,  635,  646,  647,  577,  577,  577,  577,
      577,  577,  577,  644,  648,  644,  273,  644,  187,  187,
      187,  187,  273,  273,  577,  577,  577,  577,  577,  577,
      602,  350,  298,  577,  625,  625,  645,  649,  641,  577,

      641,  650,  577,  577,  577,  577,  577,  577,  577,  577,
      648,  577,  273,  644,  644,  644,  187,  187,  187,  187,
      273,  273,  577,  577,  577,  577,  577,  577,  602,  298,
      577,  577,  625,  649,  434,  434,  434,  434,  651,  652,
      577,  577,  577,  577,  577,  187,  273,  577,  577,  577,
      577,  577,  602,  577,  577,  434,  434,  434,  434,  651,
      653,  577,  577,  577,  577,  187,  577,  577,  577,  577,
      470,  602,  602,  602,  602,  577,  577,  647,  577,  577,
      577,  273,  577,  273,  273,  577,  577,  577,  577,  577,
      577,  602,  602,  602,  602,  602,  602,  577,  477,  577,

      577,  577,  577,  577,  273,  577,  577,  577,  577,  602,
      602,  602,  602,  602,  602,  602,  602,  577,  577,  577,
      577,  577,  273,  577,  577,  577,  577,  602,  602,  602,
      602,  602,  602,  602,  602,  577,  577,  577,  577,  577,
      577,  273,  577,  577,  577,  577,  602,  602,  602,  602,
      602,  602,  577,  577,  577,  577,  273,  577,  577,  577,
      577,  602,  602,  602,  577,  577,  273,  577,  273,  577,
      577,  577,  577,  602,  577,  577,    0,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,

      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577
    } ;

static const flex_int16_t yy_nxt[2845] =
    {   0,
      577,  577,   72,   67,   50,   56,   50,   73,   50,   50,
       56,   68,  577,   51,   50,  157,   50,   48,   52,   62,
       63,   64,   48,  577,   50,   50,   50,   50,   62,   63,
       64,  577,   72,  140,   65,  236,   67,   73,  237,   78,
       79,   78,  152,   65,   68,   80,  188,  153,   57,   69,
       50,  141,  142,   57,  141,   70,   50,   50,  157,   50,
       70,   50,   50,  189,  198,  140,   51,   50,  183,   50,
       81,   52,  144,  144,  144,  199,  183,   50,   50,   50,
       50,  575,   69,  141,  142,  216,  141,  161,  162,  162,
      164,  164,  164,  216,  145,  184,  184,  184,  200,  165,

      185,  152,  163,   50,  574,  166,  153,  201,  202,   50,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   75,   75,   75,
       75,   76,   76,   76,   76,   75,   75,   75,   76,   78,
       79,   78,  144,  144,  144,   80,  164,  164,  164,  181,
      572,  195,  182,  239,  240,  165,  196,  184,  184,  184,
      203,  166,  185,  197,  145,  571,  204,  204,  204,  182,

       81,   82,   83,   84,   83,   85,   86,   87,   88,   89,
       90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
      100,  101,  101,  102,  103,  104,  105,  106,   82,  107,
      107,  107,  107,  108,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  109,   82,
      110,   82,  107,  107,  107,  107,  111,  112,  113,  107,
      114,  115,  116,  115,  117,  118,  119,  120,  121,  122,
      123,  124,  124,  121,  121,  124,  125,  126,  127,  128,
      128,  128,  129,  124,  130,  131,  132,  122,  133,  134,
      133,  133,  135,  133,  133,  133,  133,  133,  136,  133,

      133,  133,  133,  133,  133,  137,  138,  124,  114,  124,
      121,  133,  133,  137,  138,  114,  122,  114,  133,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  146,  146,  146,  146,
      147,  147,  147,  147,  146,  146,  146,  147,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,

      148,  148,  148,  148,  148,  148,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  148,  148,  148,  148,  149,
      149,  149,  149,  148,  148,  148,  149,  170,  170,  178,
      178,  178,  564,  190,  181,  188,  205,  191,  218,  218,
      218,  206,  208,  219,  209,  209,  209,  192,  207,  264,
      264,  180,  189,  171,  191,  192,  229,  210,  230,  230,
      230,  172,  173,  208,  420,  209,  209,  209,  218,  218,
      218,  211,  420,  219,  225,  269,  271,  270,  210,  211,
      222,  286,  222,  563,  222,  222,  226,  226,  226,  222,

      222,  331,  222,  232,  222,  233,  233,  233,  332,  195,
      222,  222,  222,  222,  196,  253,  253,  253,  235,  324,
      324,  223,  256,  256,  256,  161,  162,  162,  338,  279,
      164,  164,  164,  280,  281,  339,  222,  254,  224,  165,
      163,  562,  222,  223,  258,  166,  164,  164,  164,  262,
      162,  162,  178,  178,  178,  165,  178,  178,  178,  279,
      224,  166,  342,  280,  263,  184,  184,  184,  282,  343,
      185,  282,  283,  284,  180,  283,  355,  355,  180,  273,
      273,  274,  275,  273,  273,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  276,  273,  273,

      273,  273,  273,  273,  273,  273,  273,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  273,  278,  273,  273,
      273,  277,  277,  277,  273,  273,  273,  273,  204,  204,
      204,  292,  315,  293,  293,  293,  208,  316,  209,  209,
      209,  210,  294,  561,  294,  377,  210,  295,  295,  295,
      413,  210,  218,  218,  218,  559,  558,  219,  298,  557,
      298,  424,  298,  298,  226,  226,  226,  298,  298,  424,
      298,  556,  299,  230,  230,  230,  312,  313,  298,  298,
      298,  298,  320,  164,  164,  292,  305,  307,  307,  307,

      232,  321,  308,  308,  308,  369,  309,  322,  309,  437,
      305,  310,  310,  310,  298,  235,  426,  314,  552,  458,
      298,  303,  369,  303,  426,  303,  303,  253,  253,  253,
      303,  303,  550,  303,  393,  303,  256,  256,  256,  430,
      387,  303,  303,  303,  303,  328,  256,  256,  256,  254,
      262,  162,  162,  329,  262,  162,  162,  387,  258,  262,
      162,  162,  328,  549,  479,  263,  480,  303,  258,  263,
      335,  336,  337,  303,  323,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  293,  293,  293,  548,  503,  273,

      273,  273,  295,  295,  295,  504,  547,  210,  295,  295,
      295,  298,  309,  298,  309,  298,  298,  310,  310,  310,
      298,  298,  546,  298,  351,  299,  352,  352,  352,  312,
      313,  298,  298,  298,  298,  310,  310,  310,  232,  305,
      353,  353,  353,  310,  310,  310,  356,  356,  356,  360,
      360,  360,  514,  235,  372,  372,  372,  298,  520,  515,
      314,  358,  412,  298,  303,  545,  303,  273,  303,  303,
      493,  361,  494,  303,  303,  520,  303,  495,  303,  362,
      362,  362,  496,  541,  303,  303,  303,  303,  320,  164,
      164,  320,  164,  164,  359,  540,  373,  321,  375,  376,

      321,  363,  539,  322,  535,  534,  322,  500,  528,  377,
      303,  320,  164,  164,  276,  501,  303,  262,  162,  162,
      321,  320,  164,  164,  500,  528,  322,  335,  336,  337,
      321,  533,  323,  335,  336,  337,  364,  335,  336,  337,
      390,  390,  390,  532,  378,  394,  394,  394,  351,  481,
      395,  395,  395,  396,  508,  353,  353,  353,  530,  542,
      312,  313,  543,  305,  356,  356,  356,  542,  235,  551,
      543,  356,  356,  356,  360,  360,  360,  551,  177,  358,
      560,  531,  391,  375,  376,  392,  358,  392,  560,  392,
      392,  314,  177,  177,  393,  392,  361,  392,  531,  299,

      356,  356,  356,  544,  529,  392,  392,  392,  392,  356,
      356,  356,  359,  312,  313,  398,  362,  362,  362,  359,
      544,  320,  164,  164,  399,  400,  404,  404,  404,  378,
      321,  392,  405,  405,  405,  527,  364,  392,  363,  372,
      372,  372,  375,  376,  314,  375,  376,  526,  359,  525,
      414,  415,  416,  377,  406,  401,  377,  359,  276,  457,
      458,  276,  377,  390,  390,  390,  431,  276,  432,  432,
      432,  351,  524,  433,  433,  433,  523,  356,  356,  356,
      292,  373,  433,  433,  433,  522,  305,  265,  378,  521,
      459,  378,  398,  265,  519,  305,  518,  378,  356,  356,

      356,  517,  400,  516,  513,  428,  434,  435,  356,  356,
      434,  434,  434,  358,  266,  434,  434,  404,  404,  404,
      266,  434,  437,  510,  509,  359,  267,  507,  434,  434,
      434,  434,  267,  434,  506,  405,  405,  405,  441,  441,
      441,  443,  443,  443,  505,  502,  359,  451,  451,  451,
      454,  454,  454,  296,  434,  438,  434,  406,  497,  296,
      442,  434,  434,  434,  356,  356,  356,  443,  443,  443,
      357,  357,  325,  492,  357,  357,  357,  357,  325,  358,
      357,  357,  357,  357,  357,  462,  462,  462,  481,  357,
      437,  439,  439,  439,  439,  439,  439,  439,  439,  439,

      439,  439,  439,  439,  439,  439,  439,  439,  439,  439,
      357,  431,  359,  470,  439,  439,  439,  439,  414,  415,
      416,  439,  414,  415,  416,  414,  415,  416,  469,  431,
      377,  455,  455,  455,  377,  276,  467,  377,  466,  276,
      437,  350,  276,  433,  433,  433,  441,  441,  441,  453,
      463,  463,  463,  468,  468,  468,  305,  451,  451,  451,
      476,  476,  476,  511,  326,  378,  452,  450,  442,  378,
      326,  512,  378,  434,  435,  356,  356,  434,  434,  434,
      511,  464,  434,  434,  465,  462,  462,  462,  434,  456,
      482,  483,  484,  327,  449,  434,  434,  434,  434,  327,

      434,  465,  448,  463,  463,  463,  447,  486,  486,  486,
      468,  468,  468,  488,  488,  488,  498,  498,  498,  421,
      446,  434,  438,  434,  482,  483,  484,  417,  434,  434,
      434,  356,  356,  356,  464,  417,  334,  465,  357,  365,
      485,  357,  357,  357,  357,  365,  399,  400,  357,  486,
      486,  486,  412,  445,  465,  444,  357,  487,  482,  483,
      484,  486,  486,  486,  488,  488,  488,  536,  536,  536,
      537,  537,  537,  536,  536,  536,  429,  401,  427,  359,
      471,  471,  471,  537,  537,  537,  536,  536,  536,  555,
      555,  555,  538,  537,  537,  537,  553,  553,  553,  553,

      553,  553,  555,  555,  555,  538,  565,  565,  565,  425,
      472,  473,  423,  300,  474,  538,  304,  422,  554,  300,
      300,  554,  304,  304,  475,  555,  555,  555,  566,  566,
      566,  474,  475,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  567,  568,  569,  421,  477,  477,  477,  477,
      553,  553,  553,  477,  356,  356,  356,  570,  570,  570,
      419,  357,  366,  418,  357,  357,  357,  357,  366,  399,
      400,  357,  554,  565,  565,  565,  573,  573,  573,  357,
      566,  566,  566,  565,  565,  565,  566,  566,  566,  567,

      568,  569,  570,  570,  570,  567,  568,  569,  417,  412,
      401,  410,  359,  471,  471,  471,  570,  570,  570,  573,
      573,  573,  573,  573,  573,  576,  576,  576,  576,  576,
      576,  576,  576,  576,  354,  409,  402,  408,  407,  403,
      354,  354,  402,  489,  464,  403,  440,  490,  461,  478,
      389,  388,  440,  386,  461,  478,  385,  491,  384,  383,
      382,  381,  380,  379,  490,  491,  434,  435,  356,  356,
      434,  434,  434,  499,  436,  434,  434,  436,  436,  436,
      436,  434,  457,  458,  436,  499,  499,  499,  434,  434,
      434,  434,  436,  434,  499,  499,  499,  499,  499,  499,

      499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
      499,  499,  499,  459,  434,  438,  434,  499,  499,  499,
      499,  434,  434,  434,  499,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   53,   53,   53,   53,   53,   53,

       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,

       61,   61,   61,   61,   61,   61,   61,   61,   61,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,

      139,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  150,  150,  150,  150,  150,  150,
      150,  371,  150,  150,  150,  150,  150,  150,  150,  150,
      150,  150,  150,  150,  150,  150,  150,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  370,  151,  151,  368,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      155,  155,  155,  155,  367,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  158,  158,  158,  158,  158,  158,  158,

      313,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  159,  159,  159,  159,
      159,  159,  159,  225,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  168,
      168,  168,  168,  168,  168,  168,  350,  168,  168,  168,
      168,  168,  168,  168,  168,  168,  168,  168,  168,  168,
      168,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  175,  175,  175,  175,  175,  349,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,

      175,  175,  175,  175,  175,  175,  175,  179,  179,  291,
      348,  179,  347,  346,  345,  344,  341,  340,  334,  179,
      333,  179,  330,  176,  318,  179,  179,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      215,  317,  250,  225,  297,  291,  288,  287,  215,  285,
      272,  271,  176,  260,  215,  215,  220,  167,  250,  220,
      248,  247,  220,  220,  246,  220,  245,  244,  242,  220,
      220,  220,  227,  241,  231,  228,  221,  217,  214,  213,
      227,  212,  194,  193,  186,  156,  227,  227,  234,  176,

      234,  174,  160,  167,  160,  156,  234,  234,  238,  154,
      577,  238,   60,  238,  238,  243,   60,   74,   74,   60,
       60,   60,   60,  243,   48,   48,   54,   54,   48,  243,
      243,  249,  249,  249,  249,   48,  249,  249,  249,  249,
      249,  249,  249,  249,  249,  249,  249,  577,  249,  577,
      249,  249,  249,  249,  251,  251,  251,  251,  577,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  577,  252,  252,  252,  252,

      255,  577,  577,  577,  577,  577,  577,  577,  255,  577,
      577,  577,  577,  577,  255,  255,  257,  257,  577,  577,
      257,  577,  577,  577,  577,  577,  577,  577,  257,  577,
      257,  577,  577,  577,  257,  257,  259,  577,  577,  259,
      577,  577,  259,  259,  577,  259,  577,  577,  577,  259,
      259,  259,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  268,  577,  577,  577,  577,
      577,  577,  577,  268,  577,  577,  577,  577,  577,  268,
      268,  289,  577,  577,  289,  577,  577,  289,  289,  577,

      289,  577,  577,  577,  289,  289,  289,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      301,  577,  577,  577,  577,  577,  577,  577,  301,  577,
      577,  577,  577,  577,  301,  301,  302,  302,  577,  302,
      302,  302,  302,  302,  302,  302,  302,  302,  302,  302,
      302,  302,  302,  302,  302,  302,  302,  302,  302,  306,
      577,  577,  306,  577,  577,  306,  306,  577,  306,  577,
      577,  577,  306,  306,  306,  234,  577,  234,  577,  577,
      577,  577,  577,  234,  234,  311,  577,  577,  577,  577,

      311,  311,  577,  311,  577,  577,  577,  577,  577,  311,
      311,  311,  243,  577,  577,  577,  577,  577,  577,  577,
      243,  577,  577,  577,  577,  577,  243,  243,  249,  249,
      249,  249,  577,  249,  249,  249,  249,  249,  249,  249,
      249,  249,  249,  249,  577,  249,  577,  249,  249,  249,
      249,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  255,  577,  577,

      577,  577,  577,  577,  577,  255,  577,  577,  577,  577,
      577,  255,  255,  257,  257,  577,  577,  257,  577,  577,
      577,  577,  577,  577,  577,  257,  577,  257,  577,  577,
      577,  257,  257,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  357,  357,  577,  577,
      357,  357,  577,  357,  357,  357,  357,  357,  357,  577,
      577,  577,  577,  357,  357,  357,  357,  374,  374,  374,
      374,  374,  374,  374,  374,  374,  374,  374,  374,  374,
      374,  374,  374,  374,  374,  374,  374,  374,  374,  374,

      397,  577,  577,  577,  577,  397,  397,  577,  397,  577,
      577,  577,  577,  577,  397,  397,  397,  411,  411,  411,
      411,  411,  411,  411,  411,  411,  411,  411,  411,  577,
      411,  411,  411,  411,  411,  411,  411,  411,  411,  411,
      436,  436,  436,  436,  436,  436,  436,  436,  436,  436,
      436,  436,  436,  436,  436,  436,  436,  436,  436,  436,
      436,  436,  436,  460,  460,  577,  577,  460,  460,  577,
      460,  460,  460,  460,  460,  460,  577,  577,  577,  577,
      460,  460,  460,  460,   45,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,

      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577
    } ;

static const flex_int16_t yy_chk[2845] =
    {   0,
        0,    0,   23,   19,    5,    9,    5,   23,    5,    5,
       10,   19,    0,    5,    5,   57,    5,   21,    5,   17,
       17,   17,   22,    0,    5,    5,    5,    5,   18,   18,
       18,    0,   24,   37,   17,  129,   20,   24,  129,   31,
       31,   31,   51,   18,   20,   31,   87,   51,    9,   19,
        5,   37,   37,   10,   37,   21,    5,    6,   57,    6,
       22,    6,    6,   87,   95,   38,    6,    6,   81,    6,
       31,    6,   39,   39,   39,   95,   81,    6,    6,    6,
        6,  572,   20,   38,   38,  108,   38,   62,   62,   62,
       63,   63,   63,  108,   39,   83,   83,   83,   97,   63,

       83,  152,   62,    6,  564,   63,  152,   97,   97,    6,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   32,
       32,   32,   40,   40,   40,   32,   64,   64,   64,   80,
      560,   94,   80,  130,  130,   64,   94,   84,   84,   84,
       98,   64,   84,   94,   40,  559,   98,   98,   98,   80,

       32,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,

       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   69,   69,   76,
       76,   76,  551,   88,   88,  185,   99,   88,  115,  115,
      115,   99,  100,  115,  100,  100,  100,   88,   99,  170,
      170,   76,  185,   69,   88,   88,  126,  100,  126,  126,
      126,   69,   69,  101,  382,  101,  101,  101,  116,  116,
      116,  100,  382,  116,  120,  181,  191,  181,  101,  100,
      119,  191,  119,  550,  119,  119,  120,  120,  120,  119,

      119,  271,  119,  128,  119,  128,  128,  128,  271,  195,
      119,  119,  119,  119,  195,  144,  144,  144,  128,  264,
      264,  119,  149,  149,  149,  161,  161,  161,  279,  188,
      162,  162,  162,  188,  188,  279,  119,  144,  119,  162,
      161,  547,  119,  219,  149,  162,  164,  164,  164,  167,
      167,  167,  178,  178,  178,  164,  179,  179,  179,  223,
      219,  164,  282,  223,  167,  184,  184,  184,  189,  282,
      184,  224,  189,  189,  178,  224,  640,  640,  179,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,

      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  204,  204,
      204,  208,  247,  208,  208,  208,  209,  247,  209,  209,
      209,  204,  210,  546,  210,  377,  208,  210,  210,  210,
      377,  209,  218,  218,  218,  544,  543,  218,  222,  542,
      222,  386,  222,  222,  226,  226,  226,  222,  222,  386,
      222,  541,  222,  230,  230,  230,  238,  238,  222,  222,
      222,  222,  260,  260,  260,  232,  230,  232,  232,  232,

      233,  260,  233,  233,  233,  330,  235,  260,  235,  457,
      232,  235,  235,  235,  222,  233,  388,  238,  535,  457,
      222,  228,  330,  228,  388,  228,  228,  253,  253,  253,
      228,  228,  533,  228,  393,  228,  256,  256,  256,  393,
      346,  228,  228,  228,  228,  269,  257,  257,  257,  253,
      261,  261,  261,  269,  262,  262,  262,  346,  256,  263,
      263,  263,  269,  532,  464,  261,  464,  228,  257,  262,
      278,  278,  278,  228,  263,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  273,  273,  273,
      273,  273,  273,  273,  293,  293,  293,  531,  481,  273,

      273,  273,  294,  294,  294,  481,  528,  293,  295,  295,
      295,  298,  305,  298,  305,  298,  298,  305,  305,  305,
      298,  298,  527,  298,  307,  298,  307,  307,  307,  311,
      311,  298,  298,  298,  298,  309,  309,  309,  308,  307,
      308,  308,  308,  310,  310,  310,  314,  314,  314,  317,
      317,  317,  495,  308,  333,  333,  333,  298,  502,  495,
      311,  314,  412,  298,  303,  526,  303,  412,  303,  303,
      473,  317,  473,  303,  303,  502,  303,  474,  303,  318,
      318,  318,  474,  522,  303,  303,  303,  303,  319,  319,
      319,  320,  320,  320,  314,  521,  333,  319,  334,  334,

      320,  318,  520,  319,  517,  516,  320,  479,  510,  334,
      303,  321,  321,  321,  334,  479,  303,  323,  323,  323,
      321,  322,  322,  322,  479,  510,  321,  335,  335,  335,
      322,  515,  323,  336,  336,  336,  322,  337,  337,  337,
      349,  349,  349,  514,  334,  351,  351,  351,  352,  490,
      352,  352,  352,  353,  490,  353,  353,  353,  512,  523,
      355,  355,  524,  352,  356,  356,  356,  523,  353,  534,
      524,  357,  357,  357,  360,  360,  360,  534,  599,  356,
      545,  513,  349,  350,  350,  350,  357,  350,  545,  350,
      350,  355,  599,  599,  350,  350,  360,  350,  513,  350,

      358,  358,  358,  525,  511,  350,  350,  350,  350,  359,
      359,  359,  356,  397,  397,  358,  362,  362,  362,  357,
      525,  364,  364,  364,  359,  359,  367,  367,  367,  350,
      364,  350,  368,  368,  368,  509,  364,  350,  362,  372,
      372,  372,  374,  374,  397,  376,  376,  508,  358,  507,
      378,  378,  378,  374,  368,  359,  376,  359,  374,  438,
      438,  376,  378,  390,  390,  390,  394,  378,  394,  394,
      394,  395,  506,  395,  395,  395,  505,  399,  399,  399,
      396,  372,  396,  396,  396,  504,  395,  615,  374,  503,
      438,  376,  399,  615,  501,  396,  500,  378,  401,  401,

      401,  497,  399,  496,  494,  390,  398,  398,  398,  398,
      398,  398,  398,  401,  616,  398,  398,  404,  404,  404,
      616,  398,  398,  492,  491,  399,  617,  489,  398,  398,
      398,  398,  617,  398,  487,  405,  405,  405,  407,  407,
      407,  408,  408,  408,  485,  480,  401,  427,  427,  427,
      431,  431,  431,  621,  398,  398,  398,  405,  475,  621,
      407,  398,  398,  398,  400,  400,  400,  443,  443,  443,
      400,  400,  636,  472,  400,  400,  400,  400,  636,  400,
      400,  400,  400,  400,  400,  444,  444,  444,  465,  400,
      456,  400,  400,  400,  400,  400,  400,  400,  400,  400,

      400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
      400,  455,  400,  452,  400,  400,  400,  400,  414,  414,
      414,  400,  415,  415,  415,  416,  416,  416,  450,  432,
      414,  432,  432,  432,  415,  414,  448,  416,  446,  415,
      437,  430,  416,  433,  433,  433,  441,  441,  441,  429,
      445,  445,  445,  449,  449,  449,  433,  451,  451,  451,
      454,  454,  454,  493,  637,  414,  428,  426,  441,  415,
      637,  493,  416,  434,  434,  434,  434,  434,  434,  434,
      493,  445,  434,  434,  445,  462,  462,  462,  434,  434,
      466,  466,  466,  638,  425,  434,  434,  434,  434,  638,

      434,  445,  424,  463,  463,  463,  423,  467,  467,  467,
      468,  468,  468,  469,  469,  469,  476,  476,  476,  422,
      420,  434,  434,  434,  482,  482,  482,  419,  434,  434,
      434,  439,  439,  439,  463,  418,  413,  463,  439,  642,
      466,  439,  439,  439,  439,  642,  439,  439,  439,  483,
      483,  483,  411,  410,  463,  409,  439,  467,  484,  484,
      484,  486,  486,  486,  488,  488,  488,  518,  518,  518,
      519,  519,  519,  529,  529,  529,  391,  439,  389,  439,
      453,  453,  453,  530,  530,  530,  536,  536,  536,  540,
      540,  540,  519,  537,  537,  537,  539,  539,  539,  548,

      548,  548,  549,  549,  549,  530,  552,  552,  552,  387,
      453,  453,  385,  622,  453,  537,  625,  384,  539,  622,
      622,  548,  625,  625,  453,  555,  555,  555,  556,  556,
      556,  453,  453,  458,  458,  458,  458,  458,  458,  458,
      458,  458,  458,  458,  458,  458,  458,  458,  458,  458,
      458,  458,  557,  557,  557,  383,  458,  458,  458,  458,
      553,  553,  553,  458,  460,  460,  460,  558,  558,  558,
      381,  460,  643,  380,  460,  460,  460,  460,  643,  460,
      460,  460,  553,  561,  561,  561,  562,  562,  562,  460,
      563,  563,  563,  565,  565,  565,  566,  566,  566,  567,

      567,  567,  568,  568,  568,  569,  569,  569,  379,  375,
      460,  373,  460,  470,  470,  470,  570,  570,  570,  571,
      571,  571,  573,  573,  573,  574,  574,  574,  575,  575,
      575,  576,  576,  576,  639,  371,  646,  370,  369,  647,
      639,  639,  646,  470,  470,  647,  650,  470,  652,  653,
      348,  347,  650,  345,  652,  653,  344,  470,  343,  342,
      341,  340,  339,  338,  470,  470,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,

      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  578,  578,  578,  578,  578,
      578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
      578,  578,  578,  578,  578,  578,  578,  578,  579,  579,
      579,  579,  579,  579,  579,  579,  579,  579,  579,  579,
      579,  579,  579,  579,  579,  579,  579,  579,  579,  579,
      579,  580,  580,  580,  580,  580,  580,  580,  580,  580,
      580,  580,  580,  580,  580,  580,  580,  580,  580,  580,
      580,  580,  580,  580,  581,  581,  581,  581,  581,  581,

      581,  581,  581,  581,  581,  581,  581,  581,  581,  581,
      581,  581,  581,  581,  581,  581,  581,  582,  582,  582,
      582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
      582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  583,  583,  584,  584,  584,  584,  584,  584,  584,
      584,  584,  584,  584,  584,  584,  584,  584,  584,  584,
      584,  584,  584,  584,  584,  584,  585,  585,  585,  585,
      585,  585,  585,  585,  585,  585,  585,  585,  585,  585,

      585,  585,  585,  585,  585,  585,  585,  585,  585,  586,
      586,  586,  586,  586,  586,  586,  586,  586,  586,  586,
      586,  586,  586,  586,  586,  586,  586,  586,  586,  586,
      586,  586,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
      587,  587,  587,  587,  587,  588,  588,  588,  588,  588,
      588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
      588,  588,  588,  588,  588,  588,  588,  588,  589,  589,
      589,  589,  589,  589,  589,  589,  589,  589,  589,  589,
      589,  589,  589,  589,  589,  589,  589,  589,  589,  589,

      589,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  591,  591,  591,  591,  591,  591,
      591,  332,  591,  591,  591,  591,  591,  591,  591,  591,
      591,  591,  591,  591,  591,  591,  591,  592,  592,  592,
      592,  592,  592,  592,  592,  592,  331,  592,  592,  329,
      592,  592,  592,  592,  592,  592,  592,  592,  592,  592,
      593,  593,  593,  593,  328,  593,  593,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
      593,  593,  593,  594,  594,  594,  594,  594,  594,  594,

      312,  594,  594,  594,  594,  594,  594,  594,  594,  594,
      594,  594,  594,  594,  594,  594,  595,  595,  595,  595,
      595,  595,  595,  301,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  595,  595,  595,  595,  595,  595,  596,
      596,  596,  596,  596,  596,  596,  299,  596,  596,  596,
      596,  596,  596,  596,  596,  596,  596,  596,  596,  596,
      596,  597,  597,  597,  597,  597,  597,  597,  597,  597,
      597,  597,  597,  597,  597,  597,  597,  597,  597,  597,
      597,  597,  597,  597,  598,  598,  598,  598,  598,  297,
      598,  598,  598,  598,  598,  598,  598,  598,  598,  598,

      598,  598,  598,  598,  598,  598,  598,  600,  600,  290,
      287,  600,  286,  285,  284,  283,  281,  280,  276,  600,
      272,  600,  270,  268,  252,  600,  600,  601,  601,  601,
      601,  601,  601,  601,  601,  601,  601,  601,  601,  601,
      601,  601,  601,  601,  601,  601,  601,  601,  601,  601,
      602,  251,  249,  227,  216,  206,  202,  192,  602,  190,
      183,  182,  177,  166,  602,  602,  603,  163,  139,  603,
      138,  137,  603,  603,  136,  603,  135,  134,  132,  603,
      603,  603,  604,  131,  127,  125,  117,  112,  106,  105,
      604,  104,   90,   89,   85,   74,  604,  604,  605,   73,

      605,   70,   68,   65,   60,   54,  605,  605,  606,   52,
       45,  606,   28,  606,  606,  607,   27,   26,   25,   16,
       15,   14,   13,  607,   12,   11,    8,    7,    4,  607,
      607,  608,  608,  608,  608,    3,  608,  608,  608,  608,
      608,  608,  608,  608,  608,  608,  608,    0,  608,    0,
      608,  608,  608,  608,  609,  609,  609,  609,    0,  609,
      609,  609,  609,  609,  609,  609,  609,  609,  609,  609,
      609,  609,  609,  609,  609,  609,  609,  610,  610,  610,
      610,  610,  610,  610,  610,  610,  610,  610,  610,  610,
      610,  610,  610,  610,  610,    0,  610,  610,  610,  610,

      611,    0,    0,    0,    0,    0,    0,    0,  611,    0,
        0,    0,    0,    0,  611,  611,  612,  612,    0,    0,
      612,    0,    0,    0,    0,    0,    0,    0,  612,    0,
      612,    0,    0,    0,  612,  612,  613,    0,    0,  613,
        0,    0,  613,  613,    0,  613,    0,    0,    0,  613,
      613,  613,  614,  614,  614,  614,  614,  614,  614,  614,
      614,  614,  614,  614,  614,  614,  614,  614,  614,  614,
      614,  614,  614,  614,  614,  618,    0,    0,    0,    0,
        0,    0,    0,  618,    0,    0,    0,    0,    0,  618,
      618,  619,    0,    0,  619,    0,    0,  619,  619,    0,

      619,    0,    0,    0,  619,  619,  619,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      623,    0,    0,    0,    0,    0,    0,    0,  623,    0,
        0,    0,    0,    0,  623,  623,  624,  624,    0,  624,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  626,
        0,    0,  626,    0,    0,  626,  626,    0,  626,    0,
        0,    0,  626,  626,  626,  627,    0,  627,    0,    0,
        0,    0,    0,  627,  627,  628,    0,    0,    0,    0,

      628,  628,    0,  628,    0,    0,    0,    0,    0,  628,
      628,  628,  629,    0,    0,    0,    0,    0,    0,    0,
      629,    0,    0,    0,    0,    0,  629,  629,  630,  630,
      630,  630,    0,  630,  630,  630,  630,  630,  630,  630,
      630,  630,  630,  630,    0,  630,    0,  630,  630,  630,
      630,  631,  631,  631,  631,  631,  631,  631,  631,  631,
      631,  631,  631,  631,  631,  631,  631,  631,  631,  631,
      631,  631,  631,  631,  632,  632,  632,  632,  632,  632,
      632,  632,  632,  632,  632,  632,  632,  632,  632,  632,
      632,  632,  632,  632,  632,  632,  632,  633,    0,    0,

        0,    0,    0,    0,    0,  633,    0,    0,    0,    0,
        0,  633,  633,  634,  634,    0,    0,  634,    0,    0,
        0,    0,    0,    0,    0,  634,    0,  634,    0,    0,
        0,  634,  634,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  641,  641,    0,    0,
      641,  641,    0,  641,  641,  641,  641,  641,  641,    0,
        0,    0,    0,  641,  641,  641,  641,  644,  644,  644,
      644,  644,  644,  644,  644,  644,  644,  644,  644,  644,
      644,  644,  644,  644,  644,  644,  644,  644,  644,  644,

      645,    0,    0,    0,    0,  645,  645,    0,  645,    0,
        0,    0,    0,    0,  645,  645,  645,  648,  648,  648,
      648,  648,  648,  648,  648,  648,  648,  648,  648,    0,
      648,  648,  648,  648,  648,  648,  648,  648,  648,  648,
      649,  649,  649,  649,  649,  649,  649,  649,  649,  649,
      649,  649,  649,  649,  649,  649,  649,  649,  649,  649,
      649,  649,  649,  651,  651,    0,    0,  651,  651,    0,
      651,  651,  651,  651,  651,  651,    0,    0,    0,    0,
      651,  651,  651,  651,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,

      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[143] =
    {   0,
1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
    1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
    1, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "pgc.l"

#line 33 "pgc.l"

/* LCOV_EXCL_START */

extern YYSTYPE base_yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar(unsigned char);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static void parse_include(void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;

/* vars to keep track of start conditions when scanning literals */
static int state_before_str_start;
static int state_before_str_stop;

/*
 * State for handling include files and macro expansion.  We use a new
 * flex input buffer for each level of include or macro, and create a
 * struct _yy_buffer to remember the previous level.  There is not a struct
 * for the currently active input source; that state is kept in the global
 * variables YY_CURRENT_BUFFER, yylineno, and input_filename.
 */
static struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

/*
 * Vars for handling ifdef/elif/endif constructs.  preproc_tos is the current
 * nesting depth of such constructs, and stacked_if_value[preproc_tos] is the
 * state for the innermost level.  (For convenience, stacked_if_value[0] is
 * initialized as though we are in the active branch of some outermost IF.)
 * The active field is true if the current branch is active (being expanded).
 * The saw_active field is true if we have found any successful branch,
 * so that all subsequent branches of this level should be skipped.
 * The else_branch field is true if we've found an 'else' (so that another
 * 'else' or 'elif' at this level is an error.)
 * For IFs nested within an inactive branch, all branches always have active
 * set to false, but saw_active and else_branch are maintained normally.
 * ifcond is valid only while evaluating an if-condition; it's true if we
 * are doing ifdef, false if ifndef.
 */
#define MAX_NESTED_IF 128
static short preproc_tos;
static bool ifcond;
static struct _if_value
{
	bool		active;
	bool		saw_active;
	bool		else_branch;
} stacked_if_value[MAX_NESTED_IF];

#line 1677 "pgc.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xdc> double-quoted strings in C
 *  <xh> hexadecimal byte string
 *  <xn> national character quoted strings
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xqc> single-quoted strings in C
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xcond> condition of an EXEC SQL IFDEF construct
 *  <xskip> skipping the inactive part of an EXEC SQL IFDEF construct
 *
 * Note: we intentionally don't mimic the backend's <xeu> state; we have
 * no need to distinguish it from <xe> state.
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/* Additional exclusive states that are specific to ECPG */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
/* some stuff needed for ecpg */
/* C version of hex number */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continued */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too
 */
#line 1839 "pgc.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xdc 4
#define xh 5
#define xn 6
#define xq 7
#define xqs 8
#define xe 9
#define xqc 10
#define xdolq 11
#define xui 12
#define xus 13
#define xcond 14
#define xskip 15
#define C 16
#define SQL 17
#define incl 18
#define def 19
#define def_ident 20
#define undef 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 436 "pgc.l"



#line 440 "pgc.l"
		/* code to execute during start of each call of yylex() */
		char *newdefsymbol = NULL;

		token_start = NULL;


#line 2088 "pgc.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 578 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 577 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 447 "pgc.l"
{
					/* ignore */
				}
	YY_BREAK
/* <SQL> */

case 2:
YY_RULE_SETUP
#line 453 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
/* <C,SQL> */

case 3:
YY_RULE_SETUP
#line 465 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						xcdepth++;
						/* Put back any characters past slash-star; see above */
						yyless(2);
						fputs("/_*", yyout);
					}
					else if (state_before_str_start == C)
					{
						ECHO;
					}
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 479 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						if (xcdepth <= 0)
						{
							ECHO;
							BEGIN(SQL);
							token_start = NULL;
						}
						else
						{
							xcdepth--;
							fputs("*_/", yyout);
						}
					}
					else if (state_before_str_start == C)
					{
						ECHO;
						BEGIN(C);
						token_start = NULL;
					}
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 502 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 506 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 510 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 514 "pgc.l"
{
					mmfatal(PARSE_ERROR, "unterminated /* comment");
				}
	YY_BREAK
/* <xc> */

case 8:
YY_RULE_SETUP
#line 520 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xb);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 9:
/* rule 9 can match eol */
#line 529 "pgc.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 529 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 532 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 534 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xh);
					startlit();
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 540 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 542 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xqc);
					startlit();
				}
	YY_BREAK

case 13:
YY_RULE_SETUP
#line 550 "pgc.l"
{
					/* National character.
					 * Transfer it as-is to the backend.
					 */
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xn);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 560 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xq);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 566 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 572 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 17:
YY_RULE_SETUP
#line 580 "pgc.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 592 "pgc.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 601 "pgc.l"
case 20:
/* rule 20 can match eol */
#line 602 "pgc.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 602 "pgc.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(state_before_str_start);

					switch (state_before_str_stop)
					{
						case xb:
							if (literalbuf[strspn(literalbuf, "01")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
							base_yylval.str = psprintf("b'%s'", literalbuf);
							return BCONST;
						case xh:
							if (literalbuf[strspn(literalbuf, "0123456789abcdefABCDEF")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid hexadecimal string literal");
							base_yylval.str = psprintf("x'%s'", literalbuf);
							return XCONST;
						case xq:
							/* fallthrough */
						case xqc:
							base_yylval.str = psprintf("'%s'", literalbuf);
							return SCONST;
						case xe:
							base_yylval.str = psprintf("E'%s'", literalbuf);
							return SCONST;
						case xn:
							base_yylval.str = psprintf("N'%s'", literalbuf);
							return SCONST;
						case xus:
							base_yylval.str = psprintf("U&'%s'", literalbuf);
							return USCONST;
						default:
							mmfatal(PARSE_ERROR, "unhandled previous state in xqs\n");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 642 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 643 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 644 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 645 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 648 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 651 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 654 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 657 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 660 "pgc.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 664 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 30:
YY_RULE_SETUP
#line 667 "pgc.l"
{
					token_start = yytext;
					if (dolqstart)
						free(dolqstart);
					dolqstart = mm_strdup(yytext);
					BEGIN(xdolq);
					startlit();
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 676 "pgc.l"
{
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
case 32:
YY_RULE_SETUP
#line 684 "pgc.l"
{
					if (strcmp(yytext, dolqstart) == 0)
					{
						addlit(yytext, yyleng);
						free(dolqstart);
						dolqstart = NULL;
						BEGIN(SQL);
						base_yylval.str = mm_strdup(literalbuf);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 705 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 708 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 711 "pgc.l"
{
					/* single quote or dollar sign */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 715 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated dollar-quoted string"); }
	YY_BREAK

case 36:
YY_RULE_SETUP
#line 718 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 723 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 38:
YY_RULE_SETUP
#line 730 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/*
					 * The server will truncate the identifier here.  We do
					 * not, as (1) it does not change the result; (2) we don't
					 * know what NAMEDATALEN the server might use; (3) this
					 * code path is also taken for literal query strings in
					 * PREPARE and EXECUTE IMMEDIATE, which can certainly be
					 * longer than NAMEDATALEN.
					 */
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 745 "pgc.l"
{
					BEGIN(state_before_str_start);
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 750 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/* The backend will truncate the identifier here. We do not as it does not change the result. */
					base_yylval.str = psprintf("U&\"%s\"", literalbuf);
					return UIDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 758 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 761 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 764 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 765 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xdc);
					startlit();
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 770 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xdc):
#line 773 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 45:
YY_RULE_SETUP
#line 776 "pgc.l"
{
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 780 "pgc.l"
{
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 784 "pgc.l"
{
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 788 "pgc.l"
{
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 792 "pgc.l"
{
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 796 "pgc.l"
{
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 800 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 805 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 810 "pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 820 "pgc.l"
{
					/*
					 * We may find a ';' inside a structure
					 * definition in a TYPE or VAR statement.
					 * This is not an EOL marker.
					 */
					if (yytext[0] == ';' && struct_level == 0)
						BEGIN(C);
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 831 "pgc.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					base_yylval.str = mm_strdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 928 "pgc.l"
{
					base_yylval.ival = atol(yytext+1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 932 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after parameter");
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 936 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return IP;
				}
	YY_BREAK
/* <SQL> */

case 59:
YY_RULE_SETUP
#line 943 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 946 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 950 "pgc.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 955 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 959 "pgc.l"
{
					/*
					 * throw back the [Ee][+-], and figure out whether what
					 * remains is an {integer} or {decimal}.
					 */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
/* <C,SQL> */

/*
	 * Note that some trailing junk is valid in C (such as 100LL), so we
	 * contain this to SQL mode.
	 */
case 64:
YY_RULE_SETUP
#line 974 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 977 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 980 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 984 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext+1);
					return CVARIABLE;
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 989 "pgc.l"
{
					/* First check to see if it's a define symbol to expand */
					if (!isdefine())
					{
						int		kwvalue;

						/* Is it an SQL/ECPG keyword? */
						kwvalue = ScanECPGKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/* Is it a C keyword? */
						kwvalue = ScanCKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/*
						 * None of the above.  Return it as an identifier.
						 *
						 * The backend will attempt to truncate and case-fold
						 * the identifier, but I see no good reason for ecpg
						 * to do so; that's just another way that ecpg could get
						 * out of step with the backend.
						 */
						base_yylval.str = mm_strdup(yytext);
						return IDENT;
					}
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1018 "pgc.l"
{
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
/*
	 * Begin ECPG-specific rules
	 */
case 70:
/* rule 70 can match eol */
YY_RULE_SETUP
#line 1027 "pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1028 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 72:
/* rule 72 can match eol */
YY_RULE_SETUP
#line 1038 "pgc.l"
{ ECHO; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1039 "pgc.l"
{
						char* endptr;

						errno = 0;
						base_yylval.ival = strtoul((char *) yytext, &endptr, 16);
						if (*endptr != '\0' || errno == ERANGE)
						{
							errno = 0;
							base_yylval.str = mm_strdup(yytext);
							return SCONST;
						}
						return ICONST;
					}
	YY_BREAK
case 74:
/* rule 74 can match eol */
YY_RULE_SETUP
#line 1052 "pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 75:
/* rule 75 can match eol */
YY_RULE_SETUP
#line 1064 "pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 1076 "pgc.l"
{
						base_yylval.str = mm_strdup(yytext);
						return CPP_LINE;
					}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1080 "pgc.l"
{
						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{'
						 */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							int		kwvalue;

							kwvalue = ScanCKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
							else
							{
								base_yylval.str = mm_strdup(yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1108 "pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1109 "pgc.l"
{ return ':'; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1110 "pgc.l"
{ return ';'; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1111 "pgc.l"
{ return ','; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1112 "pgc.l"
{ return '*'; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1113 "pgc.l"
{ return '%'; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1114 "pgc.l"
{ return '/'; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1115 "pgc.l"
{ return '+'; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1116 "pgc.l"
{ return '-'; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1117 "pgc.l"
{ parenths_open++; return '('; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1118 "pgc.l"
{ parenths_open--; return ')'; }
	YY_BREAK
case 89:
/* rule 89 can match eol */
YY_RULE_SETUP
#line 1119 "pgc.l"
{ ECHO; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1120 "pgc.l"
{ return '{'; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1121 "pgc.l"
{ return '}'; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1122 "pgc.l"
{ return '['; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1123 "pgc.l"
{ return ']'; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1124 "pgc.l"
{ return '='; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1125 "pgc.l"
{ return S_MEMBER; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1126 "pgc.l"
{ return S_RSHIFT; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1127 "pgc.l"
{ return S_LSHIFT; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1128 "pgc.l"
{ return S_OR; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1129 "pgc.l"
{ return S_AND; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1130 "pgc.l"
{ return S_INC; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1131 "pgc.l"
{ return S_DEC; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1132 "pgc.l"
{ return S_EQUAL; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1133 "pgc.l"
{ return S_NEQUAL; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1134 "pgc.l"
{ return S_ADD; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1135 "pgc.l"
{ return S_SUB; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1136 "pgc.l"
{ return S_MUL; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1137 "pgc.l"
{ return S_DIV; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1138 "pgc.l"
{ return S_MOD; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 1139 "pgc.l"
{ return S_MEMPOINT; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1140 "pgc.l"
{ return S_DOTPOINT; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1141 "pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 112:
/* rule 112 can match eol */
YY_RULE_SETUP
#line 1142 "pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 113:
/* rule 113 can match eol */
YY_RULE_SETUP
#line 1143 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 114:
/* rule 114 can match eol */
YY_RULE_SETUP
#line 1155 "pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 1156 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 1168 "pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(yytext)-2;
						 i > 0 && ecpg_isspace(yytext[i]);
						 i--)
						;
					yytext[i+1] = '\0';


					/* Find and unset any matching define; should be only 1 */
					for (ptr = defines; ptr; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(yytext, ptr->name) == 0)
						{
							free(ptr->value);
							ptr->value = NULL;
							/* We cannot forget it if there's a cmdvalue */
							if (ptr->cmdvalue == NULL)
							{
								if (ptr2 == NULL)
									defines = ptr->next;
								else
									ptr2->next = ptr->next;
								free(ptr->name);
								free(ptr);
							}
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 1206 "pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 118:
/* rule 118 can match eol */
YY_RULE_SETUP
#line 1210 "pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 119:
/* rule 119 can match eol */
YY_RULE_SETUP
#line 1211 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 120:
/* rule 120 can match eol */
YY_RULE_SETUP
#line 1223 "pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = true;
					  BEGIN(xcond);
					}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 1233 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = true;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 1252 "pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = false;
					  BEGIN(xcond);
					}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 1262 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = false;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 1281 "pgc.l"
{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 1289 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 1307 "pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
					else if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = true;
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active);
						stacked_if_value[preproc_tos].saw_active = true;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 1326 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = true;
							stacked_if_value[preproc_tos].active =
								(stacked_if_value[preproc_tos-1].active &&
								 !stacked_if_value[preproc_tos].saw_active);
							stacked_if_value[preproc_tos].saw_active = true;

							if (stacked_if_value[preproc_tos].active)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 1354 "pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].active)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 1365 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 1386 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1388 "pgc.l"
{
					{
						struct _defines *defptr;
						unsigned int i;
						bool this_active;

						/*
						 *	Skip the ";" and trailing whitespace. Note that yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(yytext)-2;
							 i > 0 && ecpg_isspace(yytext[i]);
							 i--)
							;
						yytext[i+1] = '\0';

						/* Does a definition exist? */
						for (defptr = defines; defptr; defptr = defptr->next)
						{
							if (strcmp(yytext, defptr->name) == 0)
							{
								/* Found it, but is it currently undefined? */
								if (defptr->value == NULL)
									defptr = NULL; /* pretend it's not found */
								break;
							}
						}

						this_active = (defptr ? ifcond : !ifcond);
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active &&
							 this_active);
						stacked_if_value[preproc_tos].saw_active |= this_active;
					}

					if (stacked_if_value[preproc_tos].active)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 1430 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 133:
YY_RULE_SETUP
#line 1434 "pgc.l"
{
				newdefsymbol = mm_strdup(yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1439 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 135:
/* rule 135 can match eol */
YY_RULE_SETUP
#line 1443 "pgc.l"
{
						struct _defines *ptr;

						/* Does it already exist? */
						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							if (strcmp(newdefsymbol, ptr->name) == 0)
							{
								free(ptr->value);
								ptr->value = mm_strdup(literalbuf);
								/* Don't leak newdefsymbol */
								free(newdefsymbol);
								break;
							}
						}
						if (ptr == NULL)
						{
							/* Not present, make a new entry */
							ptr = (struct _defines *) mm_alloc(sizeof(struct _defines));

							ptr->name = newdefsymbol;
							ptr->value = mm_strdup(literalbuf);
							ptr->cmdvalue = NULL;
							ptr->used = NULL;
							ptr->next = defines;
							defines = ptr;
						}

						BEGIN(C);
					}
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1473 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1474 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 1475 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 139:
/* rule 139 can match eol */
YY_RULE_SETUP
#line 1476 "pgc.l"
{ parse_include(); }
	YY_BREAK
case 140:
/* rule 140 can match eol */
YY_RULE_SETUP
#line 1477 "pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
#line 1482 "pgc.l"
{
					if (yy_buffer == NULL)
					{
						/* No more input */
						if (preproc_tos > 0)
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						/* Revert to previous input source */
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						/* Check to see if we are exiting a macro value */
						for (ptr = defines; ptr; ptr = ptr->next)
						{
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break; /* there can't be multiple matches */
							}
						}

						if (yyin != NULL)
							fclose(yyin);

						yy_delete_buffer(YY_CURRENT_BUFFER);
						yy_switch_to_buffer(yy_buffer->buffer);

						yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 141:
/* rule 141 can match eol */
YY_RULE_SETUP
#line 1533 "pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <%s>", PACKAGE_BUGREPORT); }
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 1535 "pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 3842 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 578 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 578 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 577);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1535 "pgc.l"


/* LCOV_EXCL_STOP */

void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	yylineno = 1;

	/* initialize state for if/else/endif */
	preproc_tos = 0;
	stacked_if_value[preproc_tos].active = true;
	stacked_if_value[preproc_tos].saw_active = true;
	stacked_if_value[preproc_tos].else_branch = false;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) mm_alloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = mm_strdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(yytext)-2;
		 i > 0 && ecpg_isspace(yytext[i]);
		 i--)
		;

	if (yytext[i] == ';')
		i--;

	yytext[i+1] = '\0';

	yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (yytext[0] == '"' && yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || yytext[1] == '/'))
	{
		yytext[i] = '\0';
		memmove(yytext, yytext+1, strlen(yytext));

		strlcpy(inc_file, yytext, sizeof(inc_file));
		yyin = fopen(inc_file, "r");
		if (!yyin)
		{
			if (strlen(inc_file) <= 2 || strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((yytext[0] == '"' && yytext[i] == '"') || (yytext[0] == '<' && yytext[i] == '>'))
		{
			yytext[i] = '\0';
			memmove(yytext, yytext+1, strlen(yytext));
		}

		for (ip = include_paths; yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(yytext) + 4 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, yytext, yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, yytext);
			yyin = fopen(inc_file, "r");
			if (!yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					yyin = fopen(inc_file, "r");
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (yyin && include_next)
			{
				fclose (yyin);
				yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", yytext, yylineno);

	input_filename = mm_strdup(inc_file);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
	yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return true if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f')
		return true;
	return false;
}

/*
 * If yytext matches a define symbol, begin scanning the symbol's value
 * and return true
 */
static bool
isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		/* notice we do not match anything being actively expanded */
		if (strcmp(yytext, ptr->name) == 0 &&
			ptr->value != NULL &&
			ptr->used == NULL)
		{
			/* Save state associated with the current buffer */
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;
			yy_buffer = yb;

			/* Mark symbol as being actively expanded */
			ptr->used = yb;

			/*
			 * We use yy_scan_string which will copy the value, so there's
			 * no need to worry about a possible undef happening while we
			 * are still scanning it.
			 */
			yy_scan_string(ptr->value);
			return true;
		}
	}

	return false;
}

/*
 * Handle replacement of INFORMIX built-in defines.  This works just
 * like isdefine() except for the source of the string to scan.
 */
static bool
isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		yy_scan_string(new);
		return true;
	}

	return false;
}

