/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.PKCS5AlgorithmIdentifier;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PKCS8EncryptionProperties
implements Serializable {
    private static final int DEFAULT_KEY_FACTORY_ITERATION_COUNT = 2048;
    private static final int DEFAULT_KEY_FACTORY_SALT_LENGTH_BYTES = 8;
    @NotNull
    private static final PKCS5AlgorithmIdentifier DEFAULT_CIPHER_TRANSFORMATION = PKCS5AlgorithmIdentifier.AES_128_CBC_PAD;
    @NotNull
    private static final PKCS5AlgorithmIdentifier DEFAULT_KEY_FACTORY_PRF = PKCS5AlgorithmIdentifier.HMAC_SHA_256;
    private static final long serialVersionUID = 9162621645150582722L;
    private int keyFactoryIterationCount = 2048;
    private int keyFactorySaltLengthBytes = 8;
    @NotNull
    private PKCS5AlgorithmIdentifier cipherTransformationAlgorithm = DEFAULT_CIPHER_TRANSFORMATION;
    @NotNull
    private PKCS5AlgorithmIdentifier keyFactoryPRFAlgorithm = DEFAULT_KEY_FACTORY_PRF;

    @NotNull
    public PKCS5AlgorithmIdentifier getKeyFactoryPRFAlgorithm() {
        return this.keyFactoryPRFAlgorithm;
    }

    public void setKeyFactoryPRFAlgorithm(@NotNull PKCS5AlgorithmIdentifier keyFactoryPRFAlgorithm) throws CertException {
        if (!PKCS5AlgorithmIdentifier.getPseudorandomFunctions().contains((Object)keyFactoryPRFAlgorithm)) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_PROPS_INVALID_KEY_FACTORY_PRF_ALG.get(keyFactoryPRFAlgorithm.getName(), keyFactoryPRFAlgorithm.getDescription()));
        }
        this.keyFactoryPRFAlgorithm = keyFactoryPRFAlgorithm;
    }

    public int getKeyFactoryIterationCount() {
        return this.keyFactoryIterationCount;
    }

    public void setKeyFactoryIterationCount(int keyFactoryIterationCount) {
        Validator.ensureTrue(keyFactoryIterationCount > 0, "The key factory iteration count must be greater than zero.");
        this.keyFactoryIterationCount = keyFactoryIterationCount;
    }

    public int getKeyFactorySaltLengthBytes() {
        return this.keyFactorySaltLengthBytes;
    }

    public void setKeyFactorySaltLengthBytes(int keyFactorySaltLengthBytes) {
        Validator.ensureTrue(keyFactorySaltLengthBytes > 0, "The key factory salt length must be greater than zero bytes.");
        this.keyFactorySaltLengthBytes = keyFactorySaltLengthBytes;
    }

    @NotNull
    public PKCS5AlgorithmIdentifier getCipherTransformationAlgorithm() {
        return this.cipherTransformationAlgorithm;
    }

    public void setCipherTransformationAlgorithm(@NotNull PKCS5AlgorithmIdentifier cipherTransformationAlgorithm) throws CertException {
        if (!PKCS5AlgorithmIdentifier.getCipherTransformations().contains((Object)cipherTransformationAlgorithm)) {
            throw new CertException(CertMessages.ERR_PKCS8_ENC_PROPS_INVALID_CIPHER_TRANSFORMATION_ALG.get(cipherTransformationAlgorithm.getName(), cipherTransformationAlgorithm.getDescription()));
        }
        this.cipherTransformationAlgorithm = cipherTransformationAlgorithm;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PKCS8EncryptionProperties(keyFactoryPRFAlgorithm='");
        buffer.append(this.keyFactoryPRFAlgorithm.getName());
        buffer.append("', keyFactoryIterationCount=");
        buffer.append(this.keyFactoryIterationCount);
        buffer.append(", keyFactorySaltLengthBytes=");
        buffer.append(this.keyFactorySaltLengthBytes);
        buffer.append(", cipherTransformation='");
        buffer.append(this.cipherTransformationAlgorithm.getName());
        buffer.append("')");
    }
}

