// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_4_autogen.cpp:
//   Defines the Desktop GL 4.x entry points.

#include "libGLESv2/entry_points_gl_4_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gl_4_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL4_autogen.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {

// GL 4.0
void GL_APIENTRY GL_BeginQueryIndexed(GLenum target, GLuint index, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBeginQueryIndexed, "context = %d, target = %s, index = %u, id = %u",
          CID(context), GLenumToString(BigGLEnum::QueryTarget, target), index, id);

    if (context)
    {
        QueryID idPacked = PackParam<QueryID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBeginQueryIndexed) &&
              ValidateBeginQueryIndexed(context, angle::EntryPoint::GLBeginQueryIndexed, target,
                                        index, idPacked)));
        if (isCallValid)
        {
            context->beginQueryIndexed(target, index, idPacked);
        }
        ANGLE_CAPTURE_GL(BeginQueryIndexed, isCallValid, context, target, index, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTransformFeedback(GLenum mode, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTransformFeedback, "context = %d, mode = %s, id = %u", CID(context),
          GLenumToString(BigGLEnum::PrimitiveType, mode), id);

    if (context)
    {
        TransformFeedbackID idPacked = PackParam<TransformFeedbackID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLDrawTransformFeedback) &&
              ValidateDrawTransformFeedback(context, angle::EntryPoint::GLDrawTransformFeedback,
                                            mode, idPacked)));
        if (isCallValid)
        {
            context->drawTransformFeedback(mode, idPacked);
        }
        ANGLE_CAPTURE_GL(DrawTransformFeedback, isCallValid, context, mode, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTransformFeedbackStream, "context = %d, mode = %s, id = %u, stream = %u",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), id, stream);

    if (context)
    {
        TransformFeedbackID idPacked = PackParam<TransformFeedbackID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLDrawTransformFeedbackStream) &&
                             ValidateDrawTransformFeedbackStream(
                                 context, angle::EntryPoint::GLDrawTransformFeedbackStream, mode,
                                 idPacked, stream)));
        if (isCallValid)
        {
            context->drawTransformFeedbackStream(mode, idPacked, stream);
        }
        ANGLE_CAPTURE_GL(DrawTransformFeedbackStream, isCallValid, context, mode, idPacked, stream);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EndQueryIndexed(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEndQueryIndexed, "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(BigGLEnum::QueryTarget, target), index);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLEndQueryIndexed) &&
              ValidateEndQueryIndexed(context, angle::EntryPoint::GLEndQueryIndexed, target,
                                      index)));
        if (isCallValid)
        {
            context->endQueryIndexed(target, index);
        }
        ANGLE_CAPTURE_GL(EndQueryIndexed, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveSubroutineName(GLuint program,
                                            GLenum shadertype,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveSubroutineName,
          "context = %d, program = %u, shadertype = %s, index = %u, bufSize = %d, length = "
          "0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(BigGLEnum::ShaderType, shadertype), index, bufSize,
          (uintptr_t)length, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetActiveSubroutineName(
                                context, angle::EntryPoint::GLGetActiveSubroutineName,
                                programPacked, shadertype, index, bufSize, length, name));
        if (isCallValid)
        {
            context->getActiveSubroutineName(programPacked, shadertype, index, bufSize, length,
                                             name);
        }
        ANGLE_CAPTURE_GL(GetActiveSubroutineName, isCallValid, context, programPacked, shadertype,
                         index, bufSize, length, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveSubroutineUniformName(GLuint program,
                                                   GLenum shadertype,
                                                   GLuint index,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveSubroutineUniformName,
          "context = %d, program = %u, shadertype = %s, index = %u, bufSize = %d, length = "
          "0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(BigGLEnum::ShaderType, shadertype), index, bufSize,
          (uintptr_t)length, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetActiveSubroutineUniformName(
                                context, angle::EntryPoint::GLGetActiveSubroutineUniformName,
                                programPacked, shadertype, index, bufSize, length, name));
        if (isCallValid)
        {
            context->getActiveSubroutineUniformName(programPacked, shadertype, index, bufSize,
                                                    length, name);
        }
        ANGLE_CAPTURE_GL(GetActiveSubroutineUniformName, isCallValid, context, programPacked,
                         shadertype, index, bufSize, length, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveSubroutineUniformiv(GLuint program,
                                                 GLenum shadertype,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveSubroutineUniformiv,
          "context = %d, program = %u, shadertype = %s, index = %u, pname = %s, values = "
          "0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(BigGLEnum::ShaderType, shadertype), index,
          GLenumToString(BigGLEnum::SubroutineParameterName, pname), (uintptr_t)values);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetActiveSubroutineUniformiv(
                                context, angle::EntryPoint::GLGetActiveSubroutineUniformiv,
                                programPacked, shadertype, index, pname, values));
        if (isCallValid)
        {
            context->getActiveSubroutineUniformiv(programPacked, shadertype, index, pname, values);
        }
        ANGLE_CAPTURE_GL(GetActiveSubroutineUniformiv, isCallValid, context, programPacked,
                         shadertype, index, pname, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetProgramStageiv(GLuint program,
                                      GLenum shadertype,
                                      GLenum pname,
                                      GLint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramStageiv,
          "context = %d, program = %u, shadertype = %s, pname = %s, values = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(BigGLEnum::ShaderType, shadertype),
          GLenumToString(BigGLEnum::ProgramStagePName, pname), (uintptr_t)values);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramStageiv(context, angle::EntryPoint::GLGetProgramStageiv,
                                       programPacked, shadertype, pname, values));
        if (isCallValid)
        {
            context->getProgramStageiv(programPacked, shadertype, pname, values);
        }
        ANGLE_CAPTURE_GL(GetProgramStageiv, isCallValid, context, programPacked, shadertype, pname,
                         values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryIndexediv,
          "context = %d, target = %s, index = %u, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::QueryTarget, target), index,
          GLenumToString(BigGLEnum::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryIndexediv(context, angle::EntryPoint::GLGetQueryIndexediv, target,
                                       index, pname, params));
        if (isCallValid)
        {
            context->getQueryIndexediv(target, index, pname, params);
        }
        ANGLE_CAPTURE_GL(GetQueryIndexediv, isCallValid, context, target, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GL_GetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSubroutineIndex,
          "context = %d, program = %u, shadertype = %s, name = 0x%016" PRIxPTR "", CID(context),
          program, GLenumToString(BigGLEnum::ShaderType, shadertype), (uintptr_t)name);

    GLuint returnValue;
    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSubroutineIndex(context, angle::EntryPoint::GLGetSubroutineIndex,
                                        programPacked, shadertype, name));
        if (isCallValid)
        {
            returnValue = context->getSubroutineIndex(programPacked, shadertype, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetSubroutineIndex, GLuint>();
        }
        ANGLE_CAPTURE_GL(GetSubroutineIndex, isCallValid, context, programPacked, shadertype, name,
                         returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetSubroutineIndex, GLuint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GL_GetSubroutineUniformLocation(GLuint program,
                                                  GLenum shadertype,
                                                  const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetSubroutineUniformLocation,
          "context = %d, program = %u, shadertype = %s, name = 0x%016" PRIxPTR "", CID(context),
          program, GLenumToString(BigGLEnum::ShaderType, shadertype), (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetSubroutineUniformLocation(
                                context, angle::EntryPoint::GLGetSubroutineUniformLocation,
                                programPacked, shadertype, name));
        if (isCallValid)
        {
            returnValue = context->getSubroutineUniformLocation(programPacked, shadertype, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetSubroutineUniformLocation, GLint>();
        }
        ANGLE_CAPTURE_GL(GetSubroutineUniformLocation, isCallValid, context, programPacked,
                         shadertype, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetSubroutineUniformLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformSubroutineuiv,
          "context = %d, shadertype = %s, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::ShaderType, shadertype), location, (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetUniformSubroutineuiv(context, angle::EntryPoint::GLGetUniformSubroutineuiv,
                                             shadertype, location, params));
        if (isCallValid)
        {
            context->getUniformSubroutineuiv(shadertype, location, params);
        }
        ANGLE_CAPTURE_GL(GetUniformSubroutineuiv, isCallValid, context, shadertype, location,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUniformdv(GLuint program, GLint location, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformdv,
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetUniformdv(context, angle::EntryPoint::GLGetUniformdv,
                                                 programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformdv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE_GL(GetUniformdv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PatchParameterfv(GLenum pname, const GLfloat *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPatchParameterfv, "context = %d, pname = %s, values = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::PatchParameterName, pname), (uintptr_t)values);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPatchParameterfv) &&
              ValidatePatchParameterfv(context, angle::EntryPoint::GLPatchParameterfv, pname,
                                       values)));
        if (isCallValid)
        {
            context->patchParameterfv(pname, values);
        }
        ANGLE_CAPTURE_GL(PatchParameterfv, isCallValid, context, pname, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform1d(GLint location, GLdouble x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform1d, "context = %d, location = %d, x = %f", CID(context), location, x);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniform1d(context, angle::EntryPoint::GLUniform1d, locationPacked, x));
        if (isCallValid)
        {
            context->uniform1d(locationPacked, x);
        }
        ANGLE_CAPTURE_GL(Uniform1d, isCallValid, context, locationPacked, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform1dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform1dv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniform1dv(context, angle::EntryPoint::GLUniform1dv,
                                               locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform1dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform1dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform2d(GLint location, GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform2d, "context = %d, location = %d, x = %f, y = %f", CID(context),
          location, x, y);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniform2d(context, angle::EntryPoint::GLUniform2d, locationPacked, x, y));
        if (isCallValid)
        {
            context->uniform2d(locationPacked, x, y);
        }
        ANGLE_CAPTURE_GL(Uniform2d, isCallValid, context, locationPacked, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform2dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform2dv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniform2dv(context, angle::EntryPoint::GLUniform2dv,
                                               locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform2dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform2dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform3d, "context = %d, location = %d, x = %f, y = %f, z = %f", CID(context),
          location, x, y, z);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniform3d(context, angle::EntryPoint::GLUniform3d, locationPacked, x, y, z));
        if (isCallValid)
        {
            context->uniform3d(locationPacked, x, y, z);
        }
        ANGLE_CAPTURE_GL(Uniform3d, isCallValid, context, locationPacked, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform3dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform3dv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniform3dv(context, angle::EntryPoint::GLUniform3dv,
                                               locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform3dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform3dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform4d, "context = %d, location = %d, x = %f, y = %f, z = %f, w = %f",
          CID(context), location, x, y, z, w);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4d(context, angle::EntryPoint::GLUniform4d,
                                                            locationPacked, x, y, z, w));
        if (isCallValid)
        {
            context->uniform4d(locationPacked, x, y, z, w);
        }
        ANGLE_CAPTURE_GL(Uniform4d, isCallValid, context, locationPacked, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform4dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform4dv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniform4dv(context, angle::EntryPoint::GLUniform4dv,
                                               locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform4dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform4dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix2dv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix2dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniformMatrix2dv(context, angle::EntryPoint::GLUniformMatrix2dv,
                                                     locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix2dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix2x3dv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix2x3dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2x3dv(context, angle::EntryPoint::GLUniformMatrix2x3dv,
                                        locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x3dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix2x3dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix2x4dv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix2x4dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2x4dv(context, angle::EntryPoint::GLUniformMatrix2x4dv,
                                        locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x4dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix2x4dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix3dv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix3dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniformMatrix3dv(context, angle::EntryPoint::GLUniformMatrix3dv,
                                                     locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix3dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix3x2dv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix3x2dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3x2dv(context, angle::EntryPoint::GLUniformMatrix3x2dv,
                                        locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3x2dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix3x2dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix3x4dv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix3x4dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3x4dv(context, angle::EntryPoint::GLUniformMatrix3x4dv,
                                        locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3x4dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix3x4dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix4dv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix4dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateUniformMatrix4dv(context, angle::EntryPoint::GLUniformMatrix4dv,
                                                     locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix4dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix4x2dv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix4x2dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4x2dv(context, angle::EntryPoint::GLUniformMatrix4x2dv,
                                        locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4x2dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix4x2dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix4x3dv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix4x3dv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4x3dv(context, angle::EntryPoint::GLUniformMatrix4x3dv,
                                        locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4x3dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix4x3dv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformSubroutinesuiv,
          "context = %d, shadertype = %s, count = %d, indices = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::ShaderType, shadertype), count, (uintptr_t)indices);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformSubroutinesuiv(context, angle::EntryPoint::GLUniformSubroutinesuiv,
                                           shadertype, count, indices));
        if (isCallValid)
        {
            context->uniformSubroutinesuiv(shadertype, count, indices);
        }
        ANGLE_CAPTURE_GL(UniformSubroutinesuiv, isCallValid, context, shadertype, count, indices);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 4.1
void GL_APIENTRY GL_DepthRangeArrayv(GLuint first, GLsizei count, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthRangeArrayv,
          "context = %d, first = %u, count = %d, v = 0x%016" PRIxPTR "", CID(context), first, count,
          (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLDepthRangeArrayv) &&
              ValidateDepthRangeArrayv(context, angle::EntryPoint::GLDepthRangeArrayv, first, count,
                                       v)));
        if (isCallValid)
        {
            context->depthRangeArrayv(first, count, v);
        }
        ANGLE_CAPTURE_GL(DepthRangeArrayv, isCallValid, context, first, count, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DepthRangeIndexed(GLuint index, GLdouble n, GLdouble f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthRangeIndexed, "context = %d, index = %u, n = %f, f = %f", CID(context),
          index, n, f);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLDepthRangeIndexed) &&
              ValidateDepthRangeIndexed(context, angle::EntryPoint::GLDepthRangeIndexed, index, n,
                                        f)));
        if (isCallValid)
        {
            context->depthRangeIndexed(index, n, f);
        }
        ANGLE_CAPTURE_GL(DepthRangeIndexed, isCallValid, context, index, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetDoublei_v(GLenum target, GLuint index, GLdouble *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetDoublei_v,
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::GetPName, target), index, (uintptr_t)data);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetDoublei_v(context, angle::EntryPoint::GLGetDoublei_v, target, index, data));
        if (isCallValid)
        {
            context->getDoublei_v(target, index, data);
        }
        ANGLE_CAPTURE_GL(GetDoublei_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetFloati_v(GLenum target, GLuint index, GLfloat *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFloati_v, "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::GetPName, target), index, (uintptr_t)data);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetFloati_v(context, angle::EntryPoint::GLGetFloati_v, target, index, data));
        if (isCallValid)
        {
            context->getFloati_v(target, index, data);
        }
        ANGLE_CAPTURE_GL(GetFloati_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribLdv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(BigGLEnum::VertexAttribEnum, pname), (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexAttribLdv(context, angle::EntryPoint::GLGetVertexAttribLdv, index,
                                        pname, params));
        if (isCallValid)
        {
            context->getVertexAttribLdv(index, pname, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribLdv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1d(GLuint program, GLint location, GLdouble v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1d, "context = %d, program = %u, location = %d, v0 = %f",
          CID(context), program, location, v0);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform1d) &&
              ValidateProgramUniform1d(context, angle::EntryPoint::GLProgramUniform1d,
                                       programPacked, locationPacked, v0)));
        if (isCallValid)
        {
            context->programUniform1d(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1d, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform1dv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform1dv,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform1dv) &&
              ValidateProgramUniform1dv(context, angle::EntryPoint::GLProgramUniform1dv,
                                        programPacked, locationPacked, count, value)));
        if (isCallValid)
        {
            context->programUniform1dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1dv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2d(GLuint program, GLint location, GLdouble v0, GLdouble v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2d,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform2d) &&
              ValidateProgramUniform2d(context, angle::EntryPoint::GLProgramUniform2d,
                                       programPacked, locationPacked, v0, v1)));
        if (isCallValid)
        {
            context->programUniform2d(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2d, isCallValid, context, programPacked, locationPacked, v0,
                         v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform2dv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform2dv,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform2dv) &&
              ValidateProgramUniform2dv(context, angle::EntryPoint::GLProgramUniform2dv,
                                        programPacked, locationPacked, count, value)));
        if (isCallValid)
        {
            context->programUniform2dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2dv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ProgramUniform3d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3d,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform3d) &&
              ValidateProgramUniform3d(context, angle::EntryPoint::GLProgramUniform3d,
                                       programPacked, locationPacked, v0, v1, v2)));
        if (isCallValid)
        {
            context->programUniform3d(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3d, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform3dv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform3dv,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform3dv) &&
              ValidateProgramUniform3dv(context, angle::EntryPoint::GLProgramUniform3dv,
                                        programPacked, locationPacked, count, value)));
        if (isCallValid)
        {
            context->programUniform3dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3dv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform4d(GLuint program,
                                     GLint location,
                                     GLdouble v0,
                                     GLdouble v1,
                                     GLdouble v2,
                                     GLdouble v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4d,
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform4d) &&
              ValidateProgramUniform4d(context, angle::EntryPoint::GLProgramUniform4d,
                                       programPacked, locationPacked, v0, v1, v2, v3)));
        if (isCallValid)
        {
            context->programUniform4d(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4d, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniform4dv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniform4dv,
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLProgramUniform4dv) &&
              ValidateProgramUniform4dv(context, angle::EntryPoint::GLProgramUniform4dv,
                                        programPacked, locationPacked, count, value)));
        if (isCallValid)
        {
            context->programUniform4dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4dv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix2dv(GLuint program,
                                            GLint location,
                                            GLsizei count,
                                            GLboolean transpose,
                                            const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix2dv) &&
                             ValidateProgramUniformMatrix2dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix2dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix2dv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix2x3dv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2x3dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix2x3dv) &&
                             ValidateProgramUniformMatrix2x3dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix2x3dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix2x3dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2x3dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix2x4dv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix2x4dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix2x4dv) &&
                             ValidateProgramUniformMatrix2x4dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix2x4dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix2x4dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2x4dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix3dv(GLuint program,
                                            GLint location,
                                            GLsizei count,
                                            GLboolean transpose,
                                            const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix3dv) &&
                             ValidateProgramUniformMatrix3dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix3dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix3dv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix3x2dv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3x2dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix3x2dv) &&
                             ValidateProgramUniformMatrix3x2dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix3x2dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix3x2dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3x2dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix3x4dv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix3x4dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix3x4dv) &&
                             ValidateProgramUniformMatrix3x4dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix3x4dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix3x4dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3x4dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix4dv(GLuint program,
                                            GLint location,
                                            GLsizei count,
                                            GLboolean transpose,
                                            const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix4dv) &&
                             ValidateProgramUniformMatrix4dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix4dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix4dv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix4x2dv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4x2dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix4x2dv) &&
                             ValidateProgramUniformMatrix4x2dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix4x2dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix4x2dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4x2dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ProgramUniformMatrix4x3dv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLProgramUniformMatrix4x3dv,
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLProgramUniformMatrix4x3dv) &&
                             ValidateProgramUniformMatrix4x3dv(
                                 context, angle::EntryPoint::GLProgramUniformMatrix4x3dv,
                                 programPacked, locationPacked, count, transpose, value)));
        if (isCallValid)
        {
            context->programUniformMatrix4x3dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4x3dv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ScissorArrayv(GLuint first, GLsizei count, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScissorArrayv, "context = %d, first = %u, count = %d, v = 0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLScissorArrayv) &&
              ValidateScissorArrayv(context, angle::EntryPoint::GLScissorArrayv, first, count, v)));
        if (isCallValid)
        {
            context->scissorArrayv(first, count, v);
        }
        ANGLE_CAPTURE_GL(ScissorArrayv, isCallValid, context, first, count, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScissorIndexed,
          "context = %d, index = %u, left = %d, bottom = %d, width = %d, height = %d", CID(context),
          index, left, bottom, width, height);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLScissorIndexed) &&
              ValidateScissorIndexed(context, angle::EntryPoint::GLScissorIndexed, index, left,
                                     bottom, width, height)));
        if (isCallValid)
        {
            context->scissorIndexed(index, left, bottom, width, height);
        }
        ANGLE_CAPTURE_GL(ScissorIndexed, isCallValid, context, index, left, bottom, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ScissorIndexedv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScissorIndexedv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLScissorIndexedv) &&
              ValidateScissorIndexedv(context, angle::EntryPoint::GLScissorIndexedv, index, v)));
        if (isCallValid)
        {
            context->scissorIndexedv(index, v);
        }
        ANGLE_CAPTURE_GL(ScissorIndexedv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL1d(GLuint index, GLdouble x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL1d, "context = %d, index = %u, x = %f", CID(context), index, x);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribL1d(context, angle::EntryPoint::GLVertexAttribL1d, index, x));
        if (isCallValid)
        {
            context->vertexAttribL1d(index, x);
        }
        ANGLE_CAPTURE_GL(VertexAttribL1d, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL1dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL1dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribL1dv(context, angle::EntryPoint::GLVertexAttribL1dv, index, v));
        if (isCallValid)
        {
            context->vertexAttribL1dv(index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribL1dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL2d(GLuint index, GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL2d, "context = %d, index = %u, x = %f, y = %f", CID(context),
          index, x, y);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribL2d(context, angle::EntryPoint::GLVertexAttribL2d, index, x, y));
        if (isCallValid)
        {
            context->vertexAttribL2d(index, x, y);
        }
        ANGLE_CAPTURE_GL(VertexAttribL2d, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL2dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL2dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribL2dv(context, angle::EntryPoint::GLVertexAttribL2dv, index, v));
        if (isCallValid)
        {
            context->vertexAttribL2dv(index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribL2dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL3d, "context = %d, index = %u, x = %f, y = %f, z = %f",
          CID(context), index, x, y, z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateVertexAttribL3d(context, angle::EntryPoint::GLVertexAttribL3d,
                                                    index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttribL3d(index, x, y, z);
        }
        ANGLE_CAPTURE_GL(VertexAttribL3d, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL3dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL3dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribL3dv(context, angle::EntryPoint::GLVertexAttribL3dv, index, v));
        if (isCallValid)
        {
            context->vertexAttribL3dv(index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribL3dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL4d, "context = %d, index = %u, x = %f, y = %f, z = %f, w = %f",
          CID(context), index, x, y, z, w);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateVertexAttribL4d(context, angle::EntryPoint::GLVertexAttribL4d,
                                                    index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttribL4d(index, x, y, z, w);
        }
        ANGLE_CAPTURE_GL(VertexAttribL4d, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribL4dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribL4dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribL4dv(context, angle::EntryPoint::GLVertexAttribL4dv, index, v));
        if (isCallValid)
        {
            context->vertexAttribL4dv(index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttribL4dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_VertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribLPointer,
          "context = %d, index = %u, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR
          "",
          CID(context), index, size, GLenumToString(BigGLEnum::VertexAttribLType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribLPointer(context, angle::EntryPoint::GLVertexAttribLPointer, index,
                                          size, type, stride, pointer));
        if (isCallValid)
        {
            context->vertexAttribLPointer(index, size, type, stride, pointer);
        }
        ANGLE_CAPTURE_GL(VertexAttribLPointer, isCallValid, context, index, size, type, stride,
                         pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ViewportArrayv(GLuint first, GLsizei count, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLViewportArrayv, "context = %d, first = %u, count = %d, v = 0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLViewportArrayv) &&
              ValidateViewportArrayv(context, angle::EntryPoint::GLViewportArrayv, first, count,
                                     v)));
        if (isCallValid)
        {
            context->viewportArrayv(first, count, v);
        }
        ANGLE_CAPTURE_GL(ViewportArrayv, isCallValid, context, first, count, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLViewportIndexedf, "context = %d, index = %u, x = %f, y = %f, w = %f, h = %f",
          CID(context), index, x, y, w, h);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLViewportIndexedf) &&
              ValidateViewportIndexedf(context, angle::EntryPoint::GLViewportIndexedf, index, x, y,
                                       w, h)));
        if (isCallValid)
        {
            context->viewportIndexedf(index, x, y, w, h);
        }
        ANGLE_CAPTURE_GL(ViewportIndexedf, isCallValid, context, index, x, y, w, h);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ViewportIndexedfv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLViewportIndexedfv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLViewportIndexedfv) &&
              ValidateViewportIndexedfv(context, angle::EntryPoint::GLViewportIndexedfv, index,
                                        v)));
        if (isCallValid)
        {
            context->viewportIndexedfv(index, v);
        }
        ANGLE_CAPTURE_GL(ViewportIndexedfv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 4.2
void GL_APIENTRY GL_DrawArraysInstancedBaseInstance(GLenum mode,
                                                    GLint first,
                                                    GLsizei count,
                                                    GLsizei instancecount,
                                                    GLuint baseinstance)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawArraysInstancedBaseInstance,
          "context = %d, mode = %s, first = %d, count = %d, instancecount = %d, baseinstance = %u",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), first, count, instancecount,
          baseinstance);

    if (context)
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateDrawArraysInstancedBaseInstance(
                                context, angle::EntryPoint::GLDrawArraysInstancedBaseInstance,
                                modePacked, first, count, instancecount, baseinstance));
        if (isCallValid)
        {
            context->drawArraysInstancedBaseInstance(modePacked, first, count, instancecount,
                                                     baseinstance);
        }
        ANGLE_CAPTURE_GL(DrawArraysInstancedBaseInstance, isCallValid, context, modePacked, first,
                         count, instancecount, baseinstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseInstance(GLenum mode,
                                                      GLsizei count,
                                                      GLenum type,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLuint baseinstance)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseInstance,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, baseinstance = %u",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), count,
          GLenumToString(BigGLEnum::PrimitiveType, type), (uintptr_t)indices, instancecount,
          baseinstance);

    if (context)
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawElementsInstancedBaseInstance(
                 context, angle::EntryPoint::GLDrawElementsInstancedBaseInstance, modePacked, count,
                 typePacked, indices, instancecount, baseinstance));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseInstance(modePacked, count, typePacked, indices,
                                                       instancecount, baseinstance);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseInstance, isCallValid, context, modePacked, count,
                         typePacked, indices, instancecount, baseinstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawElementsInstancedBaseVertexBaseInstance(GLenum mode,
                                                                GLsizei count,
                                                                GLenum type,
                                                                const void *indices,
                                                                GLsizei instancecount,
                                                                GLint basevertex,
                                                                GLuint baseinstance)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawElementsInstancedBaseVertexBaseInstance,
          "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR
          ", instancecount = %d, basevertex = %d, baseinstance = %u",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), count,
          GLenumToString(BigGLEnum::DrawElementsType, type), (uintptr_t)indices, instancecount,
          basevertex, baseinstance);

    if (context)
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawElementsInstancedBaseVertexBaseInstance(
                 context, angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstance,
                 modePacked, count, typePacked, indices, instancecount, basevertex, baseinstance));
        if (isCallValid)
        {
            context->drawElementsInstancedBaseVertexBaseInstance(
                modePacked, count, typePacked, indices, instancecount, basevertex, baseinstance);
        }
        ANGLE_CAPTURE_GL(DrawElementsInstancedBaseVertexBaseInstance, isCallValid, context,
                         modePacked, count, typePacked, indices, instancecount, basevertex,
                         baseinstance);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei instancecount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTransformFeedbackInstanced,
          "context = %d, mode = %s, id = %u, instancecount = %d", CID(context),
          GLenumToString(BigGLEnum::PrimitiveType, mode), id, instancecount);

    if (context)
    {
        TransformFeedbackID idPacked = PackParam<TransformFeedbackID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLDrawTransformFeedbackInstanced) &&
                             ValidateDrawTransformFeedbackInstanced(
                                 context, angle::EntryPoint::GLDrawTransformFeedbackInstanced, mode,
                                 idPacked, instancecount)));
        if (isCallValid)
        {
            context->drawTransformFeedbackInstanced(mode, idPacked, instancecount);
        }
        ANGLE_CAPTURE_GL(DrawTransformFeedbackInstanced, isCallValid, context, mode, idPacked,
                         instancecount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawTransformFeedbackStreamInstanced(GLenum mode,
                                                         GLuint id,
                                                         GLuint stream,
                                                         GLsizei instancecount)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawTransformFeedbackStreamInstanced,
          "context = %d, mode = %s, id = %u, stream = %u, instancecount = %d", CID(context),
          GLenumToString(BigGLEnum::PrimitiveType, mode), id, stream, instancecount);

    if (context)
    {
        TransformFeedbackID idPacked = PackParam<TransformFeedbackID>(id);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(
                  context, angle::EntryPoint::GLDrawTransformFeedbackStreamInstanced) &&
              ValidateDrawTransformFeedbackStreamInstanced(
                  context, angle::EntryPoint::GLDrawTransformFeedbackStreamInstanced, mode,
                  idPacked, stream, instancecount)));
        if (isCallValid)
        {
            context->drawTransformFeedbackStreamInstanced(mode, idPacked, stream, instancecount);
        }
        ANGLE_CAPTURE_GL(DrawTransformFeedbackStreamInstanced, isCallValid, context, mode, idPacked,
                         stream, instancecount);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveAtomicCounterBufferiv(GLuint program,
                                                   GLuint bufferIndex,
                                                   GLenum pname,
                                                   GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveAtomicCounterBufferiv,
          "context = %d, program = %u, bufferIndex = %u, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), program, bufferIndex,
          GLenumToString(BigGLEnum::AtomicCounterBufferPName, pname), (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetActiveAtomicCounterBufferiv(
                                context, angle::EntryPoint::GLGetActiveAtomicCounterBufferiv,
                                programPacked, bufferIndex, pname, params));
        if (isCallValid)
        {
            context->getActiveAtomicCounterBufferiv(programPacked, bufferIndex, pname, params);
        }
        ANGLE_CAPTURE_GL(GetActiveAtomicCounterBufferiv, isCallValid, context, programPacked,
                         bufferIndex, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TexStorage1D(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexStorage1D,
          "context = %d, target = %s, levels = %d, internalformat = %s, width = %d", CID(context),
          GLenumToString(BigGLEnum::TextureTarget, target), levels,
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), width);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexStorage1D) &&
              ValidateTexStorage1D(context, angle::EntryPoint::GLTexStorage1D, target, levels,
                                   internalformat, width)));
        if (isCallValid)
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
        ANGLE_CAPTURE_GL(TexStorage1D, isCallValid, context, target, levels, internalformat, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 4.3
void GL_APIENTRY GL_ClearBufferData(GLenum target,
                                    GLenum internalformat,
                                    GLenum format,
                                    GLenum type,
                                    const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearBufferData,
          "context = %d, target = %s, internalformat = %s, format = %s, type = %s, data = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::BufferStorageTarget, target),
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)data);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateClearBufferData(context, angle::EntryPoint::GLClearBufferData,
                                                    target, internalformat, format, type, data));
        if (isCallValid)
        {
            context->clearBufferData(target, internalformat, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearBufferData, isCallValid, context, target, internalformat, format,
                         type, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearBufferSubData(GLenum target,
                                       GLenum internalformat,
                                       GLintptr offset,
                                       GLsizeiptr size,
                                       GLenum format,
                                       GLenum type,
                                       const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearBufferSubData,
          "context = %d, target = %s, internalformat = %s, offset = %llu, size = %llu, format = "
          "%s, type = %s, data = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::BufferTargetARB, target),
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)data);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateClearBufferSubData(context, angle::EntryPoint::GLClearBufferSubData, target,
                                        internalformat, offset, size, format, type, data));
        if (isCallValid)
        {
            context->clearBufferSubData(target, internalformat, offset, size, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearBufferSubData, isCallValid, context, target, internalformat, offset,
                         size, format, type, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetInternalformati64v(GLenum target,
                                          GLenum internalformat,
                                          GLenum pname,
                                          GLsizei count,
                                          GLint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetInternalformati64v,
          "context = %d, target = %s, internalformat = %s, pname = %s, count = %d, params = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TextureTarget, target),
          GLenumToString(BigGLEnum::InternalFormat, internalformat),
          GLenumToString(BigGLEnum::InternalFormatPName, pname), count, (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetInternalformati64v(context, angle::EntryPoint::GLGetInternalformati64v,
                                           target, internalformat, pname, count, params));
        if (isCallValid)
        {
            context->getInternalformati64v(target, internalformat, pname, count, params);
        }
        ANGLE_CAPTURE_GL(GetInternalformati64v, isCallValid, context, target, internalformat, pname,
                         count, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLint GL_APIENTRY GL_GetProgramResourceLocationIndex(GLuint program,
                                                     GLenum programInterface,
                                                     const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramResourceLocationIndex,
          "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(BigGLEnum::ProgramInterface, programInterface),
          (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetProgramResourceLocationIndex(
                                context, angle::EntryPoint::GLGetProgramResourceLocationIndex,
                                programPacked, programInterface, name));
        if (isCallValid)
        {
            returnValue =
                context->getProgramResourceLocationIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndex,
                                      GLint>();
        }
        ANGLE_CAPTURE_GL(GetProgramResourceLocationIndex, isCallValid, context, programPacked,
                         programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocationIndex, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_InvalidateBufferData(GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateBufferData, "context = %d, buffer = %u", CID(context), buffer);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLInvalidateBufferData) &&
              ValidateInvalidateBufferData(context, angle::EntryPoint::GLInvalidateBufferData,
                                           bufferPacked)));
        if (isCallValid)
        {
            context->invalidateBufferData(bufferPacked);
        }
        ANGLE_CAPTURE_GL(InvalidateBufferData, isCallValid, context, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateBufferSubData,
          "context = %d, buffer = %u, offset = %llu, length = %llu", CID(context), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLInvalidateBufferSubData) &&
              ValidateInvalidateBufferSubData(context, angle::EntryPoint::GLInvalidateBufferSubData,
                                              bufferPacked, offset, length)));
        if (isCallValid)
        {
            context->invalidateBufferSubData(bufferPacked, offset, length);
        }
        ANGLE_CAPTURE_GL(InvalidateBufferSubData, isCallValid, context, bufferPacked, offset,
                         length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InvalidateTexImage(GLuint texture, GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateTexImage, "context = %d, texture = %u, level = %d", CID(context),
          texture, level);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLInvalidateTexImage) &&
              ValidateInvalidateTexImage(context, angle::EntryPoint::GLInvalidateTexImage,
                                         texturePacked, level)));
        if (isCallValid)
        {
            context->invalidateTexImage(texturePacked, level);
        }
        ANGLE_CAPTURE_GL(InvalidateTexImage, isCallValid, context, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InvalidateTexSubImage(GLuint texture,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint zoffset,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateTexSubImage,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLInvalidateTexSubImage) &&
                             ValidateInvalidateTexSubImage(
                                 context, angle::EntryPoint::GLInvalidateTexSubImage, texturePacked,
                                 level, xoffset, yoffset, zoffset, width, height, depth)));
        if (isCallValid)
        {
            context->invalidateTexSubImage(texturePacked, level, xoffset, yoffset, zoffset, width,
                                           height, depth);
        }
        ANGLE_CAPTURE_GL(InvalidateTexSubImage, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, zoffset, width, height, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawArraysIndirect(GLenum mode,
                                            const void *indirect,
                                            GLsizei drawcount,
                                            GLsizei stride)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysIndirect,
          "context = %d, mode = %s, indirect = 0x%016" PRIxPTR ", drawcount = %d, stride = %d",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), (uintptr_t)indirect,
          drawcount, stride);

    if (context)
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLMultiDrawArraysIndirect) &&
              ValidateMultiDrawArraysIndirect(context, angle::EntryPoint::GLMultiDrawArraysIndirect,
                                              modePacked, indirect, drawcount, stride)));
        if (isCallValid)
        {
            context->multiDrawArraysIndirect(modePacked, indirect, drawcount, stride);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysIndirect, isCallValid, context, modePacked, indirect,
                         drawcount, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawElementsIndirect(GLenum mode,
                                              GLenum type,
                                              const void *indirect,
                                              GLsizei drawcount,
                                              GLsizei stride)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsIndirect,
          "context = %d, mode = %s, type = %s, indirect = 0x%016" PRIxPTR
          ", drawcount = %d, stride = %d",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode),
          GLenumToString(BigGLEnum::DrawElementsType, type), (uintptr_t)indirect, drawcount,
          stride);

    if (context)
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLMultiDrawElementsIndirect) &&
                             ValidateMultiDrawElementsIndirect(
                                 context, angle::EntryPoint::GLMultiDrawElementsIndirect,
                                 modePacked, typePacked, indirect, drawcount, stride)));
        if (isCallValid)
        {
            context->multiDrawElementsIndirect(modePacked, typePacked, indirect, drawcount, stride);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsIndirect, isCallValid, context, modePacked, typePacked,
                         indirect, drawcount, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ShaderStorageBlockBinding(GLuint program,
                                              GLuint storageBlockIndex,
                                              GLuint storageBlockBinding)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShaderStorageBlockBinding,
          "context = %d, program = %u, storageBlockIndex = %u, storageBlockBinding = %u",
          CID(context), program, storageBlockIndex, storageBlockBinding);

    if (context)
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLShaderStorageBlockBinding) &&
                             ValidateShaderStorageBlockBinding(
                                 context, angle::EntryPoint::GLShaderStorageBlockBinding,
                                 programPacked, storageBlockIndex, storageBlockBinding)));
        if (isCallValid)
        {
            context->shaderStorageBlockBinding(programPacked, storageBlockIndex,
                                               storageBlockBinding);
        }
        ANGLE_CAPTURE_GL(ShaderStorageBlockBinding, isCallValid, context, programPacked,
                         storageBlockIndex, storageBlockBinding);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureView(GLuint texture,
                                GLenum target,
                                GLuint origtexture,
                                GLenum internalformat,
                                GLuint minlevel,
                                GLuint numlevels,
                                GLuint minlayer,
                                GLuint numlayers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureView,
          "context = %d, texture = %u, target = %s, origtexture = %u, internalformat = %s, "
          "minlevel = %u, numlevels = %u, minlayer = %u, numlayers = %u",
          CID(context), texture, GLenumToString(BigGLEnum::TextureTarget, target), origtexture,
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), minlevel, numlevels,
          minlayer, numlayers);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureView) &&
              ValidateTextureView(context, angle::EntryPoint::GLTextureView, texturePacked, target,
                                  origtexture, internalformat, minlevel, numlevels, minlayer,
                                  numlayers)));
        if (isCallValid)
        {
            context->textureView(texturePacked, target, origtexture, internalformat, minlevel,
                                 numlevels, minlayer, numlayers);
        }
        ANGLE_CAPTURE_GL(TextureView, isCallValid, context, texturePacked, target, origtexture,
                         internalformat, minlevel, numlevels, minlayer, numlayers);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribLFormat(GLuint attribindex,
                                        GLint size,
                                        GLenum type,
                                        GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribLFormat,
          "context = %d, attribindex = %u, size = %d, type = %s, relativeoffset = %u", CID(context),
          attribindex, size, GLenumToString(BigGLEnum::VertexAttribLType, type), relativeoffset);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribLFormat(context, angle::EntryPoint::GLVertexAttribLFormat,
                                         attribindex, size, type, relativeoffset));
        if (isCallValid)
        {
            context->vertexAttribLFormat(attribindex, size, type, relativeoffset);
        }
        ANGLE_CAPTURE_GL(VertexAttribLFormat, isCallValid, context, attribindex, size, type,
                         relativeoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 4.4
void GL_APIENTRY GL_BindBuffersBase(GLenum target,
                                    GLuint first,
                                    GLsizei count,
                                    const GLuint *buffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindBuffersBase,
          "context = %d, target = %s, first = %u, count = %d, buffers = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::BufferTargetARB, target), first, count,
          (uintptr_t)buffers);

    if (context)
    {
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindBuffersBase) &&
              ValidateBindBuffersBase(context, angle::EntryPoint::GLBindBuffersBase, target, first,
                                      count, buffersPacked)));
        if (isCallValid)
        {
            context->bindBuffersBase(target, first, count, buffersPacked);
        }
        ANGLE_CAPTURE_GL(BindBuffersBase, isCallValid, context, target, first, count,
                         buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindBuffersRange(GLenum target,
                                     GLuint first,
                                     GLsizei count,
                                     const GLuint *buffers,
                                     const GLintptr *offsets,
                                     const GLsizeiptr *sizes)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindBuffersRange,
          "context = %d, target = %s, first = %u, count = %d, buffers = 0x%016" PRIxPTR
          ", offsets = 0x%016" PRIxPTR ", sizes = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::BufferTargetARB, target), first, count,
          (uintptr_t)buffers, (uintptr_t)offsets, (uintptr_t)sizes);

    if (context)
    {
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindBuffersRange) &&
              ValidateBindBuffersRange(context, angle::EntryPoint::GLBindBuffersRange, target,
                                       first, count, buffersPacked, offsets, sizes)));
        if (isCallValid)
        {
            context->bindBuffersRange(target, first, count, buffersPacked, offsets, sizes);
        }
        ANGLE_CAPTURE_GL(BindBuffersRange, isCallValid, context, target, first, count,
                         buffersPacked, offsets, sizes);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindImageTextures(GLuint first, GLsizei count, const GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindImageTextures,
          "context = %d, first = %u, count = %d, textures = 0x%016" PRIxPTR "", CID(context), first,
          count, (uintptr_t)textures);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindImageTextures) &&
              ValidateBindImageTextures(context, angle::EntryPoint::GLBindImageTextures, first,
                                        count, textures)));
        if (isCallValid)
        {
            context->bindImageTextures(first, count, textures);
        }
        ANGLE_CAPTURE_GL(BindImageTextures, isCallValid, context, first, count, textures);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindSamplers(GLuint first, GLsizei count, const GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindSamplers,
          "context = %d, first = %u, count = %d, samplers = 0x%016" PRIxPTR "", CID(context), first,
          count, (uintptr_t)samplers);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindSamplers) &&
              ValidateBindSamplers(context, angle::EntryPoint::GLBindSamplers, first, count,
                                   samplers)));
        if (isCallValid)
        {
            context->bindSamplers(first, count, samplers);
        }
        ANGLE_CAPTURE_GL(BindSamplers, isCallValid, context, first, count, samplers);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindTextures(GLuint first, GLsizei count, const GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindTextures,
          "context = %d, first = %u, count = %d, textures = 0x%016" PRIxPTR "", CID(context), first,
          count, (uintptr_t)textures);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindTextures) &&
              ValidateBindTextures(context, angle::EntryPoint::GLBindTextures, first, count,
                                   textures)));
        if (isCallValid)
        {
            context->bindTextures(first, count, textures);
        }
        ANGLE_CAPTURE_GL(BindTextures, isCallValid, context, first, count, textures);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindVertexBuffers(GLuint first,
                                      GLsizei count,
                                      const GLuint *buffers,
                                      const GLintptr *offsets,
                                      const GLsizei *strides)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindVertexBuffers,
          "context = %d, first = %u, count = %d, buffers = 0x%016" PRIxPTR
          ", offsets = 0x%016" PRIxPTR ", strides = 0x%016" PRIxPTR "",
          CID(context), first, count, (uintptr_t)buffers, (uintptr_t)offsets, (uintptr_t)strides);

    if (context)
    {
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindVertexBuffers) &&
              ValidateBindVertexBuffers(context, angle::EntryPoint::GLBindVertexBuffers, first,
                                        count, buffersPacked, offsets, strides)));
        if (isCallValid)
        {
            context->bindVertexBuffers(first, count, buffersPacked, offsets, strides);
        }
        ANGLE_CAPTURE_GL(BindVertexBuffers, isCallValid, context, first, count, buffersPacked,
                         offsets, strides);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BufferStorage(GLenum target,
                                  GLsizeiptr size,
                                  const void *data,
                                  GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBufferStorage,
          "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR ", flags = %s",
          CID(context), GLenumToString(BigGLEnum::BufferStorageTarget, target),
          static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(BigGLEnum::BufferStorageMask, flags).c_str());

    if (context)
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBufferStorage) &&
              ValidateBufferStorage(context, angle::EntryPoint::GLBufferStorage, targetPacked, size,
                                    data, flags)));
        if (isCallValid)
        {
            context->bufferStorage(targetPacked, size, data, flags);
        }
        ANGLE_CAPTURE_GL(BufferStorage, isCallValid, context, targetPacked, size, data, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_ClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearTexImage,
          "context = %d, texture = %u, level = %d, format = %s, type = %s, data = 0x%016" PRIxPTR
          "",
          CID(context), texture, level, GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClearTexImage) &&
              ValidateClearTexImage(context, angle::EntryPoint::GLClearTexImage, texturePacked,
                                    level, format, type, data)));
        if (isCallValid)
        {
            context->clearTexImage(texturePacked, level, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearTexImage, isCallValid, context, texturePacked, level, format, type,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearTexSubImage(GLuint texture,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth,
                                     GLenum format,
                                     GLenum type,
                                     const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearTexSubImage,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, type = %s, data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClearTexSubImage) &&
              ValidateClearTexSubImage(context, angle::EntryPoint::GLClearTexSubImage,
                                       texturePacked, level, xoffset, yoffset, zoffset, width,
                                       height, depth, format, type, data)));
        if (isCallValid)
        {
            context->clearTexSubImage(texturePacked, level, xoffset, yoffset, zoffset, width,
                                      height, depth, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearTexSubImage, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, zoffset, width, height, depth, format, type, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 4.5
void GL_APIENTRY GL_BindTextureUnit(GLuint unit, GLuint texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindTextureUnit, "context = %d, unit = %u, texture = %u", CID(context), unit,
          texture);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLBindTextureUnit) &&
              ValidateBindTextureUnit(context, angle::EntryPoint::GLBindTextureUnit, unit,
                                      texturePacked)));
        if (isCallValid)
        {
            context->bindTextureUnit(unit, texturePacked);
        }
        ANGLE_CAPTURE_GL(BindTextureUnit, isCallValid, context, unit, texturePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlitNamedFramebuffer(GLuint readFramebuffer,
                                         GLuint drawFramebuffer,
                                         GLint srcX0,
                                         GLint srcY0,
                                         GLint srcX1,
                                         GLint srcY1,
                                         GLint dstX0,
                                         GLint dstY0,
                                         GLint dstX1,
                                         GLint dstY1,
                                         GLbitfield mask,
                                         GLenum filter)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        context, GLBlitNamedFramebuffer,
        "context = %d, readFramebuffer = %u, drawFramebuffer = %u, srcX0 = %d, srcY0 = %d, srcX1 = "
        "%d, srcY1 = %d, dstX0 = %d, dstY0 = %d, dstX1 = %d, dstY1 = %d, mask = %s, filter = %s",
        CID(context), readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0,
        dstX1, dstY1, GLbitfieldToString(BigGLEnum::ClearBufferMask, mask).c_str(),
        GLenumToString(BigGLEnum::BlitFramebufferFilter, filter));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLBlitNamedFramebuffer) &&
              ValidateBlitNamedFramebuffer(context, angle::EntryPoint::GLBlitNamedFramebuffer,
                                           readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1,
                                           srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter)));
        if (isCallValid)
        {
            context->blitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1,
                                          srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        }
        ANGLE_CAPTURE_GL(BlitNamedFramebuffer, isCallValid, context, readFramebuffer,
                         drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
                         mask, filter);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLenum GL_APIENTRY GL_CheckNamedFramebufferStatus(GLuint framebuffer, GLenum target)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCheckNamedFramebufferStatus, "context = %d, framebuffer = %u, target = %s",
          CID(context), framebuffer, GLenumToString(BigGLEnum::FramebufferTarget, target));

    GLenum returnValue;
    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLCheckNamedFramebufferStatus) &&
                             ValidateCheckNamedFramebufferStatus(
                                 context, angle::EntryPoint::GLCheckNamedFramebufferStatus,
                                 framebufferPacked, target)));
        if (isCallValid)
        {
            returnValue = context->checkNamedFramebufferStatus(framebufferPacked, target);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCheckNamedFramebufferStatus, GLenum>();
        }
        ANGLE_CAPTURE_GL(CheckNamedFramebufferStatus, isCallValid, context, framebufferPacked,
                         target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLCheckNamedFramebufferStatus, GLenum>();
    }
    return returnValue;
}

void GL_APIENTRY GL_ClearNamedBufferData(GLuint buffer,
                                         GLenum internalformat,
                                         GLenum format,
                                         GLenum type,
                                         const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearNamedBufferData,
          "context = %d, buffer = %u, internalformat = %s, format = %s, type = %s, data = "
          "0x%016" PRIxPTR "",
          CID(context), buffer, GLenumToString(BigGLEnum::SizedInternalFormat, internalformat),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLClearNamedBufferData) &&
              ValidateClearNamedBufferData(context, angle::EntryPoint::GLClearNamedBufferData,
                                           bufferPacked, internalformat, format, type, data)));
        if (isCallValid)
        {
            context->clearNamedBufferData(bufferPacked, internalformat, format, type, data);
        }
        ANGLE_CAPTURE_GL(ClearNamedBufferData, isCallValid, context, bufferPacked, internalformat,
                         format, type, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearNamedBufferSubData(GLuint buffer,
                                            GLenum internalformat,
                                            GLintptr offset,
                                            GLsizeiptr size,
                                            GLenum format,
                                            GLenum type,
                                            const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearNamedBufferSubData,
          "context = %d, buffer = %u, internalformat = %s, offset = %llu, size = %llu, format = "
          "%s, type = %s, data = 0x%016" PRIxPTR "",
          CID(context), buffer, GLenumToString(BigGLEnum::SizedInternalFormat, internalformat),
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLClearNamedBufferSubData) &&
                             ValidateClearNamedBufferSubData(
                                 context, angle::EntryPoint::GLClearNamedBufferSubData,
                                 bufferPacked, internalformat, offset, size, format, type, data)));
        if (isCallValid)
        {
            context->clearNamedBufferSubData(bufferPacked, internalformat, offset, size, format,
                                             type, data);
        }
        ANGLE_CAPTURE_GL(ClearNamedBufferSubData, isCallValid, context, bufferPacked,
                         internalformat, offset, size, format, type, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearNamedFramebufferfi(GLuint framebuffer,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            GLfloat depth,
                                            GLint stencil)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearNamedFramebufferfi,
          "context = %d, framebuffer = %u, buffer = %s, drawbuffer = %d, depth = %f, stencil = %d",
          CID(context), framebuffer, GLenumToString(BigGLEnum::Buffer, buffer), drawbuffer, depth,
          stencil);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLClearNamedFramebufferfi) &&
                             ValidateClearNamedFramebufferfi(
                                 context, angle::EntryPoint::GLClearNamedFramebufferfi,
                                 framebufferPacked, buffer, drawbuffer, depth, stencil)));
        if (isCallValid)
        {
            context->clearNamedFramebufferfi(framebufferPacked, buffer, drawbuffer, depth, stencil);
        }
        ANGLE_CAPTURE_GL(ClearNamedFramebufferfi, isCallValid, context, framebufferPacked, buffer,
                         drawbuffer, depth, stencil);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearNamedFramebufferfv(GLuint framebuffer,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearNamedFramebufferfv,
          "context = %d, framebuffer = %u, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(BigGLEnum::Buffer, buffer), drawbuffer,
          (uintptr_t)value);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLClearNamedFramebufferfv) &&
              ValidateClearNamedFramebufferfv(context, angle::EntryPoint::GLClearNamedFramebufferfv,
                                              framebufferPacked, buffer, drawbuffer, value)));
        if (isCallValid)
        {
            context->clearNamedFramebufferfv(framebufferPacked, buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE_GL(ClearNamedFramebufferfv, isCallValid, context, framebufferPacked, buffer,
                         drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearNamedFramebufferiv(GLuint framebuffer,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearNamedFramebufferiv,
          "context = %d, framebuffer = %u, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(BigGLEnum::Buffer, buffer), drawbuffer,
          (uintptr_t)value);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLClearNamedFramebufferiv) &&
              ValidateClearNamedFramebufferiv(context, angle::EntryPoint::GLClearNamedFramebufferiv,
                                              framebufferPacked, buffer, drawbuffer, value)));
        if (isCallValid)
        {
            context->clearNamedFramebufferiv(framebufferPacked, buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE_GL(ClearNamedFramebufferiv, isCallValid, context, framebufferPacked, buffer,
                         drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClearNamedFramebufferuiv(GLuint framebuffer,
                                             GLenum buffer,
                                             GLint drawbuffer,
                                             const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearNamedFramebufferuiv,
          "context = %d, framebuffer = %u, buffer = %s, drawbuffer = %d, value = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(BigGLEnum::Buffer, buffer), drawbuffer,
          (uintptr_t)value);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLClearNamedFramebufferuiv) &&
                             ValidateClearNamedFramebufferuiv(
                                 context, angle::EntryPoint::GLClearNamedFramebufferuiv,
                                 framebufferPacked, buffer, drawbuffer, value)));
        if (isCallValid)
        {
            context->clearNamedFramebufferuiv(framebufferPacked, buffer, drawbuffer, value);
        }
        ANGLE_CAPTURE_GL(ClearNamedFramebufferuiv, isCallValid, context, framebufferPacked, buffer,
                         drawbuffer, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ClipControl(GLenum origin, GLenum depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipControl, "context = %d, origin = %s, depth = %s", CID(context),
          GLenumToString(BigGLEnum::ClipControlOrigin, origin),
          GLenumToString(BigGLEnum::ClipControlDepth, depth));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClipControl) &&
              ValidateClipControl(context, angle::EntryPoint::GLClipControl, origin, depth)));
        if (isCallValid)
        {
            context->clipControl(origin, depth);
        }
        ANGLE_CAPTURE_GL(ClipControl, isCallValid, context, origin, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTextureSubImage1D(GLuint texture,
                                                GLint level,
                                                GLint xoffset,
                                                GLsizei width,
                                                GLenum format,
                                                GLsizei imageSize,
                                                const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTextureSubImage1D,
          "context = %d, texture = %u, level = %d, xoffset = %d, width = %d, format = %s, "
          "imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, width,
          GLenumToString(BigGLEnum::InternalFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLCompressedTextureSubImage1D) &&
                             ValidateCompressedTextureSubImage1D(
                                 context, angle::EntryPoint::GLCompressedTextureSubImage1D,
                                 texturePacked, level, xoffset, width, format, imageSize, data)));
        if (isCallValid)
        {
            context->compressedTextureSubImage1D(texturePacked, level, xoffset, width, format,
                                                 imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTextureSubImage1D, isCallValid, context, texturePacked, level,
                         xoffset, width, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTextureSubImage2D(GLuint texture,
                                                GLint level,
                                                GLint xoffset,
                                                GLint yoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLenum format,
                                                GLsizei imageSize,
                                                const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTextureSubImage2D,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, width = %d, height "
          "= %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, width, height,
          GLenumToString(BigGLEnum::InternalFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLCompressedTextureSubImage2D) &&
              ValidateCompressedTextureSubImage2D(
                  context, angle::EntryPoint::GLCompressedTextureSubImage2D, texturePacked, level,
                  xoffset, yoffset, width, height, format, imageSize, data)));
        if (isCallValid)
        {
            context->compressedTextureSubImage2D(texturePacked, level, xoffset, yoffset, width,
                                                 height, format, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTextureSubImage2D, isCallValid, context, texturePacked, level,
                         xoffset, yoffset, width, height, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompressedTextureSubImage3D(GLuint texture,
                                                GLint level,
                                                GLint xoffset,
                                                GLint yoffset,
                                                GLint zoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLenum format,
                                                GLsizei imageSize,
                                                const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompressedTextureSubImage3D,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(BigGLEnum::InternalFormat, format), imageSize, (uintptr_t)data);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLCompressedTextureSubImage3D) &&
              ValidateCompressedTextureSubImage3D(
                  context, angle::EntryPoint::GLCompressedTextureSubImage3D, texturePacked, level,
                  xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data)));
        if (isCallValid)
        {
            context->compressedTextureSubImage3D(texturePacked, level, xoffset, yoffset, zoffset,
                                                 width, height, depth, format, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTextureSubImage3D, isCallValid, context, texturePacked, level,
                         xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyNamedBufferSubData(GLuint readBuffer,
                                           GLuint writeBuffer,
                                           GLintptr readOffset,
                                           GLintptr writeOffset,
                                           GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyNamedBufferSubData,
          "context = %d, readBuffer = %u, writeBuffer = %u, readOffset = %llu, writeOffset = %llu, "
          "size = %llu",
          CID(context), readBuffer, writeBuffer, static_cast<unsigned long long>(readOffset),
          static_cast<unsigned long long>(writeOffset), static_cast<unsigned long long>(size));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLCopyNamedBufferSubData) &&
                             ValidateCopyNamedBufferSubData(
                                 context, angle::EntryPoint::GLCopyNamedBufferSubData, readBuffer,
                                 writeBuffer, readOffset, writeOffset, size)));
        if (isCallValid)
        {
            context->copyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size);
        }
        ANGLE_CAPTURE_GL(CopyNamedBufferSubData, isCallValid, context, readBuffer, writeBuffer,
                         readOffset, writeOffset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTextureSubImage1D(GLuint texture,
                                          GLint level,
                                          GLint xoffset,
                                          GLint x,
                                          GLint y,
                                          GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTextureSubImage1D,
          "context = %d, texture = %u, level = %d, xoffset = %d, x = %d, y = %d, width = %d",
          CID(context), texture, level, xoffset, x, y, width);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLCopyTextureSubImage1D) &&
              ValidateCopyTextureSubImage1D(context, angle::EntryPoint::GLCopyTextureSubImage1D,
                                            texturePacked, level, xoffset, x, y, width)));
        if (isCallValid)
        {
            context->copyTextureSubImage1D(texturePacked, level, xoffset, x, y, width);
        }
        ANGLE_CAPTURE_GL(CopyTextureSubImage1D, isCallValid, context, texturePacked, level, xoffset,
                         x, y, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTextureSubImage2D(GLuint texture,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTextureSubImage2D,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, x = %d, y = %d, "
          "width = %d, height = %d",
          CID(context), texture, level, xoffset, yoffset, x, y, width, height);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLCopyTextureSubImage2D) &&
                             ValidateCopyTextureSubImage2D(
                                 context, angle::EntryPoint::GLCopyTextureSubImage2D, texturePacked,
                                 level, xoffset, yoffset, x, y, width, height)));
        if (isCallValid)
        {
            context->copyTextureSubImage2D(texturePacked, level, xoffset, yoffset, x, y, width,
                                           height);
        }
        ANGLE_CAPTURE_GL(CopyTextureSubImage2D, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CopyTextureSubImage3D(GLuint texture,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint zoffset,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCopyTextureSubImage3D,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, x = "
          "%d, y = %d, width = %d, height = %d",
          CID(context), texture, level, xoffset, yoffset, zoffset, x, y, width, height);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLCopyTextureSubImage3D) &&
                             ValidateCopyTextureSubImage3D(
                                 context, angle::EntryPoint::GLCopyTextureSubImage3D, texturePacked,
                                 level, xoffset, yoffset, zoffset, x, y, width, height)));
        if (isCallValid)
        {
            context->copyTextureSubImage3D(texturePacked, level, xoffset, yoffset, zoffset, x, y,
                                           width, height);
        }
        ANGLE_CAPTURE_GL(CopyTextureSubImage3D, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, zoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateBuffers(GLsizei n, GLuint *buffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateBuffers, "context = %d, n = %d, buffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)buffers);

    if (context)
    {
        BufferID *buffersPacked = PackParam<BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLCreateBuffers) &&
              ValidateCreateBuffers(context, angle::EntryPoint::GLCreateBuffers, n,
                                    buffersPacked)));
        if (isCallValid)
        {
            context->createBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE_GL(CreateBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateFramebuffers(GLsizei n, GLuint *framebuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateFramebuffers, "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)framebuffers);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLCreateFramebuffers) &&
              ValidateCreateFramebuffers(context, angle::EntryPoint::GLCreateFramebuffers, n,
                                         framebuffers)));
        if (isCallValid)
        {
            context->createFramebuffers(n, framebuffers);
        }
        ANGLE_CAPTURE_GL(CreateFramebuffers, isCallValid, context, n, framebuffers);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateProgramPipelines(GLsizei n, GLuint *pipelines)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateProgramPipelines, "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)pipelines);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLCreateProgramPipelines) &&
              ValidateCreateProgramPipelines(context, angle::EntryPoint::GLCreateProgramPipelines,
                                             n, pipelines)));
        if (isCallValid)
        {
            context->createProgramPipelines(n, pipelines);
        }
        ANGLE_CAPTURE_GL(CreateProgramPipelines, isCallValid, context, n, pipelines);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateQueries(GLenum target, GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateQueries, "context = %d, target = %s, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::QueryTarget, target), n, (uintptr_t)ids);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLCreateQueries) &&
              ValidateCreateQueries(context, angle::EntryPoint::GLCreateQueries, target, n, ids)));
        if (isCallValid)
        {
            context->createQueries(target, n, ids);
        }
        ANGLE_CAPTURE_GL(CreateQueries, isCallValid, context, target, n, ids);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateRenderbuffers, "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)renderbuffers);

    if (context)
    {
        RenderbufferID *renderbuffersPacked = PackParam<RenderbufferID *>(renderbuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLCreateRenderbuffers) &&
              ValidateCreateRenderbuffers(context, angle::EntryPoint::GLCreateRenderbuffers, n,
                                          renderbuffersPacked)));
        if (isCallValid)
        {
            context->createRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE_GL(CreateRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateSamplers(GLsizei n, GLuint *samplers)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateSamplers, "context = %d, n = %d, samplers = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)samplers);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLCreateSamplers) &&
              ValidateCreateSamplers(context, angle::EntryPoint::GLCreateSamplers, n, samplers)));
        if (isCallValid)
        {
            context->createSamplers(n, samplers);
        }
        ANGLE_CAPTURE_GL(CreateSamplers, isCallValid, context, n, samplers);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateTextures(GLenum target, GLsizei n, GLuint *textures)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateTextures,
          "context = %d, target = %s, n = %d, textures = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::TextureTarget, target), n, (uintptr_t)textures);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLCreateTextures) &&
              ValidateCreateTextures(context, angle::EntryPoint::GLCreateTextures, target, n,
                                     textures)));
        if (isCallValid)
        {
            context->createTextures(target, n, textures);
        }
        ANGLE_CAPTURE_GL(CreateTextures, isCallValid, context, target, n, textures);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateTransformFeedbacks(GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateTransformFeedbacks, "context = %d, n = %d, ids = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)ids);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLCreateTransformFeedbacks) &&
                             ValidateCreateTransformFeedbacks(
                                 context, angle::EntryPoint::GLCreateTransformFeedbacks, n, ids)));
        if (isCallValid)
        {
            context->createTransformFeedbacks(n, ids);
        }
        ANGLE_CAPTURE_GL(CreateTransformFeedbacks, isCallValid, context, n, ids);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CreateVertexArrays(GLsizei n, GLuint *arrays)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateVertexArrays, "context = %d, n = %d, arrays = 0x%016" PRIxPTR "",
          CID(context), n, (uintptr_t)arrays);

    if (context)
    {
        VertexArrayID *arraysPacked = PackParam<VertexArrayID *>(arrays);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLCreateVertexArrays) &&
              ValidateCreateVertexArrays(context, angle::EntryPoint::GLCreateVertexArrays, n,
                                         arraysPacked)));
        if (isCallValid)
        {
            context->createVertexArrays(n, arraysPacked);
        }
        ANGLE_CAPTURE_GL(CreateVertexArrays, isCallValid, context, n, arraysPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DisableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableVertexArrayAttrib, "context = %d, vaobj = %u, index = %u", CID(context),
          vaobj, index);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLDisableVertexArrayAttrib) &&
              ValidateDisableVertexArrayAttrib(
                  context, angle::EntryPoint::GLDisableVertexArrayAttrib, vaobjPacked, index)));
        if (isCallValid)
        {
            context->disableVertexArrayAttrib(vaobjPacked, index);
        }
        ANGLE_CAPTURE_GL(DisableVertexArrayAttrib, isCallValid, context, vaobjPacked, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EnableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableVertexArrayAttrib, "context = %d, vaobj = %u, index = %u", CID(context),
          vaobj, index);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLEnableVertexArrayAttrib) &&
              ValidateEnableVertexArrayAttrib(context, angle::EntryPoint::GLEnableVertexArrayAttrib,
                                              vaobjPacked, index)));
        if (isCallValid)
        {
            context->enableVertexArrayAttrib(vaobjPacked, index);
        }
        ANGLE_CAPTURE_GL(EnableVertexArrayAttrib, isCallValid, context, vaobjPacked, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_FlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFlushMappedNamedBufferRange,
          "context = %d, buffer = %u, offset = %llu, length = %llu", CID(context), buffer,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLFlushMappedNamedBufferRange) &&
                             ValidateFlushMappedNamedBufferRange(
                                 context, angle::EntryPoint::GLFlushMappedNamedBufferRange,
                                 bufferPacked, offset, length)));
        if (isCallValid)
        {
            context->flushMappedNamedBufferRange(bufferPacked, offset, length);
        }
        ANGLE_CAPTURE_GL(FlushMappedNamedBufferRange, isCallValid, context, bufferPacked, offset,
                         length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GenerateTextureMipmap(GLuint texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGenerateTextureMipmap, "context = %d, texture = %u", CID(context), texture);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLGenerateTextureMipmap) &&
              ValidateGenerateTextureMipmap(context, angle::EntryPoint::GLGenerateTextureMipmap,
                                            texturePacked)));
        if (isCallValid)
        {
            context->generateTextureMipmap(texturePacked);
        }
        ANGLE_CAPTURE_GL(GenerateTextureMipmap, isCallValid, context, texturePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetCompressedTextureImage(GLuint texture,
                                              GLint level,
                                              GLsizei bufSize,
                                              void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetCompressedTextureImage,
          "context = %d, texture = %u, level = %d, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetCompressedTextureImage(
                                context, angle::EntryPoint::GLGetCompressedTextureImage,
                                texturePacked, level, bufSize, pixels));
        if (isCallValid)
        {
            context->getCompressedTextureImage(texturePacked, level, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(GetCompressedTextureImage, isCallValid, context, texturePacked, level,
                         bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetCompressedTextureSubImage(GLuint texture,
                                                 GLint level,
                                                 GLint xoffset,
                                                 GLint yoffset,
                                                 GLint zoffset,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLsizei bufSize,
                                                 void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetCompressedTextureSubImage,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize,
          (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetCompressedTextureSubImage(
                 context, angle::EntryPoint::GLGetCompressedTextureSubImage, texturePacked, level,
                 xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels));
        if (isCallValid)
        {
            context->getCompressedTextureSubImage(texturePacked, level, xoffset, yoffset, zoffset,
                                                  width, height, depth, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(GetCompressedTextureSubImage, isCallValid, context, texturePacked, level,
                         xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedBufferParameteri64v,
          "context = %d, buffer = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), buffer,
          GLenumToString(BigGLEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetNamedBufferParameteri64v(
                                context, angle::EntryPoint::GLGetNamedBufferParameteri64v,
                                bufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedBufferParameteri64v(bufferPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetNamedBufferParameteri64v, isCallValid, context, bufferPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedBufferParameteriv,
          "context = %d, buffer = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), buffer,
          GLenumToString(BigGLEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetNamedBufferParameteriv(
                                context, angle::EntryPoint::GLGetNamedBufferParameteriv,
                                bufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedBufferParameteriv(bufferPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetNamedBufferParameteriv, isCallValid, context, bufferPacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedBufferPointerv(GLuint buffer, GLenum pname, void **params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedBufferPointerv,
          "context = %d, buffer = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), buffer,
          GLenumToString(BigGLEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetNamedBufferPointerv(context, angle::EntryPoint::GLGetNamedBufferPointerv,
                                            bufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedBufferPointerv(bufferPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetNamedBufferPointerv, isCallValid, context, bufferPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedBufferSubData(GLuint buffer,
                                          GLintptr offset,
                                          GLsizeiptr size,
                                          void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedBufferSubData,
          "context = %d, buffer = %u, offset = %llu, size = %llu, data = 0x%016" PRIxPTR "",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetNamedBufferSubData(context, angle::EntryPoint::GLGetNamedBufferSubData,
                                           bufferPacked, offset, size, data));
        if (isCallValid)
        {
            context->getNamedBufferSubData(bufferPacked, offset, size, data);
        }
        ANGLE_CAPTURE_GL(GetNamedBufferSubData, isCallValid, context, bufferPacked, offset, size,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedFramebufferAttachmentParameteriv(GLuint framebuffer,
                                                             GLenum attachment,
                                                             GLenum pname,
                                                             GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedFramebufferAttachmentParameteriv,
          "context = %d, framebuffer = %u, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), framebuffer, GLenumToString(BigGLEnum::FramebufferAttachment, attachment),
          GLenumToString(BigGLEnum::FramebufferAttachmentParameterName, pname), (uintptr_t)params);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetNamedFramebufferAttachmentParameteriv(
                 context, angle::EntryPoint::GLGetNamedFramebufferAttachmentParameteriv,
                 framebufferPacked, attachment, pname, params));
        if (isCallValid)
        {
            context->getNamedFramebufferAttachmentParameteriv(framebufferPacked, attachment, pname,
                                                              params);
        }
        ANGLE_CAPTURE_GL(GetNamedFramebufferAttachmentParameteriv, isCallValid, context,
                         framebufferPacked, attachment, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedFramebufferParameteriv,
          "context = %d, framebuffer = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          framebuffer, GLenumToString(BigGLEnum::GetFramebufferParameter, pname), (uintptr_t)param);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetNamedFramebufferParameteriv(
                                context, angle::EntryPoint::GLGetNamedFramebufferParameteriv,
                                framebufferPacked, pname, param));
        if (isCallValid)
        {
            context->getNamedFramebufferParameteriv(framebufferPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(GetNamedFramebufferParameteriv, isCallValid, context, framebufferPacked,
                         pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetNamedRenderbufferParameteriv(GLuint renderbuffer,
                                                    GLenum pname,
                                                    GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetNamedRenderbufferParameteriv,
          "context = %d, renderbuffer = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          renderbuffer, GLenumToString(BigGLEnum::RenderbufferParameterName, pname),
          (uintptr_t)params);

    if (context)
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetNamedRenderbufferParameteriv(
                                context, angle::EntryPoint::GLGetNamedRenderbufferParameteriv,
                                renderbufferPacked, pname, params));
        if (isCallValid)
        {
            context->getNamedRenderbufferParameteriv(renderbufferPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetNamedRenderbufferParameteriv, isCallValid, context, renderbufferPacked,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryBufferObjecti64v(GLuint id,
                                             GLuint buffer,
                                             GLenum pname,
                                             GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryBufferObjecti64v,
          "context = %d, id = %u, buffer = %u, pname = %s, offset = %llu", CID(context), id, buffer,
          GLenumToString(BigGLEnum::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetQueryBufferObjecti64v(
                                context, angle::EntryPoint::GLGetQueryBufferObjecti64v, id,
                                bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjecti64v(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE_GL(GetQueryBufferObjecti64v, isCallValid, context, id, bufferPacked, pname,
                         offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryBufferObjectiv,
          "context = %d, id = %u, buffer = %u, pname = %s, offset = %llu", CID(context), id, buffer,
          GLenumToString(BigGLEnum::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryBufferObjectiv(context, angle::EntryPoint::GLGetQueryBufferObjectiv,
                                            id, bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjectiv(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE_GL(GetQueryBufferObjectiv, isCallValid, context, id, bufferPacked, pname,
                         offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryBufferObjectui64v(GLuint id,
                                              GLuint buffer,
                                              GLenum pname,
                                              GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryBufferObjectui64v,
          "context = %d, id = %u, buffer = %u, pname = %s, offset = %llu", CID(context), id, buffer,
          GLenumToString(BigGLEnum::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetQueryBufferObjectui64v(
                                context, angle::EntryPoint::GLGetQueryBufferObjectui64v, id,
                                bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjectui64v(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE_GL(GetQueryBufferObjectui64v, isCallValid, context, id, bufferPacked, pname,
                         offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetQueryBufferObjectuiv,
          "context = %d, id = %u, buffer = %u, pname = %s, offset = %llu", CID(context), id, buffer,
          GLenumToString(BigGLEnum::QueryObjectParameterName, pname),
          static_cast<unsigned long long>(offset));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetQueryBufferObjectuiv(context, angle::EntryPoint::GLGetQueryBufferObjectuiv,
                                             id, bufferPacked, pname, offset));
        if (isCallValid)
        {
            context->getQueryBufferObjectuiv(id, bufferPacked, pname, offset);
        }
        ANGLE_CAPTURE_GL(GetQueryBufferObjectuiv, isCallValid, context, id, bufferPacked, pname,
                         offset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureImage(GLuint texture,
                                    GLint level,
                                    GLenum format,
                                    GLenum type,
                                    GLsizei bufSize,
                                    void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureImage,
          "context = %d, texture = %u, level = %d, format = %s, type = %s, bufSize = %d, pixels = "
          "0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureImage(context, angle::EntryPoint::GLGetTextureImage, texturePacked,
                                     level, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->getTextureImage(texturePacked, level, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(GetTextureImage, isCallValid, context, texturePacked, level, format, type,
                         bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureLevelParameterfv(GLuint texture,
                                               GLint level,
                                               GLenum pname,
                                               GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureLevelParameterfv,
          "context = %d, texture = %u, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(BigGLEnum::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetTextureLevelParameterfv(
                                context, angle::EntryPoint::GLGetTextureLevelParameterfv,
                                texturePacked, level, pname, params));
        if (isCallValid)
        {
            context->getTextureLevelParameterfv(texturePacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTextureLevelParameterfv, isCallValid, context, texturePacked, level,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureLevelParameteriv(GLuint texture,
                                               GLint level,
                                               GLenum pname,
                                               GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureLevelParameteriv,
          "context = %d, texture = %u, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), texture, level, GLenumToString(BigGLEnum::GetTextureParameter, pname),
          (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetTextureLevelParameteriv(
                                context, angle::EntryPoint::GLGetTextureLevelParameteriv,
                                texturePacked, level, pname, params));
        if (isCallValid)
        {
            context->getTextureLevelParameteriv(texturePacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTextureLevelParameteriv, isCallValid, context, texturePacked, level,
                         pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureParameterIiv(GLuint texture, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureParameterIiv,
          "context = %d, texture = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureParameterIiv(context, angle::EntryPoint::GLGetTextureParameterIiv,
                                            texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameterIiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTextureParameterIiv, isCallValid, context, texturePacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureParameterIuiv,
          "context = %d, texture = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureParameterIuiv(context, angle::EntryPoint::GLGetTextureParameterIuiv,
                                             texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameterIuiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTextureParameterIuiv, isCallValid, context, texturePacked, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureParameterfv(GLuint texture, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureParameterfv,
          "context = %d, texture = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureParameterfv(context, angle::EntryPoint::GLGetTextureParameterfv,
                                           texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameterfv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTextureParameterfv, isCallValid, context, texturePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureParameteriv(GLuint texture, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTextureParameteriv,
          "context = %d, texture = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureParameteriv(context, angle::EntryPoint::GLGetTextureParameteriv,
                                           texturePacked, pname, params));
        if (isCallValid)
        {
            context->getTextureParameteriv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTextureParameteriv, isCallValid, context, texturePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTextureSubImage(GLuint texture,
                                       GLint level,
                                       GLint xoffset,
                                       GLint yoffset,
                                       GLint zoffset,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        context, GLGetTextureSubImage,
        "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width = "
        "%d, height = %d, depth = %d, format = %s, type = %s, bufSize = %d, pixels = 0x%016" PRIxPTR
        "",
        CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
        GLenumToString(BigGLEnum::PixelFormat, format), GLenumToString(BigGLEnum::PixelType, type),
        bufSize, (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTextureSubImage(context, angle::EntryPoint::GLGetTextureSubImage,
                                        texturePacked, level, xoffset, yoffset, zoffset, width,
                                        height, depth, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->getTextureSubImage(texturePacked, level, xoffset, yoffset, zoffset, width,
                                        height, depth, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(GetTextureSubImage, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTransformFeedbacki64_v(GLuint xfb,
                                              GLenum pname,
                                              GLuint index,
                                              GLint64 *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTransformFeedbacki64_v,
          "context = %d, xfb = %u, pname = %s, index = %u, param = 0x%016" PRIxPTR "", CID(context),
          xfb, GLenumToString(BigGLEnum::TransformFeedbackPName, pname), index, (uintptr_t)param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetTransformFeedbacki64_v(
                                context, angle::EntryPoint::GLGetTransformFeedbacki64_v, xfb, pname,
                                index, param));
        if (isCallValid)
        {
            context->getTransformFeedbacki64_v(xfb, pname, index, param);
        }
        ANGLE_CAPTURE_GL(GetTransformFeedbacki64_v, isCallValid, context, xfb, pname, index, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTransformFeedbacki_v,
          "context = %d, xfb = %u, pname = %s, index = %u, param = 0x%016" PRIxPTR "", CID(context),
          xfb, GLenumToString(BigGLEnum::TransformFeedbackPName, pname), index, (uintptr_t)param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTransformFeedbacki_v(context, angle::EntryPoint::GLGetTransformFeedbacki_v,
                                             xfb, pname, index, param));
        if (isCallValid)
        {
            context->getTransformFeedbacki_v(xfb, pname, index, param);
        }
        ANGLE_CAPTURE_GL(GetTransformFeedbacki_v, isCallValid, context, xfb, pname, index, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTransformFeedbackiv,
          "context = %d, xfb = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context), xfb,
          GLenumToString(BigGLEnum::TransformFeedbackPName, pname), (uintptr_t)param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTransformFeedbackiv(context, angle::EntryPoint::GLGetTransformFeedbackiv,
                                            xfb, pname, param));
        if (isCallValid)
        {
            context->getTransformFeedbackiv(xfb, pname, param);
        }
        ANGLE_CAPTURE_GL(GetTransformFeedbackiv, isCallValid, context, xfb, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexArrayIndexed64iv(GLuint vaobj,
                                              GLuint index,
                                              GLenum pname,
                                              GLint64 *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexArrayIndexed64iv,
          "context = %d, vaobj = %u, index = %u, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), vaobj, index, GLenumToString(BigGLEnum::VertexArrayPName, pname),
          (uintptr_t)param);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetVertexArrayIndexed64iv(
                                context, angle::EntryPoint::GLGetVertexArrayIndexed64iv,
                                vaobjPacked, index, pname, param));
        if (isCallValid)
        {
            context->getVertexArrayIndexed64iv(vaobjPacked, index, pname, param);
        }
        ANGLE_CAPTURE_GL(GetVertexArrayIndexed64iv, isCallValid, context, vaobjPacked, index, pname,
                         param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexArrayIndexediv,
          "context = %d, vaobj = %u, index = %u, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), vaobj, index, GLenumToString(BigGLEnum::VertexArrayPName, pname),
          (uintptr_t)param);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetVertexArrayIndexediv(context, angle::EntryPoint::GLGetVertexArrayIndexediv,
                                             vaobjPacked, index, pname, param));
        if (isCallValid)
        {
            context->getVertexArrayIndexediv(vaobjPacked, index, pname, param);
        }
        ANGLE_CAPTURE_GL(GetVertexArrayIndexediv, isCallValid, context, vaobjPacked, index, pname,
                         param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexArrayiv(GLuint vaobj, GLenum pname, GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexArrayiv,
          "context = %d, vaobj = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context), vaobj,
          GLenumToString(BigGLEnum::VertexArrayPName, pname), (uintptr_t)param);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetVertexArrayiv(context, angle::EntryPoint::GLGetVertexArrayiv,
                                                     vaobjPacked, pname, param));
        if (isCallValid)
        {
            context->getVertexArrayiv(vaobjPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(GetVertexArrayiv, isCallValid, context, vaobjPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_GetnColorTable(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnColorTable,
          "context = %d, target = %s, format = %s, type = %s, bufSize = %d, table = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(BigGLEnum::ColorTableTarget, target),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), bufSize, (uintptr_t)table);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnColorTable(context, angle::EntryPoint::GLGetnColorTable,
                                                   target, format, type, bufSize, table));
        if (isCallValid)
        {
            context->getnColorTable(target, format, type, bufSize, table);
        }
        ANGLE_CAPTURE_GL(GetnColorTable, isCallValid, context, target, format, type, bufSize,
                         table);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnCompressedTexImage(GLenum target, GLint lod, GLsizei bufSize, void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnCompressedTexImage,
          "context = %d, target = %s, lod = %d, bufSize = %d, pixels = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TextureTarget, target), lod, bufSize,
          (uintptr_t)pixels);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnCompressedTexImage(context, angle::EntryPoint::GLGetnCompressedTexImage,
                                            target, lod, bufSize, pixels));
        if (isCallValid)
        {
            context->getnCompressedTexImage(target, lod, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(GetnCompressedTexImage, isCallValid, context, target, lod, bufSize,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
GL_GetnConvolutionFilter(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnConvolutionFilter,
          "context = %d, target = %s, format = %s, type = %s, bufSize = %d, image = 0x%016" PRIxPTR
          "",
          CID(context), GLenumToString(BigGLEnum::ConvolutionTarget, target),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), bufSize, (uintptr_t)image);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnConvolutionFilter(context, angle::EntryPoint::GLGetnConvolutionFilter,
                                           target, format, type, bufSize, image));
        if (isCallValid)
        {
            context->getnConvolutionFilter(target, format, type, bufSize, image);
        }
        ANGLE_CAPTURE_GL(GetnConvolutionFilter, isCallValid, context, target, format, type, bufSize,
                         image);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnHistogram(GLenum target,
                                  GLboolean reset,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnHistogram,
          "context = %d, target = %s, reset = %s, format = %s, type = %s, bufSize = %d, values = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::HistogramTarget, target),
          GLbooleanToString(reset), GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), bufSize, (uintptr_t)values);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnHistogram(context, angle::EntryPoint::GLGetnHistogram,
                                                  target, reset, format, type, bufSize, values));
        if (isCallValid)
        {
            context->getnHistogram(target, reset, format, type, bufSize, values);
        }
        ANGLE_CAPTURE_GL(GetnHistogram, isCallValid, context, target, reset, format, type, bufSize,
                         values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnMapdv(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnMapdv,
          "context = %d, target = %s, query = %s, bufSize = %d, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::MapTarget, target),
          GLenumToString(BigGLEnum::MapQuery, query), bufSize, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnMapdv(context, angle::EntryPoint::GLGetnMapdv, target, query, bufSize, v));
        if (isCallValid)
        {
            context->getnMapdv(target, query, bufSize, v);
        }
        ANGLE_CAPTURE_GL(GetnMapdv, isCallValid, context, target, query, bufSize, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnMapfv(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnMapfv,
          "context = %d, target = %s, query = %s, bufSize = %d, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::MapTarget, target),
          GLenumToString(BigGLEnum::MapQuery, query), bufSize, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnMapfv(context, angle::EntryPoint::GLGetnMapfv, target, query, bufSize, v));
        if (isCallValid)
        {
            context->getnMapfv(target, query, bufSize, v);
        }
        ANGLE_CAPTURE_GL(GetnMapfv, isCallValid, context, target, query, bufSize, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnMapiv(GLenum target, GLenum query, GLsizei bufSize, GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnMapiv,
          "context = %d, target = %s, query = %s, bufSize = %d, v = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::MapTarget, target),
          GLenumToString(BigGLEnum::MapQuery, query), bufSize, (uintptr_t)v);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnMapiv(context, angle::EntryPoint::GLGetnMapiv, target, query, bufSize, v));
        if (isCallValid)
        {
            context->getnMapiv(target, query, bufSize, v);
        }
        ANGLE_CAPTURE_GL(GetnMapiv, isCallValid, context, target, query, bufSize, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnMinmax(GLenum target,
                               GLboolean reset,
                               GLenum format,
                               GLenum type,
                               GLsizei bufSize,
                               void *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnMinmax,
          "context = %d, target = %s, reset = %s, format = %s, type = %s, bufSize = %d, values = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::MinmaxTarget, target), GLbooleanToString(reset),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), bufSize, (uintptr_t)values);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnMinmax(context, angle::EntryPoint::GLGetnMinmax, target,
                                               reset, format, type, bufSize, values));
        if (isCallValid)
        {
            context->getnMinmax(target, reset, format, type, bufSize, values);
        }
        ANGLE_CAPTURE_GL(GetnMinmax, isCallValid, context, target, reset, format, type, bufSize,
                         values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnPixelMapfv(GLenum map, GLsizei bufSize, GLfloat *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnPixelMapfv,
          "context = %d, map = %s, bufSize = %d, values = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::PixelMap, map), bufSize, (uintptr_t)values);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnPixelMapfv(context, angle::EntryPoint::GLGetnPixelMapfv,
                                                   map, bufSize, values));
        if (isCallValid)
        {
            context->getnPixelMapfv(map, bufSize, values);
        }
        ANGLE_CAPTURE_GL(GetnPixelMapfv, isCallValid, context, map, bufSize, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnPixelMapuiv(GLenum map, GLsizei bufSize, GLuint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnPixelMapuiv,
          "context = %d, map = %s, bufSize = %d, values = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::PixelMap, map), bufSize, (uintptr_t)values);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnPixelMapuiv(context, angle::EntryPoint::GLGetnPixelMapuiv,
                                                    map, bufSize, values));
        if (isCallValid)
        {
            context->getnPixelMapuiv(map, bufSize, values);
        }
        ANGLE_CAPTURE_GL(GetnPixelMapuiv, isCallValid, context, map, bufSize, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnPixelMapusv(GLenum map, GLsizei bufSize, GLushort *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnPixelMapusv,
          "context = %d, map = %s, bufSize = %d, values = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(BigGLEnum::PixelMap, map), bufSize, (uintptr_t)values);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnPixelMapusv(context, angle::EntryPoint::GLGetnPixelMapusv,
                                                    map, bufSize, values));
        if (isCallValid)
        {
            context->getnPixelMapusv(map, bufSize, values);
        }
        ANGLE_CAPTURE_GL(GetnPixelMapusv, isCallValid, context, map, bufSize, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnPolygonStipple(GLsizei bufSize, GLubyte *pattern)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnPolygonStipple, "context = %d, bufSize = %d, pattern = 0x%016" PRIxPTR "",
          CID(context), bufSize, (uintptr_t)pattern);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetnPolygonStipple(context, angle::EntryPoint::GLGetnPolygonStipple, bufSize,
                                        pattern));
        if (isCallValid)
        {
            context->getnPolygonStipple(bufSize, pattern);
        }
        ANGLE_CAPTURE_GL(GetnPolygonStipple, isCallValid, context, bufSize, pattern);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnSeparableFilter(GLenum target,
                                        GLenum format,
                                        GLenum type,
                                        GLsizei rowBufSize,
                                        void *row,
                                        GLsizei columnBufSize,
                                        void *column,
                                        void *span)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnSeparableFilter,
          "context = %d, target = %s, format = %s, type = %s, rowBufSize = %d, row = 0x%016" PRIxPTR
          ", columnBufSize = %d, column = 0x%016" PRIxPTR ", span = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::SeparableTarget, target),
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), rowBufSize, (uintptr_t)row, columnBufSize,
          (uintptr_t)column, (uintptr_t)span);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnSeparableFilter(
                                context, angle::EntryPoint::GLGetnSeparableFilter, target, format,
                                type, rowBufSize, row, columnBufSize, column, span));
        if (isCallValid)
        {
            context->getnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize,
                                         column, span);
        }
        ANGLE_CAPTURE_GL(GetnSeparableFilter, isCallValid, context, target, format, type,
                         rowBufSize, row, columnBufSize, column, span);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnTexImage(GLenum target,
                                 GLint level,
                                 GLenum format,
                                 GLenum type,
                                 GLsizei bufSize,
                                 void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnTexImage,
          "context = %d, target = %s, level = %d, format = %s, type = %s, bufSize = %d, pixels = "
          "0x%016" PRIxPTR "",
          CID(context), GLenumToString(BigGLEnum::TextureTarget, target), level,
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), bufSize, (uintptr_t)pixels);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnTexImage(context, angle::EntryPoint::GLGetnTexImage, target,
                                                 level, format, type, bufSize, pixels));
        if (isCallValid)
        {
            context->getnTexImage(target, level, format, type, bufSize, pixels);
        }
        ANGLE_CAPTURE_GL(GetnTexImage, isCallValid, context, target, level, format, type, bufSize,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetnUniformdv(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetnUniformdv,
          "context = %d, program = %u, location = %d, bufSize = %d, params = 0x%016" PRIxPTR "",
          CID(context), program, location, bufSize, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetnUniformdv(context, angle::EntryPoint::GLGetnUniformdv,
                                                  programPacked, locationPacked, bufSize, params));
        if (isCallValid)
        {
            context->getnUniformdv(programPacked, locationPacked, bufSize, params);
        }
        ANGLE_CAPTURE_GL(GetnUniformdv, isCallValid, context, programPacked, locationPacked,
                         bufSize, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InvalidateNamedFramebufferData(GLuint framebuffer,
                                                   GLsizei numAttachments,
                                                   const GLenum *attachments)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateNamedFramebufferData,
          "context = %d, framebuffer = %u, numAttachments = %d, attachments = 0x%016" PRIxPTR "",
          CID(context), framebuffer, numAttachments, (uintptr_t)attachments);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLInvalidateNamedFramebufferData) &&
                             ValidateInvalidateNamedFramebufferData(
                                 context, angle::EntryPoint::GLInvalidateNamedFramebufferData,
                                 framebufferPacked, numAttachments, attachments)));
        if (isCallValid)
        {
            context->invalidateNamedFramebufferData(framebufferPacked, numAttachments, attachments);
        }
        ANGLE_CAPTURE_GL(InvalidateNamedFramebufferData, isCallValid, context, framebufferPacked,
                         numAttachments, attachments);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_InvalidateNamedFramebufferSubData(GLuint framebuffer,
                                                      GLsizei numAttachments,
                                                      const GLenum *attachments,
                                                      GLint x,
                                                      GLint y,
                                                      GLsizei width,
                                                      GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLInvalidateNamedFramebufferSubData,
          "context = %d, framebuffer = %u, numAttachments = %d, attachments = 0x%016" PRIxPTR
          ", x = %d, y = %d, width = %d, height = %d",
          CID(context), framebuffer, numAttachments, (uintptr_t)attachments, x, y, width, height);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(
                  context, angle::EntryPoint::GLInvalidateNamedFramebufferSubData) &&
              ValidateInvalidateNamedFramebufferSubData(
                  context, angle::EntryPoint::GLInvalidateNamedFramebufferSubData,
                  framebufferPacked, numAttachments, attachments, x, y, width, height)));
        if (isCallValid)
        {
            context->invalidateNamedFramebufferSubData(framebufferPacked, numAttachments,
                                                       attachments, x, y, width, height);
        }
        ANGLE_CAPTURE_GL(InvalidateNamedFramebufferSubData, isCallValid, context, framebufferPacked,
                         numAttachments, attachments, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void *GL_APIENTRY GL_MapNamedBuffer(GLuint buffer, GLenum access)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapNamedBuffer, "context = %d, buffer = %u, access = %s", CID(context), buffer,
          GLenumToString(BigGLEnum::BufferAccessARB, access));

    void *returnValue;
    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMapNamedBuffer) &&
              ValidateMapNamedBuffer(context, angle::EntryPoint::GLMapNamedBuffer, bufferPacked,
                                     access)));
        if (isCallValid)
        {
            returnValue = context->mapNamedBuffer(bufferPacked, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapNamedBuffer, void *>();
        }
        ANGLE_CAPTURE_GL(MapNamedBuffer, isCallValid, context, bufferPacked, access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapNamedBuffer, void *>();
    }
    return returnValue;
}

void *GL_APIENTRY GL_MapNamedBufferRange(GLuint buffer,
                                         GLintptr offset,
                                         GLsizeiptr length,
                                         GLbitfield access)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMapNamedBufferRange,
          "context = %d, buffer = %u, offset = %llu, length = %llu, access = %s", CID(context),
          buffer, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
          GLbitfieldToString(BigGLEnum::MapBufferAccessMask, access).c_str());

    void *returnValue;
    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLMapNamedBufferRange) &&
              ValidateMapNamedBufferRange(context, angle::EntryPoint::GLMapNamedBufferRange,
                                          bufferPacked, offset, length, access)));
        if (isCallValid)
        {
            returnValue = context->mapNamedBufferRange(bufferPacked, offset, length, access);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapNamedBufferRange, void *>();
        }
        ANGLE_CAPTURE_GL(MapNamedBufferRange, isCallValid, context, bufferPacked, offset, length,
                         access, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLMapNamedBufferRange, void *>();
    }
    return returnValue;
}

void GL_APIENTRY GL_NamedBufferData(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedBufferData,
          "context = %d, buffer = %u, size = %llu, data = 0x%016" PRIxPTR ", usage = %s",
          CID(context), buffer, static_cast<unsigned long long>(size), (uintptr_t)data,
          GLenumToString(BigGLEnum::VertexBufferObjectUsage, usage));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLNamedBufferData) &&
              ValidateNamedBufferData(context, angle::EntryPoint::GLNamedBufferData, bufferPacked,
                                      size, data, usage)));
        if (isCallValid)
        {
            context->namedBufferData(bufferPacked, size, data, usage);
        }
        ANGLE_CAPTURE_GL(NamedBufferData, isCallValid, context, bufferPacked, size, data, usage);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedBufferStorage(GLuint buffer,
                                       GLsizeiptr size,
                                       const void *data,
                                       GLbitfield flags)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedBufferStorage,
          "context = %d, buffer = %u, size = %llu, data = 0x%016" PRIxPTR ", flags = %s",
          CID(context), buffer, static_cast<unsigned long long>(size), (uintptr_t)data,
          GLbitfieldToString(BigGLEnum::BufferStorageMask, flags).c_str());

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLNamedBufferStorage) &&
              ValidateNamedBufferStorage(context, angle::EntryPoint::GLNamedBufferStorage,
                                         bufferPacked, size, data, flags)));
        if (isCallValid)
        {
            context->namedBufferStorage(bufferPacked, size, data, flags);
        }
        ANGLE_CAPTURE_GL(NamedBufferStorage, isCallValid, context, bufferPacked, size, data, flags);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedBufferSubData(GLuint buffer,
                                       GLintptr offset,
                                       GLsizeiptr size,
                                       const void *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedBufferSubData,
          "context = %d, buffer = %u, offset = %llu, size = %llu, data = 0x%016" PRIxPTR "",
          CID(context), buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size), (uintptr_t)data);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLNamedBufferSubData) &&
              ValidateNamedBufferSubData(context, angle::EntryPoint::GLNamedBufferSubData,
                                         bufferPacked, offset, size, data)));
        if (isCallValid)
        {
            context->namedBufferSubData(bufferPacked, offset, size, data);
        }
        ANGLE_CAPTURE_GL(NamedBufferSubData, isCallValid, context, bufferPacked, offset, size,
                         data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferDrawBuffer, "context = %d, framebuffer = %u, buf = %s",
          CID(context), framebuffer, GLenumToString(BigGLEnum::ColorBuffer, buf));

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedFramebufferDrawBuffer) &&
                             ValidateNamedFramebufferDrawBuffer(
                                 context, angle::EntryPoint::GLNamedFramebufferDrawBuffer,
                                 framebufferPacked, buf)));
        if (isCallValid)
        {
            context->namedFramebufferDrawBuffer(framebufferPacked, buf);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferDrawBuffer, isCallValid, context, framebufferPacked, buf);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum *bufs)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferDrawBuffers,
          "context = %d, framebuffer = %u, n = %d, bufs = 0x%016" PRIxPTR "", CID(context),
          framebuffer, n, (uintptr_t)bufs);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedFramebufferDrawBuffers) &&
                             ValidateNamedFramebufferDrawBuffers(
                                 context, angle::EntryPoint::GLNamedFramebufferDrawBuffers,
                                 framebufferPacked, n, bufs)));
        if (isCallValid)
        {
            context->namedFramebufferDrawBuffers(framebufferPacked, n, bufs);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferDrawBuffers, isCallValid, context, framebufferPacked, n,
                         bufs);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferParameteri,
          "context = %d, framebuffer = %u, pname = %s, param = %d", CID(context), framebuffer,
          GLenumToString(BigGLEnum::FramebufferParameterName, pname), param);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedFramebufferParameteri) &&
                             ValidateNamedFramebufferParameteri(
                                 context, angle::EntryPoint::GLNamedFramebufferParameteri,
                                 framebufferPacked, pname, param)));
        if (isCallValid)
        {
            context->namedFramebufferParameteri(framebufferPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferParameteri, isCallValid, context, framebufferPacked, pname,
                         param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferReadBuffer(GLuint framebuffer, GLenum src)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferReadBuffer, "context = %d, framebuffer = %u, src = %s",
          CID(context), framebuffer, GLenumToString(BigGLEnum::ColorBuffer, src));

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedFramebufferReadBuffer) &&
                             ValidateNamedFramebufferReadBuffer(
                                 context, angle::EntryPoint::GLNamedFramebufferReadBuffer,
                                 framebufferPacked, src)));
        if (isCallValid)
        {
            context->namedFramebufferReadBuffer(framebufferPacked, src);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferReadBuffer, isCallValid, context, framebufferPacked, src);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferRenderbuffer(GLuint framebuffer,
                                                 GLenum attachment,
                                                 GLenum renderbuffertarget,
                                                 GLuint renderbuffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferRenderbuffer,
          "context = %d, framebuffer = %u, attachment = %s, renderbuffertarget = %s, renderbuffer "
          "= %u",
          CID(context), framebuffer, GLenumToString(BigGLEnum::FramebufferAttachment, attachment),
          GLenumToString(BigGLEnum::RenderbufferTarget, renderbuffertarget), renderbuffer);

    if (context)
    {
        FramebufferID framebufferPacked   = PackParam<FramebufferID>(framebuffer);
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(
                  context, angle::EntryPoint::GLNamedFramebufferRenderbuffer) &&
              ValidateNamedFramebufferRenderbuffer(
                  context, angle::EntryPoint::GLNamedFramebufferRenderbuffer, framebufferPacked,
                  attachment, renderbuffertarget, renderbufferPacked)));
        if (isCallValid)
        {
            context->namedFramebufferRenderbuffer(framebufferPacked, attachment, renderbuffertarget,
                                                  renderbufferPacked);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferRenderbuffer, isCallValid, context, framebufferPacked,
                         attachment, renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferTexture(GLuint framebuffer,
                                            GLenum attachment,
                                            GLuint texture,
                                            GLint level)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferTexture,
          "context = %d, framebuffer = %u, attachment = %s, texture = %u, level = %d", CID(context),
          framebuffer, GLenumToString(BigGLEnum::FramebufferAttachment, attachment), texture,
          level);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        TextureID texturePacked         = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedFramebufferTexture) &&
                             ValidateNamedFramebufferTexture(
                                 context, angle::EntryPoint::GLNamedFramebufferTexture,
                                 framebufferPacked, attachment, texturePacked, level)));
        if (isCallValid)
        {
            context->namedFramebufferTexture(framebufferPacked, attachment, texturePacked, level);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferTexture, isCallValid, context, framebufferPacked,
                         attachment, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedFramebufferTextureLayer(GLuint framebuffer,
                                                 GLenum attachment,
                                                 GLuint texture,
                                                 GLint level,
                                                 GLint layer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedFramebufferTextureLayer,
          "context = %d, framebuffer = %u, attachment = %s, texture = %u, level = %d, layer = %d",
          CID(context), framebuffer, GLenumToString(BigGLEnum::FramebufferAttachment, attachment),
          texture, level, layer);

    if (context)
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        TextureID texturePacked         = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedFramebufferTextureLayer) &&
                             ValidateNamedFramebufferTextureLayer(
                                 context, angle::EntryPoint::GLNamedFramebufferTextureLayer,
                                 framebufferPacked, attachment, texturePacked, level, layer)));
        if (isCallValid)
        {
            context->namedFramebufferTextureLayer(framebufferPacked, attachment, texturePacked,
                                                  level, layer);
        }
        ANGLE_CAPTURE_GL(NamedFramebufferTextureLayer, isCallValid, context, framebufferPacked,
                         attachment, texturePacked, level, layer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedRenderbufferStorage(GLuint renderbuffer,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedRenderbufferStorage,
          "context = %d, renderbuffer = %u, internalformat = %s, width = %d, height = %d",
          CID(context), renderbuffer, GLenumToString(BigGLEnum::InternalFormat, internalformat),
          width, height);

    if (context)
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLNamedRenderbufferStorage) &&
                             ValidateNamedRenderbufferStorage(
                                 context, angle::EntryPoint::GLNamedRenderbufferStorage,
                                 renderbufferPacked, internalformat, width, height)));
        if (isCallValid)
        {
            context->namedRenderbufferStorage(renderbufferPacked, internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(NamedRenderbufferStorage, isCallValid, context, renderbufferPacked,
                         internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_NamedRenderbufferStorageMultisample(GLuint renderbuffer,
                                                        GLsizei samples,
                                                        GLenum internalformat,
                                                        GLsizei width,
                                                        GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNamedRenderbufferStorageMultisample,
          "context = %d, renderbuffer = %u, samples = %d, internalformat = %s, width = %d, height "
          "= %d",
          CID(context), renderbuffer, samples,
          GLenumToString(BigGLEnum::InternalFormat, internalformat), width, height);

    if (context)
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(
                  context, angle::EntryPoint::GLNamedRenderbufferStorageMultisample) &&
              ValidateNamedRenderbufferStorageMultisample(
                  context, angle::EntryPoint::GLNamedRenderbufferStorageMultisample,
                  renderbufferPacked, samples, internalformat, width, height)));
        if (isCallValid)
        {
            context->namedRenderbufferStorageMultisample(renderbufferPacked, samples,
                                                         internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(NamedRenderbufferStorageMultisample, isCallValid, context,
                         renderbufferPacked, samples, internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureBarrier()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureBarrier, "context = %d", CID(context));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureBarrier) &&
              ValidateTextureBarrier(context, angle::EntryPoint::GLTextureBarrier)));
        if (isCallValid)
        {
            context->textureBarrier();
        }
        ANGLE_CAPTURE_GL(TextureBarrier, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureBuffer, "context = %d, texture = %u, internalformat = %s, buffer = %u",
          CID(context), texture, GLenumToString(BigGLEnum::SizedInternalFormat, internalformat),
          buffer);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        BufferID bufferPacked   = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureBuffer) &&
              ValidateTextureBuffer(context, angle::EntryPoint::GLTextureBuffer, texturePacked,
                                    internalformat, bufferPacked)));
        if (isCallValid)
        {
            context->textureBuffer(texturePacked, internalformat, bufferPacked);
        }
        ANGLE_CAPTURE_GL(TextureBuffer, isCallValid, context, texturePacked, internalformat,
                         bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureBufferRange(GLuint texture,
                                       GLenum internalformat,
                                       GLuint buffer,
                                       GLintptr offset,
                                       GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(
        context, GLTextureBufferRange,
        "context = %d, texture = %u, internalformat = %s, buffer = %u, offset = %llu, size = %llu",
        CID(context), texture, GLenumToString(BigGLEnum::SizedInternalFormat, internalformat),
        buffer, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size));

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        BufferID bufferPacked   = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureBufferRange) &&
              ValidateTextureBufferRange(context, angle::EntryPoint::GLTextureBufferRange,
                                         texturePacked, internalformat, bufferPacked, offset,
                                         size)));
        if (isCallValid)
        {
            context->textureBufferRange(texturePacked, internalformat, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE_GL(TextureBufferRange, isCallValid, context, texturePacked, internalformat,
                         bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureParameterIiv(GLuint texture, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureParameterIiv,
          "context = %d, texture = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLTextureParameterIiv) &&
              ValidateTextureParameterIiv(context, angle::EntryPoint::GLTextureParameterIiv,
                                          texturePacked, pname, params)));
        if (isCallValid)
        {
            context->textureParameterIiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TextureParameterIiv, isCallValid, context, texturePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureParameterIuiv(GLuint texture, GLenum pname, const GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureParameterIuiv,
          "context = %d, texture = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::TextureParameterName, pname), (uintptr_t)params);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLTextureParameterIuiv) &&
              ValidateTextureParameterIuiv(context, angle::EntryPoint::GLTextureParameterIuiv,
                                           texturePacked, pname, params)));
        if (isCallValid)
        {
            context->textureParameterIuiv(texturePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TextureParameterIuiv, isCallValid, context, texturePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureParameterf(GLuint texture, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureParameterf, "context = %d, texture = %u, pname = %s, param = %f",
          CID(context), texture, GLenumToString(BigGLEnum::TextureParameterName, pname), param);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureParameterf) &&
              ValidateTextureParameterf(context, angle::EntryPoint::GLTextureParameterf,
                                        texturePacked, pname, param)));
        if (isCallValid)
        {
            context->textureParameterf(texturePacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TextureParameterf, isCallValid, context, texturePacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureParameterfv(GLuint texture, GLenum pname, const GLfloat *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureParameterfv,
          "context = %d, texture = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::TextureParameterName, pname), (uintptr_t)param);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureParameterfv) &&
              ValidateTextureParameterfv(context, angle::EntryPoint::GLTextureParameterfv,
                                         texturePacked, pname, param)));
        if (isCallValid)
        {
            context->textureParameterfv(texturePacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TextureParameterfv, isCallValid, context, texturePacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureParameteri(GLuint texture, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureParameteri, "context = %d, texture = %u, pname = %s, param = %d",
          CID(context), texture, GLenumToString(BigGLEnum::TextureParameterName, pname), param);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureParameteri) &&
              ValidateTextureParameteri(context, angle::EntryPoint::GLTextureParameteri,
                                        texturePacked, pname, param)));
        if (isCallValid)
        {
            context->textureParameteri(texturePacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TextureParameteri, isCallValid, context, texturePacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureParameteriv(GLuint texture, GLenum pname, const GLint *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureParameteriv,
          "context = %d, texture = %u, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          texture, GLenumToString(BigGLEnum::TextureParameterName, pname), (uintptr_t)param);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureParameteriv) &&
              ValidateTextureParameteriv(context, angle::EntryPoint::GLTextureParameteriv,
                                         texturePacked, pname, param)));
        if (isCallValid)
        {
            context->textureParameteriv(texturePacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TextureParameteriv, isCallValid, context, texturePacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureStorage1D(GLuint texture,
                                     GLsizei levels,
                                     GLenum internalformat,
                                     GLsizei width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureStorage1D,
          "context = %d, texture = %u, levels = %d, internalformat = %s, width = %d", CID(context),
          texture, levels, GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), width);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureStorage1D) &&
              ValidateTextureStorage1D(context, angle::EntryPoint::GLTextureStorage1D,
                                       texturePacked, levels, internalformat, width)));
        if (isCallValid)
        {
            context->textureStorage1D(texturePacked, levels, internalformat, width);
        }
        ANGLE_CAPTURE_GL(TextureStorage1D, isCallValid, context, texturePacked, levels,
                         internalformat, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureStorage2D(GLuint texture,
                                     GLsizei levels,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureStorage2D,
          "context = %d, texture = %u, levels = %d, internalformat = %s, width = %d, height = %d",
          CID(context), texture, levels,
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), width, height);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureStorage2D) &&
              ValidateTextureStorage2D(context, angle::EntryPoint::GLTextureStorage2D,
                                       texturePacked, levels, internalformat, width, height)));
        if (isCallValid)
        {
            context->textureStorage2D(texturePacked, levels, internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(TextureStorage2D, isCallValid, context, texturePacked, levels,
                         internalformat, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureStorage2DMultisample(GLuint texture,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureStorage2DMultisample,
          "context = %d, texture = %u, samples = %d, internalformat = %s, width = %d, height = %d, "
          "fixedsamplelocations = %s",
          CID(context), texture, samples,
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), width, height,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLTextureStorage2DMultisample) &&
              ValidateTextureStorage2DMultisample(
                  context, angle::EntryPoint::GLTextureStorage2DMultisample, texturePacked, samples,
                  internalformat, width, height, fixedsamplelocations)));
        if (isCallValid)
        {
            context->textureStorage2DMultisample(texturePacked, samples, internalformat, width,
                                                 height, fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TextureStorage2DMultisample, isCallValid, context, texturePacked, samples,
                         internalformat, width, height, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureStorage3D(GLuint texture,
                                     GLsizei levels,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureStorage3D,
          "context = %d, texture = %u, levels = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d",
          CID(context), texture, levels,
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), width, height, depth);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureStorage3D) &&
              ValidateTextureStorage3D(context, angle::EntryPoint::GLTextureStorage3D,
                                       texturePacked, levels, internalformat, width, height,
                                       depth)));
        if (isCallValid)
        {
            context->textureStorage3D(texturePacked, levels, internalformat, width, height, depth);
        }
        ANGLE_CAPTURE_GL(TextureStorage3D, isCallValid, context, texturePacked, levels,
                         internalformat, width, height, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureStorage3DMultisample(GLuint texture,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLboolean fixedsamplelocations)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureStorage3DMultisample,
          "context = %d, texture = %u, samples = %d, internalformat = %s, width = %d, height = %d, "
          "depth = %d, fixedsamplelocations = %s",
          CID(context), texture, samples,
          GLenumToString(BigGLEnum::SizedInternalFormat, internalformat), width, height, depth,
          GLbooleanToString(fixedsamplelocations));

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context,
                                                angle::EntryPoint::GLTextureStorage3DMultisample) &&
              ValidateTextureStorage3DMultisample(
                  context, angle::EntryPoint::GLTextureStorage3DMultisample, texturePacked, samples,
                  internalformat, width, height, depth, fixedsamplelocations)));
        if (isCallValid)
        {
            context->textureStorage3DMultisample(texturePacked, samples, internalformat, width,
                                                 height, depth, fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TextureStorage3DMultisample, isCallValid, context, texturePacked, samples,
                         internalformat, width, height, depth, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureSubImage1D(GLuint texture,
                                      GLint level,
                                      GLint xoffset,
                                      GLsizei width,
                                      GLenum format,
                                      GLenum type,
                                      const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureSubImage1D,
          "context = %d, texture = %u, level = %d, xoffset = %d, width = %d, format = %s, type = "
          "%s, pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, width,
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureSubImage1D) &&
              ValidateTextureSubImage1D(context, angle::EntryPoint::GLTextureSubImage1D,
                                        texturePacked, level, xoffset, width, format, type,
                                        pixels)));
        if (isCallValid)
        {
            context->textureSubImage1D(texturePacked, level, xoffset, width, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TextureSubImage1D, isCallValid, context, texturePacked, level, xoffset,
                         width, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureSubImage2D(GLuint texture,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLenum format,
                                      GLenum type,
                                      const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureSubImage2D,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, width = %d, height "
          "= %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, width, height,
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureSubImage2D) &&
              ValidateTextureSubImage2D(context, angle::EntryPoint::GLTextureSubImage2D,
                                        texturePacked, level, xoffset, yoffset, width, height,
                                        format, type, pixels)));
        if (isCallValid)
        {
            context->textureSubImage2D(texturePacked, level, xoffset, yoffset, width, height,
                                       format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TextureSubImage2D, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, width, height, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TextureSubImage3D(GLuint texture,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLenum format,
                                      GLenum type,
                                      const void *pixels)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTextureSubImage3D,
          "context = %d, texture = %u, level = %d, xoffset = %d, yoffset = %d, zoffset = %d, width "
          "= %d, height = %d, depth = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
          CID(context), texture, level, xoffset, yoffset, zoffset, width, height, depth,
          GLenumToString(BigGLEnum::PixelFormat, format),
          GLenumToString(BigGLEnum::PixelType, type), (uintptr_t)pixels);

    if (context)
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTextureSubImage3D) &&
              ValidateTextureSubImage3D(context, angle::EntryPoint::GLTextureSubImage3D,
                                        texturePacked, level, xoffset, yoffset, zoffset, width,
                                        height, depth, format, type, pixels)));
        if (isCallValid)
        {
            context->textureSubImage3D(texturePacked, level, xoffset, yoffset, zoffset, width,
                                       height, depth, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(TextureSubImage3D, isCallValid, context, texturePacked, level, xoffset,
                         yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTransformFeedbackBufferBase, "context = %d, xfb = %u, index = %u, buffer = %u",
          CID(context), xfb, index, buffer);

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLTransformFeedbackBufferBase) &&
                             ValidateTransformFeedbackBufferBase(
                                 context, angle::EntryPoint::GLTransformFeedbackBufferBase, xfb,
                                 index, bufferPacked)));
        if (isCallValid)
        {
            context->transformFeedbackBufferBase(xfb, index, bufferPacked);
        }
        ANGLE_CAPTURE_GL(TransformFeedbackBufferBase, isCallValid, context, xfb, index,
                         bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_TransformFeedbackBufferRange(GLuint xfb,
                                                 GLuint index,
                                                 GLuint buffer,
                                                 GLintptr offset,
                                                 GLsizeiptr size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTransformFeedbackBufferRange,
          "context = %d, xfb = %u, index = %u, buffer = %u, offset = %llu, size = %llu",
          CID(context), xfb, index, buffer, static_cast<unsigned long long>(offset),
          static_cast<unsigned long long>(size));

    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLTransformFeedbackBufferRange) &&
                             ValidateTransformFeedbackBufferRange(
                                 context, angle::EntryPoint::GLTransformFeedbackBufferRange, xfb,
                                 index, bufferPacked, offset, size)));
        if (isCallValid)
        {
            context->transformFeedbackBufferRange(xfb, index, bufferPacked, offset, size);
        }
        ANGLE_CAPTURE_GL(TransformFeedbackBufferRange, isCallValid, context, xfb, index,
                         bufferPacked, offset, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_UnmapNamedBuffer(GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUnmapNamedBuffer, "context = %d, buffer = %u", CID(context), buffer);

    GLboolean returnValue;
    if (context)
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLUnmapNamedBuffer) &&
              ValidateUnmapNamedBuffer(context, angle::EntryPoint::GLUnmapNamedBuffer,
                                       bufferPacked)));
        if (isCallValid)
        {
            returnValue = context->unmapNamedBuffer(bufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapNamedBuffer, GLboolean>();
        }
        ANGLE_CAPTURE_GL(UnmapNamedBuffer, isCallValid, context, bufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLUnmapNamedBuffer, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_VertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayAttribBinding,
          "context = %d, vaobj = %u, attribindex = %u, bindingindex = %u", CID(context), vaobj,
          attribindex, bindingindex);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayAttribBinding) &&
                             ValidateVertexArrayAttribBinding(
                                 context, angle::EntryPoint::GLVertexArrayAttribBinding,
                                 vaobjPacked, attribindex, bindingindex)));
        if (isCallValid)
        {
            context->vertexArrayAttribBinding(vaobjPacked, attribindex, bindingindex);
        }
        ANGLE_CAPTURE_GL(VertexArrayAttribBinding, isCallValid, context, vaobjPacked, attribindex,
                         bindingindex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayAttribFormat(GLuint vaobj,
                                            GLuint attribindex,
                                            GLint size,
                                            GLenum type,
                                            GLboolean normalized,
                                            GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayAttribFormat,
          "context = %d, vaobj = %u, attribindex = %u, size = %d, type = %s, normalized = %s, "
          "relativeoffset = %u",
          CID(context), vaobj, attribindex, size, GLenumToString(BigGLEnum::VertexAttribType, type),
          GLbooleanToString(normalized), relativeoffset);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayAttribFormat) &&
                             ValidateVertexArrayAttribFormat(
                                 context, angle::EntryPoint::GLVertexArrayAttribFormat, vaobjPacked,
                                 attribindex, size, type, normalized, relativeoffset)));
        if (isCallValid)
        {
            context->vertexArrayAttribFormat(vaobjPacked, attribindex, size, type, normalized,
                                             relativeoffset);
        }
        ANGLE_CAPTURE_GL(VertexArrayAttribFormat, isCallValid, context, vaobjPacked, attribindex,
                         size, type, normalized, relativeoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayAttribIFormat(GLuint vaobj,
                                             GLuint attribindex,
                                             GLint size,
                                             GLenum type,
                                             GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayAttribIFormat,
          "context = %d, vaobj = %u, attribindex = %u, size = %d, type = %s, relativeoffset = %u",
          CID(context), vaobj, attribindex, size,
          GLenumToString(BigGLEnum::VertexAttribIType, type), relativeoffset);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayAttribIFormat) &&
                             ValidateVertexArrayAttribIFormat(
                                 context, angle::EntryPoint::GLVertexArrayAttribIFormat,
                                 vaobjPacked, attribindex, size, type, relativeoffset)));
        if (isCallValid)
        {
            context->vertexArrayAttribIFormat(vaobjPacked, attribindex, size, type, relativeoffset);
        }
        ANGLE_CAPTURE_GL(VertexArrayAttribIFormat, isCallValid, context, vaobjPacked, attribindex,
                         size, type, relativeoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayAttribLFormat(GLuint vaobj,
                                             GLuint attribindex,
                                             GLint size,
                                             GLenum type,
                                             GLuint relativeoffset)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayAttribLFormat,
          "context = %d, vaobj = %u, attribindex = %u, size = %d, type = %s, relativeoffset = %u",
          CID(context), vaobj, attribindex, size,
          GLenumToString(BigGLEnum::VertexAttribLType, type), relativeoffset);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayAttribLFormat) &&
                             ValidateVertexArrayAttribLFormat(
                                 context, angle::EntryPoint::GLVertexArrayAttribLFormat,
                                 vaobjPacked, attribindex, size, type, relativeoffset)));
        if (isCallValid)
        {
            context->vertexArrayAttribLFormat(vaobjPacked, attribindex, size, type, relativeoffset);
        }
        ANGLE_CAPTURE_GL(VertexArrayAttribLFormat, isCallValid, context, vaobjPacked, attribindex,
                         size, type, relativeoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayBindingDivisor,
          "context = %d, vaobj = %u, bindingindex = %u, divisor = %u", CID(context), vaobj,
          bindingindex, divisor);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayBindingDivisor) &&
                             ValidateVertexArrayBindingDivisor(
                                 context, angle::EntryPoint::GLVertexArrayBindingDivisor,
                                 vaobjPacked, bindingindex, divisor)));
        if (isCallValid)
        {
            context->vertexArrayBindingDivisor(vaobjPacked, bindingindex, divisor);
        }
        ANGLE_CAPTURE_GL(VertexArrayBindingDivisor, isCallValid, context, vaobjPacked, bindingindex,
                         divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayElementBuffer(GLuint vaobj, GLuint buffer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayElementBuffer, "context = %d, vaobj = %u, buffer = %u",
          CID(context), vaobj, buffer);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        BufferID bufferPacked     = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayElementBuffer) &&
                             ValidateVertexArrayElementBuffer(
                                 context, angle::EntryPoint::GLVertexArrayElementBuffer,
                                 vaobjPacked, bufferPacked)));
        if (isCallValid)
        {
            context->vertexArrayElementBuffer(vaobjPacked, bufferPacked);
        }
        ANGLE_CAPTURE_GL(VertexArrayElementBuffer, isCallValid, context, vaobjPacked, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayVertexBuffer(GLuint vaobj,
                                            GLuint bindingindex,
                                            GLuint buffer,
                                            GLintptr offset,
                                            GLsizei stride)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayVertexBuffer,
          "context = %d, vaobj = %u, bindingindex = %u, buffer = %u, offset = %llu, stride = %d",
          CID(context), vaobj, bindingindex, buffer, static_cast<unsigned long long>(offset),
          stride);

    if (context)
    {
        VertexArrayID vaobjPacked = PackParam<VertexArrayID>(vaobj);
        BufferID bufferPacked     = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayVertexBuffer) &&
                             ValidateVertexArrayVertexBuffer(
                                 context, angle::EntryPoint::GLVertexArrayVertexBuffer, vaobjPacked,
                                 bindingindex, bufferPacked, offset, stride)));
        if (isCallValid)
        {
            context->vertexArrayVertexBuffer(vaobjPacked, bindingindex, bufferPacked, offset,
                                             stride);
        }
        ANGLE_CAPTURE_GL(VertexArrayVertexBuffer, isCallValid, context, vaobjPacked, bindingindex,
                         bufferPacked, offset, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexArrayVertexBuffers(GLuint vaobj,
                                             GLuint first,
                                             GLsizei count,
                                             const GLuint *buffers,
                                             const GLintptr *offsets,
                                             const GLsizei *strides)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexArrayVertexBuffers,
          "context = %d, vaobj = %u, first = %u, count = %d, buffers = 0x%016" PRIxPTR
          ", offsets = 0x%016" PRIxPTR ", strides = 0x%016" PRIxPTR "",
          CID(context), vaobj, first, count, (uintptr_t)buffers, (uintptr_t)offsets,
          (uintptr_t)strides);

    if (context)
    {
        VertexArrayID vaobjPacked     = PackParam<VertexArrayID>(vaobj);
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLVertexArrayVertexBuffers) &&
                             ValidateVertexArrayVertexBuffers(
                                 context, angle::EntryPoint::GLVertexArrayVertexBuffers,
                                 vaobjPacked, first, count, buffersPacked, offsets, strides)));
        if (isCallValid)
        {
            context->vertexArrayVertexBuffers(vaobjPacked, first, count, buffersPacked, offsets,
                                              strides);
        }
        ANGLE_CAPTURE_GL(VertexArrayVertexBuffers, isCallValid, context, vaobjPacked, first, count,
                         buffersPacked, offsets, strides);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 4.6
void GL_APIENTRY GL_MultiDrawArraysIndirectCount(GLenum mode,
                                                 const void *indirect,
                                                 GLintptr drawcount,
                                                 GLsizei maxdrawcount,
                                                 GLsizei stride)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawArraysIndirectCount,
          "context = %d, mode = %s, indirect = 0x%016" PRIxPTR
          ", drawcount = %llu, maxdrawcount = %d, stride = %d",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode), (uintptr_t)indirect,
          static_cast<unsigned long long>(drawcount), maxdrawcount, stride);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLMultiDrawArraysIndirectCount) &&
                             ValidateMultiDrawArraysIndirectCount(
                                 context, angle::EntryPoint::GLMultiDrawArraysIndirectCount, mode,
                                 indirect, drawcount, maxdrawcount, stride)));
        if (isCallValid)
        {
            context->multiDrawArraysIndirectCount(mode, indirect, drawcount, maxdrawcount, stride);
        }
        ANGLE_CAPTURE_GL(MultiDrawArraysIndirectCount, isCallValid, context, mode, indirect,
                         drawcount, maxdrawcount, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_MultiDrawElementsIndirectCount(GLenum mode,
                                                   GLenum type,
                                                   const void *indirect,
                                                   GLintptr drawcount,
                                                   GLsizei maxdrawcount,
                                                   GLsizei stride)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiDrawElementsIndirectCount,
          "context = %d, mode = %s, type = %s, indirect = 0x%016" PRIxPTR
          ", drawcount = %llu, maxdrawcount = %d, stride = %d",
          CID(context), GLenumToString(BigGLEnum::PrimitiveType, mode),
          GLenumToString(BigGLEnum::DrawElementsType, type), (uintptr_t)indirect,
          static_cast<unsigned long long>(drawcount), maxdrawcount, stride);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLMultiDrawElementsIndirectCount) &&
                             ValidateMultiDrawElementsIndirectCount(
                                 context, angle::EntryPoint::GLMultiDrawElementsIndirectCount, mode,
                                 type, indirect, drawcount, maxdrawcount, stride)));
        if (isCallValid)
        {
            context->multiDrawElementsIndirectCount(mode, type, indirect, drawcount, maxdrawcount,
                                                    stride);
        }
        ANGLE_CAPTURE_GL(MultiDrawElementsIndirectCount, isCallValid, context, mode, type, indirect,
                         drawcount, maxdrawcount, stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_PolygonOffsetClamp(GLfloat factor, GLfloat units, GLfloat clamp)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonOffsetClamp, "context = %d, factor = %f, units = %f, clamp = %f",
          CID(context), factor, units, clamp);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPolygonOffsetClamp) &&
              ValidatePolygonOffsetClamp(context, angle::EntryPoint::GLPolygonOffsetClamp, factor,
                                         units, clamp)));
        if (isCallValid)
        {
            context->polygonOffsetClamp(factor, units, clamp);
        }
        ANGLE_CAPTURE_GL(PolygonOffsetClamp, isCallValid, context, factor, units, clamp);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_SpecializeShader(GLuint shader,
                                     const GLchar *pEntryPoint,
                                     GLuint numSpecializationConstants,
                                     const GLuint *pConstantIndex,
                                     const GLuint *pConstantValue)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSpecializeShader,
          "context = %d, shader = %u, pEntryPoint = 0x%016" PRIxPTR
          ", numSpecializationConstants = %u, pConstantIndex = 0x%016" PRIxPTR
          ", pConstantValue = 0x%016" PRIxPTR "",
          CID(context), shader, (uintptr_t)pEntryPoint, numSpecializationConstants,
          (uintptr_t)pConstantIndex, (uintptr_t)pConstantValue);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLSpecializeShader) &&
              ValidateSpecializeShader(context, angle::EntryPoint::GLSpecializeShader, shader,
                                       pEntryPoint, numSpecializationConstants, pConstantIndex,
                                       pConstantValue)));
        if (isCallValid)
        {
            context->specializeShader(shader, pEntryPoint, numSpecializationConstants,
                                      pConstantIndex, pConstantValue);
        }
        ANGLE_CAPTURE_GL(SpecializeShader, isCallValid, context, shader, pEntryPoint,
                         numSpecializationConstants, pConstantIndex, pConstantValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

}  // extern "C"
