/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.Coroutine;
import java.dyn.CoroutineBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Contended;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

@Contended
public class CoroutineSupport {
    private static final boolean CHECK_LOCK = true;
    private static final int SPIN_BACKOFF_LIMIT = 512;
    private static final AtomicInteger idGen = new AtomicInteger();
    private final Thread thread;
    private final Coroutine threadCoroutine;
    private Coroutine currentCoroutine;
    private volatile Thread lockOwner = null;
    private int lockRecursive;
    private final int id;
    private boolean terminated = false;
    private static final AtomicReferenceFieldUpdater<CoroutineSupport, Thread> LOCK_UPDATER;

    public CoroutineSupport(Thread thread) {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        if (javaLangAccess != null && javaLangAccess.getCoroutineSupport(thread) != null) {
            throw new IllegalArgumentException("Cannot instantiate CoroutineThreadSupport for existing Thread");
        }
        this.id = idGen.incrementAndGet();
        this.thread = thread;
        this.threadCoroutine = new Coroutine(this, CoroutineSupport.getNativeThreadCoroutine());
        CoroutineSupport.markThreadCoroutine(this.threadCoroutine.nativeCoroutine, this.threadCoroutine);
        this.currentCoroutine = this.threadCoroutine;
    }

    public Coroutine threadCoroutine() {
        return this.threadCoroutine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCoroutine(Coroutine coroutine, long l) {
        assert (this.currentCoroutine != null);
        this.lock();
        try {
            coroutine.nativeCoroutine = CoroutineSupport.createCoroutine(coroutine, l);
        }
        finally {
            this.unlock();
        }
    }

    Thread getThread() {
        return this.thread;
    }

    public static boolean checkAndThrowException(Coroutine coroutine) {
        return CoroutineSupport.shouldThrowException0(coroutine.nativeCoroutine);
    }

    public void drain() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalArgumentException("Cannot drain another threads CoroutineThreadSupport");
        }
        this.lock();
        try {
            Coroutine coroutine = null;
            while ((coroutine = CoroutineSupport.getNextCoroutine(this.currentCoroutine.nativeCoroutine)) != this.currentCoroutine) {
                this.symmetricExitInternal(coroutine);
            }
            CoroutineBase coroutineBase = CoroutineSupport.cleanupCoroutine();
            if (coroutineBase != null) {
                System.out.println(coroutineBase);
                throw new NotImplementedException();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            assert (this.lockOwner == this.thread && this.lockRecursive == 0);
            this.terminated = true;
            this.unlock();
        }
    }

    public boolean unsafeSymmetricYieldTo(Coroutine coroutine) {
        if (coroutine.threadSupport != this) {
            return false;
        }
        Coroutine coroutine2 = this.currentCoroutine;
        this.currentCoroutine = coroutine;
        CoroutineSupport.switchTo(coroutine2, coroutine);
        this.beforeResume(coroutine2);
        return true;
    }

    public void symmetricYieldTo(Coroutine coroutine) {
        this.lock();
        if (coroutine.threadSupport != this) {
            this.unlock();
            return;
        }
        CoroutineSupport.moveCoroutine(this.currentCoroutine.nativeCoroutine, coroutine.nativeCoroutine);
        this.unlockLater(coroutine);
        this.unsafeSymmetricYieldTo(coroutine);
    }

    public void symmetricStopCoroutine(Coroutine coroutine) {
        Coroutine coroutine2;
        this.lock();
        try {
            if (coroutine.threadSupport != this) {
                this.unlock();
                return;
            }
            coroutine2 = this.currentCoroutine;
            this.currentCoroutine = coroutine;
            CoroutineSupport.moveCoroutine(coroutine2.nativeCoroutine, coroutine.nativeCoroutine);
        }
        finally {
            this.unlock();
        }
        CoroutineSupport.switchToAndExit(coroutine2, coroutine);
    }

    void symmetricExitInternal(Coroutine coroutine) {
        assert (this.currentCoroutine != coroutine);
        assert (coroutine.threadSupport == this);
        if (!CoroutineSupport.testDisposableAndTryReleaseStack(coroutine.nativeCoroutine)) {
            CoroutineSupport.moveCoroutine(this.currentCoroutine.nativeCoroutine, coroutine.nativeCoroutine);
            Coroutine coroutine2 = this.currentCoroutine;
            this.currentCoroutine = coroutine;
            CoroutineSupport.switchToAndExit(coroutine2, coroutine);
            this.beforeResume(coroutine2);
        }
    }

    public void terminateCoroutine(Coroutine coroutine) {
        assert (this.currentCoroutine != this.threadCoroutine) : "cannot exit thread coroutine";
        assert (this.currentCoroutine != CoroutineSupport.getNextCoroutine(this.currentCoroutine.nativeCoroutine)) : "last coroutine shouldn't call coroutineexit";
        this.lock();
        Coroutine coroutine2 = this.currentCoroutine;
        Coroutine coroutine3 = coroutine;
        if (coroutine3 == null) {
            coroutine3 = CoroutineSupport.getNextCoroutine(coroutine2.nativeCoroutine);
        }
        this.currentCoroutine = coroutine3;
        this.unlockLater(coroutine3);
        CoroutineSupport.switchToAndTerminate(coroutine2, coroutine3);
        assert (false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Coroutine.StealResult steal(Coroutine coroutine, boolean bl) {
        assert (coroutine.threadSupport.threadCoroutine() != coroutine);
        CoroutineSupport coroutineSupport = this;
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        CoroutineSupport coroutineSupport2 = javaLangAccess.getCoroutineSupport(javaLangAccess.currentThread0());
        if (coroutineSupport == coroutineSupport2) {
            return Coroutine.StealResult.SUCCESS;
        }
        if (coroutineSupport.id < coroutineSupport2.id) {
            if (!coroutineSupport.lockInternal(bl)) {
                return Coroutine.StealResult.FAIL_BY_CONTENTION;
            }
            coroutineSupport2.lock();
        } else {
            coroutineSupport2.lock();
            if (!coroutineSupport.lockInternal(bl)) {
                coroutineSupport2.unlock();
                return Coroutine.StealResult.FAIL_BY_CONTENTION;
            }
        }
        try {
            if (coroutineSupport.terminated || coroutine.finished || coroutine.threadSupport != coroutineSupport || coroutineSupport.currentCoroutine == coroutine) {
                Coroutine.StealResult stealResult = Coroutine.StealResult.FAIL_BY_STATUS;
                return stealResult;
            }
            if (!CoroutineSupport.stealCoroutine(coroutine.nativeCoroutine)) {
                Coroutine.StealResult stealResult = Coroutine.StealResult.FAIL_BY_NATIVE_FRAME;
                return stealResult;
            }
            coroutine.threadSupport = coroutineSupport2;
        }
        finally {
            coroutineSupport.unlock();
            coroutineSupport2.unlock();
        }
        return Coroutine.StealResult.SUCCESS;
    }

    void beforeResume(CoroutineBase coroutineBase) {
        if (coroutineBase.needsUnlock) {
            coroutineBase.needsUnlock = false;
            coroutineBase.threadSupport.unlock();
        }
    }

    private void unlockLater(CoroutineBase coroutineBase) {
        if (coroutineBase.needsUnlock) {
            throw new InternalError("pending unlock");
        }
        coroutineBase.needsUnlock = true;
    }

    private void lock() {
        boolean bl = this.lockInternal(false);
        assert (bl);
    }

    private boolean lockInternal(boolean bl) {
        Thread thread = SharedSecrets.getJavaLangAccess().currentThread0();
        if (this.lockOwner == thread) {
            ++this.lockRecursive;
            return true;
        }
        int n = 1;
        while (this.lockOwner != null || !LOCK_UPDATER.compareAndSet(this, null, thread)) {
            for (int i = 0; i < n; ++i) {
            }
            if (n == 512) {
                if (bl) {
                    return false;
                }
                SharedSecrets.getJavaLangAccess().yield0();
                continue;
            }
            n *= 2;
        }
        return true;
    }

    private void unlock() {
        if (SharedSecrets.getJavaLangAccess().currentThread0() != this.lockOwner) {
            throw new InternalError("unlock from non-owner thread");
        }
        if (this.lockRecursive > 0) {
            --this.lockRecursive;
        } else {
            LOCK_UPDATER.lazySet(this, null);
        }
    }

    public boolean isCurrent(CoroutineBase coroutineBase) {
        return coroutineBase == this.currentCoroutine;
    }

    public CoroutineBase getCurrent() {
        return this.currentCoroutine;
    }

    private static native void registerNatives();

    private static native long getNativeThreadCoroutine();

    private static native long createCoroutine(CoroutineBase var0, long var1);

    private static native void switchToAndTerminate(CoroutineBase var0, CoroutineBase var1);

    private static native boolean testDisposableAndTryReleaseStack(long var0);

    private static native boolean stealCoroutine(long var0);

    private static native Coroutine getNextCoroutine(long var0);

    private static native void moveCoroutine(long var0, long var2);

    private static native void markThreadCoroutine(long var0, CoroutineBase var2);

    private static native void switchTo(CoroutineBase var0, CoroutineBase var1);

    private static native void switchToAndExit(CoroutineBase var0, CoroutineBase var1);

    private static native CoroutineBase cleanupCoroutine();

    public static native void setWispBooted();

    public static native StackTraceElement[] getCoroutineStack(long var0);

    private static native boolean shouldThrowException0(long var0);

    static {
        CoroutineSupport.registerNatives();
        LOCK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CoroutineSupport.class, Thread.class, "lockOwner");
    }
}

