# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from geckoprocesstypes import process_types


def main(output):
    output.write(
        """\
/* THIS FILE IS GENERATED BY GeckoProcessTypes - DO NOT EDIT */
"""
    )

    for p in process_types:
        output.write(
            """
#ifndef SKIP_PROCESS_TYPE_%(allcaps_name)s
GECKO_PROCESS_TYPE(%(enum_value)d, %(enum_name)s, "%(string_name)s", """
            """%(proc_typename)s, %(process_bin_type)s, %(procinfo_typename)s, """
            """%(webidl_typename)s, %(allcaps_name)s)
#endif // SKIP_PROCESS_TYPE_%(allcaps_name)s
"""
            % {
                "enum_value": p.enum_value,
                "enum_name": p.enum_name,
                "string_name": p.string_name,
                "proc_typename": p.proc_typename,
                "process_bin_type": p.process_bin_type,
                "procinfo_typename": p.procinfo_typename,
                "webidl_typename": p.webidl_typename,
                "allcaps_name": p.allcaps_name,
            }
        )
