/*! For license information please see kustoWorker.js.LICENSE.txt */
define("vs/language/kusto/languageService/schema",["require","exports"],(function(e,d){"use strict";Object.defineProperty(d,"__esModule",{value:!0}),d.getInputParametersAsCslString=d.getExpression=d.getCallName=d.getEntityDataTypeFromCslType=d.getCslTypeNameFromClrType=void 0;var u={"System.SByte":"bool","System.Byte":"uint8","System.Int16":"int16","System.UInt16":"uint16","System.Int32":"int","System.UInt32":"uint","System.Int64":"long","System.UInt64":"ulong","System.String":"string","System.Single":"float","System.Double":"real","System.DateTime":"datetime","System.TimeSpan":"timespan","System.Guid":"guid","System.Boolean":"bool","Newtonsoft.Json.Linq.JArray":"dynamic","Newtonsoft.Json.Linq.JObject":"dynamic","Newtonsoft.Json.Linq.JToken":"dynamic","System.Object":"dynamic","System.Data.SqlTypes.SqlDecimal":"decimal"};d.getCslTypeNameFromClrType=function(e){return u[e]||e};var n={object:"Object",bool:"Boolean",uint8:"Byte",int16:"Int16",uint16:"UInt16",int:"Int32",uint:"UInt32",long:"Int64",ulong:"UInt64",float:"Single",real:"Double",decimal:"Decimal",datetime:"DateTime",string:"String",dynamic:"Dynamic",timespan:"TimeSpan"};d.getEntityDataTypeFromCslType=function(e){return n[e]||e},d.getCallName=function(e){return e.name+"("+e.inputParameters.map((function(e){return"{"+e.name+"}"})).join(",")+")"},d.getExpression=function(e){return"let "+e.name+" = "+d.getInputParametersAsCslString(e.inputParameters)+" "+e.body},d.getInputParametersAsCslString=function(e){return"("+e.map((function(e){return t(e)})).join(",")+")"};var t=function(e){if(e.columns&&e.columns.length>0){var u=e.columns.map((function(e){return e.name+":"+(e.cslType||d.getCslTypeNameFromClrType(e.type))})).join(",");return e.name+":"+(""===u?"*":u)}return e.name+":"+(e.cslType||d.getCslTypeNameFromClrType(e.type))}})),function(e){if("object"==typeof module&&"object"==typeof module.exports){var d=e(require,exports);void 0!==d&&(module.exports=d)}else"function"==typeof define&&define.amd&&define("vscode-languageserver-types/main",["require","exports"],e)}((function(e,d){"use strict";var u,n,t,a,r,i,o,c,s,f,l,m,p,g,b,h,v;Object.defineProperty(d,"__esModule",{value:!0}),d.TextDocument=d.EOL=d.SelectionRange=d.DocumentLink=d.FormattingOptions=d.CodeLens=d.CodeAction=d.CodeActionContext=d.CodeActionKind=d.DocumentSymbol=d.SymbolInformation=d.SymbolTag=d.SymbolKind=d.DocumentHighlight=d.DocumentHighlightKind=d.SignatureInformation=d.ParameterInformation=d.Hover=d.MarkedString=d.CompletionList=d.CompletionItem=d.InsertTextMode=d.InsertReplaceEdit=d.CompletionItemTag=d.InsertTextFormat=d.CompletionItemKind=d.MarkupContent=d.MarkupKind=d.TextDocumentItem=d.OptionalVersionedTextDocumentIdentifier=d.VersionedTextDocumentIdentifier=d.TextDocumentIdentifier=d.WorkspaceChange=d.WorkspaceEdit=d.DeleteFile=d.RenameFile=d.CreateFile=d.TextDocumentEdit=d.AnnotatedTextEdit=d.ChangeAnnotationIdentifier=d.ChangeAnnotation=d.TextEdit=d.Command=d.Diagnostic=d.CodeDescription=d.DiagnosticTag=d.DiagnosticSeverity=d.DiagnosticRelatedInformation=d.FoldingRange=d.FoldingRangeKind=d.ColorPresentation=d.ColorInformation=d.Color=d.LocationLink=d.Location=d.Range=d.Position=d.uinteger=d.integer=void 0,function(e){e.MIN_VALUE=-2147483648,e.MAX_VALUE=2147483647}(d.integer||(d.integer={})),function(e){e.MIN_VALUE=0,e.MAX_VALUE=2147483647}(u=d.uinteger||(d.uinteger={})),function(e){e.create=function(e,d){return e===Number.MAX_VALUE&&(e=u.MAX_VALUE),d===Number.MAX_VALUE&&(d=u.MAX_VALUE),{line:e,character:d}},e.is=function(e){var d=e;return K.objectLiteral(d)&&K.uinteger(d.line)&&K.uinteger(d.character)}}(n=d.Position||(d.Position={})),function(e){e.create=function(e,d,u,t){if(K.uinteger(e)&&K.uinteger(d)&&K.uinteger(u)&&K.uinteger(t))return{start:n.create(e,d),end:n.create(u,t)};if(n.is(e)&&n.is(d))return{start:e,end:d};throw new Error("Range#create called with invalid arguments["+e+", "+d+", "+u+", "+t+"]")},e.is=function(e){var d=e;return K.objectLiteral(d)&&n.is(d.start)&&n.is(d.end)}}(t=d.Range||(d.Range={})),function(e){e.create=function(e,d){return{uri:e,range:d}},e.is=function(e){var d=e;return K.defined(d)&&t.is(d.range)&&(K.string(d.uri)||K.undefined(d.uri))}}(a=d.Location||(d.Location={})),function(e){e.create=function(e,d,u,n){return{targetUri:e,targetRange:d,targetSelectionRange:u,originSelectionRange:n}},e.is=function(e){var d=e;return K.defined(d)&&t.is(d.targetRange)&&K.string(d.targetUri)&&(t.is(d.targetSelectionRange)||K.undefined(d.targetSelectionRange))&&(t.is(d.originSelectionRange)||K.undefined(d.originSelectionRange))}}(d.LocationLink||(d.LocationLink={})),function(e){e.create=function(e,d,u,n){return{red:e,green:d,blue:u,alpha:n}},e.is=function(e){var d=e;return K.numberRange(d.red,0,1)&&K.numberRange(d.green,0,1)&&K.numberRange(d.blue,0,1)&&K.numberRange(d.alpha,0,1)}}(r=d.Color||(d.Color={})),function(e){e.create=function(e,d){return{range:e,color:d}},e.is=function(e){var d=e;return t.is(d.range)&&r.is(d.color)}}(d.ColorInformation||(d.ColorInformation={})),function(e){e.create=function(e,d,u){return{label:e,textEdit:d,additionalTextEdits:u}},e.is=function(e){var d=e;return K.string(d.label)&&(K.undefined(d.textEdit)||s.is(d))&&(K.undefined(d.additionalTextEdits)||K.typedArray(d.additionalTextEdits,s.is))}}(d.ColorPresentation||(d.ColorPresentation={})),function(e){e.Comment="comment",e.Imports="imports",e.Region="region"}(d.FoldingRangeKind||(d.FoldingRangeKind={})),function(e){e.create=function(e,d,u,n,t){var a={startLine:e,endLine:d};return K.defined(u)&&(a.startCharacter=u),K.defined(n)&&(a.endCharacter=n),K.defined(t)&&(a.kind=t),a},e.is=function(e){var d=e;return K.uinteger(d.startLine)&&K.uinteger(d.startLine)&&(K.undefined(d.startCharacter)||K.uinteger(d.startCharacter))&&(K.undefined(d.endCharacter)||K.uinteger(d.endCharacter))&&(K.undefined(d.kind)||K.string(d.kind))}}(d.FoldingRange||(d.FoldingRange={})),function(e){e.create=function(e,d){return{location:e,message:d}},e.is=function(e){var d=e;return K.defined(d)&&a.is(d.location)&&K.string(d.message)}}(i=d.DiagnosticRelatedInformation||(d.DiagnosticRelatedInformation={})),function(e){e.Error=1,e.Warning=2,e.Information=3,e.Hint=4}(d.DiagnosticSeverity||(d.DiagnosticSeverity={})),function(e){e.Unnecessary=1,e.Deprecated=2}(d.DiagnosticTag||(d.DiagnosticTag={})),function(e){e.is=function(e){var d=e;return null!=d&&K.string(d.href)}}(d.CodeDescription||(d.CodeDescription={})),function(e){e.create=function(e,d,u,n,t,a){var r={range:e,message:d};return K.defined(u)&&(r.severity=u),K.defined(n)&&(r.code=n),K.defined(t)&&(r.source=t),K.defined(a)&&(r.relatedInformation=a),r},e.is=function(e){var d,u=e;return K.defined(u)&&t.is(u.range)&&K.string(u.message)&&(K.number(u.severity)||K.undefined(u.severity))&&(K.integer(u.code)||K.string(u.code)||K.undefined(u.code))&&(K.undefined(u.codeDescription)||K.string(null===(d=u.codeDescription)||void 0===d?void 0:d.href))&&(K.string(u.source)||K.undefined(u.source))&&(K.undefined(u.relatedInformation)||K.typedArray(u.relatedInformation,i.is))}}(o=d.Diagnostic||(d.Diagnostic={})),function(e){e.create=function(e,d){for(var u=[],n=2;n<arguments.length;n++)u[n-2]=arguments[n];var t={title:e,command:d};return K.defined(u)&&u.length>0&&(t.arguments=u),t},e.is=function(e){var d=e;return K.defined(d)&&K.string(d.title)&&K.string(d.command)}}(c=d.Command||(d.Command={})),function(e){e.replace=function(e,d){return{range:e,newText:d}},e.insert=function(e,d){return{range:{start:e,end:e},newText:d}},e.del=function(e){return{range:e,newText:""}},e.is=function(e){var d=e;return K.objectLiteral(d)&&K.string(d.newText)&&t.is(d.range)}}(s=d.TextEdit||(d.TextEdit={})),function(e){e.create=function(e,d,u){var n={label:e};return void 0!==d&&(n.needsConfirmation=d),void 0!==u&&(n.description=u),n},e.is=function(e){var d=e;return void 0!==d&&K.objectLiteral(d)&&K.string(d.label)&&(K.boolean(d.needsConfirmation)||void 0===d.needsConfirmation)&&(K.string(d.description)||void 0===d.description)}}(f=d.ChangeAnnotation||(d.ChangeAnnotation={})),function(e){e.is=function(e){return"string"==typeof e}}(l=d.ChangeAnnotationIdentifier||(d.ChangeAnnotationIdentifier={})),function(e){e.replace=function(e,d,u){return{range:e,newText:d,annotationId:u}},e.insert=function(e,d,u){return{range:{start:e,end:e},newText:d,annotationId:u}},e.del=function(e,d){return{range:e,newText:"",annotationId:d}},e.is=function(e){var d=e;return s.is(d)&&(f.is(d.annotationId)||l.is(d.annotationId))}}(m=d.AnnotatedTextEdit||(d.AnnotatedTextEdit={})),function(e){e.create=function(e,d){return{textDocument:e,edits:d}},e.is=function(e){var d=e;return K.defined(d)&&y.is(d.textDocument)&&Array.isArray(d.edits)}}(p=d.TextDocumentEdit||(d.TextDocumentEdit={})),function(e){e.create=function(e,d,u){var n={kind:"create",uri:e};return void 0===d||void 0===d.overwrite&&void 0===d.ignoreIfExists||(n.options=d),void 0!==u&&(n.annotationId=u),n},e.is=function(e){var d=e;return d&&"create"===d.kind&&K.string(d.uri)&&(void 0===d.options||(void 0===d.options.overwrite||K.boolean(d.options.overwrite))&&(void 0===d.options.ignoreIfExists||K.boolean(d.options.ignoreIfExists)))&&(void 0===d.annotationId||l.is(d.annotationId))}}(g=d.CreateFile||(d.CreateFile={})),function(e){e.create=function(e,d,u,n){var t={kind:"rename",oldUri:e,newUri:d};return void 0===u||void 0===u.overwrite&&void 0===u.ignoreIfExists||(t.options=u),void 0!==n&&(t.annotationId=n),t},e.is=function(e){var d=e;return d&&"rename"===d.kind&&K.string(d.oldUri)&&K.string(d.newUri)&&(void 0===d.options||(void 0===d.options.overwrite||K.boolean(d.options.overwrite))&&(void 0===d.options.ignoreIfExists||K.boolean(d.options.ignoreIfExists)))&&(void 0===d.annotationId||l.is(d.annotationId))}}(b=d.RenameFile||(d.RenameFile={})),function(e){e.create=function(e,d,u){var n={kind:"delete",uri:e};return void 0===d||void 0===d.recursive&&void 0===d.ignoreIfNotExists||(n.options=d),void 0!==u&&(n.annotationId=u),n},e.is=function(e){var d=e;return d&&"delete"===d.kind&&K.string(d.uri)&&(void 0===d.options||(void 0===d.options.recursive||K.boolean(d.options.recursive))&&(void 0===d.options.ignoreIfNotExists||K.boolean(d.options.ignoreIfNotExists)))&&(void 0===d.annotationId||l.is(d.annotationId))}}(h=d.DeleteFile||(d.DeleteFile={})),function(e){e.is=function(e){var d=e;return d&&(void 0!==d.changes||void 0!==d.documentChanges)&&(void 0===d.documentChanges||d.documentChanges.every((function(e){return K.string(e.kind)?g.is(e)||b.is(e)||h.is(e):p.is(e)})))}}(v=d.WorkspaceEdit||(d.WorkspaceEdit={}));var y,C,_,I,S=function(){function e(e,d){this.edits=e,this.changeAnnotations=d}return e.prototype.insert=function(e,d,u){var n,t;if(void 0===u?n=s.insert(e,d):l.is(u)?(t=u,n=m.insert(e,d,u)):(this.assertChangeAnnotations(this.changeAnnotations),t=this.changeAnnotations.manage(u),n=m.insert(e,d,t)),this.edits.push(n),void 0!==t)return t},e.prototype.replace=function(e,d,u){var n,t;if(void 0===u?n=s.replace(e,d):l.is(u)?(t=u,n=m.replace(e,d,u)):(this.assertChangeAnnotations(this.changeAnnotations),t=this.changeAnnotations.manage(u),n=m.replace(e,d,t)),this.edits.push(n),void 0!==t)return t},e.prototype.delete=function(e,d){var u,n;if(void 0===d?u=s.del(e):l.is(d)?(n=d,u=m.del(e,d)):(this.assertChangeAnnotations(this.changeAnnotations),n=this.changeAnnotations.manage(d),u=m.del(e,n)),this.edits.push(u),void 0!==n)return n},e.prototype.add=function(e){this.edits.push(e)},e.prototype.all=function(){return this.edits},e.prototype.clear=function(){this.edits.splice(0,this.edits.length)},e.prototype.assertChangeAnnotations=function(e){if(void 0===e)throw new Error("Text edit change is not configured to manage change annotations.")},e}(),x=function(){function e(e){this._annotations=void 0===e?Object.create(null):e,this._counter=0,this._size=0}return e.prototype.all=function(){return this._annotations},Object.defineProperty(e.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),e.prototype.manage=function(e,d){var u;if(l.is(e)?u=e:(u=this.nextId(),d=e),void 0!==this._annotations[u])throw new Error("Id "+u+" is already in use.");if(void 0===d)throw new Error("No annotation provided for id "+u);return this._annotations[u]=d,this._size++,u},e.prototype.nextId=function(){return this._counter++,this._counter.toString()},e}(),T=function(){function e(e){var d=this;this._textEditChanges=Object.create(null),void 0!==e?(this._workspaceEdit=e,e.documentChanges?(this._changeAnnotations=new x(e.changeAnnotations),e.changeAnnotations=this._changeAnnotations.all(),e.documentChanges.forEach((function(e){if(p.is(e)){var u=new S(e.edits,d._changeAnnotations);d._textEditChanges[e.textDocument.uri]=u}}))):e.changes&&Object.keys(e.changes).forEach((function(u){var n=new S(e.changes[u]);d._textEditChanges[u]=n}))):this._workspaceEdit={}}return Object.defineProperty(e.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),e.prototype.getTextEditChange=function(e){if(y.is(e)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var d={uri:e.uri,version:e.version};if(!(n=this._textEditChanges[d.uri])){var u={textDocument:d,edits:t=[]};this._workspaceEdit.documentChanges.push(u),n=new S(t,this._changeAnnotations),this._textEditChanges[d.uri]=n}return n}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var n;if(!(n=this._textEditChanges[e])){var t=[];this._workspaceEdit.changes[e]=t,n=new S(t),this._textEditChanges[e]=n}return n},e.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new x,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},e.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},e.prototype.createFile=function(e,d,u){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var n,t,a;if(f.is(d)||l.is(d)?n=d:u=d,void 0===n?t=g.create(e,u):(a=l.is(n)?n:this._changeAnnotations.manage(n),t=g.create(e,u,a)),this._workspaceEdit.documentChanges.push(t),void 0!==a)return a},e.prototype.renameFile=function(e,d,u,n){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var t,a,r;if(f.is(u)||l.is(u)?t=u:n=u,void 0===t?a=b.create(e,d,n):(r=l.is(t)?t:this._changeAnnotations.manage(t),a=b.create(e,d,n,r)),this._workspaceEdit.documentChanges.push(a),void 0!==r)return r},e.prototype.deleteFile=function(e,d,u){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var n,t,a;if(f.is(d)||l.is(d)?n=d:u=d,void 0===n?t=h.create(e,u):(a=l.is(n)?n:this._changeAnnotations.manage(n),t=h.create(e,u,a)),this._workspaceEdit.documentChanges.push(t),void 0!==a)return a},e}();d.WorkspaceChange=T,function(e){e.create=function(e){return{uri:e}},e.is=function(e){var d=e;return K.defined(d)&&K.string(d.uri)}}(d.TextDocumentIdentifier||(d.TextDocumentIdentifier={})),function(e){e.create=function(e,d){return{uri:e,version:d}},e.is=function(e){var d=e;return K.defined(d)&&K.string(d.uri)&&K.integer(d.version)}}(d.VersionedTextDocumentIdentifier||(d.VersionedTextDocumentIdentifier={})),function(e){e.create=function(e,d){return{uri:e,version:d}},e.is=function(e){var d=e;return K.defined(d)&&K.string(d.uri)&&(null===d.version||K.integer(d.version))}}(y=d.OptionalVersionedTextDocumentIdentifier||(d.OptionalVersionedTextDocumentIdentifier={})),function(e){e.create=function(e,d,u,n){return{uri:e,languageId:d,version:u,text:n}},e.is=function(e){var d=e;return K.defined(d)&&K.string(d.uri)&&K.string(d.languageId)&&K.integer(d.version)&&K.string(d.text)}}(d.TextDocumentItem||(d.TextDocumentItem={})),function(e){e.PlainText="plaintext",e.Markdown="markdown"}(C=d.MarkupKind||(d.MarkupKind={})),function(e){e.is=function(d){var u=d;return u===e.PlainText||u===e.Markdown}}(C=d.MarkupKind||(d.MarkupKind={})),function(e){e.is=function(e){var d=e;return K.objectLiteral(e)&&C.is(d.kind)&&K.string(d.value)}}(_=d.MarkupContent||(d.MarkupContent={})),function(e){e.Text=1,e.Method=2,e.Function=3,e.Constructor=4,e.Field=5,e.Variable=6,e.Class=7,e.Interface=8,e.Module=9,e.Property=10,e.Unit=11,e.Value=12,e.Enum=13,e.Keyword=14,e.Snippet=15,e.Color=16,e.File=17,e.Reference=18,e.Folder=19,e.EnumMember=20,e.Constant=21,e.Struct=22,e.Event=23,e.Operator=24,e.TypeParameter=25}(d.CompletionItemKind||(d.CompletionItemKind={})),function(e){e.PlainText=1,e.Snippet=2}(d.InsertTextFormat||(d.InsertTextFormat={})),function(e){e.Deprecated=1}(d.CompletionItemTag||(d.CompletionItemTag={})),function(e){e.create=function(e,d,u){return{newText:e,insert:d,replace:u}},e.is=function(e){var d=e;return d&&K.string(d.newText)&&t.is(d.insert)&&t.is(d.replace)}}(d.InsertReplaceEdit||(d.InsertReplaceEdit={})),function(e){e.asIs=1,e.adjustIndentation=2}(d.InsertTextMode||(d.InsertTextMode={})),function(e){e.create=function(e){return{label:e}}}(d.CompletionItem||(d.CompletionItem={})),function(e){e.create=function(e,d){return{items:e||[],isIncomplete:!!d}}}(d.CompletionList||(d.CompletionList={})),function(e){e.fromPlainText=function(e){return e.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},e.is=function(e){var d=e;return K.string(d)||K.objectLiteral(d)&&K.string(d.language)&&K.string(d.value)}}(I=d.MarkedString||(d.MarkedString={})),function(e){e.is=function(e){var d=e;return!!d&&K.objectLiteral(d)&&(_.is(d.contents)||I.is(d.contents)||K.typedArray(d.contents,I.is))&&(void 0===e.range||t.is(e.range))}}(d.Hover||(d.Hover={})),function(e){e.create=function(e,d){return d?{label:e,documentation:d}:{label:e}}}(d.ParameterInformation||(d.ParameterInformation={})),function(e){e.create=function(e,d){for(var u=[],n=2;n<arguments.length;n++)u[n-2]=arguments[n];var t={label:e};return K.defined(d)&&(t.documentation=d),K.defined(u)?t.parameters=u:t.parameters=[],t}}(d.SignatureInformation||(d.SignatureInformation={})),function(e){e.Text=1,e.Read=2,e.Write=3}(d.DocumentHighlightKind||(d.DocumentHighlightKind={})),function(e){e.create=function(e,d){var u={range:e};return K.number(d)&&(u.kind=d),u}}(d.DocumentHighlight||(d.DocumentHighlight={})),function(e){e.File=1,e.Module=2,e.Namespace=3,e.Package=4,e.Class=5,e.Method=6,e.Property=7,e.Field=8,e.Constructor=9,e.Enum=10,e.Interface=11,e.Function=12,e.Variable=13,e.Constant=14,e.String=15,e.Number=16,e.Boolean=17,e.Array=18,e.Object=19,e.Key=20,e.Null=21,e.EnumMember=22,e.Struct=23,e.Event=24,e.Operator=25,e.TypeParameter=26}(d.SymbolKind||(d.SymbolKind={})),function(e){e.Deprecated=1}(d.SymbolTag||(d.SymbolTag={})),function(e){e.create=function(e,d,u,n,t){var a={name:e,kind:d,location:{uri:n,range:u}};return t&&(a.containerName=t),a}}(d.SymbolInformation||(d.SymbolInformation={})),function(e){e.create=function(e,d,u,n,t,a){var r={name:e,detail:d,kind:u,range:n,selectionRange:t};return void 0!==a&&(r.children=a),r},e.is=function(e){var d=e;return d&&K.string(d.name)&&K.number(d.kind)&&t.is(d.range)&&t.is(d.selectionRange)&&(void 0===d.detail||K.string(d.detail))&&(void 0===d.deprecated||K.boolean(d.deprecated))&&(void 0===d.children||Array.isArray(d.children))&&(void 0===d.tags||Array.isArray(d.tags))}}(d.DocumentSymbol||(d.DocumentSymbol={})),function(e){e.Empty="",e.QuickFix="quickfix",e.Refactor="refactor",e.RefactorExtract="refactor.extract",e.RefactorInline="refactor.inline",e.RefactorRewrite="refactor.rewrite",e.Source="source",e.SourceOrganizeImports="source.organizeImports",e.SourceFixAll="source.fixAll"}(d.CodeActionKind||(d.CodeActionKind={})),function(e){e.create=function(e,d){var u={diagnostics:e};return null!=d&&(u.only=d),u},e.is=function(e){var d=e;return K.defined(d)&&K.typedArray(d.diagnostics,o.is)&&(void 0===d.only||K.typedArray(d.only,K.string))}}(d.CodeActionContext||(d.CodeActionContext={})),function(e){e.create=function(e,d,u){var n={title:e},t=!0;return"string"==typeof d?(t=!1,n.kind=d):c.is(d)?n.command=d:n.edit=d,t&&void 0!==u&&(n.kind=u),n},e.is=function(e){var d=e;return d&&K.string(d.title)&&(void 0===d.diagnostics||K.typedArray(d.diagnostics,o.is))&&(void 0===d.kind||K.string(d.kind))&&(void 0!==d.edit||void 0!==d.command)&&(void 0===d.command||c.is(d.command))&&(void 0===d.isPreferred||K.boolean(d.isPreferred))&&(void 0===d.edit||v.is(d.edit))}}(d.CodeAction||(d.CodeAction={})),function(e){e.create=function(e,d){var u={range:e};return K.defined(d)&&(u.data=d),u},e.is=function(e){var d=e;return K.defined(d)&&t.is(d.range)&&(K.undefined(d.command)||c.is(d.command))}}(d.CodeLens||(d.CodeLens={})),function(e){e.create=function(e,d){return{tabSize:e,insertSpaces:d}},e.is=function(e){var d=e;return K.defined(d)&&K.uinteger(d.tabSize)&&K.boolean(d.insertSpaces)}}(d.FormattingOptions||(d.FormattingOptions={})),function(e){e.create=function(e,d,u){return{range:e,target:d,data:u}},e.is=function(e){var d=e;return K.defined(d)&&t.is(d.range)&&(K.undefined(d.target)||K.string(d.target))}}(d.DocumentLink||(d.DocumentLink={})),function(e){e.create=function(e,d){return{range:e,parent:d}},e.is=function(d){var u=d;return void 0!==u&&t.is(u.range)&&(void 0===u.parent||e.is(u.parent))}}(d.SelectionRange||(d.SelectionRange={})),d.EOL=["\n","\r\n","\r"],function(e){e.create=function(e,d,u,n){return new P(e,d,u,n)},e.is=function(e){var d=e;return!!(K.defined(d)&&K.string(d.uri)&&(K.undefined(d.languageId)||K.string(d.languageId))&&K.uinteger(d.lineCount)&&K.func(d.getText)&&K.func(d.positionAt)&&K.func(d.offsetAt))},e.applyEdits=function(e,d){for(var u=e.getText(),n=function e(d,u){if(d.length<=1)return d;var n=d.length/2|0,t=d.slice(0,n),a=d.slice(n);e(t,u),e(a,u);for(var r=0,i=0,o=0;r<t.length&&i<a.length;){var c=u(t[r],a[i]);d[o++]=c<=0?t[r++]:a[i++]}for(;r<t.length;)d[o++]=t[r++];for(;i<a.length;)d[o++]=a[i++];return d}(d,(function(e,d){var u=e.range.start.line-d.range.start.line;return 0===u?e.range.start.character-d.range.start.character:u})),t=u.length,a=n.length-1;a>=0;a--){var r=n[a],i=e.offsetAt(r.range.start),o=e.offsetAt(r.range.end);if(!(o<=t))throw new Error("Overlapping edit");u=u.substring(0,i)+r.newText+u.substring(o,u.length),t=i}return u}}(d.TextDocument||(d.TextDocument={}));var K,P=function(){function e(e,d,u,n){this._uri=e,this._languageId=d,this._version=u,this._content=n,this._lineOffsets=void 0}return Object.defineProperty(e.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),e.prototype.getText=function(e){if(e){var d=this.offsetAt(e.start),u=this.offsetAt(e.end);return this._content.substring(d,u)}return this._content},e.prototype.update=function(e,d){this._content=e.text,this._version=d,this._lineOffsets=void 0},e.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var e=[],d=this._content,u=!0,n=0;n<d.length;n++){u&&(e.push(n),u=!1);var t=d.charAt(n);u="\r"===t||"\n"===t,"\r"===t&&n+1<d.length&&"\n"===d.charAt(n+1)&&n++}u&&d.length>0&&e.push(d.length),this._lineOffsets=e}return this._lineOffsets},e.prototype.positionAt=function(e){e=Math.max(Math.min(e,this._content.length),0);var d=this.getLineOffsets(),u=0,t=d.length;if(0===t)return n.create(0,e);for(;u<t;){var a=Math.floor((u+t)/2);d[a]>e?t=a:u=a+1}var r=u-1;return n.create(r,e-d[r])},e.prototype.offsetAt=function(e){var d=this.getLineOffsets();if(e.line>=d.length)return this._content.length;if(e.line<0)return 0;var u=d[e.line],n=e.line+1<d.length?d[e.line+1]:this._content.length;return Math.max(Math.min(u+e.character,n),u)},Object.defineProperty(e.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),e}();!function(e){var d=Object.prototype.toString;e.defined=function(e){return void 0!==e},e.undefined=function(e){return void 0===e},e.boolean=function(e){return!0===e||!1===e},e.string=function(e){return"[object String]"===d.call(e)},e.number=function(e){return"[object Number]"===d.call(e)},e.numberRange=function(e,u,n){return"[object Number]"===d.call(e)&&u<=e&&e<=n},e.integer=function(e){return"[object Number]"===d.call(e)&&-2147483648<=e&&e<=2147483647},e.uinteger=function(e){return"[object Number]"===d.call(e)&&0<=e&&e<=2147483647},e.func=function(e){return"[object Function]"===d.call(e)},e.objectLiteral=function(e){return null!==e&&"object"==typeof e},e.typedArray=function(e,d){return Array.isArray(e)&&e.every(d)}}(K||(K={}))})),define("vscode-languageserver-types",["vscode-languageserver-types/main"],(function(e){return e})),function(e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define("xregexp/xregexp-all",[],e):("undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this).XRegExp=e()}((function(){return function e(d,u,n){function t(r,i){if(!u[r]){if(!d[r]){var o="function"==typeof require&&require;if(!i&&o)return o(r,!0);if(a)return a(r,!0);var c=new Error("Cannot find module '"+r+"'");throw c.code="MODULE_NOT_FOUND",c}var s=u[r]={exports:{}};d[r][0].call(s.exports,(function(e){return t(d[r][1][e]||e)}),s,s.exports,e,d,u,n)}return u[r].exports}for(var a="function"==typeof require&&require,r=0;r<n.length;r++)t(n[r]);return t}({1:[function(e,d,u){d.exports=function(e){"use strict";var d=/(\()(?!\?)|\\([1-9]\d*)|\\[\s\S]|\[(?:[^\\\]]|\\[\s\S])*\]/g,u=e.union([/\({{([\w$]+)}}\)|{{([\w$]+)}}/,d],"g",{conjunction:"or"});function n(e){var d=/^(?:\(\?:\))*\^/,u=/\$(?:\(\?:\))*$/;return d.test(e)&&u.test(e)&&u.test(e.replace(/\\[\s\S]/g,""))?e.replace(d,"").replace(u,""):e}function t(d,u){var n=u?"x":"";return e.isRegExp(d)?d.xregexp&&d.xregexp.captureNames?d:e(d.source,n):e(d,n)}e.build=function(a,r,i){var o=(i=i||"").indexOf("x")>-1,c=/^\(\?([\w$]+)\)/.exec(a);c&&(i=e._clipDuplicates(i+c[1]));var s={};for(var f in r)if(r.hasOwnProperty(f)){var l=t(r[f],o);s[f]={pattern:n(l.source),names:l.xregexp.captureNames||[]}}var m,p=t(a,o),g=0,b=0,h=[0],v=p.xregexp.captureNames||[],y=p.source.replace(u,(function(e,u,n,t,a){var r,i,o,c=u||n;if(c){if(!s.hasOwnProperty(c))throw new ReferenceError("Undefined property "+e);return u?(r=v[b],h[++b]=++g,i="(?<"+(r||c)+">"):i="(?:",m=g,i+s[c].pattern.replace(d,(function(e,d,u){if(d){if(r=s[c].names[g-m],++g,r)return"(?<"+r+">"}else if(u)return o=+u-1,s[c].names[o]?"\\k<"+s[c].names[o]+">":"\\"+(+u+m);return e}))+")"}if(t){if(r=v[b],h[++b]=++g,r)return"(?<"+r+">"}else if(a)return v[o=+a-1]?"\\k<"+v[o]+">":"\\"+h[+a];return e}));return e(y,i)}}},{}],2:[function(e,d,u){d.exports=function(e){"use strict";function d(e,d,u,n){return{name:e,value:d,start:u,end:n}}e.matchRecursive=function(u,n,t,a,r){r=r||{};var i,o,c,s,f,l=(a=a||"").indexOf("g")>-1,m=a.indexOf("y")>-1,p=a.replace(/y/g,""),g=r.escapeChar,b=r.valueNames,h=[],v=0,y=0,C=0,_=0;if(n=e(n,p),t=e(t,p),g){if(g.length>1)throw new Error("Cannot use more than one escape character");g=e.escape(g),f=new RegExp("(?:"+g+"[\\S\\s]|(?:(?!"+e.union([n,t],"",{conjunction:"or"}).source+")[^"+g+"])+)+",a.replace(/[^imu]+/g,""))}for(;;){if(g&&(C+=(e.exec(u,f,C,"sticky")||[""])[0].length),c=e.exec(u,n,C),s=e.exec(u,t,C),c&&s&&(c.index<=s.index?s=null:c=null),c||s)C=(y=(c||s).index)+(c||s)[0].length;else if(!v)break;if(m&&!v&&y>_)break;if(c)v||(i=y,o=C),++v;else{if(!s||!v)throw new Error("Unbalanced delimiter found in string");if(!--v&&(b?(b[0]&&i>_&&h.push(d(b[0],u.slice(_,i),_,i)),b[1]&&h.push(d(b[1],u.slice(i,o),i,o)),b[2]&&h.push(d(b[2],u.slice(o,y),o,y)),b[3]&&h.push(d(b[3],u.slice(y,C),y,C))):h.push(u.slice(o,y)),_=C,!l))break}y===C&&++C}return l&&!m&&b&&b[0]&&u.length>_&&h.push(d(b[0],u.slice(_),_,u.length)),h}}},{}],3:[function(e,d,u){d.exports=function(e){"use strict";var d={},u=e._dec,n=e._hex,t=e._pad4;function a(e){return e.replace(/[- _]+/g,"").toLowerCase()}function r(e){var d=/^\\[xu](.+)/.exec(e);return d?u(d[1]):e.charCodeAt("\\"===e.charAt(0)?1:0)}function i(u){var a,i,o;return d[u]["b!"]||(d[u]["b!"]=(a=d[u].bmp,i="",o=-1,e.forEach(a,/(\\x..|\\u....|\\?[\s\S])(?:-(\\x..|\\u....|\\?[\s\S]))?/,(function(e){var d=r(e[1]);d>o+1&&(i+="\\u"+t(n(o+1)),d>o+2&&(i+="-\\u"+t(n(d-1)))),o=r(e[2]||e[1])})),o<65535&&(i+="\\u"+t(n(o+1)),o<65534&&(i+="-\\uFFFF")),i))}e.addToken(/\\([pP])(?:{(\^?)([^}]*)}|([A-Za-z]))/,(function(e,u,n){var t="P"===e[1]||!!e[2],r=n.indexOf("A")>-1,o=a(e[4]||e[3]),c=d[o];if("P"===e[1]&&e[2])throw new SyntaxError("Invalid double negation "+e[0]);if(!d.hasOwnProperty(o))throw new SyntaxError("Unknown Unicode token "+e[0]);if(c.inverseOf){if(o=a(c.inverseOf),!d.hasOwnProperty(o))throw new ReferenceError("Unicode token missing data "+e[0]+" -> "+c.inverseOf);c=d[o],t=!t}if(!c.bmp&&!r)throw new SyntaxError("Astral mode required for Unicode token "+e[0]);if(r){if("class"===u)throw new SyntaxError("Astral mode does not support Unicode tokens within character classes");return function(e,u){var n=u?"a!":"a=";return d[e][n]||(d[e][n]=function(e,u){var n=d[e],t="";return n.bmp&&!n.isBmpLast&&(t="["+n.bmp+"]"+(n.astral?"|":"")),n.astral&&(t+=n.astral),n.isBmpLast&&n.bmp&&(t+=(n.astral?"|":"")+"["+n.bmp+"]"),u?"(?:(?!"+t+")(?:[\ud800-\udbff][\udc00-\udfff]|[\0-￿]))":"(?:"+t+")"}(e,u))}(o,t)}return"class"===u?t?i(o):c.bmp:(t?"[^":"[")+c.bmp+"]"}),{scope:"all",optionalFlags:"A",leadChar:"\\"}),e.addUnicodeData=function(u){for(var n,t=0;t<u.length;++t){if(!(n=u[t]).name)throw new Error("Unicode token requires name");if(!(n.inverseOf||n.bmp||n.astral))throw new Error("Unicode token has no character data "+n.name);d[a(n.name)]=n,n.alias&&(d[a(n.alias)]=n)}e.cache.flush("patterns")},e._getUnicodeProperty=function(e){var u=a(e);return d[u]}}},{}],4:[function(e,d,u){d.exports=function(e){"use strict";if(!e.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Blocks");e.addUnicodeData([{name:"InAdlam",astral:"\ud83a[\udd00-\udd5f]"},{name:"InAegean_Numbers",astral:"\ud800[\udd00-\udd3f]"},{name:"InAhom",astral:"\ud805[\udf00-\udf3f]"},{name:"InAlchemical_Symbols",astral:"\ud83d[\udf00-\udf7f]"},{name:"InAlphabetic_Presentation_Forms",bmp:"ﬀ-ﭏ"},{name:"InAnatolian_Hieroglyphs",astral:"\ud811[\udc00-\ude7f]"},{name:"InAncient_Greek_Musical_Notation",astral:"\ud834[\ude00-\ude4f]"},{name:"InAncient_Greek_Numbers",astral:"\ud800[\udd40-\udd8f]"},{name:"InAncient_Symbols",astral:"\ud800[\udd90-\uddcf]"},{name:"InArabic",bmp:"؀-ۿ"},{name:"InArabic_Extended_A",bmp:"ࢠ-ࣿ"},{name:"InArabic_Mathematical_Alphabetic_Symbols",astral:"\ud83b[\ude00-\udeff]"},{name:"InArabic_Presentation_Forms_A",bmp:"ﭐ-﷿"},{name:"InArabic_Presentation_Forms_B",bmp:"ﹰ-\ufeff"},{name:"InArabic_Supplement",bmp:"ݐ-ݿ"},{name:"InArmenian",bmp:"԰-֏"},{name:"InArrows",bmp:"←-⇿"},{name:"InAvestan",astral:"\ud802[\udf00-\udf3f]"},{name:"InBalinese",bmp:"ᬀ-᭿"},{name:"InBamum",bmp:"ꚠ-꛿"},{name:"InBamum_Supplement",astral:"\ud81a[\udc00-\ude3f]"},{name:"InBasic_Latin",bmp:"\0-"},{name:"InBassa_Vah",astral:"\ud81a[\uded0-\udeff]"},{name:"InBatak",bmp:"ᯀ-᯿"},{name:"InBengali",bmp:"ঀ-৿"},{name:"InBhaiksuki",astral:"\ud807[\udc00-\udc6f]"},{name:"InBlock_Elements",bmp:"▀-▟"},{name:"InBopomofo",bmp:"㄀-ㄯ"},{name:"InBopomofo_Extended",bmp:"ㆠ-ㆿ"},{name:"InBox_Drawing",bmp:"─-╿"},{name:"InBrahmi",astral:"\ud804[\udc00-\udc7f]"},{name:"InBraille_Patterns",bmp:"⠀-⣿"},{name:"InBuginese",bmp:"ᨀ-᨟"},{name:"InBuhid",bmp:"ᝀ-᝟"},{name:"InByzantine_Musical_Symbols",astral:"\ud834[\udc00-\udcff]"},{name:"InCJK_Compatibility",bmp:"㌀-㏿"},{name:"InCJK_Compatibility_Forms",bmp:"︰-﹏"},{name:"InCJK_Compatibility_Ideographs",bmp:"豈-﫿"},{name:"InCJK_Compatibility_Ideographs_Supplement",astral:"\ud87e[\udc00-\ude1f]"},{name:"InCJK_Radicals_Supplement",bmp:"⺀-⻿"},{name:"InCJK_Strokes",bmp:"㇀-㇯"},{name:"InCJK_Symbols_and_Punctuation",bmp:"　-〿"},{name:"InCJK_Unified_Ideographs",bmp:"一-鿿"},{name:"InCJK_Unified_Ideographs_Extension_A",bmp:"㐀-䶿"},{name:"InCJK_Unified_Ideographs_Extension_B",astral:"[\ud840-\ud868][\udc00-\udfff]|\ud869[\udc00-\udedf]"},{name:"InCJK_Unified_Ideographs_Extension_C",astral:"\ud869[\udf00-\udfff]|[\ud86a-\ud86c][\udc00-\udfff]|\ud86d[\udc00-\udf3f]"},{name:"InCJK_Unified_Ideographs_Extension_D",astral:"\ud86d[\udf40-\udfff]|\ud86e[\udc00-\udc1f]"},{name:"InCJK_Unified_Ideographs_Extension_E",astral:"\ud86e[\udc20-\udfff]|[\ud86f-\ud872][\udc00-\udfff]|\ud873[\udc00-\udeaf]"},{name:"InCarian",astral:"\ud800[\udea0-\udedf]"},{name:"InCaucasian_Albanian",astral:"\ud801[\udd30-\udd6f]"},{name:"InChakma",astral:"\ud804[\udd00-\udd4f]"},{name:"InCham",bmp:"ꨀ-꩟"},{name:"InCherokee",bmp:"Ꭰ-᏿"},{name:"InCherokee_Supplement",bmp:"ꭰ-ꮿ"},{name:"InCombining_Diacritical_Marks",bmp:"̀-ͯ"},{name:"InCombining_Diacritical_Marks_Extended",bmp:"᪰-᫿"},{name:"InCombining_Diacritical_Marks_Supplement",bmp:"᷀-᷿"},{name:"InCombining_Diacritical_Marks_for_Symbols",bmp:"⃐-⃿"},{name:"InCombining_Half_Marks",bmp:"︠-︯"},{name:"InCommon_Indic_Number_Forms",bmp:"꠰-꠿"},{name:"InControl_Pictures",bmp:"␀-␿"},{name:"InCoptic",bmp:"Ⲁ-⳿"},{name:"InCoptic_Epact_Numbers",astral:"\ud800[\udee0-\udeff]"},{name:"InCounting_Rod_Numerals",astral:"\ud834[\udf60-\udf7f]"},{name:"InCuneiform",astral:"\ud808[\udc00-\udfff]"},{name:"InCuneiform_Numbers_and_Punctuation",astral:"\ud809[\udc00-\udc7f]"},{name:"InCurrency_Symbols",bmp:"₠-⃏"},{name:"InCypriot_Syllabary",astral:"\ud802[\udc00-\udc3f]"},{name:"InCyrillic",bmp:"Ѐ-ӿ"},{name:"InCyrillic_Extended_A",bmp:"ⷠ-ⷿ"},{name:"InCyrillic_Extended_B",bmp:"Ꙁ-ꚟ"},{name:"InCyrillic_Extended_C",bmp:"ᲀ-᲏"},{name:"InCyrillic_Supplement",bmp:"Ԁ-ԯ"},{name:"InDeseret",astral:"\ud801[\udc00-\udc4f]"},{name:"InDevanagari",bmp:"ऀ-ॿ"},{name:"InDevanagari_Extended",bmp:"꣠-ꣿ"},{name:"InDingbats",bmp:"✀-➿"},{name:"InDomino_Tiles",astral:"\ud83c[\udc30-\udc9f]"},{name:"InDuployan",astral:"\ud82f[\udc00-\udc9f]"},{name:"InEarly_Dynastic_Cuneiform",astral:"\ud809[\udc80-\udd4f]"},{name:"InEgyptian_Hieroglyphs",astral:"\ud80c[\udc00-\udfff]|\ud80d[\udc00-\udc2f]"},{name:"InElbasan",astral:"\ud801[\udd00-\udd2f]"},{name:"InEmoticons",astral:"\ud83d[\ude00-\ude4f]"},{name:"InEnclosed_Alphanumeric_Supplement",astral:"\ud83c[\udd00-\uddff]"},{name:"InEnclosed_Alphanumerics",bmp:"①-⓿"},{name:"InEnclosed_CJK_Letters_and_Months",bmp:"㈀-㋿"},{name:"InEnclosed_Ideographic_Supplement",astral:"\ud83c[\ude00-\udeff]"},{name:"InEthiopic",bmp:"ሀ-፿"},{name:"InEthiopic_Extended",bmp:"ⶀ-⷟"},{name:"InEthiopic_Extended_A",bmp:"꬀-꬯"},{name:"InEthiopic_Supplement",bmp:"ᎀ-᎟"},{name:"InGeneral_Punctuation",bmp:" -⁯"},{name:"InGeometric_Shapes",bmp:"■-◿"},{name:"InGeometric_Shapes_Extended",astral:"\ud83d[\udf80-\udfff]"},{name:"InGeorgian",bmp:"Ⴀ-ჿ"},{name:"InGeorgian_Supplement",bmp:"ⴀ-⴯"},{name:"InGlagolitic",bmp:"Ⰰ-ⱟ"},{name:"InGlagolitic_Supplement",astral:"\ud838[\udc00-\udc2f]"},{name:"InGothic",astral:"\ud800[\udf30-\udf4f]"},{name:"InGrantha",astral:"\ud804[\udf00-\udf7f]"},{name:"InGreek_Extended",bmp:"ἀ-῿"},{name:"InGreek_and_Coptic",bmp:"Ͱ-Ͽ"},{name:"InGujarati",bmp:"઀-૿"},{name:"InGurmukhi",bmp:"਀-੿"},{name:"InHalfwidth_and_Fullwidth_Forms",bmp:"＀-￯"},{name:"InHangul_Compatibility_Jamo",bmp:"㄰-㆏"},{name:"InHangul_Jamo",bmp:"ᄀ-ᇿ"},{name:"InHangul_Jamo_Extended_A",bmp:"ꥠ-꥿"},{name:"InHangul_Jamo_Extended_B",bmp:"ힰ-퟿"},{name:"InHangul_Syllables",bmp:"가-힯"},{name:"InHanunoo",bmp:"ᜠ-᜿"},{name:"InHatran",astral:"\ud802[\udce0-\udcff]"},{name:"InHebrew",bmp:"֐-׿"},{name:"InHigh_Private_Use_Surrogates",bmp:"\udb80-\udbff"},{name:"InHigh_Surrogates",bmp:"\ud800-\udb7f"},{name:"InHiragana",bmp:"぀-ゟ"},{name:"InIPA_Extensions",bmp:"ɐ-ʯ"},{name:"InIdeographic_Description_Characters",bmp:"⿰-⿿"},{name:"InIdeographic_Symbols_and_Punctuation",astral:"\ud81b[\udfe0-\udfff]"},{name:"InImperial_Aramaic",astral:"\ud802[\udc40-\udc5f]"},{name:"InInscriptional_Pahlavi",astral:"\ud802[\udf60-\udf7f]"},{name:"InInscriptional_Parthian",astral:"\ud802[\udf40-\udf5f]"},{name:"InJavanese",bmp:"ꦀ-꧟"},{name:"InKaithi",astral:"\ud804[\udc80-\udccf]"},{name:"InKana_Supplement",astral:"\ud82c[\udc00-\udcff]"},{name:"InKanbun",bmp:"㆐-㆟"},{name:"InKangxi_Radicals",bmp:"⼀-⿟"},{name:"InKannada",bmp:"ಀ-೿"},{name:"InKatakana",bmp:"゠-ヿ"},{name:"InKatakana_Phonetic_Extensions",bmp:"ㇰ-ㇿ"},{name:"InKayah_Li",bmp:"꤀-꤯"},{name:"InKharoshthi",astral:"\ud802[\ude00-\ude5f]"},{name:"InKhmer",bmp:"ក-៿"},{name:"InKhmer_Symbols",bmp:"᧠-᧿"},{name:"InKhojki",astral:"\ud804[\ude00-\ude4f]"},{name:"InKhudawadi",astral:"\ud804[\udeb0-\udeff]"},{name:"InLao",bmp:"຀-໿"},{name:"InLatin_Extended_Additional",bmp:"Ḁ-ỿ"},{name:"InLatin_Extended_A",bmp:"Ā-ſ"},{name:"InLatin_Extended_B",bmp:"ƀ-ɏ"},{name:"InLatin_Extended_C",bmp:"Ⱡ-Ɀ"},{name:"InLatin_Extended_D",bmp:"꜠-ꟿ"},{name:"InLatin_Extended_E",bmp:"ꬰ-꭯"},{name:"InLatin_1_Supplement",bmp:"-ÿ"},{name:"InLepcha",bmp:"ᰀ-ᱏ"},{name:"InLetterlike_Symbols",bmp:"℀-⅏"},{name:"InLimbu",bmp:"ᤀ-᥏"},{name:"InLinear_A",astral:"\ud801[\ude00-\udf7f]"},{name:"InLinear_B_Ideograms",astral:"\ud800[\udc80-\udcff]"},{name:"InLinear_B_Syllabary",astral:"\ud800[\udc00-\udc7f]"},{name:"InLisu",bmp:"ꓐ-꓿"},{name:"InLow_Surrogates",bmp:"\udc00-\udfff"},{name:"InLycian",astral:"\ud800[\ude80-\ude9f]"},{name:"InLydian",astral:"\ud802[\udd20-\udd3f]"},{name:"InMahajani",astral:"\ud804[\udd50-\udd7f]"},{name:"InMahjong_Tiles",astral:"\ud83c[\udc00-\udc2f]"},{name:"InMalayalam",bmp:"ഀ-ൿ"},{name:"InMandaic",bmp:"ࡀ-࡟"},{name:"InManichaean",astral:"\ud802[\udec0-\udeff]"},{name:"InMarchen",astral:"\ud807[\udc70-\udcbf]"},{name:"InMathematical_Alphanumeric_Symbols",astral:"\ud835[\udc00-\udfff]"},{name:"InMathematical_Operators",bmp:"∀-⋿"},{name:"InMeetei_Mayek",bmp:"ꯀ-꯿"},{name:"InMeetei_Mayek_Extensions",bmp:"ꫠ-꫿"},{name:"InMende_Kikakui",astral:"\ud83a[\udc00-\udcdf]"},{name:"InMeroitic_Cursive",astral:"\ud802[\udda0-\uddff]"},{name:"InMeroitic_Hieroglyphs",astral:"\ud802[\udd80-\udd9f]"},{name:"InMiao",astral:"\ud81b[\udf00-\udf9f]"},{name:"InMiscellaneous_Mathematical_Symbols_A",bmp:"⟀-⟯"},{name:"InMiscellaneous_Mathematical_Symbols_B",bmp:"⦀-⧿"},{name:"InMiscellaneous_Symbols",bmp:"☀-⛿"},{name:"InMiscellaneous_Symbols_and_Arrows",bmp:"⬀-⯿"},{name:"InMiscellaneous_Symbols_and_Pictographs",astral:"\ud83c[\udf00-\udfff]|\ud83d[\udc00-\uddff]"},{name:"InMiscellaneous_Technical",bmp:"⌀-⏿"},{name:"InModi",astral:"\ud805[\ude00-\ude5f]"},{name:"InModifier_Tone_Letters",bmp:"꜀-ꜟ"},{name:"InMongolian",bmp:"᠀-᢯"},{name:"InMongolian_Supplement",astral:"\ud805[\ude60-\ude7f]"},{name:"InMro",astral:"\ud81a[\ude40-\ude6f]"},{name:"InMultani",astral:"\ud804[\ude80-\udeaf]"},{name:"InMusical_Symbols",astral:"\ud834[\udd00-\uddff]"},{name:"InMyanmar",bmp:"က-႟"},{name:"InMyanmar_Extended_A",bmp:"ꩠ-ꩿ"},{name:"InMyanmar_Extended_B",bmp:"ꧠ-꧿"},{name:"InNKo",bmp:"߀-߿"},{name:"InNabataean",astral:"\ud802[\udc80-\udcaf]"},{name:"InNew_Tai_Lue",bmp:"ᦀ-᧟"},{name:"InNewa",astral:"\ud805[\udc00-\udc7f]"},{name:"InNumber_Forms",bmp:"⅐-↏"},{name:"InOgham",bmp:" -᚟"},{name:"InOl_Chiki",bmp:"᱐-᱿"},{name:"InOld_Hungarian",astral:"\ud803[\udc80-\udcff]"},{name:"InOld_Italic",astral:"\ud800[\udf00-\udf2f]"},{name:"InOld_North_Arabian",astral:"\ud802[\ude80-\ude9f]"},{name:"InOld_Permic",astral:"\ud800[\udf50-\udf7f]"},{name:"InOld_Persian",astral:"\ud800[\udfa0-\udfdf]"},{name:"InOld_South_Arabian",astral:"\ud802[\ude60-\ude7f]"},{name:"InOld_Turkic",astral:"\ud803[\udc00-\udc4f]"},{name:"InOptical_Character_Recognition",bmp:"⑀-⑟"},{name:"InOriya",bmp:"଀-୿"},{name:"InOrnamental_Dingbats",astral:"\ud83d[\ude50-\ude7f]"},{name:"InOsage",astral:"\ud801[\udcb0-\udcff]"},{name:"InOsmanya",astral:"\ud801[\udc80-\udcaf]"},{name:"InPahawh_Hmong",astral:"\ud81a[\udf00-\udf8f]"},{name:"InPalmyrene",astral:"\ud802[\udc60-\udc7f]"},{name:"InPau_Cin_Hau",astral:"\ud806[\udec0-\udeff]"},{name:"InPhags_pa",bmp:"ꡀ-꡿"},{name:"InPhaistos_Disc",astral:"\ud800[\uddd0-\uddff]"},{name:"InPhoenician",astral:"\ud802[\udd00-\udd1f]"},{name:"InPhonetic_Extensions",bmp:"ᴀ-ᵿ"},{name:"InPhonetic_Extensions_Supplement",bmp:"ᶀ-ᶿ"},{name:"InPlaying_Cards",astral:"\ud83c[\udca0-\udcff]"},{name:"InPrivate_Use_Area",bmp:"-"},{name:"InPsalter_Pahlavi",astral:"\ud802[\udf80-\udfaf]"},{name:"InRejang",bmp:"ꤰ-꥟"},{name:"InRumi_Numeral_Symbols",astral:"\ud803[\ude60-\ude7f]"},{name:"InRunic",bmp:"ᚠ-᛿"},{name:"InSamaritan",bmp:"ࠀ-࠿"},{name:"InSaurashtra",bmp:"ꢀ-꣟"},{name:"InSharada",astral:"\ud804[\udd80-\udddf]"},{name:"InShavian",astral:"\ud801[\udc50-\udc7f]"},{name:"InShorthand_Format_Controls",astral:"\ud82f[\udca0-\udcaf]"},{name:"InSiddham",astral:"\ud805[\udd80-\uddff]"},{name:"InSinhala",bmp:"඀-෿"},{name:"InSinhala_Archaic_Numbers",astral:"\ud804[\udde0-\uddff]"},{name:"InSmall_Form_Variants",bmp:"﹐-﹯"},{name:"InSora_Sompeng",astral:"\ud804[\udcd0-\udcff]"},{name:"InSpacing_Modifier_Letters",bmp:"ʰ-˿"},{name:"InSpecials",bmp:"￰-￿"},{name:"InSundanese",bmp:"ᮀ-ᮿ"},{name:"InSundanese_Supplement",bmp:"᳀-᳏"},{name:"InSuperscripts_and_Subscripts",bmp:"⁰-₟"},{name:"InSupplemental_Arrows_A",bmp:"⟰-⟿"},{name:"InSupplemental_Arrows_B",bmp:"⤀-⥿"},{name:"InSupplemental_Arrows_C",astral:"\ud83e[\udc00-\udcff]"},{name:"InSupplemental_Mathematical_Operators",bmp:"⨀-⫿"},{name:"InSupplemental_Punctuation",bmp:"⸀-⹿"},{name:"InSupplemental_Symbols_and_Pictographs",astral:"\ud83e[\udd00-\uddff]"},{name:"InSupplementary_Private_Use_Area_A",astral:"[\udb80-\udbbf][\udc00-\udfff]"},{name:"InSupplementary_Private_Use_Area_B",astral:"[\udbc0-\udbff][\udc00-\udfff]"},{name:"InSutton_SignWriting",astral:"\ud836[\udc00-\udeaf]"},{name:"InSyloti_Nagri",bmp:"ꠀ-꠯"},{name:"InSyriac",bmp:"܀-ݏ"},{name:"InTagalog",bmp:"ᜀ-ᜟ"},{name:"InTagbanwa",bmp:"ᝠ-᝿"},{name:"InTags",astral:"\udb40[\udc00-\udc7f]"},{name:"InTai_Le",bmp:"ᥐ-᥿"},{name:"InTai_Tham",bmp:"ᨠ-᪯"},{name:"InTai_Viet",bmp:"ꪀ-꫟"},{name:"InTai_Xuan_Jing_Symbols",astral:"\ud834[\udf00-\udf5f]"},{name:"InTakri",astral:"\ud805[\ude80-\udecf]"},{name:"InTamil",bmp:"஀-௿"},{name:"InTangut",astral:"[\ud81c-\ud821][\udc00-\udfff]"},{name:"InTangut_Components",astral:"\ud822[\udc00-\udeff]"},{name:"InTelugu",bmp:"ఀ-౿"},{name:"InThaana",bmp:"ހ-޿"},{name:"InThai",bmp:"฀-๿"},{name:"InTibetan",bmp:"ༀ-࿿"},{name:"InTifinagh",bmp:"ⴰ-⵿"},{name:"InTirhuta",astral:"\ud805[\udc80-\udcdf]"},{name:"InTransport_and_Map_Symbols",astral:"\ud83d[\ude80-\udeff]"},{name:"InUgaritic",astral:"\ud800[\udf80-\udf9f]"},{name:"InUnified_Canadian_Aboriginal_Syllabics",bmp:"᐀-ᙿ"},{name:"InUnified_Canadian_Aboriginal_Syllabics_Extended",bmp:"ᢰ-᣿"},{name:"InVai",bmp:"ꔀ-꘿"},{name:"InVariation_Selectors",bmp:"︀-️"},{name:"InVariation_Selectors_Supplement",astral:"\udb40[\udd00-\uddef]"},{name:"InVedic_Extensions",bmp:"᳐-᳿"},{name:"InVertical_Forms",bmp:"︐-︟"},{name:"InWarang_Citi",astral:"\ud806[\udca0-\udcff]"},{name:"InYi_Radicals",bmp:"꒐-꓏"},{name:"InYi_Syllables",bmp:"ꀀ-꒏"},{name:"InYijing_Hexagram_Symbols",bmp:"䷀-䷿"}])}},{}],5:[function(e,d,u){d.exports=function(e){"use strict";if(!e.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Categories");e.addUnicodeData([{name:"C",alias:"Other",isBmpLast:!0,bmp:"\0--­͸͹΀-΃΋΍΢԰՗՘ՠֈ֋֌֐׈-׏׫-ׯ׵-؅؜؝۝܎܏݋݌޲-޿߻-߿࠮࠯࠿࡜࡝࡟-࢟ࢵࢾ-࣓࣢঄঍঎঑঒঩঱঳-঵঺঻৅৆৉৊৏-৖৘-৛৞৤৥ৼ-਀਄਋-਎਑਒਩਱਴਷਺਻਽੃-੆੉੊੎-੐੒-੘੝੟-੥੶-઀઄઎઒઩઱઴઺઻૆૊૎૏૑-૟૤૥૲-૸ૺ-଀଄଍଎଑଒଩଱଴଺଻୅୆୉୊୎-୕୘-୛୞୤୥୸-஁஄஋-஍஑஖-஘஛஝஠-஢஥-஧஫-஭஺-஽௃-௅௉௎௏௑-௖௘-௥௻-௿ఄ఍఑఩఺-఼౅౉౎-౔౗౛-౟౤౥౰-౷಄಍಑಩಴಺಻೅೉೎-೔೗-ೝ೟೤೥೰ೳ-ഀഄ഍഑഻഼൅൉൐-൓൤൥඀ඁ඄඗-඙඲඼඾඿෇-෉෋-෎෕෗෠-෥෰෱෵-฀฻-฾๜-຀຃຅ຆຉ຋ຌຎ-ຓຘຠ຤຦ຨຩຬ຺຾຿໅໇໎໏໚໛໠-໿཈཭-཰྘྽࿍࿛-࿿჆჈-჌჎჏቉቎቏቗቙቞቟኉኎኏኱኶኷኿዁዆዇዗጑጖጗፛፜፽-፿᎚-᎟᏶᏷᏾᏿᚝-᚟᛹-᛿ᜍ᜕-ᜟ᜷-᜿᝔-᝟᝭᝱᝴-᝿៞៟៪-៯៺-៿᠎᠏᠚-᠟ᡸ-᡿᢫-᢯᣶-᣿᤟᤬-᤯᤼-᤿᥁-᥃᥮᥯᥵-᥿᦬-᦯᧊-᧏᧛-᧝᨜᨝᩟᩽᩾᪊-᪏᪚-᪟᪮᪯ᪿ-᫿ᭌ-᭏᭽-᭿᯴-᯻᰸-᰺᱊-᱌Ᲊ-Ჿ᳈-᳏᳷ᳺ-᳿᷶-᷺἖἗἞἟὆὇὎὏὘὚὜὞὾὿᾵῅῔῕῜῰῱῵῿​-‏‪-‮⁠-⁯⁲⁳₏₝-₟₿-⃏⃱-⃿↌-↏⏿␧-␿⑋-⑟⭴⭵⮖⮗⮺-⮼⯉⯒-⯫⯰-⯿Ⱟⱟ⳴-⳸⴦⴨-⴬⴮⴯⵨-⵮⵱-⵾⶗-⶟⶧⶯⶷⶿⷇⷏⷗⷟⹅-⹿⺚⻴-⻿⿖-⿯⿼-⿿぀゗゘㄀-㄄ㄮ-㄰㆏ㆻ-ㆿ㇤-㇯㈟㋿䶶-䶿鿖-鿿꒍-꒏꓇-꓏꘬-꘿꛸-꛿ꞯꞸ-ꟶ꠬-꠯꠺-꠿꡸-꡿꣆-꣍꣚-꣟ꣾꣿ꥔-꥞꥽-꥿꧎꧚-꧝꧿꨷-꨿꩎꩏꩚꩛꫃-꫚꫷-꬀꬇꬈꬏꬐꬗-꬟꬧꬯ꭦ-꭯꯮꯯꯺-꯿힤-힯퟇-퟊퟼-﩮﩯﫚-﫿﬇-﬒﬘-﬜﬷﬽﬿﭂﭅﯂-﯒﵀-﵏﶐﶑﷈-﷯﷾﷿︚-︟﹓﹧﹬-﹯﹵﻽-＀﾿-￁￈￉￐￑￘￙￝-￟￧￯-￻￾￿",astral:"\ud800[\udc0c\udc27\udc3b\udc3e\udc4e\udc4f\udc5e-\udc7f\udcfb-\udcff\udd03-\udd06\udd34-\udd36\udd8f\udd9c-\udd9f\udda1-\uddcf\uddfe-\ude7f\ude9d-\ude9f\uded1-\udedf\udefc-\udeff\udf24-\udf2f\udf4b-\udf4f\udf7b-\udf7f\udf9e\udfc4-\udfc7\udfd6-\udfff]|\ud801[\udc9e\udc9f\udcaa-\udcaf\udcd4-\udcd7\udcfc-\udcff\udd28-\udd2f\udd64-\udd6e\udd70-\uddff\udf37-\udf3f\udf56-\udf5f\udf68-\udfff]|\ud802[\udc06\udc07\udc09\udc36\udc39-\udc3b\udc3d\udc3e\udc56\udc9f-\udca6\udcb0-\udcdf\udcf3\udcf6-\udcfa\udd1c-\udd1e\udd3a-\udd3e\udd40-\udd7f\uddb8-\uddbb\uddd0\uddd1\ude04\ude07-\ude0b\ude14\ude18\ude34-\ude37\ude3b-\ude3e\ude48-\ude4f\ude59-\ude5f\udea0-\udebf\udee7-\udeea\udef7-\udeff\udf36-\udf38\udf56\udf57\udf73-\udf77\udf92-\udf98\udf9d-\udfa8\udfb0-\udfff]|\ud803[\udc49-\udc7f\udcb3-\udcbf\udcf3-\udcf9\udd00-\ude5f\ude7f-\udfff]|\ud804[\udc4e-\udc51\udc70-\udc7e\udcbd\udcc2-\udccf\udce9-\udcef\udcfa-\udcff\udd35\udd44-\udd4f\udd77-\udd7f\uddce\uddcf\udde0\uddf5-\uddff\ude12\ude3f-\ude7f\ude87\ude89\ude8e\ude9e\udeaa-\udeaf\udeeb-\udeef\udefa-\udeff\udf04\udf0d\udf0e\udf11\udf12\udf29\udf31\udf34\udf3a\udf3b\udf45\udf46\udf49\udf4a\udf4e\udf4f\udf51-\udf56\udf58-\udf5c\udf64\udf65\udf6d-\udf6f\udf75-\udfff]|\ud805[\udc5a\udc5c\udc5e-\udc7f\udcc8-\udccf\udcda-\udd7f\uddb6\uddb7\uddde-\uddff\ude45-\ude4f\ude5a-\ude5f\ude6d-\ude7f\udeb8-\udebf\udeca-\udeff\udf1a-\udf1c\udf2c-\udf2f\udf40-\udfff]|\ud806[\udc00-\udc9f\udcf3-\udcfe\udd00-\udebf\udef9-\udfff]|\ud807[\udc09\udc37\udc46-\udc4f\udc6d-\udc6f\udc90\udc91\udca8\udcb7-\udfff]|\ud808[\udf9a-\udfff]|\ud809[\udc6f\udc75-\udc7f\udd44-\udfff]|[\ud80a\ud80b\ud80e-\ud810\ud812-\ud819\ud823-\ud82b\ud82d\ud82e\ud830-\ud833\ud837\ud839\ud83f\ud874-\ud87d\ud87f-\udb3f\udb41-\udbff][\udc00-\udfff]|\ud80d[\udc2f-\udfff]|\ud811[\ude47-\udfff]|\ud81a[\ude39-\ude3f\ude5f\ude6a-\ude6d\ude70-\udecf\udeee\udeef\udef6-\udeff\udf46-\udf4f\udf5a\udf62\udf78-\udf7c\udf90-\udfff]|\ud81b[\udc00-\udeff\udf45-\udf4f\udf7f-\udf8e\udfa0-\udfdf\udfe1-\udfff]|\ud821[\udfed-\udfff]|\ud822[\udef3-\udfff]|\ud82c[\udc02-\udfff]|\ud82f[\udc6b-\udc6f\udc7d-\udc7f\udc89-\udc8f\udc9a\udc9b\udca0-\udfff]|\ud834[\udcf6-\udcff\udd27\udd28\udd73-\udd7a\udde9-\uddff\ude46-\udeff\udf57-\udf5f\udf72-\udfff]|\ud835[\udc55\udc9d\udca0\udca1\udca3\udca4\udca7\udca8\udcad\udcba\udcbc\udcc4\udd06\udd0b\udd0c\udd15\udd1d\udd3a\udd3f\udd45\udd47-\udd49\udd51\udea6\udea7\udfcc\udfcd]|\ud836[\ude8c-\ude9a\udea0\udeb0-\udfff]|\ud838[\udc07\udc19\udc1a\udc22\udc25\udc2b-\udfff]|\ud83a[\udcc5\udcc6\udcd7-\udcff\udd4b-\udd4f\udd5a-\udd5d\udd60-\udfff]|\ud83b[\udc00-\uddff\ude04\ude20\ude23\ude25\ude26\ude28\ude33\ude38\ude3a\ude3c-\ude41\ude43-\ude46\ude48\ude4a\ude4c\ude50\ude53\ude55\ude56\ude58\ude5a\ude5c\ude5e\ude60\ude63\ude65\ude66\ude6b\ude73\ude78\ude7d\ude7f\ude8a\ude9c-\udea0\udea4\udeaa\udebc-\udeef\udef2-\udfff]|\ud83c[\udc2c-\udc2f\udc94-\udc9f\udcaf\udcb0\udcc0\udcd0\udcf6-\udcff\udd0d-\udd0f\udd2f\udd6c-\udd6f\uddad-\udde5\ude03-\ude0f\ude3c-\ude3f\ude49-\ude4f\ude52-\udeff]|\ud83d[\uded3-\udedf\udeed-\udeef\udef7-\udeff\udf74-\udf7f\udfd5-\udfff]|\ud83e[\udc0c-\udc0f\udc48-\udc4f\udc5a-\udc5f\udc88-\udc8f\udcae-\udd0f\udd1f\udd28-\udd2f\udd31\udd32\udd3f\udd4c-\udd4f\udd5f-\udd7f\udd92-\uddbf\uddc1-\udfff]|\ud869[\uded7-\udeff]|\ud86d[\udf35-\udf3f]|\ud86e[\udc1e\udc1f]|\ud873[\udea2-\udfff]|\ud87e[\ude1e-\udfff]|\udb40[\udc00-\udcff\uddf0-\udfff]"},{name:"Cc",alias:"Control",bmp:"\0--"},{name:"Cf",alias:"Format",bmp:"­؀-؅؜۝܏࣢᠎​-‏‪-‮⁠-⁤⁦-⁯\ufeff￹-￻",astral:"𑂽|\ud82f[\udca0-\udca3]|\ud834[\udd73-\udd7a]|\udb40[\udc01\udc20-\udc7f]"},{name:"Cn",alias:"Unassigned",bmp:"͸͹΀-΃΋΍΢԰՗՘ՠֈ֋֌֐׈-׏׫-ׯ׵-׿؝܎݋݌޲-޿߻-߿࠮࠯࠿࡜࡝࡟-࢟ࢵࢾ-࣓঄঍঎঑঒঩঱঳-঵঺঻৅৆৉৊৏-৖৘-৛৞৤৥ৼ-਀਄਋-਎਑਒਩਱਴਷਺਻਽੃-੆੉੊੎-੐੒-੘੝੟-੥੶-઀઄઎઒઩઱઴઺઻૆૊૎૏૑-૟૤૥૲-૸ૺ-଀଄଍଎଑଒଩଱଴଺଻୅୆୉୊୎-୕୘-୛୞୤୥୸-஁஄஋-஍஑஖-஘஛஝஠-஢஥-஧஫-஭஺-஽௃-௅௉௎௏௑-௖௘-௥௻-௿ఄ఍఑఩఺-఼౅౉౎-౔౗౛-౟౤౥౰-౷಄಍಑಩಴಺಻೅೉೎-೔೗-ೝ೟೤೥೰ೳ-ഀഄ഍഑഻഼൅൉൐-൓൤൥඀ඁ඄඗-඙඲඼඾඿෇-෉෋-෎෕෗෠-෥෰෱෵-฀฻-฾๜-຀຃຅ຆຉ຋ຌຎ-ຓຘຠ຤຦ຨຩຬ຺຾຿໅໇໎໏໚໛໠-໿཈཭-཰྘྽࿍࿛-࿿჆჈-჌჎჏቉቎቏቗቙቞቟኉኎኏኱኶኷኿዁዆዇዗጑጖጗፛፜፽-፿᎚-᎟᏶᏷᏾᏿᚝-᚟᛹-᛿ᜍ᜕-ᜟ᜷-᜿᝔-᝟᝭᝱᝴-᝿៞៟៪-៯៺-៿᠏᠚-᠟ᡸ-᡿᢫-᢯᣶-᣿᤟᤬-᤯᤼-᤿᥁-᥃᥮᥯᥵-᥿᦬-᦯᧊-᧏᧛-᧝᨜᨝᩟᩽᩾᪊-᪏᪚-᪟᪮᪯ᪿ-᫿ᭌ-᭏᭽-᭿᯴-᯻᰸-᰺᱊-᱌Ᲊ-Ჿ᳈-᳏᳷ᳺ-᳿᷶-᷺἖἗἞἟὆὇὎὏὘὚὜὞὾὿᾵῅῔῕῜῰῱῵῿⁥⁲⁳₏₝-₟₿-⃏⃱-⃿↌-↏⏿␧-␿⑋-⑟⭴⭵⮖⮗⮺-⮼⯉⯒-⯫⯰-⯿Ⱟⱟ⳴-⳸⴦⴨-⴬⴮⴯⵨-⵮⵱-⵾⶗-⶟⶧⶯⶷⶿⷇⷏⷗⷟⹅-⹿⺚⻴-⻿⿖-⿯⿼-⿿぀゗゘㄀-㄄ㄮ-㄰㆏ㆻ-ㆿ㇤-㇯㈟㋿䶶-䶿鿖-鿿꒍-꒏꓇-꓏꘬-꘿꛸-꛿ꞯꞸ-ꟶ꠬-꠯꠺-꠿꡸-꡿꣆-꣍꣚-꣟ꣾꣿ꥔-꥞꥽-꥿꧎꧚-꧝꧿꨷-꨿꩎꩏꩚꩛꫃-꫚꫷-꬀꬇꬈꬏꬐꬗-꬟꬧꬯ꭦ-꭯꯮꯯꯺-꯿힤-힯퟇-퟊퟼-퟿﩮﩯﫚-﫿﬇-﬒﬘-﬜﬷﬽﬿﭂﭅﯂-﯒﵀-﵏﶐﶑﷈-﷯﷾﷿︚-︟﹓﹧﹬-﹯﹵﻽﻾＀﾿-￁￈￉￐￑￘￙￝-￟￧￯-￸￾￿",astral:"\ud800[\udc0c\udc27\udc3b\udc3e\udc4e\udc4f\udc5e-\udc7f\udcfb-\udcff\udd03-\udd06\udd34-\udd36\udd8f\udd9c-\udd9f\udda1-\uddcf\uddfe-\ude7f\ude9d-\ude9f\uded1-\udedf\udefc-\udeff\udf24-\udf2f\udf4b-\udf4f\udf7b-\udf7f\udf9e\udfc4-\udfc7\udfd6-\udfff]|\ud801[\udc9e\udc9f\udcaa-\udcaf\udcd4-\udcd7\udcfc-\udcff\udd28-\udd2f\udd64-\udd6e\udd70-\uddff\udf37-\udf3f\udf56-\udf5f\udf68-\udfff]|\ud802[\udc06\udc07\udc09\udc36\udc39-\udc3b\udc3d\udc3e\udc56\udc9f-\udca6\udcb0-\udcdf\udcf3\udcf6-\udcfa\udd1c-\udd1e\udd3a-\udd3e\udd40-\udd7f\uddb8-\uddbb\uddd0\uddd1\ude04\ude07-\ude0b\ude14\ude18\ude34-\ude37\ude3b-\ude3e\ude48-\ude4f\ude59-\ude5f\udea0-\udebf\udee7-\udeea\udef7-\udeff\udf36-\udf38\udf56\udf57\udf73-\udf77\udf92-\udf98\udf9d-\udfa8\udfb0-\udfff]|\ud803[\udc49-\udc7f\udcb3-\udcbf\udcf3-\udcf9\udd00-\ude5f\ude7f-\udfff]|\ud804[\udc4e-\udc51\udc70-\udc7e\udcc2-\udccf\udce9-\udcef\udcfa-\udcff\udd35\udd44-\udd4f\udd77-\udd7f\uddce\uddcf\udde0\uddf5-\uddff\ude12\ude3f-\ude7f\ude87\ude89\ude8e\ude9e\udeaa-\udeaf\udeeb-\udeef\udefa-\udeff\udf04\udf0d\udf0e\udf11\udf12\udf29\udf31\udf34\udf3a\udf3b\udf45\udf46\udf49\udf4a\udf4e\udf4f\udf51-\udf56\udf58-\udf5c\udf64\udf65\udf6d-\udf6f\udf75-\udfff]|\ud805[\udc5a\udc5c\udc5e-\udc7f\udcc8-\udccf\udcda-\udd7f\uddb6\uddb7\uddde-\uddff\ude45-\ude4f\ude5a-\ude5f\ude6d-\ude7f\udeb8-\udebf\udeca-\udeff\udf1a-\udf1c\udf2c-\udf2f\udf40-\udfff]|\ud806[\udc00-\udc9f\udcf3-\udcfe\udd00-\udebf\udef9-\udfff]|\ud807[\udc09\udc37\udc46-\udc4f\udc6d-\udc6f\udc90\udc91\udca8\udcb7-\udfff]|\ud808[\udf9a-\udfff]|\ud809[\udc6f\udc75-\udc7f\udd44-\udfff]|[\ud80a\ud80b\ud80e-\ud810\ud812-\ud819\ud823-\ud82b\ud82d\ud82e\ud830-\ud833\ud837\ud839\ud83f\ud874-\ud87d\ud87f-\udb3f\udb41-\udb7f][\udc00-\udfff]|\ud80d[\udc2f-\udfff]|\ud811[\ude47-\udfff]|\ud81a[\ude39-\ude3f\ude5f\ude6a-\ude6d\ude70-\udecf\udeee\udeef\udef6-\udeff\udf46-\udf4f\udf5a\udf62\udf78-\udf7c\udf90-\udfff]|\ud81b[\udc00-\udeff\udf45-\udf4f\udf7f-\udf8e\udfa0-\udfdf\udfe1-\udfff]|\ud821[\udfed-\udfff]|\ud822[\udef3-\udfff]|\ud82c[\udc02-\udfff]|\ud82f[\udc6b-\udc6f\udc7d-\udc7f\udc89-\udc8f\udc9a\udc9b\udca4-\udfff]|\ud834[\udcf6-\udcff\udd27\udd28\udde9-\uddff\ude46-\udeff\udf57-\udf5f\udf72-\udfff]|\ud835[\udc55\udc9d\udca0\udca1\udca3\udca4\udca7\udca8\udcad\udcba\udcbc\udcc4\udd06\udd0b\udd0c\udd15\udd1d\udd3a\udd3f\udd45\udd47-\udd49\udd51\udea6\udea7\udfcc\udfcd]|\ud836[\ude8c-\ude9a\udea0\udeb0-\udfff]|\ud838[\udc07\udc19\udc1a\udc22\udc25\udc2b-\udfff]|\ud83a[\udcc5\udcc6\udcd7-\udcff\udd4b-\udd4f\udd5a-\udd5d\udd60-\udfff]|\ud83b[\udc00-\uddff\ude04\ude20\ude23\ude25\ude26\ude28\ude33\ude38\ude3a\ude3c-\ude41\ude43-\ude46\ude48\ude4a\ude4c\ude50\ude53\ude55\ude56\ude58\ude5a\ude5c\ude5e\ude60\ude63\ude65\ude66\ude6b\ude73\ude78\ude7d\ude7f\ude8a\ude9c-\udea0\udea4\udeaa\udebc-\udeef\udef2-\udfff]|\ud83c[\udc2c-\udc2f\udc94-\udc9f\udcaf\udcb0\udcc0\udcd0\udcf6-\udcff\udd0d-\udd0f\udd2f\udd6c-\udd6f\uddad-\udde5\ude03-\ude0f\ude3c-\ude3f\ude49-\ude4f\ude52-\udeff]|\ud83d[\uded3-\udedf\udeed-\udeef\udef7-\udeff\udf74-\udf7f\udfd5-\udfff]|\ud83e[\udc0c-\udc0f\udc48-\udc4f\udc5a-\udc5f\udc88-\udc8f\udcae-\udd0f\udd1f\udd28-\udd2f\udd31\udd32\udd3f\udd4c-\udd4f\udd5f-\udd7f\udd92-\uddbf\uddc1-\udfff]|\ud869[\uded7-\udeff]|\ud86d[\udf35-\udf3f]|\ud86e[\udc1e\udc1f]|\ud873[\udea2-\udfff]|\ud87e[\ude1e-\udfff]|\udb40[\udc00\udc02-\udc1f\udc80-\udcff\uddf0-\udfff]|[\udbbf\udbff][\udffe\udfff]"},{name:"Co",alias:"Private_Use",bmp:"-",astral:"[\udb80-\udbbe\udbc0-\udbfe][\udc00-\udfff]|[\udbbf\udbff][\udc00-\udffd]"},{name:"Cs",alias:"Surrogate",bmp:"\ud800-\udfff"},{name:"L",alias:"Letter",bmp:"A-Za-zªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙա-ևא-תװ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࢠ-ࢴࢶ-ࢽऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೞೠೡೱೲഅ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄງຈຊຍດ-ທນ-ຟມ-ຣລວສຫອ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛱ-ᛸᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡷᢀ-ᢄᢇ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲈᳩ-ᳬᳮ-ᳱᳵᳶᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕℙ-ℝℤΩℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎↃↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ々〆〱-〵〻〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋ-ꞮꞰ-ꞷꟷ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭥꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ",astral:"\ud800[\udc00-\udc0b\udc0d-\udc26\udc28-\udc3a\udc3c\udc3d\udc3f-\udc4d\udc50-\udc5d\udc80-\udcfa\ude80-\ude9c\udea0-\uded0\udf00-\udf1f\udf30-\udf40\udf42-\udf49\udf50-\udf75\udf80-\udf9d\udfa0-\udfc3\udfc8-\udfcf]|\ud801[\udc00-\udc9d\udcb0-\udcd3\udcd8-\udcfb\udd00-\udd27\udd30-\udd63\ude00-\udf36\udf40-\udf55\udf60-\udf67]|\ud802[\udc00-\udc05\udc08\udc0a-\udc35\udc37\udc38\udc3c\udc3f-\udc55\udc60-\udc76\udc80-\udc9e\udce0-\udcf2\udcf4\udcf5\udd00-\udd15\udd20-\udd39\udd80-\uddb7\uddbe\uddbf\ude00\ude10-\ude13\ude15-\ude17\ude19-\ude33\ude60-\ude7c\ude80-\ude9c\udec0-\udec7\udec9-\udee4\udf00-\udf35\udf40-\udf55\udf60-\udf72\udf80-\udf91]|\ud803[\udc00-\udc48\udc80-\udcb2\udcc0-\udcf2]|\ud804[\udc03-\udc37\udc83-\udcaf\udcd0-\udce8\udd03-\udd26\udd50-\udd72\udd76\udd83-\uddb2\uddc1-\uddc4\uddda\udddc\ude00-\ude11\ude13-\ude2b\ude80-\ude86\ude88\ude8a-\ude8d\ude8f-\ude9d\ude9f-\udea8\udeb0-\udede\udf05-\udf0c\udf0f\udf10\udf13-\udf28\udf2a-\udf30\udf32\udf33\udf35-\udf39\udf3d\udf50\udf5d-\udf61]|\ud805[\udc00-\udc34\udc47-\udc4a\udc80-\udcaf\udcc4\udcc5\udcc7\udd80-\uddae\uddd8-\udddb\ude00-\ude2f\ude44\ude80-\udeaa\udf00-\udf19]|\ud806[\udca0-\udcdf\udcff\udec0-\udef8]|\ud807[\udc00-\udc08\udc0a-\udc2e\udc40\udc72-\udc8f]|\ud808[\udc00-\udf99]|\ud809[\udc80-\udd43]|[\ud80c\ud81c-\ud820\ud840-\ud868\ud86a-\ud86c\ud86f-\ud872][\udc00-\udfff]|\ud80d[\udc00-\udc2e]|\ud811[\udc00-\ude46]|\ud81a[\udc00-\ude38\ude40-\ude5e\uded0-\udeed\udf00-\udf2f\udf40-\udf43\udf63-\udf77\udf7d-\udf8f]|\ud81b[\udf00-\udf44\udf50\udf93-\udf9f\udfe0]|\ud821[\udc00-\udfec]|\ud822[\udc00-\udef2]|\ud82c[\udc00\udc01]|\ud82f[\udc00-\udc6a\udc70-\udc7c\udc80-\udc88\udc90-\udc99]|\ud835[\udc00-\udc54\udc56-\udc9c\udc9e\udc9f\udca2\udca5\udca6\udca9-\udcac\udcae-\udcb9\udcbb\udcbd-\udcc3\udcc5-\udd05\udd07-\udd0a\udd0d-\udd14\udd16-\udd1c\udd1e-\udd39\udd3b-\udd3e\udd40-\udd44\udd46\udd4a-\udd50\udd52-\udea5\udea8-\udec0\udec2-\udeda\udedc-\udefa\udefc-\udf14\udf16-\udf34\udf36-\udf4e\udf50-\udf6e\udf70-\udf88\udf8a-\udfa8\udfaa-\udfc2\udfc4-\udfcb]|\ud83a[\udc00-\udcc4\udd00-\udd43]|\ud83b[\ude00-\ude03\ude05-\ude1f\ude21\ude22\ude24\ude27\ude29-\ude32\ude34-\ude37\ude39\ude3b\ude42\ude47\ude49\ude4b\ude4d-\ude4f\ude51\ude52\ude54\ude57\ude59\ude5b\ude5d\ude5f\ude61\ude62\ude64\ude67-\ude6a\ude6c-\ude72\ude74-\ude77\ude79-\ude7c\ude7e\ude80-\ude89\ude8b-\ude9b\udea1-\udea3\udea5-\udea9\udeab-\udebb]|\ud869[\udc00-\uded6\udf00-\udfff]|\ud86d[\udc00-\udf34\udf40-\udfff]|\ud86e[\udc00-\udc1d\udc20-\udfff]|\ud873[\udc00-\udea1]|\ud87e[\udc00-\ude1d]"},{name:"Ll",alias:"Lowercase_Letter",bmp:"a-zµß-öø-ÿāăąćĉċčďđēĕėęěĝğġģĥħĩīĭįıĳĵķĸĺļľŀłńņňŉŋōŏőœŕŗřśŝşšţťŧũūŭůűųŵŷźżž-ƀƃƅƈƌƍƒƕƙ-ƛƞơƣƥƨƪƫƭưƴƶƹƺƽ-ƿǆǉǌǎǐǒǔǖǘǚǜǝǟǡǣǥǧǩǫǭǯǰǳǵǹǻǽǿȁȃȅȇȉȋȍȏȑȓȕȗșțȝȟȡȣȥȧȩȫȭȯȱȳ-ȹȼȿɀɂɇɉɋɍɏ-ʓʕ-ʯͱͳͷͻ-ͽΐά-ώϐϑϕ-ϗϙϛϝϟϡϣϥϧϩϫϭϯ-ϳϵϸϻϼа-џѡѣѥѧѩѫѭѯѱѳѵѷѹѻѽѿҁҋҍҏґғҕҗҙқҝҟҡңҥҧҩҫҭүұҳҵҷҹһҽҿӂӄӆӈӊӌӎӏӑӓӕӗәӛӝӟӡӣӥӧөӫӭӯӱӳӵӷӹӻӽӿԁԃԅԇԉԋԍԏԑԓԕԗԙԛԝԟԡԣԥԧԩԫԭԯա-ևᏸ-ᏽᲀ-ᲈᴀ-ᴫᵫ-ᵷᵹ-ᶚḁḃḅḇḉḋḍḏḑḓḕḗḙḛḝḟḡḣḥḧḩḫḭḯḱḳḵḷḹḻḽḿṁṃṅṇṉṋṍṏṑṓṕṗṙṛṝṟṡṣṥṧṩṫṭṯṱṳṵṷṹṻṽṿẁẃẅẇẉẋẍẏẑẓẕ-ẝẟạảấầẩẫậắằẳẵặẹẻẽếềểễệỉịọỏốồổỗộớờởỡợụủứừửữựỳỵỷỹỻỽỿ-ἇἐ-ἕἠ-ἧἰ-ἷὀ-ὅὐ-ὗὠ-ὧὰ-ώᾀ-ᾇᾐ-ᾗᾠ-ᾧᾰ-ᾴᾶᾷιῂ-ῄῆῇῐ-ΐῖῗῠ-ῧῲ-ῴῶῷℊℎℏℓℯℴℹℼℽⅆ-ⅉⅎↄⰰ-ⱞⱡⱥⱦⱨⱪⱬⱱⱳⱴⱶ-ⱻⲁⲃⲅⲇⲉⲋⲍⲏⲑⲓⲕⲗⲙⲛⲝⲟⲡⲣⲥⲧⲩⲫⲭⲯⲱⲳⲵⲷⲹⲻⲽⲿⳁⳃⳅⳇⳉⳋⳍⳏⳑⳓⳕⳗⳙⳛⳝⳟⳡⳣⳤⳬⳮⳳⴀ-ⴥⴧⴭꙁꙃꙅꙇꙉꙋꙍꙏꙑꙓꙕꙗꙙꙛꙝꙟꙡꙣꙥꙧꙩꙫꙭꚁꚃꚅꚇꚉꚋꚍꚏꚑꚓꚕꚗꚙꚛꜣꜥꜧꜩꜫꜭꜯ-ꜱꜳꜵꜷꜹꜻꜽꜿꝁꝃꝅꝇꝉꝋꝍꝏꝑꝓꝕꝗꝙꝛꝝꝟꝡꝣꝥꝧꝩꝫꝭꝯꝱ-ꝸꝺꝼꝿꞁꞃꞅꞇꞌꞎꞑꞓ-ꞕꞗꞙꞛꞝꞟꞡꞣꞥꞧꞩꞵꞷꟺꬰ-ꭚꭠ-ꭥꭰ-ꮿﬀ-ﬆﬓ-ﬗａ-ｚ",astral:"\ud801[\udc28-\udc4f\udcd8-\udcfb]|\ud803[\udcc0-\udcf2]|\ud806[\udcc0-\udcdf]|\ud835[\udc1a-\udc33\udc4e-\udc54\udc56-\udc67\udc82-\udc9b\udcb6-\udcb9\udcbb\udcbd-\udcc3\udcc5-\udccf\udcea-\udd03\udd1e-\udd37\udd52-\udd6b\udd86-\udd9f\uddba-\uddd3\uddee-\ude07\ude22-\ude3b\ude56-\ude6f\ude8a-\udea5\udec2-\udeda\udedc-\udee1\udefc-\udf14\udf16-\udf1b\udf36-\udf4e\udf50-\udf55\udf70-\udf88\udf8a-\udf8f\udfaa-\udfc2\udfc4-\udfc9\udfcb]|\ud83a[\udd22-\udd43]"},{name:"Lm",alias:"Modifier_Letter",bmp:"ʰ-ˁˆ-ˑˠ-ˤˬˮʹͺՙـۥۦߴߵߺࠚࠤࠨॱๆໆჼៗᡃᪧᱸ-ᱽᴬ-ᵪᵸᶛ-ᶿⁱⁿₐ-ₜⱼⱽⵯⸯ々〱-〵〻ゝゞー-ヾꀕꓸ-ꓽꘌꙿꚜꚝꜗ-ꜟꝰꞈꟸꟹꧏꧦꩰꫝꫳꫴꭜ-ꭟｰﾞﾟ",astral:"\ud81a[\udf40-\udf43]|\ud81b[\udf93-\udf9f\udfe0]"},{name:"Lo",alias:"Other_Letter",bmp:"ªºƻǀ-ǃʔא-תװ-ײؠ-ؿف-يٮٯٱ-ۓەۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪࠀ-ࠕࡀ-ࡘࢠ-ࢴࢶ-ࢽऄ-हऽॐक़-ॡॲ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೞೠೡೱೲഅ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๅກຂຄງຈຊຍດ-ທນ-ຟມ-ຣລວສຫອ-ະາຳຽເ-ໄໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎა-ჺჽ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛱ-ᛸᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៜᠠ-ᡂᡄ-ᡷᢀ-ᢄᢇ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱷᳩ-ᳬᳮ-ᳱᳵᳶℵ-ℸⴰ-ⵧⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ〆〼ぁ-ゖゟァ-ヺヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꀔꀖ-ꒌꓐ-ꓷꔀ-ꘋꘐ-ꘟꘪꘫꙮꚠ-ꛥꞏꟷꟻ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧠ-ꧤꧧ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩯꩱ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛꫜꫠ-ꫪꫲꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꯀ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎יִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼｦ-ｯｱ-ﾝﾠ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ",astral:"\ud800[\udc00-\udc0b\udc0d-\udc26\udc28-\udc3a\udc3c\udc3d\udc3f-\udc4d\udc50-\udc5d\udc80-\udcfa\ude80-\ude9c\udea0-\uded0\udf00-\udf1f\udf30-\udf40\udf42-\udf49\udf50-\udf75\udf80-\udf9d\udfa0-\udfc3\udfc8-\udfcf]|\ud801[\udc50-\udc9d\udd00-\udd27\udd30-\udd63\ude00-\udf36\udf40-\udf55\udf60-\udf67]|\ud802[\udc00-\udc05\udc08\udc0a-\udc35\udc37\udc38\udc3c\udc3f-\udc55\udc60-\udc76\udc80-\udc9e\udce0-\udcf2\udcf4\udcf5\udd00-\udd15\udd20-\udd39\udd80-\uddb7\uddbe\uddbf\ude00\ude10-\ude13\ude15-\ude17\ude19-\ude33\ude60-\ude7c\ude80-\ude9c\udec0-\udec7\udec9-\udee4\udf00-\udf35\udf40-\udf55\udf60-\udf72\udf80-\udf91]|\ud803[\udc00-\udc48]|\ud804[\udc03-\udc37\udc83-\udcaf\udcd0-\udce8\udd03-\udd26\udd50-\udd72\udd76\udd83-\uddb2\uddc1-\uddc4\uddda\udddc\ude00-\ude11\ude13-\ude2b\ude80-\ude86\ude88\ude8a-\ude8d\ude8f-\ude9d\ude9f-\udea8\udeb0-\udede\udf05-\udf0c\udf0f\udf10\udf13-\udf28\udf2a-\udf30\udf32\udf33\udf35-\udf39\udf3d\udf50\udf5d-\udf61]|\ud805[\udc00-\udc34\udc47-\udc4a\udc80-\udcaf\udcc4\udcc5\udcc7\udd80-\uddae\uddd8-\udddb\ude00-\ude2f\ude44\ude80-\udeaa\udf00-\udf19]|\ud806[\udcff\udec0-\udef8]|\ud807[\udc00-\udc08\udc0a-\udc2e\udc40\udc72-\udc8f]|\ud808[\udc00-\udf99]|\ud809[\udc80-\udd43]|[\ud80c\ud81c-\ud820\ud840-\ud868\ud86a-\ud86c\ud86f-\ud872][\udc00-\udfff]|\ud80d[\udc00-\udc2e]|\ud811[\udc00-\ude46]|\ud81a[\udc00-\ude38\ude40-\ude5e\uded0-\udeed\udf00-\udf2f\udf63-\udf77\udf7d-\udf8f]|\ud81b[\udf00-\udf44\udf50]|\ud821[\udc00-\udfec]|\ud822[\udc00-\udef2]|\ud82c[\udc00\udc01]|\ud82f[\udc00-\udc6a\udc70-\udc7c\udc80-\udc88\udc90-\udc99]|\ud83a[\udc00-\udcc4]|\ud83b[\ude00-\ude03\ude05-\ude1f\ude21\ude22\ude24\ude27\ude29-\ude32\ude34-\ude37\ude39\ude3b\ude42\ude47\ude49\ude4b\ude4d-\ude4f\ude51\ude52\ude54\ude57\ude59\ude5b\ude5d\ude5f\ude61\ude62\ude64\ude67-\ude6a\ude6c-\ude72\ude74-\ude77\ude79-\ude7c\ude7e\ude80-\ude89\ude8b-\ude9b\udea1-\udea3\udea5-\udea9\udeab-\udebb]|\ud869[\udc00-\uded6\udf00-\udfff]|\ud86d[\udc00-\udf34\udf40-\udfff]|\ud86e[\udc00-\udc1d\udc20-\udfff]|\ud873[\udc00-\udea1]|\ud87e[\udc00-\ude1d]"},{name:"Lt",alias:"Titlecase_Letter",bmp:"ǅǈǋǲᾈ-ᾏᾘ-ᾟᾨ-ᾯᾼῌῼ"},{name:"Lu",alias:"Uppercase_Letter",bmp:"A-ZÀ-ÖØ-ÞĀĂĄĆĈĊČĎĐĒĔĖĘĚĜĞĠĢĤĦĨĪĬĮİĲĴĶĹĻĽĿŁŃŅŇŊŌŎŐŒŔŖŘŚŜŞŠŢŤŦŨŪŬŮŰŲŴŶŸŹŻŽƁƂƄƆƇƉ-ƋƎ-ƑƓƔƖ-ƘƜƝƟƠƢƤƦƧƩƬƮƯƱ-ƳƵƷƸƼǄǇǊǍǏǑǓǕǗǙǛǞǠǢǤǦǨǪǬǮǱǴǶ-ǸǺǼǾȀȂȄȆȈȊȌȎȐȒȔȖȘȚȜȞȠȢȤȦȨȪȬȮȰȲȺȻȽȾɁɃ-ɆɈɊɌɎͰͲͶͿΆΈ-ΊΌΎΏΑ-ΡΣ-ΫϏϒ-ϔϘϚϜϞϠϢϤϦϨϪϬϮϴϷϹϺϽ-ЯѠѢѤѦѨѪѬѮѰѲѴѶѸѺѼѾҀҊҌҎҐҒҔҖҘҚҜҞҠҢҤҦҨҪҬҮҰҲҴҶҸҺҼҾӀӁӃӅӇӉӋӍӐӒӔӖӘӚӜӞӠӢӤӦӨӪӬӮӰӲӴӶӸӺӼӾԀԂԄԆԈԊԌԎԐԒԔԖԘԚԜԞԠԢԤԦԨԪԬԮԱ-ՖႠ-ჅჇჍᎠ-ᏵḀḂḄḆḈḊḌḎḐḒḔḖḘḚḜḞḠḢḤḦḨḪḬḮḰḲḴḶḸḺḼḾṀṂṄṆṈṊṌṎṐṒṔṖṘṚṜṞṠṢṤṦṨṪṬṮṰṲṴṶṸṺṼṾẀẂẄẆẈẊẌẎẐẒẔẞẠẢẤẦẨẪẬẮẰẲẴẶẸẺẼẾỀỂỄỆỈỊỌỎỐỒỔỖỘỚỜỞỠỢỤỦỨỪỬỮỰỲỴỶỸỺỼỾἈ-ἏἘ-ἝἨ-ἯἸ-ἿὈ-ὍὙὛὝὟὨ-ὯᾸ-ΆῈ-ΉῘ-ΊῨ-ῬῸ-Ώℂℇℋ-ℍℐ-ℒℕℙ-ℝℤΩℨK-ℭℰ-ℳℾℿⅅↃⰀ-ⰮⱠⱢ-ⱤⱧⱩⱫⱭ-ⱰⱲⱵⱾ-ⲀⲂⲄⲆⲈⲊⲌⲎⲐⲒⲔⲖⲘⲚⲜⲞⲠⲢⲤⲦⲨⲪⲬⲮⲰⲲⲴⲶⲸⲺⲼⲾⳀⳂⳄⳆⳈⳊⳌⳎⳐⳒⳔⳖⳘⳚⳜⳞⳠⳢⳫⳭⳲꙀꙂꙄꙆꙈꙊꙌꙎꙐꙒꙔꙖꙘꙚꙜꙞꙠꙢꙤꙦꙨꙪꙬꚀꚂꚄꚆꚈꚊꚌꚎꚐꚒꚔꚖꚘꚚꜢꜤꜦꜨꜪꜬꜮꜲꜴꜶꜸꜺꜼꜾꝀꝂꝄꝆꝈꝊꝌꝎꝐꝒꝔꝖꝘꝚꝜꝞꝠꝢꝤꝦꝨꝪꝬꝮꝹꝻꝽꝾꞀꞂꞄꞆꞋꞍꞐꞒꞖꞘꞚꞜꞞꞠꞢꞤꞦꞨꞪ-ꞮꞰ-ꞴꞶＡ-Ｚ",astral:"\ud801[\udc00-\udc27\udcb0-\udcd3]|\ud803[\udc80-\udcb2]|\ud806[\udca0-\udcbf]|\ud835[\udc00-\udc19\udc34-\udc4d\udc68-\udc81\udc9c\udc9e\udc9f\udca2\udca5\udca6\udca9-\udcac\udcae-\udcb5\udcd0-\udce9\udd04\udd05\udd07-\udd0a\udd0d-\udd14\udd16-\udd1c\udd38\udd39\udd3b-\udd3e\udd40-\udd44\udd46\udd4a-\udd50\udd6c-\udd85\udda0-\uddb9\uddd4-\udded\ude08-\ude21\ude3c-\ude55\ude70-\ude89\udea8-\udec0\udee2-\udefa\udf1c-\udf34\udf56-\udf6e\udf90-\udfa8\udfca]|\ud83a[\udd00-\udd21]"},{name:"M",alias:"Mark",bmp:"̀-ͯ҃-҉֑-ׇֽֿׁׂׅׄؐ-ًؚ-ٰٟۖ-ۜ۟-۪ۤۧۨ-ܑۭܰ-݊ަ-ް߫-߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛ࣔ-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣঁ-ঃ়া-ৄেৈো-্ৗৢৣਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑੰੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣଁ-ଃ଼ା-ୄେୈୋ-୍ୖୗୢୣஂா-ூெ-ைொ-்ௗఀ-ఃా-ౄె-ైొ-్ౕౖౢౣಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣഁ-ഃാ-ൄെ-ൈൊ-്ൗൢൣංඃ්ා-ුූෘ-ෟෲෳัิ-ฺ็-๎ັິ-ູົຼ່-ໍ༹༘༙༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏႚ-ႝ፝-፟ᜒ-᜔ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝᠋-᠍ᢅᢆᢩᤠ-ᤫᤰ-᤻ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼᪰-᪾ᬀ-ᬄ᬴-᭄᭫-᭳ᮀ-ᮂᮡ-ᮭ᯦-᯳ᰤ-᰷᳐-᳔᳒-᳨᳭ᳲ-᳴᳸᳹᷀-᷵᷻-᷿⃐-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯꙯-꙲ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧꢀꢁꢴ-ꣅ꣠-꣱ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀ꧥꨩ-ꨶꩃꩌꩍꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭ﬞ︀-️︠-︯",astral:"\ud800[\uddfd\udee0\udf76-\udf7a]|\ud802[\ude01-\ude03\ude05\ude06\ude0c-\ude0f\ude38-\ude3a\ude3f\udee5\udee6]|\ud804[\udc00-\udc02\udc38-\udc46\udc7f-\udc82\udcb0-\udcba\udd00-\udd02\udd27-\udd34\udd73\udd80-\udd82\uddb3-\uddc0\uddca-\uddcc\ude2c-\ude37\ude3e\udedf-\udeea\udf00-\udf03\udf3c\udf3e-\udf44\udf47\udf48\udf4b-\udf4d\udf57\udf62\udf63\udf66-\udf6c\udf70-\udf74]|\ud805[\udc35-\udc46\udcb0-\udcc3\uddaf-\uddb5\uddb8-\uddc0\udddc\udddd\ude30-\ude40\udeab-\udeb7\udf1d-\udf2b]|\ud807[\udc2f-\udc36\udc38-\udc3f\udc92-\udca7\udca9-\udcb6]|\ud81a[\udef0-\udef4\udf30-\udf36]|\ud81b[\udf51-\udf7e\udf8f-\udf92]|\ud82f[\udc9d\udc9e]|\ud834[\udd65-\udd69\udd6d-\udd72\udd7b-\udd82\udd85-\udd8b\uddaa-\uddad\ude42-\ude44]|\ud836[\ude00-\ude36\ude3b-\ude6c\ude75\ude84\ude9b-\ude9f\udea1-\udeaf]|\ud838[\udc00-\udc06\udc08-\udc18\udc1b-\udc21\udc23\udc24\udc26-\udc2a]|\ud83a[\udcd0-\udcd6\udd44-\udd4a]|\udb40[\udd00-\uddef]"},{name:"Mc",alias:"Spacing_Mark",bmp:"ःऻा-ीॉ-ौॎॏংঃা-ীেৈোৌৗਃਾ-ੀઃા-ીૉોૌଂଃାୀେୈୋୌୗாிுூெ-ைொ-ௌௗఁ-ఃు-ౄಂಃಾೀ-ೄೇೈೊೋೕೖംഃാ-ീെ-ൈൊ-ൌൗංඃා-ෑෘ-ෟෲෳ༾༿ཿါာေးျြၖၗၢ-ၤၧ-ၭႃႄႇ-ႌႏႚ-ႜាើ-ៅះៈᤣ-ᤦᤩ-ᤫᤰᤱᤳ-ᤸᨙᨚᩕᩗᩡᩣᩤᩭ-ᩲᬄᬵᬻᬽ-ᭁᭃ᭄ᮂᮡᮦᮧ᮪ᯧᯪ-ᯬᯮ᯲᯳ᰤ-ᰫᰴᰵ᳡ᳲᳳ〮〯ꠣꠤꠧꢀꢁꢴ-ꣃꥒ꥓ꦃꦴꦵꦺꦻꦽ-꧀ꨯꨰꨳꨴꩍꩻꩽꫫꫮꫯꫵꯣꯤꯦꯧꯩꯪ꯬",astral:"\ud804[\udc00\udc02\udc82\udcb0-\udcb2\udcb7\udcb8\udd2c\udd82\uddb3-\uddb5\uddbf\uddc0\ude2c-\ude2e\ude32\ude33\ude35\udee0-\udee2\udf02\udf03\udf3e\udf3f\udf41-\udf44\udf47\udf48\udf4b-\udf4d\udf57\udf62\udf63]|\ud805[\udc35-\udc37\udc40\udc41\udc45\udcb0-\udcb2\udcb9\udcbb-\udcbe\udcc1\uddaf-\uddb1\uddb8-\uddbb\uddbe\ude30-\ude32\ude3b\ude3c\ude3e\udeac\udeae\udeaf\udeb6\udf20\udf21\udf26]|\ud807[\udc2f\udc3e\udca9\udcb1\udcb4]|\ud81b[\udf51-\udf7e]|\ud834[\udd65\udd66\udd6d-\udd72]"},{name:"Me",alias:"Enclosing_Mark",bmp:"҈҉᪾⃝-⃠⃢-⃤꙰-꙲"},{name:"Mn",alias:"Nonspacing_Mark",bmp:"̀-ͯ҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-ٰٟۖ-ۜ۟-۪ۤۧۨ-ܑۭܰ-݊ަ-ް߫-߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛ࣔ-ࣣ࣡-ंऺ़ु-ै्॑-ॗॢॣঁ়ু-ৄ্ৢৣਁਂ਼ੁੂੇੈੋ-੍ੑੰੱੵઁં઼ુ-ૅેૈ્ૢૣଁ଼ିୁ-ୄ୍ୖୢୣஂீ்ఀా-ీె-ైొ-్ౕౖౢౣಁ಼ಿೆೌ್ೢೣഁു-ൄ്ൢൣ්ි-ුූัิ-ฺ็-๎ັິ-ູົຼ່-ໍཱ༹༘༙༵༷-ཾྀ-྄྆྇ྍ-ྗྙ-ྼ࿆ိ-ူဲ-့္်ွှၘၙၞ-ၠၱ-ၴႂႅႆႍႝ፝-፟ᜒ-᜔ᜲ-᜴ᝒᝓᝲᝳ឴឵ិ-ួំ៉-៓៝᠋-᠍ᢅᢆᢩᤠ-ᤢᤧᤨᤲ᤹-᤻ᨘᨗᨛᩖᩘ-ᩞ᩠ᩢᩥ-ᩬᩳ-᩿᩼᪰-᪽ᬀ-ᬃ᬴ᬶ-ᬺᬼᭂ᭫-᭳ᮀᮁᮢ-ᮥᮨᮩ᮫-ᮭ᯦ᯨᯩᯭᯯ-ᯱᰬ-ᰳᰶ᰷᳐-᳔᳒-᳢᳠-᳨᳭᳴᳸᳹᷀-᷵᷻-᷿⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〭꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠥꠦ꣄ꣅ꣠-꣱ꤦ-꤭ꥇ-ꥑꦀ-ꦂ꦳ꦶ-ꦹꦼꧥꨩ-ꨮꨱꨲꨵꨶꩃꩌꩼꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫬꫭ꫶ꯥꯨ꯭ﬞ︀-️︠-︯",astral:"\ud800[\uddfd\udee0\udf76-\udf7a]|\ud802[\ude01-\ude03\ude05\ude06\ude0c-\ude0f\ude38-\ude3a\ude3f\udee5\udee6]|\ud804[\udc01\udc38-\udc46\udc7f-\udc81\udcb3-\udcb6\udcb9\udcba\udd00-\udd02\udd27-\udd2b\udd2d-\udd34\udd73\udd80\udd81\uddb6-\uddbe\uddca-\uddcc\ude2f-\ude31\ude34\ude36\ude37\ude3e\udedf\udee3-\udeea\udf00\udf01\udf3c\udf40\udf66-\udf6c\udf70-\udf74]|\ud805[\udc38-\udc3f\udc42-\udc44\udc46\udcb3-\udcb8\udcba\udcbf\udcc0\udcc2\udcc3\uddb2-\uddb5\uddbc\uddbd\uddbf\uddc0\udddc\udddd\ude33-\ude3a\ude3d\ude3f\ude40\udeab\udead\udeb0-\udeb5\udeb7\udf1d-\udf1f\udf22-\udf25\udf27-\udf2b]|\ud807[\udc30-\udc36\udc38-\udc3d\udc3f\udc92-\udca7\udcaa-\udcb0\udcb2\udcb3\udcb5\udcb6]|\ud81a[\udef0-\udef4\udf30-\udf36]|\ud81b[\udf8f-\udf92]|\ud82f[\udc9d\udc9e]|\ud834[\udd67-\udd69\udd7b-\udd82\udd85-\udd8b\uddaa-\uddad\ude42-\ude44]|\ud836[\ude00-\ude36\ude3b-\ude6c\ude75\ude84\ude9b-\ude9f\udea1-\udeaf]|\ud838[\udc00-\udc06\udc08-\udc18\udc1b-\udc21\udc23\udc24\udc26-\udc2a]|\ud83a[\udcd0-\udcd6\udd44-\udd4a]|\udb40[\udd00-\uddef]"},{name:"N",alias:"Number",bmp:"0-9²³¹¼-¾٠-٩۰-۹߀-߉०-९০-৯৴-৹੦-੯૦-૯୦-୯୲-୷௦-௲౦-౯౸-౾೦-೯൘-൞൦-൸෦-෯๐-๙໐-໙༠-༳၀-၉႐-႙፩-፼ᛮ-ᛰ០-៩៰-៹᠐-᠙᥆-᥏᧐-᧚᪀-᪉᪐-᪙᭐-᭙᮰-᮹᱀-᱉᱐-᱙⁰⁴-⁹₀-₉⅐-ↂↅ-↉①-⒛⓪-⓿❶-➓⳽〇〡-〩〸-〺㆒-㆕㈠-㈩㉈-㉏㉑-㉟㊀-㊉㊱-㊿꘠-꘩ꛦ-ꛯ꠰-꠵꣐-꣙꤀-꤉꧐-꧙꧰-꧹꩐-꩙꯰-꯹０-９",astral:"\ud800[\udd07-\udd33\udd40-\udd78\udd8a\udd8b\udee1-\udefb\udf20-\udf23\udf41\udf4a\udfd1-\udfd5]|\ud801[\udca0-\udca9]|\ud802[\udc58-\udc5f\udc79-\udc7f\udca7-\udcaf\udcfb-\udcff\udd16-\udd1b\uddbc\uddbd\uddc0-\uddcf\uddd2-\uddff\ude40-\ude47\ude7d\ude7e\ude9d-\ude9f\udeeb-\udeef\udf58-\udf5f\udf78-\udf7f\udfa9-\udfaf]|\ud803[\udcfa-\udcff\ude60-\ude7e]|\ud804[\udc52-\udc6f\udcf0-\udcf9\udd36-\udd3f\uddd0-\uddd9\udde1-\uddf4\udef0-\udef9]|\ud805[\udc50-\udc59\udcd0-\udcd9\ude50-\ude59\udec0-\udec9\udf30-\udf3b]|\ud806[\udce0-\udcf2]|\ud807[\udc50-\udc6c]|\ud809[\udc00-\udc6e]|\ud81a[\ude60-\ude69\udf50-\udf59\udf5b-\udf61]|\ud834[\udf60-\udf71]|\ud835[\udfce-\udfff]|\ud83a[\udcc7-\udccf\udd50-\udd59]|\ud83c[\udd00-\udd0c]"},{name:"Nd",alias:"Decimal_Number",bmp:"0-9٠-٩۰-۹߀-߉०-९০-৯੦-੯૦-૯୦-୯௦-௯౦-౯೦-೯൦-൯෦-෯๐-๙໐-໙༠-༩၀-၉႐-႙០-៩᠐-᠙᥆-᥏᧐-᧙᪀-᪉᪐-᪙᭐-᭙᮰-᮹᱀-᱉᱐-᱙꘠-꘩꣐-꣙꤀-꤉꧐-꧙꧰-꧹꩐-꩙꯰-꯹０-９",astral:"\ud801[\udca0-\udca9]|\ud804[\udc66-\udc6f\udcf0-\udcf9\udd36-\udd3f\uddd0-\uddd9\udef0-\udef9]|\ud805[\udc50-\udc59\udcd0-\udcd9\ude50-\ude59\udec0-\udec9\udf30-\udf39]|\ud806[\udce0-\udce9]|\ud807[\udc50-\udc59]|\ud81a[\ude60-\ude69\udf50-\udf59]|\ud835[\udfce-\udfff]|\ud83a[\udd50-\udd59]"},{name:"Nl",alias:"Letter_Number",bmp:"ᛮ-ᛰⅠ-ↂↅ-ↈ〇〡-〩〸-〺ꛦ-ꛯ",astral:"\ud800[\udd40-\udd74\udf41\udf4a\udfd1-\udfd5]|\ud809[\udc00-\udc6e]"},{name:"No",alias:"Other_Number",bmp:"²³¹¼-¾৴-৹୲-୷௰-௲౸-౾൘-൞൰-൸༪-༳፩-፼៰-៹᧚⁰⁴-⁹₀-₉⅐-⅟↉①-⒛⓪-⓿❶-➓⳽㆒-㆕㈠-㈩㉈-㉏㉑-㉟㊀-㊉㊱-㊿꠰-꠵",astral:"\ud800[\udd07-\udd33\udd75-\udd78\udd8a\udd8b\udee1-\udefb\udf20-\udf23]|\ud802[\udc58-\udc5f\udc79-\udc7f\udca7-\udcaf\udcfb-\udcff\udd16-\udd1b\uddbc\uddbd\uddc0-\uddcf\uddd2-\uddff\ude40-\ude47\ude7d\ude7e\ude9d-\ude9f\udeeb-\udeef\udf58-\udf5f\udf78-\udf7f\udfa9-\udfaf]|\ud803[\udcfa-\udcff\ude60-\ude7e]|\ud804[\udc52-\udc65\udde1-\uddf4]|\ud805[\udf3a\udf3b]|\ud806[\udcea-\udcf2]|\ud807[\udc5a-\udc6c]|\ud81a[\udf5b-\udf61]|\ud834[\udf60-\udf71]|\ud83a[\udcc7-\udccf]|\ud83c[\udd00-\udd0c]"},{name:"P",alias:"Punctuation",bmp:"!-#%-\\x2A,-/:;\\x3F@\\x5B-\\x5D_\\x7B}¡§«¶·»¿;·՚-՟։֊־׀׃׆׳״؉؊،؍؛؞؟٪-٭۔܀-܍߷-߹࠰-࠾࡞।॥॰૰෴๏๚๛༄-༒༔༺-༽྅࿐-࿔࿙࿚၊-၏჻፠-፨᐀᙭᙮᚛᚜᛫-᛭᜵᜶។-៖៘-៚᠀-᠊᥄᥅᨞᨟᪠-᪦᪨-᪭᭚-᭠᯼-᯿᰻-᰿᱾᱿᳀-᳇᳓‐-‧‰-⁃⁅-⁑⁓-⁞⁽⁾₍₎⌈-⌋〈〉❨-❵⟅⟆⟦-⟯⦃-⦘⧘-⧛⧼⧽⳹-⳼⳾⳿⵰⸀-⸮⸰-⹄、-〃〈-】〔-〟〰〽゠・꓾꓿꘍-꘏꙳꙾꛲-꛷꡴-꡷꣎꣏꣸-꣺꣼꤮꤯꥟꧁-꧍꧞꧟꩜-꩟꫞꫟꫰꫱꯫﴾﴿︐-︙︰-﹒﹔-﹡﹣﹨﹪﹫！-＃％-＊，-／：；？＠［-］＿｛｝｟-･",astral:"\ud800[\udd00-\udd02\udf9f\udfd0]|𐕯|\ud802[\udc57\udd1f\udd3f\ude50-\ude58\ude7f\udef0-\udef6\udf39-\udf3f\udf99-\udf9c]|\ud804[\udc47-\udc4d\udcbb\udcbc\udcbe-\udcc1\udd40-\udd43\udd74\udd75\uddc5-\uddc9\uddcd\udddb\udddd-\udddf\ude38-\ude3d\udea9]|\ud805[\udc4b-\udc4f\udc5b\udc5d\udcc6\uddc1-\uddd7\ude41-\ude43\ude60-\ude6c\udf3c-\udf3e]|\ud807[\udc41-\udc45\udc70\udc71]|\ud809[\udc70-\udc74]|\ud81a[\ude6e\ude6f\udef5\udf37-\udf3b\udf44]|𛲟|\ud836[\ude87-\ude8b]|\ud83a[\udd5e\udd5f]"},{name:"Pc",alias:"Connector_Punctuation",bmp:"_‿⁀⁔︳︴﹍-﹏＿"},{name:"Pd",alias:"Dash_Punctuation",bmp:"\\x2D֊־᐀᠆‐-―⸗⸚⸺⸻⹀〜〰゠︱︲﹘﹣－"},{name:"Pe",alias:"Close_Punctuation",bmp:"\\x29\\x5D}༻༽᚜⁆⁾₎⌉⌋〉❩❫❭❯❱❳❵⟆⟧⟩⟫⟭⟯⦄⦆⦈⦊⦌⦎⦐⦒⦔⦖⦘⧙⧛⧽⸣⸥⸧⸩〉》」』】〕〗〙〛〞〟﴾︘︶︸︺︼︾﹀﹂﹄﹈﹚﹜﹞）］｝｠｣"},{name:"Pf",alias:"Final_Punctuation",bmp:"»’”›⸃⸅⸊⸍⸝⸡"},{name:"Pi",alias:"Initial_Punctuation",bmp:"«‘‛“‟‹⸂⸄⸉⸌⸜⸠"},{name:"Po",alias:"Other_Punctuation",bmp:"!-#%-'\\x2A,\\x2E/:;\\x3F@\\x5C¡§¶·¿;·՚-՟։׀׃׆׳״؉؊،؍؛؞؟٪-٭۔܀-܍߷-߹࠰-࠾࡞।॥॰૰෴๏๚๛༄-༒༔྅࿐-࿔࿙࿚၊-၏჻፠-፨᙭᙮᛫-᛭᜵᜶។-៖៘-៚᠀-᠅᠇-᠊᥄᥅᨞᨟᪠-᪦᪨-᪭᭚-᭠᯼-᯿᰻-᰿᱾᱿᳀-᳇᳓‖‗†-‧‰-‸※-‾⁁-⁃⁇-⁑⁓⁕-⁞⳹-⳼⳾⳿⵰⸀⸁⸆-⸈⸋⸎-⸖⸘⸙⸛⸞⸟⸪-⸮⸰-⸹⸼-⸿⹁⹃⹄、-〃〽・꓾꓿꘍-꘏꙳꙾꛲-꛷꡴-꡷꣎꣏꣸-꣺꣼꤮꤯꥟꧁-꧍꧞꧟꩜-꩟꫞꫟꫰꫱꯫︐-︖︙︰﹅﹆﹉-﹌﹐-﹒﹔-﹗﹟-﹡﹨﹪﹫！-＃％-＇＊，．／：；？＠＼｡､･",astral:"\ud800[\udd00-\udd02\udf9f\udfd0]|𐕯|\ud802[\udc57\udd1f\udd3f\ude50-\ude58\ude7f\udef0-\udef6\udf39-\udf3f\udf99-\udf9c]|\ud804[\udc47-\udc4d\udcbb\udcbc\udcbe-\udcc1\udd40-\udd43\udd74\udd75\uddc5-\uddc9\uddcd\udddb\udddd-\udddf\ude38-\ude3d\udea9]|\ud805[\udc4b-\udc4f\udc5b\udc5d\udcc6\uddc1-\uddd7\ude41-\ude43\ude60-\ude6c\udf3c-\udf3e]|\ud807[\udc41-\udc45\udc70\udc71]|\ud809[\udc70-\udc74]|\ud81a[\ude6e\ude6f\udef5\udf37-\udf3b\udf44]|𛲟|\ud836[\ude87-\ude8b]|\ud83a[\udd5e\udd5f]"},{name:"Ps",alias:"Open_Punctuation",bmp:"\\x28\\x5B\\x7B༺༼᚛‚„⁅⁽₍⌈⌊〈❨❪❬❮❰❲❴⟅⟦⟨⟪⟬⟮⦃⦅⦇⦉⦋⦍⦏⦑⦓⦕⦗⧘⧚⧼⸢⸤⸦⸨⹂〈《「『【〔〖〘〚〝﴿︗︵︷︹︻︽︿﹁﹃﹇﹙﹛﹝（［｛｟｢"},{name:"S",alias:"Symbol",bmp:"\\x24\\x2B<->\\x5E`\\x7C~¢-¦¨©¬®-±´¸×÷˂-˅˒-˟˥-˫˭˯-˿͵΄΅϶҂֍-֏؆-؈؋؎؏۞۩۽۾߶৲৳৺৻૱୰௳-௺౿൏൹฿༁-༃༓༕-༗༚-༟༴༶༸྾-࿅࿇-࿌࿎࿏࿕-࿘႞႟᎐-᎙៛᥀᧞-᧿᭡-᭪᭴-᭼᾽᾿-῁῍-῏῝-῟῭-`´῾⁄⁒⁺-⁼₊-₌₠-₾℀℁℃-℆℈℉℔№-℘℞-℣℥℧℩℮℺℻⅀-⅄⅊-⅍⅏↊↋←-⌇⌌-⌨⌫-⏾␀-␦⑀-⑊⒜-ⓩ─-❧➔-⟄⟇-⟥⟰-⦂⦙-⧗⧜-⧻⧾-⭳⭶-⮕⮘-⮹⮽-⯈⯊-⯑⯬-⯯⳥-⳪⺀-⺙⺛-⻳⼀-⿕⿰-⿻〄〒〓〠〶〷〾〿゛゜㆐㆑㆖-㆟㇀-㇣㈀-㈞㈪-㉇㉐㉠-㉿㊊-㊰㋀-㋾㌀-㏿䷀-䷿꒐-꓆꜀-꜖꜠꜡꞉꞊꠨-꠫꠶-꠹꩷-꩹꭛﬩﮲-﯁﷼﷽﹢﹤-﹦﹩＄＋＜-＞＾｀｜～￠-￦￨-￮￼�",astral:"\ud800[\udd37-\udd3f\udd79-\udd89\udd8c-\udd8e\udd90-\udd9b\udda0\uddd0-\uddfc]|\ud802[\udc77\udc78\udec8]|𑜿|\ud81a[\udf3c-\udf3f\udf45]|𛲜|\ud834[\udc00-\udcf5\udd00-\udd26\udd29-\udd64\udd6a-\udd6c\udd83\udd84\udd8c-\udda9\uddae-\udde8\ude00-\ude41\ude45\udf00-\udf56]|\ud835[\udec1\udedb\udefb\udf15\udf35\udf4f\udf6f\udf89\udfa9\udfc3]|\ud836[\udc00-\uddff\ude37-\ude3a\ude6d-\ude74\ude76-\ude83\ude85\ude86]|\ud83b[\udef0\udef1]|\ud83c[\udc00-\udc2b\udc30-\udc93\udca0-\udcae\udcb1-\udcbf\udcc1-\udccf\udcd1-\udcf5\udd10-\udd2e\udd30-\udd6b\udd70-\uddac\udde6-\ude02\ude10-\ude3b\ude40-\ude48\ude50\ude51\udf00-\udfff]|\ud83d[\udc00-\uded2\udee0-\udeec\udef0-\udef6\udf00-\udf73\udf80-\udfd4]|\ud83e[\udc00-\udc0b\udc10-\udc47\udc50-\udc59\udc60-\udc87\udc90-\udcad\udd10-\udd1e\udd20-\udd27\udd30\udd33-\udd3e\udd40-\udd4b\udd50-\udd5e\udd80-\udd91\uddc0]"},{name:"Sc",alias:"Currency_Symbol",bmp:"\\x24¢-¥֏؋৲৳৻૱௹฿៛₠-₾꠸﷼﹩＄￠￡￥￦"},{name:"Sk",alias:"Modifier_Symbol",bmp:"\\x5E`¨¯´¸˂-˅˒-˟˥-˫˭˯-˿͵΄΅᾽᾿-῁῍-῏῝-῟῭-`´῾゛゜꜀-꜖꜠꜡꞉꞊꭛﮲-﯁＾｀￣",astral:"\ud83c[\udffb-\udfff]"},{name:"Sm",alias:"Math_Symbol",bmp:"\\x2B<->\\x7C~¬±×÷϶؆-؈⁄⁒⁺-⁼₊-₌℘⅀-⅄⅋←-↔↚↛↠↣↦↮⇎⇏⇒⇔⇴-⋿⌠⌡⍼⎛-⎳⏜-⏡▷◁◸-◿♯⟀-⟄⟇-⟥⟰-⟿⤀-⦂⦙-⧗⧜-⧻⧾-⫿⬰-⭄⭇-⭌﬩﹢﹤-﹦＋＜-＞｜～￢￩-￬",astral:"\ud835[\udec1\udedb\udefb\udf15\udf35\udf4f\udf6f\udf89\udfa9\udfc3]|\ud83b[\udef0\udef1]"},{name:"So",alias:"Other_Symbol",bmp:"¦©®°҂֍֎؎؏۞۩۽۾߶৺୰௳-௸௺౿൏൹༁-༃༓༕-༗༚-༟༴༶༸྾-࿅࿇-࿌࿎࿏࿕-࿘႞႟᎐-᎙᥀᧞-᧿᭡-᭪᭴-᭼℀℁℃-℆℈℉℔№℗℞-℣℥℧℩℮℺℻⅊⅌⅍⅏↊↋↕-↙↜-↟↡↢↤↥↧-↭↯-⇍⇐⇑⇓⇕-⇳⌀-⌇⌌-⌟⌢-⌨⌫-⍻⍽-⎚⎴-⏛⏢-⏾␀-␦⑀-⑊⒜-ⓩ─-▶▸-◀◂-◷☀-♮♰-❧➔-➿⠀-⣿⬀-⬯⭅⭆⭍-⭳⭶-⮕⮘-⮹⮽-⯈⯊-⯑⯬-⯯⳥-⳪⺀-⺙⺛-⻳⼀-⿕⿰-⿻〄〒〓〠〶〷〾〿㆐㆑㆖-㆟㇀-㇣㈀-㈞㈪-㉇㉐㉠-㉿㊊-㊰㋀-㋾㌀-㏿䷀-䷿꒐-꓆꠨-꠫꠶꠷꠹꩷-꩹﷽￤￨￭￮￼�",astral:"\ud800[\udd37-\udd3f\udd79-\udd89\udd8c-\udd8e\udd90-\udd9b\udda0\uddd0-\uddfc]|\ud802[\udc77\udc78\udec8]|𑜿|\ud81a[\udf3c-\udf3f\udf45]|𛲜|\ud834[\udc00-\udcf5\udd00-\udd26\udd29-\udd64\udd6a-\udd6c\udd83\udd84\udd8c-\udda9\uddae-\udde8\ude00-\ude41\ude45\udf00-\udf56]|\ud836[\udc00-\uddff\ude37-\ude3a\ude6d-\ude74\ude76-\ude83\ude85\ude86]|\ud83c[\udc00-\udc2b\udc30-\udc93\udca0-\udcae\udcb1-\udcbf\udcc1-\udccf\udcd1-\udcf5\udd10-\udd2e\udd30-\udd6b\udd70-\uddac\udde6-\ude02\ude10-\ude3b\ude40-\ude48\ude50\ude51\udf00-\udffa]|\ud83d[\udc00-\uded2\udee0-\udeec\udef0-\udef6\udf00-\udf73\udf80-\udfd4]|\ud83e[\udc00-\udc0b\udc10-\udc47\udc50-\udc59\udc60-\udc87\udc90-\udcad\udd10-\udd1e\udd20-\udd27\udd30\udd33-\udd3e\udd40-\udd4b\udd50-\udd5e\udd80-\udd91\uddc0]"},{name:"Z",alias:"Separator",bmp:"    - \u2028\u2029  　"},{name:"Zl",alias:"Line_Separator",bmp:"\u2028"},{name:"Zp",alias:"Paragraph_Separator",bmp:"\u2029"},{name:"Zs",alias:"Space_Separator",bmp:"    -   　"}])}},{}],6:[function(e,d,u){d.exports=function(e){"use strict";if(!e.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Properties");var d=[{name:"ASCII",bmp:"\0-"},{name:"Alphabetic",bmp:"A-Za-zªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͅͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙա-ևְ-ׇֽֿׁׂׅׄא-תװ-ײؐ-ؚؠ-ٗٙ-ٟٮ-ۓە-ۜۡ-ۭۨ-ۯۺ-ۼۿܐ-ܿݍ-ޱߊ-ߪߴߵߺࠀ-ࠗࠚ-ࠬࡀ-ࡘࢠ-ࢴࢶ-ࢽࣔ-ࣣࣟ-ࣰࣩ-ऻऽ-ौॎ-ॐॕ-ॣॱ-ঃঅ-ঌএঐও-নপ-রলশ-হঽ-ৄেৈোৌৎৗড়ঢ়য়-ৣৰৱਁ-ਃਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਾ-ੂੇੈੋੌੑਖ਼-ੜਫ਼ੰ-ੵઁ-ઃઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽ-ૅે-ૉોૌૐૠ-ૣૹଁ-ଃଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽ-ୄେୈୋୌୖୗଡ଼ଢ଼ୟ-ୣୱஂஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹா-ூெ-ைொ-ௌௐௗఀ-ఃఅ-ఌఎ-ఐఒ-నప-హఽ-ౄె-ైొ-ౌౕౖౘ-ౚౠ-ౣಀ-ಃಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽ-ೄೆ-ೈೊ-ೌೕೖೞೠ-ೣೱೲഁ-ഃഅ-ഌഎ-ഐഒ-ഺഽ-ൄെ-ൈൊ-ൌൎൔ-ൗൟ-ൣൺ-ൿංඃඅ-ඖක-නඳ-රලව-ෆා-ුූෘ-ෟෲෳก-ฺเ-ๆํກຂຄງຈຊຍດ-ທນ-ຟມ-ຣລວສຫອ-ູົ-ຽເ-ໄໆໍໜ-ໟༀཀ-ཇཉ-ཬཱ-ཱྀྈ-ྗྙ-ྼက-ံးျ-ဿၐ-ၢၥ-ၨၮ-ႆႎႜႝႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚ፟ᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜌᜎ-ᜓᜠ-ᜳᝀ-ᝓᝠ-ᝬᝮ-ᝰᝲᝳក-ឳា-ៈៗៜᠠ-ᡷᢀ-ᢪᢰ-ᣵᤀ-ᤞᤠ-ᤫᤰ-ᤸᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨛᨠ-ᩞᩡ-ᩴᪧᬀ-ᬳᬵ-ᭃᭅ-ᭋᮀ-ᮩᮬ-ᮯᮺ-ᯥᯧ-ᯱᰀ-ᰵᱍ-ᱏᱚ-ᱽᲀ-ᲈᳩ-ᳬᳮ-ᳳᳵᳶᴀ-ᶿᷧ-ᷴḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕℙ-ℝℤΩℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⒶ-ⓩⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⷠ-ⷿⸯ々-〇〡-〩〱-〵〸-〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿕ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙴ-ꙻꙿ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꞮꞰ-ꞷꟷ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠧꡀ-ꡳꢀ-ꣃꣅꣲ-ꣷꣻꣽꤊ-ꤪꤰ-ꥒꥠ-ꥼꦀ-ꦲꦴ-ꦿꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨶꩀ-ꩍꩠ-ꩶꩺꩾ-ꪾꫀꫂꫛ-ꫝꫠ-ꫯꫲ-ꫵꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭥꭰ-ꯪ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ",astral:"\ud800[\udc00-\udc0b\udc0d-\udc26\udc28-\udc3a\udc3c\udc3d\udc3f-\udc4d\udc50-\udc5d\udc80-\udcfa\udd40-\udd74\ude80-\ude9c\udea0-\uded0\udf00-\udf1f\udf30-\udf4a\udf50-\udf7a\udf80-\udf9d\udfa0-\udfc3\udfc8-\udfcf\udfd1-\udfd5]|\ud801[\udc00-\udc9d\udcb0-\udcd3\udcd8-\udcfb\udd00-\udd27\udd30-\udd63\ude00-\udf36\udf40-\udf55\udf60-\udf67]|\ud802[\udc00-\udc05\udc08\udc0a-\udc35\udc37\udc38\udc3c\udc3f-\udc55\udc60-\udc76\udc80-\udc9e\udce0-\udcf2\udcf4\udcf5\udd00-\udd15\udd20-\udd39\udd80-\uddb7\uddbe\uddbf\ude00-\ude03\ude05\ude06\ude0c-\ude13\ude15-\ude17\ude19-\ude33\ude60-\ude7c\ude80-\ude9c\udec0-\udec7\udec9-\udee4\udf00-\udf35\udf40-\udf55\udf60-\udf72\udf80-\udf91]|\ud803[\udc00-\udc48\udc80-\udcb2\udcc0-\udcf2]|\ud804[\udc00-\udc45\udc82-\udcb8\udcd0-\udce8\udd00-\udd32\udd50-\udd72\udd76\udd80-\uddbf\uddc1-\uddc4\uddda\udddc\ude00-\ude11\ude13-\ude34\ude37\ude3e\ude80-\ude86\ude88\ude8a-\ude8d\ude8f-\ude9d\ude9f-\udea8\udeb0-\udee8\udf00-\udf03\udf05-\udf0c\udf0f\udf10\udf13-\udf28\udf2a-\udf30\udf32\udf33\udf35-\udf39\udf3d-\udf44\udf47\udf48\udf4b\udf4c\udf50\udf57\udf5d-\udf63]|\ud805[\udc00-\udc41\udc43-\udc45\udc47-\udc4a\udc80-\udcc1\udcc4\udcc5\udcc7\udd80-\uddb5\uddb8-\uddbe\uddd8-\udddd\ude00-\ude3e\ude40\ude44\ude80-\udeb5\udf00-\udf19\udf1d-\udf2a]|\ud806[\udca0-\udcdf\udcff\udec0-\udef8]|\ud807[\udc00-\udc08\udc0a-\udc36\udc38-\udc3e\udc40\udc72-\udc8f\udc92-\udca7\udca9-\udcb6]|\ud808[\udc00-\udf99]|\ud809[\udc00-\udc6e\udc80-\udd43]|[\ud80c\ud81c-\ud820\ud840-\ud868\ud86a-\ud86c\ud86f-\ud872][\udc00-\udfff]|\ud80d[\udc00-\udc2e]|\ud811[\udc00-\ude46]|\ud81a[\udc00-\ude38\ude40-\ude5e\uded0-\udeed\udf00-\udf36\udf40-\udf43\udf63-\udf77\udf7d-\udf8f]|\ud81b[\udf00-\udf44\udf50-\udf7e\udf93-\udf9f\udfe0]|\ud821[\udc00-\udfec]|\ud822[\udc00-\udef2]|\ud82c[\udc00\udc01]|\ud82f[\udc00-\udc6a\udc70-\udc7c\udc80-\udc88\udc90-\udc99\udc9e]|\ud835[\udc00-\udc54\udc56-\udc9c\udc9e\udc9f\udca2\udca5\udca6\udca9-\udcac\udcae-\udcb9\udcbb\udcbd-\udcc3\udcc5-\udd05\udd07-\udd0a\udd0d-\udd14\udd16-\udd1c\udd1e-\udd39\udd3b-\udd3e\udd40-\udd44\udd46\udd4a-\udd50\udd52-\udea5\udea8-\udec0\udec2-\udeda\udedc-\udefa\udefc-\udf14\udf16-\udf34\udf36-\udf4e\udf50-\udf6e\udf70-\udf88\udf8a-\udfa8\udfaa-\udfc2\udfc4-\udfcb]|\ud838[\udc00-\udc06\udc08-\udc18\udc1b-\udc21\udc23\udc24\udc26-\udc2a]|\ud83a[\udc00-\udcc4\udd00-\udd43\udd47]|\ud83b[\ude00-\ude03\ude05-\ude1f\ude21\ude22\ude24\ude27\ude29-\ude32\ude34-\ude37\ude39\ude3b\ude42\ude47\ude49\ude4b\ude4d-\ude4f\ude51\ude52\ude54\ude57\ude59\ude5b\ude5d\ude5f\ude61\ude62\ude64\ude67-\ude6a\ude6c-\ude72\ude74-\ude77\ude79-\ude7c\ude7e\ude80-\ude89\ude8b-\ude9b\udea1-\udea3\udea5-\udea9\udeab-\udebb]|\ud83c[\udd30-\udd49\udd50-\udd69\udd70-\udd89]|\ud869[\udc00-\uded6\udf00-\udfff]|\ud86d[\udc00-\udf34\udf40-\udfff]|\ud86e[\udc00-\udc1d\udc20-\udfff]|\ud873[\udc00-\udea1]|\ud87e[\udc00-\ude1d]"},{name:"Any",isBmpLast:!0,bmp:"\0-￿",astral:"[\ud800-\udbff][\udc00-\udfff]"},{name:"Default_Ignorable_Code_Point",bmp:"­͏؜ᅟᅠ឴឵᠋-᠎​-‏‪-‮⁠-⁯ㅤ︀-️\ufeffﾠ￰-￸",astral:"\ud82f[\udca0-\udca3]|\ud834[\udd73-\udd7a]|[\udb40-\udb43][\udc00-\udfff]"},{name:"Lowercase",bmp:"a-zªµºß-öø-ÿāăąćĉċčďđēĕėęěĝğġģĥħĩīĭįıĳĵķĸĺļľŀłńņňŉŋōŏőœŕŗřśŝşšţťŧũūŭůűųŵŷźżž-ƀƃƅƈƌƍƒƕƙ-ƛƞơƣƥƨƪƫƭưƴƶƹƺƽ-ƿǆǉǌǎǐǒǔǖǘǚǜǝǟǡǣǥǧǩǫǭǯǰǳǵǹǻǽǿȁȃȅȇȉȋȍȏȑȓȕȗșțȝȟȡȣȥȧȩȫȭȯȱȳ-ȹȼȿɀɂɇɉɋɍɏ-ʓʕ-ʸˀˁˠ-ˤͅͱͳͷͺ-ͽΐά-ώϐϑϕ-ϗϙϛϝϟϡϣϥϧϩϫϭϯ-ϳϵϸϻϼа-џѡѣѥѧѩѫѭѯѱѳѵѷѹѻѽѿҁҋҍҏґғҕҗҙқҝҟҡңҥҧҩҫҭүұҳҵҷҹһҽҿӂӄӆӈӊӌӎӏӑӓӕӗәӛӝӟӡӣӥӧөӫӭӯӱӳӵӷӹӻӽӿԁԃԅԇԉԋԍԏԑԓԕԗԙԛԝԟԡԣԥԧԩԫԭԯա-ևᏸ-ᏽᲀ-ᲈᴀ-ᶿḁḃḅḇḉḋḍḏḑḓḕḗḙḛḝḟḡḣḥḧḩḫḭḯḱḳḵḷḹḻḽḿṁṃṅṇṉṋṍṏṑṓṕṗṙṛṝṟṡṣṥṧṩṫṭṯṱṳṵṷṹṻṽṿẁẃẅẇẉẋẍẏẑẓẕ-ẝẟạảấầẩẫậắằẳẵặẹẻẽếềểễệỉịọỏốồổỗộớờởỡợụủứừửữựỳỵỷỹỻỽỿ-ἇἐ-ἕἠ-ἧἰ-ἷὀ-ὅὐ-ὗὠ-ὧὰ-ώᾀ-ᾇᾐ-ᾗᾠ-ᾧᾰ-ᾴᾶᾷιῂ-ῄῆῇῐ-ΐῖῗῠ-ῧῲ-ῴῶῷⁱⁿₐ-ₜℊℎℏℓℯℴℹℼℽⅆ-ⅉⅎⅰ-ⅿↄⓐ-ⓩⰰ-ⱞⱡⱥⱦⱨⱪⱬⱱⱳⱴⱶ-ⱽⲁⲃⲅⲇⲉⲋⲍⲏⲑⲓⲕⲗⲙⲛⲝⲟⲡⲣⲥⲧⲩⲫⲭⲯⲱⲳⲵⲷⲹⲻⲽⲿⳁⳃⳅⳇⳉⳋⳍⳏⳑⳓⳕⳗⳙⳛⳝⳟⳡⳣⳤⳬⳮⳳⴀ-ⴥⴧⴭꙁꙃꙅꙇꙉꙋꙍꙏꙑꙓꙕꙗꙙꙛꙝꙟꙡꙣꙥꙧꙩꙫꙭꚁꚃꚅꚇꚉꚋꚍꚏꚑꚓꚕꚗꚙꚛ-ꚝꜣꜥꜧꜩꜫꜭꜯ-ꜱꜳꜵꜷꜹꜻꜽꜿꝁꝃꝅꝇꝉꝋꝍꝏꝑꝓꝕꝗꝙꝛꝝꝟꝡꝣꝥꝧꝩꝫꝭꝯ-ꝸꝺꝼꝿꞁꞃꞅꞇꞌꞎꞑꞓ-ꞕꞗꞙꞛꞝꞟꞡꞣꞥꞧꞩꞵꞷꟸ-ꟺꬰ-ꭚꭜ-ꭥꭰ-ꮿﬀ-ﬆﬓ-ﬗａ-ｚ",astral:"\ud801[\udc28-\udc4f\udcd8-\udcfb]|\ud803[\udcc0-\udcf2]|\ud806[\udcc0-\udcdf]|\ud835[\udc1a-\udc33\udc4e-\udc54\udc56-\udc67\udc82-\udc9b\udcb6-\udcb9\udcbb\udcbd-\udcc3\udcc5-\udccf\udcea-\udd03\udd1e-\udd37\udd52-\udd6b\udd86-\udd9f\uddba-\uddd3\uddee-\ude07\ude22-\ude3b\ude56-\ude6f\ude8a-\udea5\udec2-\udeda\udedc-\udee1\udefc-\udf14\udf16-\udf1b\udf36-\udf4e\udf50-\udf55\udf70-\udf88\udf8a-\udf8f\udfaa-\udfc2\udfc4-\udfc9\udfcb]|\ud83a[\udd22-\udd43]"},{name:"Noncharacter_Code_Point",bmp:"﷐-﷯￾￿",astral:"[\ud83f\ud87f\ud8bf\ud8ff\ud93f\ud97f\ud9bf\ud9ff\uda3f\uda7f\udabf\udaff\udb3f\udb7f\udbbf\udbff][\udffe\udfff]"},{name:"Uppercase",bmp:"A-ZÀ-ÖØ-ÞĀĂĄĆĈĊČĎĐĒĔĖĘĚĜĞĠĢĤĦĨĪĬĮİĲĴĶĹĻĽĿŁŃŅŇŊŌŎŐŒŔŖŘŚŜŞŠŢŤŦŨŪŬŮŰŲŴŶŸŹŻŽƁƂƄƆƇƉ-ƋƎ-ƑƓƔƖ-ƘƜƝƟƠƢƤƦƧƩƬƮƯƱ-ƳƵƷƸƼǄǇǊǍǏǑǓǕǗǙǛǞǠǢǤǦǨǪǬǮǱǴǶ-ǸǺǼǾȀȂȄȆȈȊȌȎȐȒȔȖȘȚȜȞȠȢȤȦȨȪȬȮȰȲȺȻȽȾɁɃ-ɆɈɊɌɎͰͲͶͿΆΈ-ΊΌΎΏΑ-ΡΣ-ΫϏϒ-ϔϘϚϜϞϠϢϤϦϨϪϬϮϴϷϹϺϽ-ЯѠѢѤѦѨѪѬѮѰѲѴѶѸѺѼѾҀҊҌҎҐҒҔҖҘҚҜҞҠҢҤҦҨҪҬҮҰҲҴҶҸҺҼҾӀӁӃӅӇӉӋӍӐӒӔӖӘӚӜӞӠӢӤӦӨӪӬӮӰӲӴӶӸӺӼӾԀԂԄԆԈԊԌԎԐԒԔԖԘԚԜԞԠԢԤԦԨԪԬԮԱ-ՖႠ-ჅჇჍᎠ-ᏵḀḂḄḆḈḊḌḎḐḒḔḖḘḚḜḞḠḢḤḦḨḪḬḮḰḲḴḶḸḺḼḾṀṂṄṆṈṊṌṎṐṒṔṖṘṚṜṞṠṢṤṦṨṪṬṮṰṲṴṶṸṺṼṾẀẂẄẆẈẊẌẎẐẒẔẞẠẢẤẦẨẪẬẮẰẲẴẶẸẺẼẾỀỂỄỆỈỊỌỎỐỒỔỖỘỚỜỞỠỢỤỦỨỪỬỮỰỲỴỶỸỺỼỾἈ-ἏἘ-ἝἨ-ἯἸ-ἿὈ-ὍὙὛὝὟὨ-ὯᾸ-ΆῈ-ΉῘ-ΊῨ-ῬῸ-Ώℂℇℋ-ℍℐ-ℒℕℙ-ℝℤΩℨK-ℭℰ-ℳℾℿⅅⅠ-ⅯↃⒶ-ⓏⰀ-ⰮⱠⱢ-ⱤⱧⱩⱫⱭ-ⱰⱲⱵⱾ-ⲀⲂⲄⲆⲈⲊⲌⲎⲐⲒⲔⲖⲘⲚⲜⲞⲠⲢⲤⲦⲨⲪⲬⲮⲰⲲⲴⲶⲸⲺⲼⲾⳀⳂⳄⳆⳈⳊⳌⳎⳐⳒⳔⳖⳘⳚⳜⳞⳠⳢⳫⳭⳲꙀꙂꙄꙆꙈꙊꙌꙎꙐꙒꙔꙖꙘꙚꙜꙞꙠꙢꙤꙦꙨꙪꙬꚀꚂꚄꚆꚈꚊꚌꚎꚐꚒꚔꚖꚘꚚꜢꜤꜦꜨꜪꜬꜮꜲꜴꜶꜸꜺꜼꜾꝀꝂꝄꝆꝈꝊꝌꝎꝐꝒꝔꝖꝘꝚꝜꝞꝠꝢꝤꝦꝨꝪꝬꝮꝹꝻꝽꝾꞀꞂꞄꞆꞋꞍꞐꞒꞖꞘꞚꞜꞞꞠꞢꞤꞦꞨꞪ-ꞮꞰ-ꞴꞶＡ-Ｚ",astral:"\ud801[\udc00-\udc27\udcb0-\udcd3]|\ud803[\udc80-\udcb2]|\ud806[\udca0-\udcbf]|\ud835[\udc00-\udc19\udc34-\udc4d\udc68-\udc81\udc9c\udc9e\udc9f\udca2\udca5\udca6\udca9-\udcac\udcae-\udcb5\udcd0-\udce9\udd04\udd05\udd07-\udd0a\udd0d-\udd14\udd16-\udd1c\udd38\udd39\udd3b-\udd3e\udd40-\udd44\udd46\udd4a-\udd50\udd6c-\udd85\udda0-\uddb9\uddd4-\udded\ude08-\ude21\ude3c-\ude55\ude70-\ude89\udea8-\udec0\udee2-\udefa\udf1c-\udf34\udf56-\udf6e\udf90-\udfa8\udfca]|\ud83a[\udd00-\udd21]|\ud83c[\udd30-\udd49\udd50-\udd69\udd70-\udd89]"},{name:"White_Space",bmp:"\t-\r    - \u2028\u2029  　"}];d.push({name:"Assigned",inverseOf:"Cn"}),e.addUnicodeData(d)}},{}],7:[function(e,d,u){d.exports=function(e){"use strict";if(!e.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Scripts");e.addUnicodeData([{name:"Adlam",astral:"\ud83a[\udd00-\udd4a\udd50-\udd59\udd5e\udd5f]"},{name:"Ahom",astral:"\ud805[\udf00-\udf19\udf1d-\udf2b\udf30-\udf3f]"},{name:"Anatolian_Hieroglyphs",astral:"\ud811[\udc00-\ude46]"},{name:"Arabic",bmp:"؀-؄؆-؋؍-ؚ؞ؠ-ؿف-يٖ-ٯٱ-ۜ۞-ۿݐ-ݿࢠ-ࢴࢶ-ࢽࣔ-ࣣ࣡-ࣿﭐ-﯁ﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-﷽ﹰ-ﹴﹶ-ﻼ",astral:"\ud803[\ude60-\ude7e]|\ud83b[\ude00-\ude03\ude05-\ude1f\ude21\ude22\ude24\ude27\ude29-\ude32\ude34-\ude37\ude39\ude3b\ude42\ude47\ude49\ude4b\ude4d-\ude4f\ude51\ude52\ude54\ude57\ude59\ude5b\ude5d\ude5f\ude61\ude62\ude64\ude67-\ude6a\ude6c-\ude72\ude74-\ude77\ude79-\ude7c\ude7e\ude80-\ude89\ude8b-\ude9b\udea1-\udea3\udea5-\udea9\udeab-\udebb\udef0\udef1]"},{name:"Armenian",bmp:"Ա-Ֆՙ-՟ա-և֊֍-֏ﬓ-ﬗ"},{name:"Avestan",astral:"\ud802[\udf00-\udf35\udf39-\udf3f]"},{name:"Balinese",bmp:"ᬀ-ᭋ᭐-᭼"},{name:"Bamum",bmp:"ꚠ-꛷",astral:"\ud81a[\udc00-\ude38]"},{name:"Bassa_Vah",astral:"\ud81a[\uded0-\udeed\udef0-\udef5]"},{name:"Batak",bmp:"ᯀ-᯳᯼-᯿"},{name:"Bengali",bmp:"ঀ-ঃঅ-ঌএঐও-নপ-রলশ-হ়-ৄেৈো-ৎৗড়ঢ়য়-ৣ০-৻"},{name:"Bhaiksuki",astral:"\ud807[\udc00-\udc08\udc0a-\udc36\udc38-\udc45\udc50-\udc6c]"},{name:"Bopomofo",bmp:"˪˫ㄅ-ㄭㆠ-ㆺ"},{name:"Brahmi",astral:"\ud804[\udc00-\udc4d\udc52-\udc6f\udc7f]"},{name:"Braille",bmp:"⠀-⣿"},{name:"Buginese",bmp:"ᨀ-ᨛ᨞᨟"},{name:"Buhid",bmp:"ᝀ-ᝓ"},{name:"Canadian_Aboriginal",bmp:"᐀-ᙿᢰ-ᣵ"},{name:"Carian",astral:"\ud800[\udea0-\uded0]"},{name:"Caucasian_Albanian",astral:"\ud801[\udd30-\udd63\udd6f]"},{name:"Chakma",astral:"\ud804[\udd00-\udd34\udd36-\udd43]"},{name:"Cham",bmp:"ꨀ-ꨶꩀ-ꩍ꩐-꩙꩜-꩟"},{name:"Cherokee",bmp:"Ꭰ-Ᏽᏸ-ᏽꭰ-ꮿ"},{name:"Common",bmp:"\0-@\\x5B-`\\x7B-©«-¹»-¿×÷ʹ-˟˥-˩ˬ-˿ʹ;΅·։؅،؛؜؟ـ۝࣢।॥฿࿕-࿘჻᛫-᛭᜵᜶᠂᠃᠅᳓᳡ᳩ-ᳬᳮ-ᳳᳵᳶ -​‎-⁤⁦-⁰⁴-⁾₀-₎₠-₾℀-℥℧-℩ℬ-ℱℳ-⅍⅏-⅟↉-↋←-⏾␀-␦⑀-⑊①-⟿⤀-⭳⭶-⮕⮘-⮹⮽-⯈⯊-⯑⯬-⯯⸀-⹄⿰-⿻　-〄〆〈-〠〰-〷〼-〿゛゜゠・ー㆐-㆟㇀-㇣㈠-㉟㉿-㋏㍘-㏿䷀-䷿꜀-꜡ꞈ-꞊꠰-꠹꤮ꧏ꭛﴾﴿︐-︙︰-﹒﹔-﹦﹨-﹫\ufeff！-＠［-｀｛-･ｰﾞﾟ￠-￦￨-￮￹-�",astral:"\ud800[\udd00-\udd02\udd07-\udd33\udd37-\udd3f\udd90-\udd9b\uddd0-\uddfc\udee1-\udefb]|\ud82f[\udca0-\udca3]|\ud834[\udc00-\udcf5\udd00-\udd26\udd29-\udd66\udd6a-\udd7a\udd83\udd84\udd8c-\udda9\uddae-\udde8\udf00-\udf56\udf60-\udf71]|\ud835[\udc00-\udc54\udc56-\udc9c\udc9e\udc9f\udca2\udca5\udca6\udca9-\udcac\udcae-\udcb9\udcbb\udcbd-\udcc3\udcc5-\udd05\udd07-\udd0a\udd0d-\udd14\udd16-\udd1c\udd1e-\udd39\udd3b-\udd3e\udd40-\udd44\udd46\udd4a-\udd50\udd52-\udea5\udea8-\udfcb\udfce-\udfff]|\ud83c[\udc00-\udc2b\udc30-\udc93\udca0-\udcae\udcb1-\udcbf\udcc1-\udccf\udcd1-\udcf5\udd00-\udd0c\udd10-\udd2e\udd30-\udd6b\udd70-\uddac\udde6-\uddff\ude01\ude02\ude10-\ude3b\ude40-\ude48\ude50\ude51\udf00-\udfff]|\ud83d[\udc00-\uded2\udee0-\udeec\udef0-\udef6\udf00-\udf73\udf80-\udfd4]|\ud83e[\udc00-\udc0b\udc10-\udc47\udc50-\udc59\udc60-\udc87\udc90-\udcad\udd10-\udd1e\udd20-\udd27\udd30\udd33-\udd3e\udd40-\udd4b\udd50-\udd5e\udd80-\udd91\uddc0]|\udb40[\udc01\udc20-\udc7f]"},{name:"Coptic",bmp:"Ϣ-ϯⲀ-ⳳ⳹-⳿"},{name:"Cuneiform",astral:"\ud808[\udc00-\udf99]|\ud809[\udc00-\udc6e\udc70-\udc74\udc80-\udd43]"},{name:"Cypriot",astral:"\ud802[\udc00-\udc05\udc08\udc0a-\udc35\udc37\udc38\udc3c\udc3f]"},{name:"Cyrillic",bmp:"Ѐ-҄҇-ԯᲀ-ᲈᴫᵸⷠ-ⷿꙀ-ꚟ︮︯"},{name:"Deseret",astral:"\ud801[\udc00-\udc4f]"},{name:"Devanagari",bmp:"ऀ-ॐ॓-ॣ०-ॿ꣠-ꣽ"},{name:"Duployan",astral:"\ud82f[\udc00-\udc6a\udc70-\udc7c\udc80-\udc88\udc90-\udc99\udc9c-\udc9f]"},{name:"Egyptian_Hieroglyphs",astral:"\ud80c[\udc00-\udfff]|\ud80d[\udc00-\udc2e]"},{name:"Elbasan",astral:"\ud801[\udd00-\udd27]"},{name:"Ethiopic",bmp:"ሀ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚ፝-፼ᎀ-᎙ⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮ"},{name:"Georgian",bmp:"Ⴀ-ჅჇჍა-ჺჼ-ჿⴀ-ⴥⴧⴭ"},{name:"Glagolitic",bmp:"Ⰰ-Ⱞⰰ-ⱞ",astral:"\ud838[\udc00-\udc06\udc08-\udc18\udc1b-\udc21\udc23\udc24\udc26-\udc2a]"},{name:"Gothic",astral:"\ud800[\udf30-\udf4a]"},{name:"Grantha",astral:"\ud804[\udf00-\udf03\udf05-\udf0c\udf0f\udf10\udf13-\udf28\udf2a-\udf30\udf32\udf33\udf35-\udf39\udf3c-\udf44\udf47\udf48\udf4b-\udf4d\udf50\udf57\udf5d-\udf63\udf66-\udf6c\udf70-\udf74]"},{name:"Greek",bmp:"Ͱ-ͳ͵-ͷͺ-ͽͿ΄ΆΈ-ΊΌΎ-ΡΣ-ϡϰ-Ͽᴦ-ᴪᵝ-ᵡᵦ-ᵪᶿἀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ῄῆ-ΐῖ-Ί῝-`ῲ-ῴῶ-῾Ωꭥ",astral:"\ud800[\udd40-\udd8e\udda0]|\ud834[\ude00-\ude45]"},{name:"Gujarati",bmp:"ઁ-ઃઅ-ઍએ-ઑઓ-નપ-રલળવ-હ઼-ૅે-ૉો-્ૐૠ-ૣ૦-૱ૹ"},{name:"Gurmukhi",bmp:"ਁ-ਃਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹ਼ਾ-ੂੇੈੋ-੍ੑਖ਼-ੜਫ਼੦-ੵ"},{name:"Han",bmp:"⺀-⺙⺛-⻳⼀-⿕々〇〡-〩〸-〻㐀-䶵一-鿕豈-舘並-龎",astral:"[\ud840-\ud868\ud86a-\ud86c\ud86f-\ud872][\udc00-\udfff]|\ud869[\udc00-\uded6\udf00-\udfff]|\ud86d[\udc00-\udf34\udf40-\udfff]|\ud86e[\udc00-\udc1d\udc20-\udfff]|\ud873[\udc00-\udea1]|\ud87e[\udc00-\ude1d]"},{name:"Hangul",bmp:"ᄀ-ᇿ〮〯ㄱ-ㆎ㈀-㈞㉠-㉾ꥠ-ꥼ가-힣ힰ-ퟆퟋ-ퟻﾠ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ"},{name:"Hanunoo",bmp:"ᜠ-᜴"},{name:"Hatran",astral:"\ud802[\udce0-\udcf2\udcf4\udcf5\udcfb-\udcff]"},{name:"Hebrew",bmp:"֑-ׇא-תװ-״יִ-זּטּ-לּמּנּסּףּפּצּ-ﭏ"},{name:"Hiragana",bmp:"ぁ-ゖゝ-ゟ",astral:"𛀁|🈀"},{name:"Imperial_Aramaic",astral:"\ud802[\udc40-\udc55\udc57-\udc5f]"},{name:"Inherited",bmp:"̀-ًͯ҅҆-ٰٕ॒॑᪰-᪾᳐-᳔᳒-᳢᳠-᳨᳭᳴᳸᳹᷀-᷵᷻-᷿‌‍⃐-〪⃰-゙゚〭︀-️︠-︭",astral:"\ud800[\uddfd\udee0]|\ud834[\udd67-\udd69\udd7b-\udd82\udd85-\udd8b\uddaa-\uddad]|\udb40[\udd00-\uddef]"},{name:"Inscriptional_Pahlavi",astral:"\ud802[\udf60-\udf72\udf78-\udf7f]"},{name:"Inscriptional_Parthian",astral:"\ud802[\udf40-\udf55\udf58-\udf5f]"},{name:"Javanese",bmp:"ꦀ-꧍꧐-꧙꧞꧟"},{name:"Kaithi",astral:"\ud804[\udc80-\udcc1]"},{name:"Kannada",bmp:"ಀ-ಃಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹ಼-ೄೆ-ೈೊ-್ೕೖೞೠ-ೣ೦-೯ೱೲ"},{name:"Katakana",bmp:"ァ-ヺヽ-ヿㇰ-ㇿ㋐-㋾㌀-㍗ｦ-ｯｱ-ﾝ",astral:"𛀀"},{name:"Kayah_Li",bmp:"꤀-꤭꤯"},{name:"Kharoshthi",astral:"\ud802[\ude00-\ude03\ude05\ude06\ude0c-\ude13\ude15-\ude17\ude19-\ude33\ude38-\ude3a\ude3f-\ude47\ude50-\ude58]"},{name:"Khmer",bmp:"ក-៝០-៩៰-៹᧠-᧿"},{name:"Khojki",astral:"\ud804[\ude00-\ude11\ude13-\ude3e]"},{name:"Khudawadi",astral:"\ud804[\udeb0-\udeea\udef0-\udef9]"},{name:"Lao",bmp:"ກຂຄງຈຊຍດ-ທນ-ຟມ-ຣລວສຫອ-ູົ-ຽເ-ໄໆ່-ໍ໐-໙ໜ-ໟ"},{name:"Latin",bmp:"A-Za-zªºÀ-ÖØ-öø-ʸˠ-ˤᴀ-ᴥᴬ-ᵜᵢ-ᵥᵫ-ᵷᵹ-ᶾḀ-ỿⁱⁿₐ-ₜKÅℲⅎⅠ-ↈⱠ-ⱿꜢ-ꞇꞋ-ꞮꞰ-ꞷꟷ-ꟿꬰ-ꭚꭜ-ꭤﬀ-ﬆＡ-Ｚａ-ｚ"},{name:"Lepcha",bmp:"ᰀ-᰷᰻-᱉ᱍ-ᱏ"},{name:"Limbu",bmp:"ᤀ-ᤞᤠ-ᤫᤰ-᤻᥀᥄-᥏"},{name:"Linear_A",astral:"\ud801[\ude00-\udf36\udf40-\udf55\udf60-\udf67]"},{name:"Linear_B",astral:"\ud800[\udc00-\udc0b\udc0d-\udc26\udc28-\udc3a\udc3c\udc3d\udc3f-\udc4d\udc50-\udc5d\udc80-\udcfa]"},{name:"Lisu",bmp:"ꓐ-꓿"},{name:"Lycian",astral:"\ud800[\ude80-\ude9c]"},{name:"Lydian",astral:"\ud802[\udd20-\udd39\udd3f]"},{name:"Mahajani",astral:"\ud804[\udd50-\udd76]"},{name:"Malayalam",bmp:"ഁ-ഃഅ-ഌഎ-ഐഒ-ഺഽ-ൄെ-ൈൊ-൏ൔ-ൣ൦-ൿ"},{name:"Mandaic",bmp:"ࡀ-࡛࡞"},{name:"Manichaean",astral:"\ud802[\udec0-\udee6\udeeb-\udef6]"},{name:"Marchen",astral:"\ud807[\udc70-\udc8f\udc92-\udca7\udca9-\udcb6]"},{name:"Meetei_Mayek",bmp:"ꫠ-꫶ꯀ-꯭꯰-꯹"},{name:"Mende_Kikakui",astral:"\ud83a[\udc00-\udcc4\udcc7-\udcd6]"},{name:"Meroitic_Cursive",astral:"\ud802[\udda0-\uddb7\uddbc-\uddcf\uddd2-\uddff]"},{name:"Meroitic_Hieroglyphs",astral:"\ud802[\udd80-\udd9f]"},{name:"Miao",astral:"\ud81b[\udf00-\udf44\udf50-\udf7e\udf8f-\udf9f]"},{name:"Modi",astral:"\ud805[\ude00-\ude44\ude50-\ude59]"},{name:"Mongolian",bmp:"᠀᠁᠄᠆-᠎᠐-᠙ᠠ-ᡷᢀ-ᢪ",astral:"\ud805[\ude60-\ude6c]"},{name:"Mro",astral:"\ud81a[\ude40-\ude5e\ude60-\ude69\ude6e\ude6f]"},{name:"Multani",astral:"\ud804[\ude80-\ude86\ude88\ude8a-\ude8d\ude8f-\ude9d\ude9f-\udea9]"},{name:"Myanmar",bmp:"က-႟ꧠ-ꧾꩠ-ꩿ"},{name:"Nabataean",astral:"\ud802[\udc80-\udc9e\udca7-\udcaf]"},{name:"New_Tai_Lue",bmp:"ᦀ-ᦫᦰ-ᧉ᧐-᧚᧞᧟"},{name:"Newa",astral:"\ud805[\udc00-\udc59\udc5b\udc5d]"},{name:"Nko",bmp:"߀-ߺ"},{name:"Ogham",bmp:" -᚜"},{name:"Ol_Chiki",bmp:"᱐-᱿"},{name:"Old_Hungarian",astral:"\ud803[\udc80-\udcb2\udcc0-\udcf2\udcfa-\udcff]"},{name:"Old_Italic",astral:"\ud800[\udf00-\udf23]"},{name:"Old_North_Arabian",astral:"\ud802[\ude80-\ude9f]"},{name:"Old_Permic",astral:"\ud800[\udf50-\udf7a]"},{name:"Old_Persian",astral:"\ud800[\udfa0-\udfc3\udfc8-\udfd5]"},{name:"Old_South_Arabian",astral:"\ud802[\ude60-\ude7f]"},{name:"Old_Turkic",astral:"\ud803[\udc00-\udc48]"},{name:"Oriya",bmp:"ଁ-ଃଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହ଼-ୄେୈୋ-୍ୖୗଡ଼ଢ଼ୟ-ୣ୦-୷"},{name:"Osage",astral:"\ud801[\udcb0-\udcd3\udcd8-\udcfb]"},{name:"Osmanya",astral:"\ud801[\udc80-\udc9d\udca0-\udca9]"},{name:"Pahawh_Hmong",astral:"\ud81a[\udf00-\udf45\udf50-\udf59\udf5b-\udf61\udf63-\udf77\udf7d-\udf8f]"},{name:"Palmyrene",astral:"\ud802[\udc60-\udc7f]"},{name:"Pau_Cin_Hau",astral:"\ud806[\udec0-\udef8]"},{name:"Phags_Pa",bmp:"ꡀ-꡷"},{name:"Phoenician",astral:"\ud802[\udd00-\udd1b\udd1f]"},{name:"Psalter_Pahlavi",astral:"\ud802[\udf80-\udf91\udf99-\udf9c\udfa9-\udfaf]"},{name:"Rejang",bmp:"ꤰ-꥓꥟"},{name:"Runic",bmp:"ᚠ-ᛪᛮ-ᛸ"},{name:"Samaritan",bmp:"ࠀ-࠭࠰-࠾"},{name:"Saurashtra",bmp:"ꢀ-ꣅ꣎-꣙"},{name:"Sharada",astral:"\ud804[\udd80-\uddcd\uddd0-\udddf]"},{name:"Shavian",astral:"\ud801[\udc50-\udc7f]"},{name:"Siddham",astral:"\ud805[\udd80-\uddb5\uddb8-\udddd]"},{name:"SignWriting",astral:"\ud836[\udc00-\ude8b\ude9b-\ude9f\udea1-\udeaf]"},{name:"Sinhala",bmp:"ංඃඅ-ඖක-නඳ-රලව-ෆ්ා-ුූෘ-ෟ෦-෯ෲ-෴",astral:"\ud804[\udde1-\uddf4]"},{name:"Sora_Sompeng",astral:"\ud804[\udcd0-\udce8\udcf0-\udcf9]"},{name:"Sundanese",bmp:"ᮀ-ᮿ᳀-᳇"},{name:"Syloti_Nagri",bmp:"ꠀ-꠫"},{name:"Syriac",bmp:"܀-܍܏-݊ݍ-ݏ"},{name:"Tagalog",bmp:"ᜀ-ᜌᜎ-᜔"},{name:"Tagbanwa",bmp:"ᝠ-ᝬᝮ-ᝰᝲᝳ"},{name:"Tai_Le",bmp:"ᥐ-ᥭᥰ-ᥴ"},{name:"Tai_Tham",bmp:"ᨠ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪠-᪭"},{name:"Tai_Viet",bmp:"ꪀ-ꫂꫛ-꫟"},{name:"Takri",astral:"\ud805[\ude80-\udeb7\udec0-\udec9]"},{name:"Tamil",bmp:"ஂஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹா-ூெ-ைொ-்ௐௗ௦-௺"},{name:"Tangut",astral:"𖿠|[\ud81c-\ud820][\udc00-\udfff]|\ud821[\udc00-\udfec]|\ud822[\udc00-\udef2]"},{name:"Telugu",bmp:"ఀ-ఃఅ-ఌఎ-ఐఒ-నప-హఽ-ౄె-ైొ-్ౕౖౘ-ౚౠ-ౣ౦-౯౸-౿"},{name:"Thaana",bmp:"ހ-ޱ"},{name:"Thai",bmp:"ก-ฺเ-๛"},{name:"Tibetan",bmp:"ༀ-ཇཉ-ཬཱ-ྗྙ-ྼ྾-࿌࿎-࿔࿙࿚"},{name:"Tifinagh",bmp:"ⴰ-ⵧⵯ⵰⵿"},{name:"Tirhuta",astral:"\ud805[\udc80-\udcc7\udcd0-\udcd9]"},{name:"Ugaritic",astral:"\ud800[\udf80-\udf9d\udf9f]"},{name:"Vai",bmp:"ꔀ-ꘫ"},{name:"Warang_Citi",astral:"\ud806[\udca0-\udcf2\udcff]"},{name:"Yi",bmp:"ꀀ-ꒌ꒐-꓆"}])}},{}],8:[function(e,d,u){var n=e("./xregexp");e("./addons/build")(n),e("./addons/matchrecursive")(n),e("./addons/unicode-base")(n),e("./addons/unicode-blocks")(n),e("./addons/unicode-categories")(n),e("./addons/unicode-properties")(n),e("./addons/unicode-scripts")(n),d.exports=n},{"./addons/build":1,"./addons/matchrecursive":2,"./addons/unicode-base":3,"./addons/unicode-blocks":4,"./addons/unicode-categories":5,"./addons/unicode-properties":6,"./addons/unicode-scripts":7,"./xregexp":9}],9:[function(e,d,u){var n={astral:!1,natives:!1},t={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},a={},r={},i={},o=[],c={default:/\\(?:0(?:[0-3][0-7]{0,2}|[4-7][0-7]?)?|[1-9]\d*|x[\dA-Fa-f]{2}|u(?:[\dA-Fa-f]{4}|{[\dA-Fa-f]+})|c[A-Za-z]|[\s\S])|\(\?(?:[:=!]|<[=!])|[?*+]\?|{\d+(?:,\d*)?}\??|[\s\S]/,class:/\\(?:[0-3][0-7]{0,2}|[4-7][0-7]?|x[\dA-Fa-f]{2}|u(?:[\dA-Fa-f]{4}|{[\dA-Fa-f]+})|c[A-Za-z]|[\s\S])|[\s\S]/},s=/\$(?:{([\w$]+)}|(\d\d?|[\s\S]))/g,f=void 0===t.exec.call(/()??/,"")[1],l=void 0!==/x/.flags,m={}.toString;function p(e){var d=!0;try{new RegExp("",e)}catch(e){d=!1}return d}var g=p("u"),b=p("y"),h={g:!0,i:!0,m:!0,u:g,y:b};function v(e,d,u,n,t){var a;if(e.xregexp={captureNames:d},t)return e;if(e.__proto__)e.__proto__=O.prototype;else for(a in O.prototype)e[a]=O.prototype[a];return e.xregexp.source=u,e.xregexp.flags=n?n.split("").sort().join(""):n,e}function y(e){return t.replace.call(e,/([\s\S])(?=[\s\S]*\1)/g,"")}function C(e,d){if(!O.isRegExp(e))throw new TypeError("Type RegExp expected");var u=e.xregexp||{},n=function(e){return l?e.flags:t.exec.call(/\/([a-z]*)$/i,RegExp.prototype.toString.call(e))[1]}(e),a="",r="",i=null,o=null;return(d=d||{}).removeG&&(r+="g"),d.removeY&&(r+="y"),r&&(n=t.replace.call(n,new RegExp("["+r+"]+","g"),"")),d.addG&&(a+="g"),d.addY&&(a+="y"),a&&(n=y(n+a)),d.isInternalOnly||(void 0!==u.source&&(i=u.source),null!=u.flags&&(o=a?y(u.flags+a):u.flags)),v(new RegExp(d.source||e.source,n),function(e){return!(!e.xregexp||!e.xregexp.captureNames)}(e)?u.captureNames.slice(0):null,i,o,d.isInternalOnly)}function _(e){return parseInt(e,16)}function I(e,d,u){return"("===e.input.charAt(e.index-1)||")"===e.input.charAt(e.index+e[0].length)||function(e,d,u,n){var a=u.indexOf("x")>-1?["\\s","#[^#\\n]*","\\(\\?#[^)]*\\)"]:["\\(\\?#[^)]*\\)"];return t.test.call(new RegExp("^(?:"+a.join("|")+")*(?:[?*+]|{\\d+(?:,\\d*)?})"),e.slice(d))}(e.input,e.index+e[0].length,u)?"":"(?:)"}function S(e){return parseInt(e,10).toString(16)}function x(e,d){var u,n=e.length;for(u=0;u<n;++u)if(e[u]===d)return u;return-1}function T(e,d){return m.call(e)==="[object "+d+"]"}function K(e){for(;e.length<4;)e="0"+e;return e}function P(e){var d={};return T(e,"String")?(O.forEach(e,/[^\s,]+/,(function(e){d[e]=!0})),d):e}function k(e){if(!/^[\w$]$/.test(e))throw new Error("Flag must be a single character A-Za-z0-9_$");h[e]=!0}function E(e,d,u,n,t){for(var a,r,i=o.length,c=e.charAt(u),s=null;i--;)if(!((r=o[i]).leadChar&&r.leadChar!==c||r.scope!==n&&"all"!==r.scope||r.flag&&-1===d.indexOf(r.flag))&&(a=O.exec(e,r.regex,u,"sticky"))){s={matchLength:a[0].length,output:r.handler.call(t,a,n,d),reparse:r.reparse};break}return s}function A(e){n.astral=e}function w(e){RegExp.prototype.exec=(e?a:t).exec,RegExp.prototype.test=(e?a:t).test,String.prototype.match=(e?a:t).match,String.prototype.replace=(e?a:t).replace,String.prototype.split=(e?a:t).split,n.natives=e}function D(e){if(null==e)throw new TypeError("Cannot convert null or undefined to object");return e}function O(e,d){if(O.isRegExp(e)){if(void 0!==d)throw new TypeError("Cannot supply flags when copying a RegExp");return C(e)}if(e=void 0===e?"":String(e),d=void 0===d?"":String(d),O.isInstalled("astral")&&-1===d.indexOf("A")&&(d+="A"),i[e]||(i[e]={}),!i[e][d]){for(var u,n={hasNamedCapture:!1,captureNames:[]},a="default",r="",o=0,s=function(e,d){var u;if(y(d)!==d)throw new SyntaxError("Invalid duplicate regex flag "+d);for(e=t.replace.call(e,/^\(\?([\w$]+)\)/,(function(e,u){if(t.test.call(/[gy]/,u))throw new SyntaxError("Cannot use flag g or y in mode modifier "+e);return d=y(d+u),""})),u=0;u<d.length;++u)if(!h[d.charAt(u)])throw new SyntaxError("Unknown regex flag "+d.charAt(u));return{pattern:e,flags:d}}(e,d),f=s.pattern,l=s.flags;o<f.length;){do{(u=E(f,l,o,a,n))&&u.reparse&&(f=f.slice(0,o)+u.output+f.slice(o+u.matchLength))}while(u&&u.reparse);if(u)r+=u.output,o+=u.matchLength||1;else{var m=O.exec(f,c[a],o,"sticky")[0];r+=m,o+=m.length,"["===m&&"default"===a?a="class":"]"===m&&"class"===a&&(a="default")}}i[e][d]={pattern:t.replace.call(r,/(?:\(\?:\))+/g,"(?:)"),flags:t.replace.call(l,/[^gimuy]+/g,""),captures:n.hasNamedCapture?n.captureNames:null}}var p=i[e][d];return v(new RegExp(p.pattern,p.flags),p.captures,e,d)}O.prototype=new RegExp,O.version="3.2.0",O._clipDuplicates=y,O._hasNativeFlag=p,O._dec=_,O._hex=S,O._pad4=K,O.addToken=function(e,d,u){var n,a=(u=u||{}).optionalFlags;if(u.flag&&k(u.flag),a)for(a=t.split.call(a,""),n=0;n<a.length;++n)k(a[n]);o.push({regex:C(e,{addG:!0,addY:b,isInternalOnly:!0}),handler:d,scope:u.scope||"default",flag:u.flag,reparse:u.reparse,leadChar:u.leadChar}),O.cache.flush("patterns")},O.cache=function(e,d){return r[e]||(r[e]={}),r[e][d]||(r[e][d]=O(e,d))},O.cache.flush=function(e){"patterns"===e?i={}:r={}},O.escape=function(e){return t.replace.call(D(e),/[-\[\]{}()*+?.,\\^$|#\s]/g,"\\$&")},O.exec=function(e,d,u,n){var t,r,i,o="g",c=!1;return(t=b&&!!(n||d.sticky&&!1!==n))?o+="y":n&&(c=!0,o+="FakeY"),d.xregexp=d.xregexp||{},u=u||0,(i=d.xregexp[o]||(d.xregexp[o]=C(d,{addG:!0,addY:t,source:c?d.source+"|()":void 0,removeY:!1===n,isInternalOnly:!0}))).lastIndex=u,r=a.exec.call(i,e),c&&r&&""===r.pop()&&(r=null),d.global&&(d.lastIndex=r?i.lastIndex:0),r},O.forEach=function(e,d,u){for(var n,t=0,a=-1;n=O.exec(e,d,t);)u(n,++a,e,d),t=n.index+(n[0].length||1)},O.globalize=function(e){return C(e,{addG:!0})},O.install=function(e){e=P(e),!n.astral&&e.astral&&A(!0),!n.natives&&e.natives&&w(!0)},O.isInstalled=function(e){return!!n[e]},O.isRegExp=function(e){return"[object RegExp]"===m.call(e)},O.match=function(e,d,u){var n,a,r=d.global&&"one"!==u||"all"===u,i=(r?"g":"")+(d.sticky?"y":"")||"noGY";return d.xregexp=d.xregexp||{},a=d.xregexp[i]||(d.xregexp[i]=C(d,{addG:!!r,removeG:"one"===u,isInternalOnly:!0})),n=t.match.call(D(e),a),d.global&&(d.lastIndex="one"===u&&n?n.index+n[0].length:0),r?n||[]:n&&n[0]},O.matchChain=function(e,d){return function e(u,n){var t=d[n].regex?d[n]:{regex:d[n]},a=[];function r(e){if(t.backref){if(!(e.hasOwnProperty(t.backref)||+t.backref<e.length))throw new ReferenceError("Backreference to undefined group: "+t.backref);a.push(e[t.backref]||"")}else a.push(e[0])}for(var i=0;i<u.length;++i)O.forEach(u[i],t.regex,r);return n!==d.length-1&&a.length?e(a,n+1):a}([e],0)},O.replace=function(e,d,u,n){var t,r=O.isRegExp(d),i=d.global&&"one"!==n||"all"===n,o=(i?"g":"")+(d.sticky?"y":"")||"noGY",c=d;return r?(d.xregexp=d.xregexp||{},c=d.xregexp[o]||(d.xregexp[o]=C(d,{addG:!!i,removeG:"one"===n,isInternalOnly:!0}))):i&&(c=new RegExp(O.escape(String(d)),"g")),t=a.replace.call(D(e),c,u),r&&d.global&&(d.lastIndex=0),t},O.replaceEach=function(e,d){var u,n;for(u=0;u<d.length;++u)n=d[u],e=O.replace(e,n[0],n[1],n[2]);return e},O.split=function(e,d,u){return a.split.call(D(e),d,u)},O.test=function(e,d,u,n){return!!O.exec(e,d,u,n)},O.uninstall=function(e){e=P(e),n.astral&&e.astral&&A(!1),n.natives&&e.natives&&w(!1)},O.union=function(e,d,u){var n,a,r=(u=u||{}).conjunction||"or",i=0;function o(e,d,u){var t=a[i-n];if(d){if(++i,t)return"(?<"+t+">"}else if(u)return"\\"+(+u+n);return e}if(!T(e,"Array")||!e.length)throw new TypeError("Must provide a nonempty array of patterns to merge");for(var c,s=/(\()(?!\?)|\\([1-9]\d*)|\\[\s\S]|\[(?:[^\\\]]|\\[\s\S])*\]/g,f=[],l=0;l<e.length;++l)c=e[l],O.isRegExp(c)?(n=i,a=c.xregexp&&c.xregexp.captureNames||[],f.push(t.replace.call(O(c.source).source,s,o))):f.push(O.escape(c));var m="none"===r?"":"|";return O(f.join(m),d)},a.exec=function(e){var d,u,n,a=this.lastIndex,r=t.exec.apply(this,arguments);if(r){if(!f&&r.length>1&&x(r,"")>-1&&(u=C(this,{removeG:!0,isInternalOnly:!0}),t.replace.call(String(e).slice(r.index),u,(function(){var e,d=arguments.length;for(e=1;e<d-2;++e)void 0===arguments[e]&&(r[e]=void 0)}))),this.xregexp&&this.xregexp.captureNames)for(n=1;n<r.length;++n)(d=this.xregexp.captureNames[n-1])&&(r[d]=r[n]);this.global&&!r[0].length&&this.lastIndex>r.index&&(this.lastIndex=r.index)}return this.global||(this.lastIndex=a),r},a.test=function(e){return!!a.exec.call(this,e)},a.match=function(e){var d;if(O.isRegExp(e)){if(e.global)return d=t.match.apply(this,arguments),e.lastIndex=0,d}else e=new RegExp(e);return a.exec.call(e,D(this))},a.replace=function(e,d){var u,n,a,r=O.isRegExp(e);return r?(e.xregexp&&(n=e.xregexp.captureNames),u=e.lastIndex):e+="",a=T(d,"Function")?t.replace.call(String(this),e,(function(){var u,t=arguments;if(n)for(t[0]=new String(t[0]),u=0;u<n.length;++u)n[u]&&(t[0][n[u]]=t[u+1]);return r&&e.global&&(e.lastIndex=t[t.length-2]+t[0].length),d.apply(void 0,t)})):t.replace.call(null==this?this:String(this),e,(function(){var e=arguments;return t.replace.call(String(d),s,(function(d,u,t){var a;if(u){if((a=+u)<=e.length-3)return e[a]||"";if((a=n?x(n,u):-1)<0)throw new SyntaxError("Backreference to undefined group "+d);return e[a+1]||""}if("$"===t)return"$";if("&"===t||0==+t)return e[0];if("`"===t)return e[e.length-1].slice(0,e[e.length-2]);if("'"===t)return e[e.length-1].slice(e[e.length-2]+e[0].length);if(t=+t,!isNaN(t)){if(t>e.length-3)throw new SyntaxError("Backreference to undefined group "+d);return e[t]||""}throw new SyntaxError("Invalid token "+d)}))})),r&&(e.global?e.lastIndex=0:e.lastIndex=u),a},a.split=function(e,d){if(!O.isRegExp(e))return t.split.apply(this,arguments);var u,n=String(this),a=[],r=e.lastIndex,i=0;return d=(void 0===d?-1:d)>>>0,O.forEach(n,e,(function(e){e.index+e[0].length>i&&(a.push(n.slice(i,e.index)),e.length>1&&e.index<n.length&&Array.prototype.push.apply(a,e.slice(1)),u=e[0].length,i=e.index+u)})),i===n.length?t.test.call(e,"")&&!u||a.push(""):a.push(n.slice(i)),e.lastIndex=r,a.length>d?a.slice(0,d):a},O.addToken(/\\([ABCE-RTUVXYZaeg-mopqyz]|c(?![A-Za-z])|u(?![\dA-Fa-f]{4}|{[\dA-Fa-f]+})|x(?![\dA-Fa-f]{2}))/,(function(e,d){if("B"===e[1]&&"default"===d)return e[0];throw new SyntaxError("Invalid escape "+e[0])}),{scope:"all",leadChar:"\\"}),O.addToken(/\\u{([\dA-Fa-f]+)}/,(function(e,d,u){var n=_(e[1]);if(n>1114111)throw new SyntaxError("Invalid Unicode code point "+e[0]);if(n<=65535)return"\\u"+K(S(n));if(g&&u.indexOf("u")>-1)return e[0];throw new SyntaxError("Cannot use Unicode code point above \\u{FFFF} without flag u")}),{scope:"all",leadChar:"\\"}),O.addToken(/\[(\^?)\]/,(function(e){return e[1]?"[\\s\\S]":"\\b\\B"}),{leadChar:"["}),O.addToken(/\(\?#[^)]*\)/,I,{leadChar:"("}),O.addToken(/\s+|#[^\n]*\n?/,I,{flag:"x"}),O.addToken(/\./,(function(){return"[\\s\\S]"}),{flag:"s",leadChar:"."}),O.addToken(/\\k<([\w$]+)>/,(function(e){var d=isNaN(e[1])?x(this.captureNames,e[1])+1:+e[1],u=e.index+e[0].length;if(!d||d>this.captureNames.length)throw new SyntaxError("Backreference to undefined group "+e[0]);return"\\"+d+(u===e.input.length||isNaN(e.input.charAt(u))?"":"(?:)")}),{leadChar:"\\"}),O.addToken(/\\(\d+)/,(function(e,d){if(!("default"===d&&/^[1-9]/.test(e[1])&&+e[1]<=this.captureNames.length)&&"0"!==e[1])throw new SyntaxError("Cannot use octal escape or backreference to undefined group "+e[0]);return e[0]}),{scope:"all",leadChar:"\\"}),O.addToken(/\(\?P?<([\w$]+)>/,(function(e){if(!isNaN(e[1]))throw new SyntaxError("Cannot use integer as capture name "+e[0]);if("length"===e[1]||"__proto__"===e[1])throw new SyntaxError("Cannot use reserved word as capture name "+e[0]);if(x(this.captureNames,e[1])>-1)throw new SyntaxError("Cannot use same name for multiple groups "+e[0]);return this.captureNames.push(e[1]),this.hasNamedCapture=!0,"("}),{leadChar:"("}),O.addToken(/\((?!\?)/,(function(e,d,u){return u.indexOf("n")>-1?"(?:":(this.captureNames.push(null),"(")}),{optionalFlags:"n",leadChar:"("}),d.exports=O},{}]},{},[8])(8)})),define("xregexp",["xregexp/xregexp-all"],(function(e){return e}));var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var d,u=1,n=arguments.length;u<n;u++)for(var t in d=arguments[u])Object.prototype.hasOwnProperty.call(d,t)&&(e[t]=d[t]);return e}).apply(this,arguments)};define("vs/language/kusto/languageService/kustoLanguageService",["require","exports","./schema","vscode-languageserver-types","xregexp","./schema"],(function(e,d,u,n,t,a){"use strict";Object.defineProperty(d,"__esModule",{value:!0}),d.getKustoLanguageService=d.TokenKind=void 0,String.prototype.endsWith||(String.prototype.endsWith=function(e,d){return(void 0===d||d>this.length)&&(d=this.length),this.substring(d-e.length,d)===e}),"undefined"==typeof document&&(importScripts("../../language/kusto/bridge.min.js"),importScripts("../../language/kusto/kusto.javascript.client.min.js"),importScripts("../../language/kusto/Kusto.Language.Bridge.min.js"));var r=Kusto.Data.IntelliSense,i=Kusto.Language.Parsing,o=Kusto.Language.Editor,c=Kusto.Language.Symbols,s=Kusto.Language.GlobalState,f=System.Collections.Generic.List$1;function l(e){throw new Error("Unexpected object: "+e)}var m,p=function(){function e(e,d,u,n){this.version=e,this.uri=d,this.rulesProvider=u,this.parseMode=n}return e.prototype.isParseNeeded=function(e,d,u){return!(e.uri===this.uri&&(!d||d===this.rulesProvider)&&e.version<=this.version&&u&&u<=this.parseMode)},e}();function g(e){return e.map((function(e){return{start:e.Start,end:e.End,length:e.Length,kind:e.Kind}}))}!function(e){e[e.TableToken=2]="TableToken",e[e.TableColumnToken=4]="TableColumnToken",e[e.OperatorToken=8]="OperatorToken",e[e.SubOperatorToken=16]="SubOperatorToken",e[e.CalculatedColumnToken=32]="CalculatedColumnToken",e[e.StringLiteralToken=64]="StringLiteralToken",e[e.FunctionNameToken=128]="FunctionNameToken",e[e.UnknownToken=256]="UnknownToken",e[e.CommentToken=512]="CommentToken",e[e.PlainTextToken=1024]="PlainTextToken",e[e.DataTypeToken=2048]="DataTypeToken",e[e.ControlCommandToken=4096]="ControlCommandToken",e[e.CommandPartToken=8192]="CommandPartToken",e[e.QueryParametersToken=16384]="QueryParametersToken",e[e.CslCommandToken=32768]="CslCommandToken",e[e.LetVariablesToken=65536]="LetVariablesToken",e[e.PluginToken=131072]="PluginToken",e[e.BracketRangeToken=262144]="BracketRangeToken",e[e.ClientDirectiveToken=524288]="ClientDirectiveToken"}(m=d.TokenKind||(d.TokenKind={}));var b=function(){function e(d,u){var t,a,i,c,s=this;this._toOptionKind=((t={})[o.CompletionKind.AggregateFunction]=r.OptionKind.FunctionAggregation,t[o.CompletionKind.BuiltInFunction]=r.OptionKind.FunctionServerSide,t[o.CompletionKind.Cluster]=r.OptionKind.Database,t[o.CompletionKind.Column]=r.OptionKind.Column,t[o.CompletionKind.CommandPrefix]=r.OptionKind.None,t[o.CompletionKind.Database]=r.OptionKind.Database,t[o.CompletionKind.DatabaseFunction]=r.OptionKind.FunctionServerSide,t[o.CompletionKind.Example]=r.OptionKind.None,t[o.CompletionKind.Identifier]=r.OptionKind.None,t[o.CompletionKind.Keyword]=r.OptionKind.None,t[o.CompletionKind.LocalFunction]=r.OptionKind.FunctionLocal,t[o.CompletionKind.MaterialiedView]=r.OptionKind.MaterializedView,t[o.CompletionKind.Parameter]=r.OptionKind.Parameter,t[o.CompletionKind.Punctuation]=r.OptionKind.None,t[o.CompletionKind.QueryPrefix]=r.OptionKind.Operator,t[o.CompletionKind.RenderChart]=r.OptionKind.Operator,t[o.CompletionKind.ScalarInfix]=r.OptionKind.None,t[o.CompletionKind.ScalarPrefix]=r.OptionKind.None,t[o.CompletionKind.ScalarType]=r.OptionKind.DataType,t[o.CompletionKind.Syntax]=r.OptionKind.None,t[o.CompletionKind.Table]=r.OptionKind.Table,t[o.CompletionKind.TabularPrefix]=r.OptionKind.None,t[o.CompletionKind.TabularSuffix]=r.OptionKind.None,t[o.CompletionKind.Unknown]=r.OptionKind.None,t[o.CompletionKind.Variable]=r.OptionKind.Parameter,t[o.CompletionKind.Option]=r.OptionKind.Option,t),this.disabledCompletionItemsV2={ladderchart:o.CompletionKind.RenderChart,pivotchart:o.CompletionKind.RenderChart,timeline:o.CompletionKind.RenderChart,timepivot:o.CompletionKind.RenderChart,"3Dchart":o.CompletionKind.RenderChart,list:o.CompletionKind.RenderChart},this.isIntellisenseV2=function(){return s._languageSettings.useIntellisenseV2&&s._schema&&"Engine"===s._schema.clusterType},this.disabledCompletionItemsV1={capacity:r.OptionKind.Policy,callout:r.OptionKind.Policy,encoding:r.OptionKind.Policy,batching:r.OptionKind.Policy,querythrottling:r.OptionKind.Policy,merge:r.OptionKind.Policy,querylimit:r.OptionKind.Policy,rowstore:r.OptionKind.Policy,streamingingestion:r.OptionKind.Policy,restricted_view_access:r.OptionKind.Policy,sharding:r.OptionKind.Policy,"restricted-viewers":r.OptionKind.Policy,attach:r.OptionKind.Command,purge:r.OptionKind.Command},this._kustoKindtolsKind=((a={})[r.OptionKind.None]=n.CompletionItemKind.Interface,a[r.OptionKind.Operator]=n.CompletionItemKind.Method,a[r.OptionKind.Command]=n.CompletionItemKind.Method,a[r.OptionKind.Service]=n.CompletionItemKind.Class,a[r.OptionKind.Policy]=n.CompletionItemKind.Reference,a[r.OptionKind.Database]=n.CompletionItemKind.Class,a[r.OptionKind.Table]=n.CompletionItemKind.Class,a[r.OptionKind.DataType]=n.CompletionItemKind.Class,a[r.OptionKind.Literal]=n.CompletionItemKind.Property,a[r.OptionKind.Parameter]=n.CompletionItemKind.Variable,a[r.OptionKind.IngestionMapping]=n.CompletionItemKind.Variable,a[r.OptionKind.ExpressionFunction]=n.CompletionItemKind.Variable,a[r.OptionKind.Option]=n.CompletionItemKind.Interface,a[r.OptionKind.OptionKind]=n.CompletionItemKind.Interface,a[r.OptionKind.OptionRender]=n.CompletionItemKind.Interface,a[r.OptionKind.Column]=n.CompletionItemKind.Function,a[r.OptionKind.ColumnString]=n.CompletionItemKind.Field,a[r.OptionKind.ColumnNumeric]=n.CompletionItemKind.Field,a[r.OptionKind.ColumnDateTime]=n.CompletionItemKind.Field,a[r.OptionKind.ColumnTimespan]=n.CompletionItemKind.Field,a[r.OptionKind.FunctionServerSide]=n.CompletionItemKind.Field,a[r.OptionKind.FunctionAggregation]=n.CompletionItemKind.Field,a[r.OptionKind.FunctionFilter]=n.CompletionItemKind.Field,a[r.OptionKind.FunctionScalar]=n.CompletionItemKind.Field,a[r.OptionKind.ClientDirective]=n.CompletionItemKind.Enum,a),this._kustoKindToLsKindV2=((i={})[o.CompletionKind.AggregateFunction]=n.CompletionItemKind.Field,i[o.CompletionKind.BuiltInFunction]=n.CompletionItemKind.Field,i[o.CompletionKind.Cluster]=n.CompletionItemKind.Class,i[o.CompletionKind.Column]=n.CompletionItemKind.Function,i[o.CompletionKind.CommandPrefix]=n.CompletionItemKind.Field,i[o.CompletionKind.Database]=n.CompletionItemKind.Class,i[o.CompletionKind.DatabaseFunction]=n.CompletionItemKind.Field,i[o.CompletionKind.Example]=n.CompletionItemKind.Text,i[o.CompletionKind.Identifier]=n.CompletionItemKind.Method,i[o.CompletionKind.Keyword]=n.CompletionItemKind.Method,i[o.CompletionKind.LocalFunction]=n.CompletionItemKind.Field,i[o.CompletionKind.MaterialiedView]=n.CompletionItemKind.Class,i[o.CompletionKind.Parameter]=n.CompletionItemKind.Variable,i[o.CompletionKind.Punctuation]=n.CompletionItemKind.Interface,i[o.CompletionKind.QueryPrefix]=n.CompletionItemKind.Function,i[o.CompletionKind.RenderChart]=n.CompletionItemKind.Method,i[o.CompletionKind.ScalarInfix]=n.CompletionItemKind.Field,i[o.CompletionKind.ScalarPrefix]=n.CompletionItemKind.Field,i[o.CompletionKind.ScalarType]=n.CompletionItemKind.TypeParameter,i[o.CompletionKind.Syntax]=n.CompletionItemKind.Method,i[o.CompletionKind.Table]=n.CompletionItemKind.Class,i[o.CompletionKind.TabularPrefix]=n.CompletionItemKind.Field,i[o.CompletionKind.TabularSuffix]=n.CompletionItemKind.Field,i[o.CompletionKind.Unknown]=n.CompletionItemKind.Interface,i[o.CompletionKind.Variable]=n.CompletionItemKind.Variable,i[o.CompletionKind.Option]=n.CompletionItemKind.Text,i),this._tokenKindToClassificationKind=((c={})[m.TableToken]=o.ClassificationKind.Table,c[m.TableColumnToken]=o.ClassificationKind.Column,c[m.OperatorToken]=o.ClassificationKind.QueryOperator,c[m.SubOperatorToken]=o.ClassificationKind.Function,c[m.CalculatedColumnToken]=o.ClassificationKind.Column,c[m.StringLiteralToken]=o.ClassificationKind.Literal,c[m.FunctionNameToken]=o.ClassificationKind.Function,c[m.UnknownToken]=o.ClassificationKind.PlainText,c[m.CommentToken]=o.ClassificationKind.Comment,c[m.PlainTextToken]=o.ClassificationKind.PlainText,c[m.DataTypeToken]=o.ClassificationKind.Type,c[m.ControlCommandToken]=o.ClassificationKind.PlainText,c[m.CommandPartToken]=o.ClassificationKind.PlainText,c[m.QueryParametersToken]=o.ClassificationKind.QueryParameter,c[m.CslCommandToken]=o.ClassificationKind.Keyword,c[m.LetVariablesToken]=o.ClassificationKind.Identifier,c[m.PluginToken]=o.ClassificationKind.Function,c[m.BracketRangeToken]=o.ClassificationKind.Keyword,c[m.ClientDirectiveToken]=o.ClassificationKind.Keyword,c),this._schemaCache={},this._kustoJsSchema=e.convertToKustoJsSchema(d),this.__kustoJsSchemaV2=this.convertToKustoJsSchemaV2(d),this._schema=d,this._clustersSetInGlobalState=new Set,this._nonEmptyDatabaseSetInGlobalState=new Set,this.configure(u),this._newlineAppendPipePolicy=new Kusto.Data.IntelliSense.ApplyPolicy,this._newlineAppendPipePolicy.Text="\n| "}return e.prototype.createDatabaseUniqueName=function(e,d){return e+"_"+d},Object.defineProperty(e.prototype,"_kustoJsSchemaV2",{get:function(){return this.__kustoJsSchemaV2},set:function(e){this.__kustoJsSchemaV2=e,this._clustersSetInGlobalState.clear(),this._nonEmptyDatabaseSetInGlobalState.clear();for(var d=0;d<e.Clusters.Count;d++){var u=this._kustoJsSchemaV2.Clusters.getItem(d);this._clustersSetInGlobalState.add(u.Name);for(var n=0;n<u.Databases.Count;n++){var t=u.Databases.getItem(n);t.Tables.Count>0&&this._nonEmptyDatabaseSetInGlobalState.add(this.createDatabaseUniqueName(u.Name,t.Name))}}},enumerable:!1,configurable:!0}),e.prototype.configure=function(e){this._languageSettings=e,this.createRulesProvider(this._kustoJsSchema,this._schema.clusterType)},e.prototype.doComplete=function(e,d){return this.isIntellisenseV2()?this.doCompleteV2(e,d):this.doCompleteV1(e,d)},e.prototype.debugGlobalState=function(e){console.log("globals.Clusters.Count: "+e.Clusters.Count);for(var d=0;d<e.Clusters.Count;d++){var u=e.Clusters.getItem(d);console.log("cluster: "+u.Name),console.log("cluster.Databases.Count: "+u.Databases.Count);for(var n=0;n<u.Databases.Count;n++){var t=u.Databases.getItem(n);console.log("cluster.database: ["+u.Name+"].["+t.Name+"]"),console.log("cluster.Databases.Tables.Count: "+t.Tables.Count);for(var a=0;a<t.Tables.Count;a++){var r=t.Tables.getItem(a);console.log("cluster.database.table: ["+u.Name+"].["+t.Name+"].["+r.Name+"]")}}}},e.prototype.doCompleteV2=function(e,d){var u=this;if(!e)return Promise.resolve(n.CompletionList.create([]));var t=this.parseDocumentV2(e),a=e.offsetAt(d),i=t.GetBlockAtPosition(a).Service.GetCompletionItems(a),c=this.disabledCompletionItemsV2;this._languageSettings.disabledCompletionItems&&this._languageSettings.disabledCompletionItems.map((function(e){c[e]=o.CompletionKind.Unknown}));var s=this.toArray(i.Items).filter((function(e){return!(e&&e.MatchText&&void 0!==c[e.MatchText]&&(c[e.MatchText]===o.CompletionKind.Unknown||c[e.MatchText]===e.Kind))})).map((function(d,t){var a=new r.CompletionOption(u._toOptionKind[d.Kind]||r.OptionKind.None,d.DisplayText),o=u.getTopic(a),c=d.AfterText&&d.AfterText.length>0?{textToInsert:d.EditText.replace("$","\\$")+"$0"+d.AfterText,format:n.InsertTextFormat.Snippet}:{textToInsert:d.EditText,format:n.InsertTextFormat.PlainText},s=c.textToInsert,f=c.format,l=n.CompletionItem.create(d.DisplayText),m=e.positionAt(i.EditStart),p=e.positionAt(i.EditStart+i.EditLength);return l.textEdit=n.TextEdit.replace(n.Range.create(m,p),s),l.sortText=u.getSortText(t+1),l.kind=u.kustoKindToLsKindV2(d.Kind),l.insertTextFormat=f,l.detail=o?o.ShortDescription:void 0,l.documentation=o?{value:o.LongDescription,kind:n.MarkupKind.Markdown}:void 0,l}));return Promise.resolve(n.CompletionList.create(s))},e.prototype.getTopic=function(e){if(e.Kind==r.OptionKind.FunctionScalar||e.Kind==r.OptionKind.FunctionAggregation){var d=e.Value.indexOf("(");d>=0&&(e=new r.CompletionOption(e.Kind,e.Value.substring(0,d)))}return r.CslDocumentation.Instance.GetTopic(e)},e.prototype.doCompleteV1=function(e,d){var u=this,t=e.offsetAt(d);this.parseDocumentV1(e,r.ParseMode.CommandTokensOnly);var a=this.getCurrentCommand(e,t),i="";if(a){a.AbsoluteStart,this.parseTextV1(a.Text,r.ParseMode.TokenizeAllText);var o=t-a.AbsoluteStart;i=a.Text.substring(a.CslExpressionStartPosition,o)}var c=this.getCommandWithoutLastWord(i),s=this._rulesProvider.AnalyzeCommand$1(i,a).Context,f={v:null};this._rulesProvider.TryMatchAnyRule(c,f);var l=f.v;if(l){var m=this.toArray(l.GetCompletionOptions(s));this._languageSettings.newlineAfterPipe&&l.DefaultAfterApplyPolicy===Kusto.Data.IntelliSense.ApplyPolicy.AppendPipePolicy&&(l.DefaultAfterApplyPolicy=this._newlineAppendPipePolicy);var p=m.filter((function(e){return!(e&&e.Value&&u.disabledCompletionItemsV1[e.Value]===e.Kind)})).map((function(e,d){var t=u.getTextToInsert(l,e),a=t.insertText,i=t.insertTextFormat,o=r.CslDocumentation.Instance.GetTopic(e),c=n.CompletionItem.create(e.Value);return c.kind=u.kustoKindToLsKind(e.Kind),c.insertText=a,c.insertTextFormat=i,c.sortText=u.getSortText(d+1),c.detail=o?o.ShortDescription:void 0,c.documentation=o?{value:o.LongDescription,kind:n.MarkupKind.Markdown}:void 0,c}));return Promise.resolve(n.CompletionList.create(p))}return Promise.resolve(n.CompletionList.create([]))},e.prototype.doRangeFormat=function(e,d){if(!e)return Promise.resolve([]);var u=e.offsetAt(d.start),t=e.offsetAt(d.end),a=this.getFormattedCommandsInDocumentV2(e,u,t);return a.originalRange&&0!==a.formattedCommands.length?Promise.resolve([n.TextEdit.replace(a.originalRange,a.formattedCommands.join(""))]):Promise.resolve([])},e.prototype.doDocumentFormat=function(e){if(!e)return Promise.resolve([]);var d=e.positionAt(0),u=e.positionAt(e.getText().length),t=n.Range.create(d,u),a=this.getFormattedCommandsInDocumentV2(e).formattedCommands.join("");return Promise.resolve([n.TextEdit.replace(t,a)])},e.prototype.doCurrentCommandFormat=function(e,d){var u=e.offsetAt(d),n=this.createRange(e,u-1,u+1);return this.doRangeFormat(e,n)},e.prototype.doFolding=function(e){return e?this.getCommandsInDocument(e).then((function(d){return d.map((function(d){d.text.endsWith("\r\n")?d.absoluteEnd-=2:(d.text.endsWith("\r")||d.text.endsWith("\n"))&&--d.absoluteEnd;var u=e.positionAt(d.absoluteStart),n=e.positionAt(d.absoluteEnd);return{startLine:u.line,startCharacter:u.character,endLine:n.line,endCharacter:n.character}}))})):Promise.resolve([])},e.prototype.getClusterReferences=function(e,d){var u,n=this.parseDocumentV2(e),t=this.getCurrentCommandV2(n,d),a=null===(u=null==t?void 0:t.Service)||void 0===u?void 0:u.GetClusterReferences();if(!a)return Promise.resolve([]);for(var r=[],i=new Set,o=0;o<a.Count;o++){var c=a.getItem(o),s=Kusto.Language.KustoFacts.GetHostName(c.Cluster);i.has(s)||(i.add(s),this._clustersSetInGlobalState.has(s)||r.push({clusterName:s}))}return Promise.resolve(r)},e.prototype.getDatabaseReferences=function(e,d){var u,n=this.parseDocumentV2(e),t=this.getCurrentCommandV2(n,d),a=null===(u=null==t?void 0:t.Service)||void 0===u?void 0:u.GetDatabaseReferences();if(!a)return Promise.resolve([]);for(var r=[],i=new Set,o=0;o<a.Count;o++){var c=a.getItem(o),s=Kusto.Language.KustoFacts.GetHostName(c.Cluster),f=this.createDatabaseUniqueName(s,c.Database);i.has(f)||(i.add(f),this._nonEmptyDatabaseSetInGlobalState.has(f)||r.push({databaseName:c.Database,clusterName:c.Cluster}))}return Promise.resolve(r)},e.prototype.doValidation=function(e,d,u,n){var t=this;if(!e||!this.isIntellisenseV2())return Promise.resolve([]);var a=this.parseDocumentV2(e),r=this.toArray(a.Blocks);d.length>0&&(r=this.getAffectedBlocks(r,d));var i=r.map((function(e){var d=t.toArray(e.Service.GetDiagnostics()),a=null!=u?u:t._languageSettings.enableQueryWarnings,r=null!=n?n:t._languageSettings.enableQuerySuggestions;if(a||r){var i=e.Service.GetAnalyzerDiagnostics(null,!0),o=t.toArray(i).filter((function(e){var d,u=a&&"Warning"===e.Severity||r&&"Suggestion"===e.Severity,n=!(null===(d=t._languageSettings.disabledDiagnoticCodes)||void 0===d?void 0:d.includes(e.Code));return u&&n}));d=d.concat(o)}return d})).reduce((function(e,d){return e.concat(d)}),[]),o=this.toLsDiagnostics(i,e);return Promise.resolve(o)},e.prototype.toLsDiagnostics=function(e,d){return e.filter((function(e){return e.HasLocation})).map((function(e){var u,t=d.positionAt(e.Start),a=d.positionAt(e.Start+e.Length),r=n.Range.create(t,a);switch(e.Severity){case"Suggestion":u=n.DiagnosticSeverity.Information;break;case"Warning":u=n.DiagnosticSeverity.Warning;break;default:u=n.DiagnosticSeverity.Error}return n.Diagnostic.create(r,e.Message,u,e.Code)}))},e.prototype.doColorization=function(e,d){var u=this;if(!e||!this._languageSettings.useSemanticColorization)return Promise.resolve([]);if(!this.isIntellisenseV2()){if(d.length>0){this.parseDocumentV1(e,r.ParseMode.CommandTokensOnly);var n=this.toArray(this._parser.Results).filter((function(e){return!!e&&d.some((function(d){var u=d.start,n=d.end;return e.AbsoluteStart>=u&&e.AbsoluteStart<=n||u>=e.AbsoluteStart&&u<=e.AbsoluteEnd+1}))}));if(!n||0===n.length)return Promise.resolve([{classifications:[],absoluteStart:d[0].start,absoluteEnd:d[0].end}]);var t=n.map((function(e){return u.parseTextV1(e.Text,r.ParseMode.TokenizeAllText),{classifications:g(u.getClassificationsFromParseResult(e.AbsoluteStart)),absoluteStart:e.AbsoluteStart,absoluteEnd:e.AbsoluteEnd}}));return Promise.resolve(t)}this.parseDocumentV1(e,r.ParseMode.TokenizeAllText);var a=this.getClassificationsFromParseResult();return Promise.resolve([{classifications:g(a),absoluteStart:0,absoluteEnd:e.getText().length}])}var i=this.parseDocumentV2(e);if(d.length>0){var o=this.toArray(i.Blocks),c=this.getAffectedBlocks(o,d).map((function(e){return{classifications:g(u.toArray(e.Service.GetClassifications(e.Start,e.End).Classifications)),absoluteStart:e.Start,absoluteEnd:e.End}}));return Promise.resolve(c)}var s=this.toArray(i.Blocks).map((function(e){return u.toArray(e.Service.GetClassifications(e.Start,e.Length).Classifications)})).reduce((function(e,d){return e.concat(d)}),[]);return Promise.resolve([{classifications:g(s),absoluteStart:0,absoluteEnd:e.getText().length}])},e.prototype.getAffectedBlocks=function(e,d){return e.filter((function(e){return!!e&&d.some((function(d){var u=d.start,n=d.end;return e.Start>=u&&e.Start<=n||u>=e.Start&&u<=e.End+1}))}))},e.prototype.addClusterToSchema=function(d,u,n){var t=Kusto.Language.KustoFacts.GetHostName(u),a=this._kustoJsSchemaV2.GetCluster$1(t);if(a&&n.filter((function(e){return!a.GetDatabase(e)})).map((function(e){var d=new c.DatabaseSymbol.$ctor1(e,void 0,!1);a=a.AddDatabase(d)})),!a){var r=n.map((function(e){return new c.DatabaseSymbol.$ctor1(e,void 0,!1)})),i=e.toBridgeList(r);a=new c.ClusterSymbol.$ctor1(t,i,!1)}return this._kustoJsSchemaV2=this._kustoJsSchemaV2.AddOrReplaceCluster(a),this._script=o.CodeScript.From$1(d.getText(),this._kustoJsSchemaV2),Promise.resolve()},e.prototype.addDatabaseToSchema=function(d,u,n){var t=Kusto.Language.KustoFacts.GetHostName(u),a=this._kustoJsSchemaV2.GetCluster$1(t);a||(a=new c.ClusterSymbol.$ctor1(t,null,!1));var r=e.convertToDatabaseSymbol(n);return a=a.AddOrUpdateDatabase(r),this._kustoJsSchemaV2=this._kustoJsSchemaV2.AddOrReplaceCluster(a),this._script=o.CodeScript.From$1(d.getText(),this._kustoJsSchemaV2),Promise.resolve()},e.prototype.setSchema=function(d){var u=this;if(this._schema=d,this._languageSettings.useIntellisenseV2){var n=d&&"Engine"===d.clusterType?this.convertToKustoJsSchemaV2(d):null;this._kustoJsSchemaV2=n,this._script=void 0,this._parsePropertiesV2=void 0}return new Promise((function(n,t){var a=d?e.convertToKustoJsSchema(d):void 0;u._kustoJsSchema=a,u.createRulesProvider(a,d.clusterType),n(void 0)}))},e.prototype.setParameters=function(d){if(!this._languageSettings.useIntellisenseV2||"Engine"!==this._schema.clusterType)throw new Error("setParameters requires intellisense V2 and Engine cluster");this._schema.globalParameters=d;var u=d.map((function(d){return e.createParameterSymbol(d)}));return this._kustoJsSchemaV2=this._kustoJsSchemaV2.WithParameters(e.toBridgeList(u)),Promise.resolve(void 0)},e.prototype.setSchemaFromShowSchema=function(e,d,u,n){var t=this;return this.normalizeSchema(e,d,u).then((function(e){return t.setSchema(__assign(__assign({},e),{globalParameters:n}))}))},e.prototype.normalizeSchema=function(e,d,u){var n=Object.keys(e.Databases).map((function(d){return e.Databases[d]})).map((function(e){var d=e.Name,u=e.Tables,n=e.ExternalTables,t=e.MaterializedViews,a=e.Functions;return{name:d,minorVersion:e.MinorVersion,majorVersion:e.MajorVersion,tables:[].concat.apply([],[[u,"Table"],[t,"MaterializedView"],[n,"ExternalTable"]].filter((function(e){return e[0]})).map((function(e){var d=e[0],u=e[1];return Object.values(d).map((function(e){var d=e.Name,n=e.OrderedColumns;return{name:d,docstring:e.DocString,entityType:u,columns:n.map((function(e){var d=e.Name,u=(e.Type,e.DocString);return{name:d,type:e.CslType,docstring:u}}))}}))}))),functions:Object.keys(a).map((function(e){return a[e]})).map((function(e){return{name:e.Name,body:e.Body,docstring:e.DocString,inputParameters:e.InputParameters.map((function(e){return{name:e.Name,type:e.Type,cslType:e.CslType,cslDefaultValue:e.CslDefaultValue,columns:e.Columns?e.Columns.map((function(e){return{name:e.Name,type:e.Type,cslType:e.CslType}})):e.Columns}}))}}))}})),t={clusterType:"Engine",cluster:{connectionString:d,databases:n},database:n.filter((function(e){return e.name===u}))[0]};return Promise.resolve(t)},e.prototype.getSchema=function(){return Promise.resolve(this._schema)},e.prototype.getCommandInContext=function(e,d){return this.isIntellisenseV2()?this.getCommandInContextV2(e,d):this.getCommandInContextV1(e,d)},e.prototype.getCommandAndLocationInContext=function(e,d){if(!e||!this.isIntellisenseV2())return Promise.resolve(null);var u=this.parseDocumentV2(e),t=this.getCurrentCommandV2(u,d);if(!t)return Promise.resolve(null);var a=e.positionAt(t.Start),r=e.positionAt(t.End),i=n.Location.create(e.uri,n.Range.create(a,r)),o=t.Text;return Promise.resolve({text:o,location:i})},e.prototype.getCommandInContextV1=function(e,d){this.parseDocumentV1(e,r.ParseMode.CommandTokensOnly);var u=this.getCurrentCommand(e,d);return u?Promise.resolve(u.Text):Promise.resolve(null)},e.prototype.getCommandInContextV2=function(e,d){if(!e)return Promise.resolve(null);var u=this.parseDocumentV2(e),n=this.getCurrentCommandV2(u,d);return n?Promise.resolve(n.Text):Promise.resolve(null)},e.prototype.getCommandsInDocument=function(e){return e?this.isIntellisenseV2()?this.getCommandsInDocumentV2(e):this.getCommandsInDocumentV1(e):Promise.resolve([])},e.prototype.getCommandsInDocumentV1=function(e){this.parseDocumentV1(e,r.ParseMode.CommandTokensOnly);var d=this.toArray(this._parser.Results);return Promise.resolve(d.map((function(e){return{absoluteStart:e.AbsoluteStart,absoluteEnd:e.AbsoluteEnd,text:e.Text}})))},e.prototype.toPlacementStyle=function(e){if(e)switch(e){case"None":return o.PlacementStyle.None;case"NewLine":return o.PlacementStyle.NewLine;case"Smart":return o.PlacementStyle.Smart;default:throw new Error("Unknown PlacementStyle")}},e.prototype.getFormattedCommandsInDocumentV2=function(e,d,u){var n=this,t=this.parseDocumentV2(e),a=this.toArray(t.Blocks).filter((function(e){if(!e.Text||""==e.Text.trim())return!1;if(null==d||null==u)return!0;for(var n=e.End,t=e.Text,a=t.length-1;a>=0&&("\r"==t[a]||"\n"==t[a]);a--)n--;return e.Start>d&&e.Start<u||n>d&&n<u||e.Start<=d&&n>=u||void 0}));return 0===a.length?{formattedCommands:[]}:{formattedCommands:a.map((function(e){var t,a,r=n._languageSettings.formatter,i=Kusto.Language.Editor.FormattingOptions.Default.WithIndentationSize(null!==(t=null==r?void 0:r.indentationSize)&&void 0!==t?t:4).WithInsertMissingTokens(!1).WithPipeOperatorStyle(null!==(a=n.toPlacementStyle(null==r?void 0:r.pipeOperatorStyle))&&void 0!==a?a:o.PlacementStyle.Smart).WithSemicolonStyle(Kusto.Language.Editor.PlacementStyle.None).WithBrackettingStyle(o.BrackettingStyle.Diagonal);return null==d||null==u||d===e.Start&&e.End,e.Service.GetFormattedText(i).Text})),originalRange:this.createRange(e,a[0].Start,a[a.length-1].End)}},e.prototype.getCommandsInDocumentV2=function(e){var d=this.parseDocumentV2(e),u=this.toArray(d.Blocks).filter((function(e){return""!=e.Text.trim()}));return Promise.resolve(u.map((function(e){return{absoluteStart:e.Start,absoluteEnd:e.End,text:e.Text}})))},e.prototype.getClientDirective=function(e){var d={v:null},u=r.CslCommandParser.IsClientDirective(e,d);return Promise.resolve({isClientDirective:u,directiveWithoutLeadingComments:d.v})},e.prototype.getAdminCommand=function(e){var d={v:null},u=r.CslCommandParser.IsAdminCommand$1(e,d);return Promise.resolve({isAdminCommand:u,adminCommandWithoutLeadingComments:d.v})},e.prototype.findDefinition=function(e,d){if(!e||!this.isIntellisenseV2())return Promise.resolve([]);var u=this.parseDocumentV2(e),t=e.offsetAt(d),a=this.getCurrentCommandV2(u,t);if(!a)return Promise.resolve([]);var r=a.Service.GetRelatedElements(e.offsetAt(d)),i=this.toArray(r.Elements)[0];if(!i)return Promise.resolve([]);var o=e.positionAt(i.Start),c=e.positionAt(i.End),s=n.Range.create(o,c),f=n.Location.create(e.uri,s);return Promise.resolve([f])},e.prototype.findReferences=function(e,d){if(!e||!this.isIntellisenseV2())return Promise.resolve([]);var u=this.parseDocumentV2(e),t=e.offsetAt(d),a=this.getCurrentCommandV2(u,t);if(!a)return Promise.resolve([]);var r=a.Service.GetRelatedElements(e.offsetAt(d)),i=this.toArray(r.Elements);if(!i||0==i.length)return Promise.resolve([]);var o=i.map((function(d){var u=e.positionAt(d.Start),t=e.positionAt(d.End),a=n.Range.create(u,t);return n.Location.create(e.uri,a)}));return Promise.resolve(o)},e.prototype.getQueryParams=function(e,d){if(!e||!this.isIntellisenseV2())return Promise.resolve([]);this.parseDocumentV2(e);var u=this.parseAndAnalyze(e,d),n=this.toArray(u.Syntax.GetDescendants(Kusto.Language.Syntax.QueryParametersStatement));if(!n||0==n.length)return Promise.resolve([]);var t=[];return n.forEach((function(e){e.WalkElements((function(e){return e.ReferencedSymbol&&e.ReferencedSymbol.Type?t.push({name:e.ReferencedSymbol.Name,type:e.ReferencedSymbol.Type.Name}):void 0}))})),Promise.resolve(t)},e.prototype.getRenderInfo=function(e,d){var u=this,n=this.parseAndAnalyze(e,d);if(!n)return Promise.resolve(void 0);var t=this.toArray(n.Syntax.GetDescendants(Kusto.Language.Syntax.RenderOperator));if(!t||0===t.length)return Promise.resolve(void 0);var a=t[0],r=a.TextStart,i=a.End,o=a.ChartType.ValueText,c=a.WithClause;if(!c){var s={options:{visualization:o},location:{startOffset:r,endOffset:i}};return Promise.resolve(s)}var f=this.toArray(c.Properties).reduce((function(e,d){var n=d.Element$1.Name.SimpleName;switch(n){case"xcolumn":var t=d.Element$1.Expression.ReferencedSymbol.Name;e[n]=t;break;case"ycolumns":case"anomalycolumns":var a=u.toArray(d.Element$1.Expression.Names).map((function(e){return e.Element$1.SimpleName}));e[n]=a;break;case"ymin":case"ymax":var r=parseFloat(d.Element$1.Expression.ConstantValue);e[n]=r;break;case"title":case"xtitle":case"ytitle":case"visualization":case"series":var i=d.Element$1.Expression.ConstantValue;e[n]=i;break;case"xaxis":case"yaxis":var o=d.Element$1.Expression.ConstantValue;e[n]=o;break;case"legend":var c=d.Element$1.Expression.ConstantValue;e[n]=c;break;case"ysplit":var s=d.Element$1.Expression.ConstantValue;e[n]=s;break;case"accumulate":var f=d.Element$1.Expression.ConstantValue;e[n]=f;break;case"kind":var m=d.Element$1.Expression.ConstantValue;e[n]=m;break;default:l(n)}return e}),{}),m={options:__assign({visualization:o},f),location:{startOffset:r,endOffset:i}};return Promise.resolve(m)},e.prototype.getReferencedGlobalParams=function(e,d){if(!e||!this.isIntellisenseV2())return Promise.resolve([]);var u=this.parseDocumentV2(e),n=this.getCurrentCommandV2(u,d);if(!n)return Promise.resolve([]);var t=n.Text,a=Kusto.Language.KustoCode.ParseAndAnalyze(t,this._kustoJsSchemaV2),r=this.toArray(this._kustoJsSchemaV2.Parameters),i=this.toArray(a.Syntax.GetDescendants(Kusto.Language.Syntax.Expression)).filter((function(e){return null!==e.ReferencedSymbol})).map((function(e){return e.ReferencedSymbol})).filter((function(e){return r.filter((function(d){return d===e})).length>0})).map((function(e){return{name:e.Name,type:e.Type.Name}}));return Promise.resolve(i)},e.prototype.getGlobalParams=function(e){if(!this.isIntellisenseV2())return Promise.resolve([]);var d=this.toArray(this._kustoJsSchemaV2.Parameters).map((function(e){return{name:e.Name,type:e.Type.Name}}));return Promise.resolve(d)},e.prototype.doRename=function(e,d,u){var t;if(!e||!this.isIntellisenseV2())return Promise.resolve(void 0);var a=this.parseDocumentV2(e),r=e.offsetAt(d),i=this.getCurrentCommandV2(a,r);if(!i)return Promise.resolve(void 0);var c=i.Service.GetRelatedElements(e.offsetAt(d)),s=this.toArray(c.Elements),f=s.filter((function(e){return e.Kind==o.RelatedElementKind.Declaration}));if(!f||0==f.length)return Promise.resolve(void 0);var l=s.map((function(d){var t=e.positionAt(d.Start),a=e.positionAt(d.End),r=n.Range.create(t,a);return n.TextEdit.replace(r,u)})),m={changes:(t={},t[e.uri]=l,t)};return Promise.resolve(m)},e.prototype.doHover=function(e,d){if(!e||!this.isIntellisenseV2())return Promise.resolve(void 0);var u=this.parseDocumentV2(e),n=e.offsetAt(d),t=this.getCurrentCommandV2(u,n);if(!t)return Promise.resolve(void 0);if(!t.Service.IsFeatureSupported(o.CodeServiceFeatures.QuickInfo,n))return Promise.resolve(void 0);var a=t.Service.GetQuickInfo(n);if(!a||!a.Items)return Promise.resolve(void 0);var r=this.toArray(a.Items);if(!r)return Promise.resolve(void 0);var i=(r=r.filter((function(e){return e.Kind!==o.QuickInfoKind.Error&&e.Kind!==o.QuickInfoKind.Suggestion&&e.Kind!==o.QuickInfoKind.Warning}))).map((function(e){return e.Text.replace("\n\n","\n* * *\n")})).join("\n* * *\n");return Promise.resolve({contents:i})},Object.defineProperty(e,"dummySchema",{get:function(){var e={majorVersion:0,minorVersion:0,name:"Kuskus",tables:[{name:"KustoLogs",columns:[{name:"Source",type:"string"},{name:"Timestamp",type:"datetime"},{name:"Directory",type:"string"}],docstring:"A dummy description to test that docstring shows as expected when hovering over a table"}],functions:[{name:"HowBig",inputParameters:[{name:"T",columns:[{name:"Timestamp",type:"System.DateTime",cslType:"datetime"}]}],docstring:"A dummy description to test that docstring shows as expected when hovering over a function",body:"{\r\n    union \r\n    (T | count | project V='Volume', Metric = strcat(Count/1e9, ' Billion records')),\r\n    (T | summarize FirstRecord=min(Timestamp)| project V='Volume', Metric = strcat(toint((now()-FirstRecord)/1d), ' Days of data (from: ', format_datetime(FirstRecord, 'yyyy-MM-dd'),')')),\r\n    (T | where Timestamp > ago(1h) | count | project V='Velocity', Metric = strcat(Count/1e6, ' Million records / hour')),\r\n    (T | summarize Latency=now()-max(Timestamp) | project V='Velocity', Metric = strcat(Latency / 1sec, ' seconds latency')),\r\n    (T | take 1 | project V='Variety', Metric=tostring(pack_all()))\r\n    | order by V \r\n}"},{name:"FindCIDPast24h",inputParameters:[{name:"clientActivityId",type:"System.String",cslType:"string"}],body:"{ KustoLogs | where Timestamp > now(-1d) | where ClientActivityId == clientActivityId}   "}]};return{clusterType:"Engine",cluster:{connectionString:"https://kuskus.kusto.windows.net;fed=true",databases:[e]},database:e}},enumerable:!1,configurable:!0}),e.convertToEntityDataType=function(e){},e.convertToKustoJsSchema=function(e){switch(e.clusterType){case"Engine":var d=e.database?e.database.name:void 0,n=new r.KustoIntelliSenseClusterEntity,t=void 0;n.ConnectionString=e.cluster.connectionString;var i=[];return e.cluster.databases.forEach((function(e){var n=new r.KustoIntelliSenseDatabaseEntity;n.Name=e.name;var o=[];e.tables.forEach((function(e){var d=new r.KustoIntelliSenseTableEntity;d.Name=e.name;var u=[];e.columns.forEach((function(e){var d=new r.KustoIntelliSenseColumnEntity;d.Name=e.name,d.TypeCode=r.EntityDataType[a.getEntityDataTypeFromCslType(e.type)],u.push(d)})),d.Columns=new Bridge.ArrayEnumerable(u),o.push(d)}));var c=[];e.functions.forEach((function(e){var d=new r.KustoIntelliSenseFunctionEntity;d.Name=e.name,d.CallName=u.getCallName(e),d.Expression=u.getExpression(e),c.push(d)})),n.Tables=new Bridge.ArrayEnumerable(o),n.Functions=new Bridge.ArrayEnumerable(c),i.push(n),e.name==d&&(t=n)})),n.Databases=new Bridge.ArrayEnumerable(i),new r.KustoIntelliSenseQuerySchema(n,t);case"ClusterManager":return{accounts:e.accounts.map((function(e){var d=new r.KustoIntelliSenseAccountEntity;return d.Name=e,d})),services:e.services.map((function(e){var d=new r.KustoIntelliSenseServiceEntity;return d.Name=e,d})),connectionString:e.connectionString};case"DataManagement":return;default:return l(e)}},e.scalarParametersToSignature=function(e){return"("+e.map((function(e){return e.name+": "+e.cslType})).join(", ")+")"},e.inputParameterToSignature=function(e){var d=this;return"("+e.map((function(e){if(e.columns){var u=d.scalarParametersToSignature(e.columns);return e.name+": "+u}return e.name+": "+e.cslType})).join(", ")+")"},e.toLetStatement=function(e){var d=this.inputParameterToSignature(e.inputParameters);return"let "+e.name+" = "+d+" "+e.body},e.createColumnSymbol=function(e){return new c.ColumnSymbol(e.name,c.ScalarTypes.GetSymbol(a.getCslTypeNameFromClrType(e.type)),e.docstring)},e.createParameterSymbol=function(e){var d=Kusto.Language.Symbols.ScalarTypes.GetSymbol(a.getCslTypeNameFromClrType(e.type));return new c.ParameterSymbol(e.name,d,null)},e.createParameter=function(d){if(!d.columns){var u=Kusto.Language.Symbols.ScalarTypes.GetSymbol(a.getCslTypeNameFromClrType(d.type)),n=d.cslDefaultValue&&"string"==typeof d.cslDefaultValue?i.QueryParser.ParseLiteral$1(d.cslDefaultValue):void 0;return new c.Parameter.$ctor3(d.name,u,null,null,null,!1,null,1,1,n,null)}if(0==d.columns.length)return new c.Parameter.ctor(d.name,c.ParameterTypeKind.Tabular,c.ArgumentKind.Expression,null,null,!1,null,1,1,null,null);var t=new c.TableSymbol.ctor(d.columns.map((function(d){return e.createColumnSymbol(d)})));return new c.Parameter.$ctor2(d.name,t)},e.convertToDatabaseSymbol=function(d){return function(d){var u=d.tables?d.tables.map((function(d){return function(d){var u,n=d.columns.map((function(d){return e.createColumnSymbol(d)})),t=new c.TableSymbol.$ctor4(d.name,n);switch(t.Description=d.docstring,d.entityType){case"MaterializedViewTable":var a=null!==(u=d.mvQuery)&&void 0!==u?u:null;t=(t=new c.MaterializedViewSymbol.$ctor2(d.name,t.Columns,a,d.docstring)).WithIsMaterializedView(!0);break;case"ExternalTable":t=t.WithIsExternal(!0)}return t}(d)})):[],n=d.functions?d.functions.map((function(d){return n=(u=d).inputParameters.map((function(d){return e.createParameter(d)})),new c.FunctionSymbol.$ctor16(u.name,u.body,e.toBridgeList(n),u.docstring);var u,n})):[];return new c.DatabaseSymbol.ctor(d.name,u.concat(n))}(d)},e.prototype.convertToKustoJsSchemaV2=function(d){var u=this._schemaCache[d.cluster.connectionString];u||(this._schemaCache[d.cluster.connectionString]={},u=this._schemaCache[d.cluster.connectionString]);var n=d.cluster.databases.reduce((function(e,d){return e[d.name]=d}),{});Object.keys(u).map((function(e){n[e]||delete u.dbName}));var t=s.Default,a=d.database?d.database.name:void 0,r=void 0,i=d.cluster.databases.map((function(d){var n=d.name===a,t=u[d.name];if(!t||t.database.majorVersion<d.majorVersion||n&&!t.includesFunctions){var i=e.convertToDatabaseSymbol(d);u[d.name]={database:d,symbol:i,includesFunctions:n}}var o=u[d.name].symbol;return d.name===a&&(r=o),o})),o=d.cluster.connectionString.match(/(.*\/\/)?([^\/;]*)/)[2].split(".")[0],f=new c.ClusterSymbol.ctor(o,i);if(t=t.WithCluster(f),r&&(t=t.WithDatabase(r)),d.globalParameters){var l=d.globalParameters.map((function(d){return e.createParameterSymbol(d)}));t=t.WithParameters(e.toBridgeList(l))}return t},e.prototype.getClassificationsFromParseResult=function(e){var d=this;return void 0===e&&(e=0),this.toArray(this._parser.Results).map((function(e){return d.toArray(e.Tokens)})).reduce((function(e,d){return e.concat(d)}),[]).map((function(u){return new o.ClassifiedRange(d.tokenKindToClassificationKind(u.TokenKind),u.AbsoluteStart+e,u.Length)}))},e.trimTrailingNewlineFromRange=function(e,d,u,t){for(var a=e.length-1;"\r"===e[a]||"\n"===e[a];)--a;var r=d+a+1,i=u.positionAt(r);return n.Range.create(t.start,i)},e.prototype.getSortText=function(e){if(e<=0)throw new RangeError("order should be a number >= 1. instead got "+e);for(var d="",u=Math.floor(e/26),n=0;n<u;++n)d+="z";var t=e%26;return t>0&&(d+=String.fromCharCode(96+t)),d},e.prototype.parseTextV1=function(e,d){this._parser.Parse("Engine"===this._schema.clusterType?this._rulesProvider:null,e,d)},e.prototype.parseDocumentV1=function(e,d){this._parsePropertiesV1&&!this._parsePropertiesV1.isParseNeeded(e,this._rulesProvider,d)||(this.parseTextV1(e.getText(),d),this._parsePropertiesV1=new p(e.version,e.uri,this._rulesProvider,d))},e.prototype.parseDocumentV2=function(e){return this._parsePropertiesV2&&!this._parsePropertiesV2.isParseNeeded(e,this._rulesProvider)||(this._script?this._script=this._script.WithText(e.getText()):this._script=o.CodeScript.From$1(e.getText(),this._kustoJsSchemaV2),this._parsePropertiesV2=new p(e.version,e.uri)),this._script},e.prototype.getCurrentCommand=function(e,d){var u=this.toArray(this._parser.Results),n=u.filter((function(e){return e.AbsoluteStart<=d&&e.AbsoluteEnd>=d}))[0];return n||(n=u.filter((function(e){return e.AbsoluteStart<=d&&e.AbsoluteEnd+1>=d}))[0])&&!n.Text.endsWith("\r\n\r\n")?n:null},e.prototype.getCurrentCommandV2=function(e,d){return e.GetBlockAtPosition(d)},e.prototype.getTextToInsert=function(e,d){var u=e.GetBeforeApplyInfo(d.Value),t=e.GetAfterApplyInfo(d.Value),a=u.Text||""+d.Value+t.Text||"",r=n.InsertTextFormat.PlainText;if(t.OffsetToken&&t.OffsetPosition){var i=a.indexOf(t.OffsetToken);i>=0&&(a=this.insertToString(a,"$0",i-a.length+t.OffsetPosition),r=n.InsertTextFormat.Snippet)}else t.OffsetPosition&&(a=this.insertToString(a,"$0",t.OffsetPosition),r=n.InsertTextFormat.Snippet);return{insertText:a,insertTextFormat:r}},e.prototype.insertToString=function(e,d,u){var n=e.length+u;return u>=0||n<0?e:e.substring(0,n)+d+e.substring(n)},e.prototype.getCommandWithoutLastWord=function(e){var d=t("[\\w_]*$","s");return e.replace(d,"")},e.prototype.createRulesProvider=function(e,d){var u=new(f(String)),n=new(f(String));if(this._parser=new r.CslCommandParser,"Engine"!=d)if("DataManagement"!==d){var t=e,a=t.accounts,i=t.services,o=t.connectionString;new r.KustoIntelliSenseAccountEntity,new r.KustoIntelliSenseServiceEntity,this._rulesProvider=new r.ClusterManagerIntelliSenseRulesProvider.$ctor1(new Bridge.ArrayEnumerable(a),new Bridge.ArrayEnumerable(i),o)}else this._rulesProvider=new r.DataManagerIntelliSenseRulesProvider(null);else{var c=e;this._rulesProvider=this._languageSettings&&this._languageSettings.includeControlCommands?new r.CslIntelliSenseRulesProvider.$ctor1(c.Cluster,c,u,n,null,!0,!0):new r.CslQueryIntelliSenseRulesProvider.$ctor1(c.Cluster,c,u,n,null,null,null)}},e.prototype.kustoKindToLsKind=function(e){return this._kustoKindtolsKind[e]||n.CompletionItemKind.Variable},e.prototype.kustoKindToLsKindV2=function(e){return this._kustoKindToLsKindV2[e]||n.CompletionItemKind.Variable},e.prototype.createRange=function(e,d,u){return n.Range.create(e.positionAt(d),e.positionAt(u))},e.prototype.toArray=function(e){return Bridge.toArray(e)},e.toBridgeList=function(e){return new(System.Collections.Generic.List$1(System.Object).$ctor1)(e)},e.prototype.tokenKindToClassificationKind=function(e){return this._tokenKindToClassificationKind[e]||o.ClassificationKind.PlainText},e.prototype.parseAndAnalyze=function(e,d){if(e&&this.isIntellisenseV2()){var u=this.parseDocumentV2(e),n=this.getCurrentCommandV2(u,d);if(n){var t=n.Text;return Kusto.Language.KustoCode.ParseAndAnalyze(t,this._kustoJsSchemaV2)}}},e}(),h=new b(b.dummySchema,{includeControlCommands:!0,useIntellisenseV2:!0,useSemanticColorization:!0});d.getKustoLanguageService=function(){return h}})),define("vs/language/kusto/kustoWorker",["require","exports","./languageService/kustoLanguageService","vscode-languageserver-types"],(function(e,d,u,n){"use strict";Object.defineProperty(d,"__esModule",{value:!0}),d.create=d.KustoWorker=void 0;var t=function(){function e(e,d){this._ctx=e,this._languageSettings=d.languageSettings,this._languageService=u.getKustoLanguageService(),this._languageService.configure(this._languageSettings)}return e.prototype.setSchema=function(e){return this._languageService.setSchema(e)},e.prototype.addClusterToSchema=function(e,d,u){var n=this._getTextDocument(e);return n?this._languageService.addClusterToSchema(n,d,u):(console.error("addClusterToSchema: document is "+n+". uri is "+e),Promise.resolve())},e.prototype.addDatabaseToSchema=function(e,d,u){var n=this._getTextDocument(e);return n?this._languageService.addDatabaseToSchema(n,d,u):(console.error("addDatabaseToSchema: document is "+n+". uri is "+e),Promise.resolve())},e.prototype.setSchemaFromShowSchema=function(e,d,u){return this._languageService.setSchemaFromShowSchema(e,d,u)},e.prototype.normalizeSchema=function(e,d,u){return this._languageService.normalizeSchema(e,d,u)},e.prototype.getSchema=function(){return this._languageService.getSchema()},e.prototype.getCommandInContext=function(e,d){var u=this._getTextDocument(e);if(!u)return console.error("getCommandInContext: document is "+u+". uri is "+e),null;var n=this._languageService.getCommandInContext(u,d);return void 0===n?null:n},e.prototype.getQueryParams=function(e,d){var u=this._getTextDocument(e);if(!u)return console.error("getQueryParams: document is "+u+". uri is "+e),null;var n=this._languageService.getQueryParams(u,d);return void 0===n?null:n},e.prototype.getGlobalParams=function(e){var d=this._getTextDocument(e);if(!d)return console.error("getGLobalParams: document is "+d+". uri is "+e),null;var u=this._languageService.getGlobalParams(d);return void 0===u?null:u},e.prototype.getReferencedGlobalParams=function(e,d){var u=this._getTextDocument(e);if(!u)return console.error("getReferencedGlobalParams: document is "+u+". uri is "+e),null;var n=this._languageService.getReferencedGlobalParams(u,d);return void 0===n?null:n},e.prototype.getRenderInfo=function(e,d){var u=this._getTextDocument(e);return u||console.error("getRenderInfo: document is "+u+". uri is "+e),this._languageService.getRenderInfo(u,d).then((function(e){return e||null}))},e.prototype.getCommandAndLocationInContext=function(e,d){var u=this._getTextDocument(e);return u?this._languageService.getCommandAndLocationInContext(u,d).then((function(e){if(!e)return null;var d=e.text,u=e.location.range,n=u.start,t=u.end;return{range:new monaco.Range(n.line+1,n.character+1,t.line+1,t.character+1),text:d}})):(console.error("getCommandAndLocationInContext: document is "+u+". uri is "+e),Promise.resolve(null))},e.prototype.getCommandsInDocument=function(e){var d=this._getTextDocument(e);return d?this._languageService.getCommandsInDocument(d):(console.error("getCommandInDocument: document is "+d+". uri is "+e),null)},e.prototype.doComplete=function(e,d){var u=this._getTextDocument(e);return u?this._languageService.doComplete(u,d):null},e.prototype.doValidation=function(e,d,u,n){var t=this._getTextDocument(e);return this._languageService.doValidation(t,d,u,n)},e.prototype.doRangeFormat=function(e,d){var u=this._getTextDocument(e);return this._languageService.doRangeFormat(u,d)},e.prototype.doFolding=function(e){var d=this._getTextDocument(e);return this._languageService.doFolding(d)},e.prototype.doDocumentFormat=function(e){var d=this._getTextDocument(e);return this._languageService.doDocumentFormat(d)},e.prototype.doCurrentCommandFormat=function(e,d){var u=this._getTextDocument(e);return this._languageService.doCurrentCommandFormat(u,d)},e.prototype.doColorization=function(e,d){var u=this._getTextDocument(e);return this._languageService.doColorization(u,d)},e.prototype.getClientDirective=function(e){return this._languageService.getClientDirective(e)},e.prototype.getAdminCommand=function(e){return this._languageService.getAdminCommand(e)},e.prototype.findDefinition=function(e,d){var u=this._getTextDocument(e);return this._languageService.findDefinition(u,d)},e.prototype.findReferences=function(e,d){var u=this._getTextDocument(e);return this._languageService.findReferences(u,d)},e.prototype.doRename=function(e,d,u){var n=this._getTextDocument(e);return this._languageService.doRename(n,d,u)},e.prototype.doHover=function(e,d){var u=this._getTextDocument(e);return this._languageService.doHover(u,d)},e.prototype.setParameters=function(e){return this._languageService.setParameters(e)},e.prototype.getClusterReferences=function(e,d){var u=this._getTextDocument(e);return u?this._languageService.getClusterReferences(u,d):Promise.resolve(null)},e.prototype.getDatabaseReferences=function(e,d){var u=this._getTextDocument(e);return u?this._languageService.getDatabaseReferences(u,d):Promise.resolve(null)},e.prototype._getTextDocument=function(e){for(var d=0,u=this._ctx.getMirrorModels();d<u.length;d++){var t=u[d];if(t.uri.toString()===e)return n.TextDocument.create(e,this._languageId,t.version,t.getValue())}return null},e}();d.KustoWorker=t,d.create=function(e,d){return new t(e,d)}}));