/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.CountingStream;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class SET
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 17L);
    protected static final Form FORM = Form.CONSTRUCTED;
    protected Vector<Element> elements = new Vector();

    @Override
    public Tag getTag() {
        return TAG;
    }

    private void addElement(Element e) {
        this.elements.addElement(e);
    }

    private void insertElementAt(Element e, int index) {
        this.elements.insertElementAt(e, index);
    }

    public void addElement(ASN1Value v) {
        this.addElement(new Element(v));
    }

    public void addElement(Tag implicitTag, ASN1Value v) {
        this.addElement(new Element(implicitTag, v));
    }

    public void insertElementAt(ASN1Value v, int index) {
        this.insertElementAt(new Element(v), index);
    }

    public void insertElementAt(Tag implicitTag, ASN1Value v, int index) {
        this.insertElementAt(new Element(implicitTag, v), index);
    }

    public ASN1Value elementAt(int index) {
        return this.elements.elementAt(index).getValue();
    }

    public Tag tagAt(int index) {
        Tag implicit = this.elements.elementAt(index).getImplicitTag();
        return implicit == null ? this.elementAt(index).getTag() : implicit;
    }

    public ASN1Value elementWithTag(Tag tag) {
        int size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            Element e = this.elements.elementAt(i);
            if (!e.getTag().equals(tag)) continue;
            return e.getValue();
        }
        return null;
    }

    public int size() {
        return this.elements.size();
    }

    public void removeAllElements() {
        this.elements.removeAllElements();
    }

    public void removeElementAt(int index) {
        this.elements.removeElementAt(index);
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        int i;
        boolean lexOrdering = this.elements.size() < 2 ? true : this.tagAt(0).equals(this.tagAt(1));
        int numElements = this.elements.size();
        int totalBytes = 0;
        Vector<byte[]> encodings = new Vector<byte[]>(numElements);
        Vector<Integer> tags = new Vector<Integer>(numElements);
        for (i = 0; i < numElements; ++i) {
            if (this.elementAt(i) == null) continue;
            byte[] enc = ASN1Util.encode(this.tagAt(i), this.elementAt(i));
            totalBytes += enc.length;
            if (lexOrdering) {
                SET.insertInOrder(encodings, enc);
                continue;
            }
            SET.insertInOrder(encodings, enc, tags, (int)this.tagAt(i).getNum());
        }
        ASN1Header header = new ASN1Header(implicitTag, FORM, totalBytes);
        header.encode(ostream);
        for (i = 0; i < numElements; ++i) {
            ostream.write((byte[])encodings.elementAt(i));
        }
    }

    public void BERencode(Tag implicitTag, OutputStream ostream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            ASN1Value el = this.elementAt(i);
            if (el == null) continue;
            el.encode(this.tagAt(i), bos);
        }
        byte[] bytes = bos.toByteArray();
        ASN1Header header = new ASN1Header(implicitTag, FORM, bytes.length);
        header.encode(ostream);
        ostream.write(bytes);
    }

    private static void insertInOrder(Vector<byte[]> encs, byte[] enc) {
        int i;
        int size = encs.size();
        for (i = 0; i < size && SET.compare(enc, encs.elementAt(i)) >= 1; ++i) {
        }
        encs.insertElementAt(enc, i);
    }

    private static void insertInOrder(Vector<byte[]> encs, byte[] enc, Vector<Integer> tags, int tag) {
        int i;
        int size = encs.size();
        for (i = 0; i < size && tag > tags.elementAt(i); ++i) {
        }
        encs.insertElementAt(enc, i);
        tags.insertElementAt(i, i);
    }

    private static int compare(byte[] left, byte[] right) {
        int min = left.length < right.length ? left.length : right.length;
        for (int i = 0; i < min; ++i) {
            if ((left[i] & 0xFF) < (right[i] & 0xFF)) {
                return -1;
            }
            if ((left[i] & 0xFF) <= (right[i] & 0xFF)) continue;
            return 1;
        }
        if (left.length > min) {
            assert (right.length == min);
            return 1;
        }
        if (right.length > min) {
            assert (left.length == min);
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        block12: {
            try {
                if (args.length > 0) {
                    SET st;
                    Template t = new Template();
                    t.addElement(new Tag(0L), new INTEGER.Template());
                    t.addElement(new Tag(3L), new INTEGER.Template());
                    t.addOptionalElement(new Tag(4L), new INTEGER.Template());
                    t.addElement(new Tag(5L), new INTEGER.Template(), new INTEGER(67L));
                    t.addElement(new Tag(29L), new BOOLEAN.Template());
                    t.addElement(new Tag(30L), new BOOLEAN.Template(), new BOOLEAN(false));
                    t.addElement(new Tag(1L), new INTEGER.Template());
                    t.addElement(new Tag(2L), new INTEGER.Template());
                    FileInputStream fin = new FileInputStream(args[0]);
                    try (BufferedInputStream is = new BufferedInputStream(fin);){
                        st = (SET)t.decode(is);
                    }
                    for (int i = 0; i < st.size(); ++i) {
                        ASN1Value v = st.elementAt(i);
                        if (v instanceof INTEGER) {
                            INTEGER in = (INTEGER)st.elementAt(i);
                            System.out.println("INTEGER: " + in);
                            continue;
                        }
                        if (v instanceof BOOLEAN) {
                            BOOLEAN bo = (BOOLEAN)st.elementAt(i);
                            System.out.println("BOOLEAN: " + bo);
                            continue;
                        }
                        System.out.println("Unknown value");
                    }
                    break block12;
                }
                SET s = new SET();
                s.addElement(new Tag(0L), new INTEGER(255L));
                s.addElement(new Tag(29L), new BOOLEAN(true));
                s.addElement(new Tag(1L), new INTEGER(-322L));
                s.addElement(new Tag(2L), new INTEGER(0L));
                s.addElement(new Tag(3L), new INTEGER("623423948273"));
                s.encode(System.out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class Element {
        private ASN1Value val;
        private Tag implicitTag = null;

        public Element(ASN1Value val) {
            this.val = val;
        }

        public Element(Tag implicitTag, ASN1Value val) {
            this.val = val;
            this.implicitTag = implicitTag;
        }

        public ASN1Value getValue() {
            return this.val;
        }

        public Tag getTag() {
            return this.implicitTag == null ? this.val.getTag() : this.implicitTag;
        }

        public Tag getImplicitTag() {
            return this.implicitTag;
        }
    }

    public static class Template
    implements ASN1Template {
        private Vector<Element> elements = new Vector();

        private void addElement(Element e) {
            this.elements.addElement(e);
        }

        private void insertElementAt(Element e, int index) {
            this.elements.insertElementAt(e, index);
        }

        public void addElement(ASN1Template t) {
            this.addElement(new Element(TAG, t, false));
        }

        public void insertElementAt(ASN1Template t, int index) {
            this.insertElementAt(new Element(TAG, t, false), index);
        }

        public void addElement(Tag implicit, ASN1Template t) {
            this.addElement(new Element(implicit, t, false));
        }

        public void insertElementAt(Tag implicit, ASN1Template t, int index) {
            this.insertElementAt(new Element(implicit, t, false), index);
        }

        public void addOptionalElement(ASN1Template t) {
            this.addElement(new Element(TAG, t, true));
        }

        public void insertOptionalElementAt(ASN1Template t, int index) {
            this.insertElementAt(new Element(null, t, true), index);
        }

        public void addOptionalElement(Tag implicit, ASN1Template t) {
            this.addElement(new Element(implicit, t, true));
        }

        public void insertOptionalElementAt(Tag implicit, ASN1Template t, int index) {
            this.insertElementAt(new Element(implicit, t, true), index);
        }

        public void addElement(ASN1Template t, ASN1Value def) {
            this.addElement(new Element(TAG, t, def));
        }

        public void insertElementAt(ASN1Template t, ASN1Value def, int index) {
            this.insertElementAt(new Element(null, t, def), index);
        }

        public void addElement(Tag implicit, ASN1Template t, ASN1Value def) {
            this.addElement(new Element(implicit, t, def));
        }

        public void insertElementAt(Tag implicit, ASN1Template t, ASN1Value def, int index) {
            this.insertElementAt(new Element(implicit, t, def), index);
        }

        public Tag implicitTagAt(int index) {
            return this.elements.elementAt(index).getImplicitTag();
        }

        public ASN1Template templateAt(int index) {
            return this.elements.elementAt(index).getTemplate();
        }

        public boolean isOptionalAt(int index) {
            return this.elements.elementAt(index).isOptional();
        }

        private boolean isRepeatableAt(int index) {
            return this.elements.elementAt(index).isRepeatable();
        }

        public ASN1Value defaultAt(int index) {
            return this.elements.elementAt(index).getDefault();
        }

        public int size() {
            return this.elements.size();
        }

        public void removeAllElements() {
            this.elements.removeAllElements();
        }

        public void removeElementAt(int index) {
            this.elements.removeElementAt(index);
        }

        private Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), istream);
        }

        @Override
        public ASN1Value decode(Tag tag, InputStream istream) throws IOException, InvalidBERException {
            try {
                ASN1Header header = new ASN1Header(istream);
                header.validate(tag, Form.CONSTRUCTED);
                long remainingContent = header.getContentLength();
                SET set = new SET();
                boolean[] found = new boolean[this.elements.size()];
                while (remainingContent > 0L || remainingContent == -1L) {
                    ASN1Value val;
                    ASN1Header lookAhead = ASN1Header.lookAhead(istream);
                    if (lookAhead.isEOC()) {
                        if (remainingContent != -1L) {
                            throw new InvalidBERException("Unexpected end-of-contentmarker");
                        }
                        lookAhead = new ASN1Header(istream);
                        break;
                    }
                    int index = this.findElementByTag(lookAhead.getTag());
                    if (index == -1) {
                        throw new InvalidBERException("Unexpected Tag in SET: " + lookAhead.getTag());
                    }
                    Element e = this.elements.elementAt(index);
                    if (found[index] && !e.isRepeatable()) {
                        throw new InvalidBERException("Duplicate Tag in SET: " + lookAhead.getTag());
                    }
                    found[index] = true;
                    ASN1Template t = e.getTemplate();
                    try (CountingStream countstream = new CountingStream(istream);){
                        val = e.getImplicitTag() == null ? t.decode(countstream) : t.decode(e.getImplicitTag(), countstream);
                        long len = countstream.getNumRead();
                        if (remainingContent != -1L) {
                            if (remainingContent < len) {
                                throw new InvalidBERException("Item went " + (len - remainingContent) + " bytes past the end of the SET");
                            }
                            remainingContent -= len;
                        }
                    }
                    org.mozilla.jss.asn1.SET$Element se = e.getImplicitTag() == null ? new org.mozilla.jss.asn1.SET$Element(val) : new org.mozilla.jss.asn1.SET$Element(e.getImplicitTag(), val);
                    set.addElement(se);
                }
                assert (remainingContent == 0L || remainingContent == -1L);
                int size = this.elements.size();
                for (int i = 0; i < size; ++i) {
                    if (found[i] || this.isOptionalAt(i) || this.isRepeatableAt(i)) continue;
                    if (this.defaultAt(i) != null) {
                        set.addElement(new org.mozilla.jss.asn1.SET$Element(this.defaultAt(i)));
                        continue;
                    }
                    throw new InvalidBERException("Field not found in SET");
                }
                return set;
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "SET");
            }
        }

        private int findElementByTag(Tag tag) {
            int size = this.elements.size();
            for (int i = 0; i < size; ++i) {
                Element e = this.elements.elementAt(i);
                if (!e.tagMatch(tag)) continue;
                return i;
            }
            return -1;
        }

        public static class Element {
            private boolean repeatable;
            private boolean optional;
            private Tag implicitTag = null;
            private ASN1Template type;
            private ASN1Value defaultVal = null;

            public Element(Tag implicitTag, ASN1Template type, boolean optional) {
                this.type = type;
                this.defaultVal = null;
                this.optional = optional;
                this.implicitTag = implicitTag;
            }

            public Element(Tag implicitTag, ASN1Template type, ASN1Value defaultVal) {
                this.type = type;
                this.defaultVal = defaultVal;
                this.optional = false;
                this.implicitTag = implicitTag;
            }

            void makeRepeatable() {
                this.repeatable = true;
            }

            boolean isRepeatable() {
                return this.repeatable;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public Tag getImplicitTag() {
                return this.implicitTag;
            }

            public boolean tagMatch(Tag tag) {
                return this.implicitTag == null ? this.type.tagMatch(tag) : this.implicitTag.equals(tag);
            }

            public ASN1Template getTemplate() {
                return this.type;
            }

            public ASN1Value getDefault() {
                return this.defaultVal;
            }
        }
    }

    public static class OF_Template
    implements ASN1Template {
        private Template template = new Template();

        public OF_Template(ASN1Template type) {
            Template.Element el = new Template.Element(null, type, false);
            el.makeRepeatable();
            this.template.addElement(el);
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.template.decode(istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.template.decode(implicitTag, istream);
        }
    }
}

