/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Cert;

public interface SSLCertificateApprovalCallback {
    public boolean approve(X509Certificate var1, ValidityStatus var2);

    public static class ValidityItem {
        private int reason;
        private int depth;
        private PK11Cert cert;

        public ValidityItem(int reason, PK11Cert cert, int depth) {
            this.reason = reason;
            this.cert = cert;
            this.depth = depth;
        }

        public int getReason() {
            return this.reason;
        }

        public int getDepth() {
            return this.depth;
        }

        public PK11Cert getCert() {
            return this.cert;
        }
    }

    public static class ValidityStatus {
        public static final int EXPIRED_CERTIFICATE = -8181;
        public static final int REVOKED_CERTIFICATE = -8180;
        public static final int INADEQUATE_KEY_USAGE = -8102;
        public static final int INADEQUATE_CERT_TYPE = -8101;
        public static final int UNTRUSTED_CERT = -8171;
        public static final int CERT_STATUS_SERVER_ERROR = -8077;
        public static final int UNKNOWN_ISSUER = -8179;
        public static final int UNTRUSTED_ISSUER = -8172;
        public static final int CERT_NOT_IN_NAME_SPACE = -8080;
        public static final int CA_CERT_INVALID = -8156;
        public static final int PATH_LEN_CONSTRAINT_INVALID = -8155;
        public static final int BAD_KEY = -8178;
        public static final int BAD_SIGNATURE = -8182;
        public static final int EXPIRED_ISSUER_CERTIFICATE = -8162;
        public static final int INVALID_TIME = -8184;
        public static final int UNKNOWN_SIGNER = -8076;
        public static final int SEC_ERROR_CRL_EXPIRED = -8161;
        public static final int SEC_ERROR_CRL_BAD_SIGNATURE = -8160;
        public static final int SEC_ERROR_CRL_INVALID = -8159;
        public static final int CERT_BAD_ACCESS_LOCATION = -8075;
        public static final int OCSP_UNKNOWN_RESPONSE_TYPE = -8074;
        public static final int OCSP_BAD_HTTP_RESPONSE = -8073;
        public static final int OCSP_MALFORMED_REQUEST = -8072;
        public static final int OCSP_SERVER_ERROR = -8071;
        public static final int OCSP_TRY_SERVER_LATER = -8070;
        public static final int OCSP_REQUEST_NEEDS_SIG = -8069;
        public static final int OCSP_UNAUTHORIZED_REQUEST = -8068;
        public static final int OCSP_UNKNOWN_RESPONSE_STATUS = -8067;
        public static final int OCSP_UNKNOWN_CERT = -8066;
        public static final int OCSP_NOT_ENABLED = -8065;
        public static final int OCSP_NO_DEFAULT_RESPONDER = -8064;
        public static final int OCSP_MALFORMED_RESPONSE = -8063;
        public static final int OCSP_UNAUTHORIZED_RESPONSE = -8062;
        public static final int OCSP_FUTURE_RESPONSE = -8061;
        public static final int OCSP_OLD_RESPONSE = -8060;
        public static final int BAD_CERT_DOMAIN = -12276;
        private Vector<ValidityItem> reasons = new Vector();

        public void addReason(int newReason, PK11Cert cert, int depth) {
            ValidityItem status = new ValidityItem(newReason, cert, depth);
            this.reasons.addElement(status);
        }

        public Enumeration<ValidityItem> getReasons() {
            return this.reasons.elements();
        }
    }
}

