/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import netscape.ldap.ber.stream.BEROctetString;

public class JDAPFilterOpers {
    private static final String escapeKey = "\\";
    private static final boolean m_debug = false;

    static BEROctetString getOctetString(String str) {
        if (str.indexOf(escapeKey) >= 0) {
            byte[] byteVal = JDAPFilterOpers.getByteValues(str);
            return new BEROctetString(byteVal);
        }
        return new BEROctetString(str);
    }

    public static String convertLDAPv2Escape(String filter) {
        if (filter.indexOf(92) < 0) {
            return filter;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int start = 0;
        int len = filter.length();
        while (start < len && (i = filter.indexOf(92, start)) >= 0) {
            sb.append(filter.substring(start, i + 1));
            try {
                char c = filter.charAt(i + 1);
                if (c >= ' ' && c < '\u007f' && !JDAPFilterOpers.isHexDigit(c)) {
                    sb.append(Integer.toHexString(c));
                } else {
                    sb.append(c);
                }
                start = i + 2;
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Bad search filter");
            }
        }
        if (start < len) {
            sb.append(filter.substring(start));
        }
        return sb.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    static byte[] getByteValues(String str) {
        byte[] b;
        int pos = 0;
        Vector<byte[]> v = new Vector<byte[]>();
        String val = new String(str);
        int totalSize = 0;
        while ((pos = val.indexOf(escapeKey)) >= 0) {
            String s1 = val.substring(0, pos);
            try {
                byte[] b2 = s1.getBytes("UTF8");
                totalSize += b2.length;
                v.addElement(b2);
            }
            catch (UnsupportedEncodingException e) {
                JDAPFilterOpers.printDebug(e.toString());
                return null;
            }
            Integer num = null;
            try {
                String hex = "0x" + val.substring(pos + 1, pos + 3);
                num = Integer.decode(hex);
            }
            catch (IndexOutOfBoundsException e) {
                JDAPFilterOpers.printDebug(e.toString());
                throw new IllegalArgumentException("Bad search filter");
            }
            catch (NumberFormatException e) {
                JDAPFilterOpers.printDebug(e.toString());
                throw new IllegalArgumentException("Bad search filter");
            }
            b = new byte[]{(byte)num.intValue()};
            totalSize += b.length;
            v.addElement(b);
            val = val.substring(pos + 3);
        }
        if (val.length() > 0) {
            try {
                byte[] b3 = val.getBytes("UTF8");
                totalSize += b3.length;
                v.addElement(b3);
            }
            catch (UnsupportedEncodingException e) {
                JDAPFilterOpers.printDebug(e.toString());
                return null;
            }
        }
        byte[] result = new byte[totalSize];
        pos = 0;
        for (int i = 0; i < v.size(); ++i) {
            b = (byte[])v.elementAt(i);
            System.arraycopy(b, 0, result, pos, b.length);
            pos += b.length;
        }
        return result;
    }

    private static void printDebug(String str) {
    }
}

