/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.base;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509Key;

public class KeyGenInfo {
    private String mSPKACString;
    private byte[] mPKAC;
    private byte[] mSPKAC;
    private X509Key mSPKI;
    private DerValue mDerSPKI;
    private String mChallenge;
    private DerValue mDerChallenge;
    private byte[] mSignature;
    private AlgorithmId mAlgId;

    public KeyGenInfo() {
    }

    public KeyGenInfo(String spkac) throws IOException {
        this.decode(spkac);
    }

    public void decode(String spkac) throws IOException {
        this.mSPKACString = spkac;
        this.mSPKAC = this.base64Decode(spkac);
        this.derDecode(this.mSPKAC);
    }

    public byte[] encode() {
        return this.mSPKAC;
    }

    public DerValue getDerSPKI() {
        return this.mDerSPKI;
    }

    public X509Key getSPKI() {
        return this.mSPKI;
    }

    public DerValue getDerChallenge() {
        return this.mDerChallenge;
    }

    public String getChallenge() {
        return this.mChallenge;
    }

    public byte[] getSignature() {
        return this.mSignature;
    }

    public AlgorithmId getAlgorithmId() {
        return this.mAlgId;
    }

    public boolean validateChallenge(String challenge) {
        return challenge == null || challenge.equals(this.mChallenge);
    }

    public String toString() {
        if (this.mSPKACString != null) {
            return this.mSPKACString;
        }
        return "";
    }

    private byte[] base64Decode(String spkac) throws IOException {
        return Utils.base64decode((String)spkac);
    }

    private void derDecode(byte[] spkac) throws IOException {
        DerInputStream derIn = new DerInputStream(spkac);
        DerValue[] derSPKACContent = derIn.getSequence(3);
        this.mAlgId = AlgorithmId.parse((DerValue)derSPKACContent[1]);
        this.mSignature = derSPKACContent[2].getBitString();
        this.mPKAC = derSPKACContent[0].toByteArray();
        derIn = new DerInputStream(this.mPKAC);
        DerValue[] derPKACContent = derIn.getSequence(2);
        this.mDerSPKI = derPKACContent[0];
        this.mSPKI = X509Key.parse((DerValue)derPKACContent[0]);
        this.mDerChallenge = derPKACContent[1];
        if (this.mDerChallenge.length() != 0) {
            this.mChallenge = derPKACContent[1].getIA5String();
        }
    }
}

