/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.ca;

import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CAAgentCertClient;
import com.netscape.certsrv.ca.CAAgentCertRequestClient;
import com.netscape.certsrv.ca.CACertRequestClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertDataInfos;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.cert.CertRevokeRequest;
import com.netscape.certsrv.cert.CertSearchRequest;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.ProfileDataInfos;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertClient
extends Client {
    public static final Logger logger = LoggerFactory.getLogger(CACertClient.class);
    public CACertRequestClient certRequestClient;
    public CAAgentCertClient agentCertClient;
    public CAAgentCertRequestClient agentCertRequestClient;

    public CACertClient(SubsystemClient subsystemClient) throws Exception {
        this(subsystemClient.client, subsystemClient.getName());
    }

    public CACertClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "certs");
        this.init();
    }

    public void init() throws Exception {
        this.certRequestClient = new CACertRequestClient(this.client);
        this.agentCertClient = new CAAgentCertClient(this.client);
        this.agentCertRequestClient = new CAAgentCertRequestClient(this.client);
    }

    public CertData getCert(CertId id) throws Exception {
        return this.get(id.toHexString(), CertData.class);
    }

    public CertData reviewCert(CertId id) throws Exception {
        return this.agentCertClient.reviewCert(id);
    }

    public CertDataInfos listCerts(String status, Integer maxResults, Integer maxTime, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (status != null) {
            params.put("status", status);
        }
        if (maxResults != null) {
            params.put("maxResults", maxResults);
        }
        if (maxTime != null) {
            params.put("maxTime", maxTime);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, CertDataInfos.class);
    }

    public CertDataInfos findCerts(CertSearchRequest data, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        String searchRequest = (String)this.client.marshall(data);
        Entity<String> entity = this.client.entity(searchRequest);
        return this.post("search", params, entity, CertDataInfos.class);
    }

    public CertRequestInfo revokeCert(CertId id, CertRevokeRequest request) throws Exception {
        return this.agentCertClient.revokeCert(id, request);
    }

    public CertRequestInfo revokeCACert(CertId id, CertRevokeRequest request) throws Exception {
        return this.agentCertClient.revokeCACert(id, request);
    }

    public CertRequestInfo unrevokeCert(CertId id) throws Exception {
        return this.agentCertClient.unrevokeCert(id);
    }

    public CertRequestInfos enrollRequest(CertEnrollmentRequest data, AuthorityID aid, X500Name adn) throws Exception {
        return this.certRequestClient.enrollRequest(data, aid, adn);
    }

    public CertRequestInfo getRequest(RequestId id) throws Exception {
        return this.certRequestClient.getRequest(id);
    }

    public CertReviewResponse reviewRequest(RequestId id) throws Exception {
        return this.agentCertRequestClient.reviewRequest(id);
    }

    public void approveRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.approveRequest(id, data);
    }

    public void rejectRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.rejectRequest(id, data);
    }

    public void cancelRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.cancelRequest(id, data);
    }

    public void updateRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.updateRequest(id, data);
    }

    public void validateRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.validateRequest(id, data);
    }

    public void assignRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.assignRequest(id, data);
    }

    public void unassignRequest(RequestId id, CertReviewResponse data) throws Exception {
        this.agentCertRequestClient.unassignRequest(id, data);
    }

    public CertRequestInfos listRequests(String requestState, String requestType, RequestId start, Integer pageSize, Integer maxResults, Integer maxTime) throws Exception {
        return this.agentCertRequestClient.listRequests(requestState, requestType, start, pageSize, maxResults, maxTime);
    }

    public CertEnrollmentRequest getEnrollmentTemplate(String id) throws Exception {
        return this.certRequestClient.getEnrollmentTemplate(id);
    }

    public ProfileDataInfos listEnrollmentTemplates(Integer start, Integer size) throws Exception {
        return this.certRequestClient.listEnrollmentTemplates(start, size);
    }

    public X509CertImpl submitRequest(String certRequestType, String certRequest, String profileID, String subjectDN, String[] dnsNames, String requestor, String sessionID) throws Exception {
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"profileId", (Object)profileID);
        content.putSingle((Object)"cert_request_type", (Object)certRequestType);
        content.putSingle((Object)"cert_request", (Object)certRequest);
        content.putSingle((Object)"xmlOutput", (Object)"true");
        content.putSingle((Object)"sessionID", (Object)sessionID);
        if (subjectDN != null) {
            content.putSingle((Object)"subject", (Object)subjectDN);
        }
        if (dnsNames != null) {
            int i = 0;
            for (String dnsName : dnsNames) {
                content.putSingle((Object)("req_san_pattern_" + i), (Object)dnsName);
                ++i;
            }
            content.putSingle((Object)"req_san_entries", (Object)("" + i));
        }
        if (requestor != null) {
            content.putSingle((Object)"requestor_name", (Object)requestor);
        }
        String response = this.client.post("ca/ee/ca/profileSubmit", (MultivaluedMap<String, String>)content, String.class);
        logger.debug("CACertClient: Response: " + response);
        if (response == null) {
            logger.error("No response");
            throw new IOException("No response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        XMLObject parser = new XMLObject(bis);
        String status = parser.getValue("Status");
        logger.debug("CACertClient: - status: " + status);
        if (status.equals("2")) {
            logger.error("Authentication failure");
            throw new EAuthException("Authentication failure");
        }
        if (!status.equals("0")) {
            String error = parser.getValue("Error");
            logger.error("Unable to generate certificate: " + error);
            throw new IOException("Unable to generate certificate: " + error);
        }
        RequestId requestID = new RequestId(parser.getValue("Id"));
        logger.debug("CACertClient: - request ID: " + requestID.toHexString());
        String serial = parser.getValue("serialno");
        logger.debug("CACertClient: - serial: " + serial);
        String b64 = parser.getValue("b64");
        logger.debug("CACertClient: - cert: " + b64);
        b64 = CryptoUtil.stripCertBrackets(b64.trim());
        byte[] bytes = CryptoUtil.base64Decode(b64);
        return new X509CertImpl(bytes);
    }
}

