/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.scep;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Hashtable;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.pkcs7.Attribute;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkcs7.EnvelopedData;
import org.mozilla.jss.pkcs7.IssuerAndSerialNumber;
import org.mozilla.jss.pkcs7.RecipientInfo;
import org.mozilla.jss.pkcs7.SignedData;
import org.mozilla.jss.pkcs7.SignerInfo;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class CRSPKIMessage {
    public static OBJECT_IDENTIFIER CRS_MESSAGETYPE = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 2L});
    public static OBJECT_IDENTIFIER CRS_PKISTATUS = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 3L});
    public static OBJECT_IDENTIFIER CRS_FAILINFO = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 4L});
    public static OBJECT_IDENTIFIER CRS_SENDERNONCE = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 5L});
    public static OBJECT_IDENTIFIER CRS_RECIPIENTNONCE = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 6L});
    public static OBJECT_IDENTIFIER CRS_TRANSID = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 7L});
    public static OBJECT_IDENTIFIER CRS_EXTENSIONREQ = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 113733L, 1L, 9L, 8L});
    public static OBJECT_IDENTIFIER PKCS9_CONTENT_TYPE = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 9L, 3L});
    public static OBJECT_IDENTIFIER PKCS9_MESSAGE_DIGEST = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 9L, 4L});
    public static OBJECT_IDENTIFIER RSA_ENCRYPTION = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 1L});
    public static OBJECT_IDENTIFIER RSAES_OAEP_ENCRYPTION = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 7L});
    public static OBJECT_IDENTIFIER DES_CBC_ENCRYPTION = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 14L, 3L, 2L, 7L});
    public static OBJECT_IDENTIFIER DES_EDE3_CBC_ENCRYPTION = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 3L, 7L});
    public static OBJECT_IDENTIFIER AES_128_CBC_ENCRYPTION = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 1L, 2L});
    public static OBJECT_IDENTIFIER MD5_DIGEST = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 2L, 5L});
    @Deprecated(since="11.0.1", forRemoval=true)
    public static OBJECT_IDENTIFIER SHA1_DIGEST = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 14L, 3L, 2L, 26L});
    public static OBJECT_IDENTIFIER SHA256_DIGEST = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 2L, 1L});
    public static OBJECT_IDENTIFIER SHA512_DIGEST = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 2L, 3L});
    public static final String mType_PKCSReq = "19";
    public static final String mType_CertRep = "3";
    public static final String mType_GetCertInitial = "20";
    public static final String mType_GetCert = "21";
    public static final String mType_GetCRL = "22";
    public static final String mStatus_SUCCESS = "0";
    public static final String mStatus_FAILURE = "2";
    public static final String mStatus_PENDING = "3";
    public static final String mFailInfo_badAlg = "0";
    public static final String mFailInfo_badMessageCheck = "1";
    public static final String mFailInfo_badRequest = "2";
    public static final String mFailInfo_badTime = "3";
    public static final String mFailInfo_badCertId = "4";
    public static final String mFailInfo_unsupportedExt = "5";
    public static final String mFailInfo_mustArchiveKeys = "6";
    public static final String mFailInfo_badIdentity = "7";
    public static final String mFailInfo_popRequired = "8";
    public static final String mFailInfo_popFailed = "9";
    public static final String mFailInfo_noKeyReuse = "10";
    public static final String mFailInfo_internalCAError = "11";
    public static final String mFailInfo_tryLater = "12";
    private ContentInfo crsci;
    private SignedData sd;
    private ContentInfo data;
    private EnvelopedData sded;
    private byte[] signerCertBytes;
    Certificate signerCert;
    private SET sis;
    private SignerInfo si;
    private AlgorithmIdentifier digestAlgorithmId = null;
    private SET aa;
    private SET aa_old;
    private IssuerAndSerialNumber sgnIASN;
    private OCTET_STRING aa_digest;
    private String messageType;
    private String failInfo;
    private String pkiStatus;
    private String transactionID;
    private byte[] senderNonce;
    private byte[] recipientNonce;
    private OCTET_STRING msg_digest;
    private RecipientInfo ri;
    private int riv;
    private AlgorithmIdentifier riAlgid;
    private byte[] riKey;
    private IssuerAndSerialNumber rcpIASN;
    private EncryptedContentInfo eci;
    private byte[] iv;
    private byte[] ec;
    private String encryptionAlgorithm = null;
    private SignedData crsd;
    private int rsdVersion;
    private byte[] rsdCert;
    private PKCS10 myP10;
    private Hashtable<String, Object> attrs = new Hashtable();

    public void debug() {
    }

    public void put(String a, Object b) {
        this.attrs.put(a, b);
    }

    public Object get(Object a) {
        return this.attrs.get(a);
    }

    private SignatureAlgorithm getSignatureAlgorithm(String hashAlgorithm) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSASignatureWithMD5Digest;
        if (hashAlgorithm != null) {
            if (hashAlgorithm.equals("SHA1")) {
                signatureAlgorithm = SignatureAlgorithm.RSASignatureWithSHA1Digest;
            } else if (hashAlgorithm.equals("SHA256")) {
                signatureAlgorithm = SignatureAlgorithm.RSASignatureWithSHA256Digest;
            } else if (hashAlgorithm.equals("SHA512")) {
                signatureAlgorithm = SignatureAlgorithm.RSASignatureWithSHA512Digest;
            }
        }
        return signatureAlgorithm;
    }

    private OBJECT_IDENTIFIER getAlgorithmOID(String hashAlgorithm) {
        OBJECT_IDENTIFIER oid = MD5_DIGEST;
        if (hashAlgorithm != null) {
            if (hashAlgorithm.equals("SHA1")) {
                oid = SHA1_DIGEST;
            } else if (hashAlgorithm.equals("SHA256")) {
                oid = SHA256_DIGEST;
            } else if (hashAlgorithm.equals("SHA512")) {
                oid = SHA512_DIGEST;
            }
        }
        return oid;
    }

    private String getHashAlgorithm(OBJECT_IDENTIFIER algorithmOID) {
        String hashAlgorithm = null;
        if (algorithmOID != null) {
            if (algorithmOID.equals((Object)MD5_DIGEST)) {
                hashAlgorithm = "MD5";
            } else if (algorithmOID.equals((Object)SHA1_DIGEST)) {
                hashAlgorithm = "SHA1";
            } else if (algorithmOID.equals((Object)SHA256_DIGEST)) {
                hashAlgorithm = "SHA256";
            } else if (algorithmOID.equals((Object)SHA512_DIGEST)) {
                hashAlgorithm = "SHA512";
            }
        }
        return hashAlgorithm;
    }

    public void makeSignedData(int version, byte[] certificate, String hashAlgorithm) {
        SET digest_algs = new SET();
        digest_algs.addElement((ASN1Value)new AlgorithmIdentifier(this.getAlgorithmOID(hashAlgorithm), (ASN1Value)new NULL()));
        SET sis = new SET();
        sis.addElement((ASN1Value)this.si);
        ContentInfo data = this.data;
        this.sd = new SignedData(digest_algs, data, null, null, sis);
    }

    public byte[] getResponse() throws IOException, InvalidBERException {
        this.crsci = new ContentInfo(ContentInfo.SIGNED_DATA, (ASN1Value)this.sd);
        return ASN1Util.encode((ASN1Value)this.crsci);
    }

    public void makeSignerInfo(int version, PrivateKey pk, String hashAlgorithm) throws NoSuchAlgorithmException, TokenException, InvalidKeyException, SignatureException, NotInitializedException {
        this.si = new SignerInfo(this.sgnIASN, this.aa, null, ContentInfo.ENVELOPED_DATA, this.msg_digest.toByteArray(), this.getSignatureAlgorithm(hashAlgorithm), pk);
    }

    public void makeAuthenticatedAttributes() {
        this.aa = new SET();
        try {
            if (this.transactionID != null) {
                SET tidset = new SET();
                tidset.addElement((ASN1Value)new PrintableString(this.transactionID));
                this.aa.addElement((ASN1Value)new Attribute(CRS_TRANSID, tidset));
            }
            if (this.pkiStatus != null) {
                SET pkistatusset = new SET();
                pkistatusset.addElement((ASN1Value)new PrintableString(this.pkiStatus));
                this.aa.addElement((ASN1Value)new Attribute(CRS_PKISTATUS, pkistatusset));
            }
            if (this.messageType != null) {
                SET aaset = new SET();
                aaset.addElement((ASN1Value)new PrintableString(this.messageType));
                this.aa.addElement((ASN1Value)new Attribute(CRS_MESSAGETYPE, aaset));
            }
            if (this.failInfo != null) {
                SET fiset = new SET();
                fiset.addElement((ASN1Value)new PrintableString(this.failInfo));
                this.aa.addElement((ASN1Value)new Attribute(CRS_FAILINFO, fiset));
            }
            if (this.senderNonce != null) {
                SET snset = new SET();
                snset.addElement((ASN1Value)new OCTET_STRING(this.senderNonce));
                this.aa.addElement((ASN1Value)new Attribute(CRS_SENDERNONCE, snset));
            }
            if (this.recipientNonce != null) {
                SET rnset = new SET();
                rnset.addElement((ASN1Value)new OCTET_STRING(this.recipientNonce));
                this.aa.addElement((ASN1Value)new Attribute(CRS_RECIPIENTNONCE, rnset));
            }
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
    }

    public byte[] makeEnvelopedData(int version) {
        try {
            byte[] r;
            if (this.ri != null) {
                SET ris = new SET();
                ris.addElement((ASN1Value)this.ri);
                this.sded = new EnvelopedData(new INTEGER((long)version), ris, this.eci);
                ContentInfo ci = new ContentInfo(ContentInfo.ENVELOPED_DATA, (ASN1Value)this.sded);
                ByteArrayOutputStream ba = new ByteArrayOutputStream();
                ci.encode((OutputStream)ba);
                r = ba.toByteArray();
            } else {
                r = new byte[]{};
            }
            this.data = new ContentInfo(ContentInfo.DATA, (ASN1Value)new OCTET_STRING(r));
            return r;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void makeRecipientInfo(int version, byte[] riKey) {
        this.riv = version;
        this.riAlgid = new AlgorithmIdentifier(RSA_ENCRYPTION, (ASN1Value)new NULL());
        this.riKey = riKey;
        this.ri = new RecipientInfo(new INTEGER((long)this.riv), this.rcpIASN, this.riAlgid, new OCTET_STRING(this.riKey));
    }

    public void makeEncryptedContentInfo(byte[] iv, byte[] ec, String algorithm) {
        this.iv = iv;
        this.ec = ec;
        try {
            OBJECT_IDENTIFIER oid = null;
            switch (String.valueOf(algorithm)) {
                case "DES3": {
                    oid = DES_EDE3_CBC_ENCRYPTION;
                    break;
                }
                case "AES": {
                    oid = AES_128_CBC_ENCRYPTION;
                    break;
                }
                default: {
                    oid = DES_CBC_ENCRYPTION;
                }
            }
            AlgorithmIdentifier aid = new AlgorithmIdentifier(oid, (ASN1Value)new OCTET_STRING(iv));
            this.eci = new EncryptedContentInfo(ContentInfo.DATA, aid, new OCTET_STRING(ec));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] makeSignedRep(int v, byte[] certificate) {
        this.rsdVersion = v;
        this.rsdCert = certificate;
        try {
            SET certs = new SET();
            ANY cert = new ANY(certificate);
            certs.addElement((ASN1Value)cert);
            this.crsd = new SignedData(new SET(), new ContentInfo(new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 1L}), null), certs, null, new SET());
            ContentInfo wrap = new ContentInfo(ContentInfo.SIGNED_DATA, (ASN1Value)this.crsd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            wrap.encode((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (InvalidBERException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ messageType=");
        sb.append(this.getMessageType());
        sb.append(", failInfo=");
        sb.append(this.getFailInfo());
        sb.append(", pkiStatus=");
        sb.append(this.getPKIStatus());
        sb.append(", transactionID=");
        sb.append(this.getTransactionID());
        sb.append(", senderNonce=");
        sb.append(Arrays.toString(this.getSenderNonce()));
        sb.append(", recipientNonce=");
        sb.append(Arrays.toString(this.getRecipientNonce()));
        sb.append(" }");
        String s = sb.toString();
        return s;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getFailInfo() {
        return this.failInfo;
    }

    public String getPKIStatus() {
        return this.pkiStatus;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public byte[] getSenderNonce() {
        return this.senderNonce;
    }

    public byte[] getRecipientNonce() {
        return this.recipientNonce;
    }

    public byte[] getWrappedKey() {
        return this.riKey;
    }

    public byte[] getEncryptedPkcs10() {
        return this.ec;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getDigestAlgorithmName() {
        String name = null;
        if (this.digestAlgorithmId != null) {
            name = this.getHashAlgorithm(this.digestAlgorithmId.getOID());
        }
        return name;
    }

    public PublicKey getSignerPublicKey() {
        try {
            Certificate.Template ct = new Certificate.Template();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.signerCertBytes);
            this.signerCert = (Certificate)ct.decode((InputStream)bais);
            return this.signerCert.getInfo().getSubjectPublicKeyInfo().toPublicKey();
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getAA() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.aa.encode((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setAA_old(SET auth_attrs) {
        this.aa_old = auth_attrs;
    }

    public byte[] getAA_old() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.aa_old.encode((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getAADigest() {
        return this.aa_digest.toByteArray();
    }

    public PKCS10 getP10() {
        return this.myP10;
    }

    public void setP10(PKCS10 p10) {
        this.myP10 = p10;
    }

    public void setSgnIssuerAndSerialNumber(IssuerAndSerialNumber iasn) {
        this.sgnIASN = iasn;
    }

    public void setRcpIssuerAndSerialNumber(IssuerAndSerialNumber iasn) {
        this.rcpIASN = iasn;
    }

    public IssuerAndSerialNumber getSgnIssuerAndSerialNumber() {
        return this.sgnIASN;
    }

    public IssuerAndSerialNumber getRcpIssuerAndSerialNumber() {
        return this.rcpIASN;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public void setPKIStatus(String pkiStatus) {
        this.pkiStatus = pkiStatus;
    }

    public void setFailInfo(String failInfo) {
        this.failInfo = failInfo;
    }

    public void setTransactionID(String tid) {
        this.transactionID = tid;
    }

    public void setRecipientNonce(byte[] rn) {
        this.recipientNonce = rn;
    }

    public void setSenderNonce(byte[] sn) {
        this.senderNonce = sn;
    }

    public void setMsgDigest(byte[] digest) {
        this.msg_digest = new OCTET_STRING(digest);
    }

    public void setAADigest(byte[] digest) {
        this.aa_digest = new OCTET_STRING(digest);
    }

    public void setPending() {
        this.setMessageType("3");
        this.setPKIStatus("3");
    }

    public void setFailure(String failInfo) {
        this.setMessageType("3");
        this.setPKIStatus("2");
        this.setFailInfo(failInfo);
    }

    public void setSuccess() {
        this.setMessageType("3");
        this.setPKIStatus("0");
    }

    public byte[] getEncoded() {
        return new byte[1];
    }

    private void decodeCRSPKIMessage(ByteArrayInputStream bais) throws InvalidBERException, Exception {
        ContentInfo.Template crscit = new ContentInfo.Template();
        this.crsci = (ContentInfo)crscit.decode((InputStream)bais);
        if (!ContentInfo.SIGNED_DATA.equals((Object)this.crsci.getContentType())) {
            throw new Exception("ContentType wasn't signed data, it was" + this.crsci.getContentType());
        }
        SignedData.Template sdt = new SignedData.Template();
        this.sd = (SignedData)sdt.decode((InputStream)new ByteArrayInputStream(this.crsci.getContent().getEncoded()));
        this.decodeSD();
    }

    public CRSPKIMessage() {
    }

    public CRSPKIMessage(ByteArrayInputStream bais) throws InvalidBERException, Exception {
        this.decodeCRSPKIMessage(bais);
    }

    private void decodeSD() throws Exception {
        this.sis = this.sd.getSignerInfos();
        this.decodeSI();
        ContentInfo sdci = this.sd.getContentInfo();
        ANY a = sdci.getContent();
        ByteArrayInputStream s = new ByteArrayInputStream(a.getEncoded());
        OCTET_STRING os = (OCTET_STRING)new OCTET_STRING.Template().decode((InputStream)s);
        ByteArrayInputStream s2 = new ByteArrayInputStream(os.toByteArray());
        ContentInfo ci = (ContentInfo)new ContentInfo.Template().decode((InputStream)s2);
        ByteArrayInputStream s3 = new ByteArrayInputStream(ci.getContent().getEncoded());
        EnvelopedData.Template edt = new EnvelopedData.Template();
        this.sded = (EnvelopedData)edt.decode((InputStream)s3);
        SET signerCerts = this.sd.getCertificates();
        Certificate firstCert = (Certificate)signerCerts.elementAt(0);
        this.signerCertBytes = ASN1Util.encode((ASN1Value)firstCert);
        CertificateInfo firstCertInfo = firstCert.getInfo();
        this.sgnIASN = new IssuerAndSerialNumber(firstCertInfo.getIssuer(), firstCertInfo.getSerialNumber());
        this.decodeED();
    }

    private void decodeSI() throws Exception {
        if (this.sis.size() == 0) {
            throw new Exception("SignerInfos is empty");
        }
        this.si = (SignerInfo)this.sis.elementAt(0);
        this.digestAlgorithmId = this.si.getDigestAlgorithmIdentifer();
        this.decodeAA();
        this.aa_digest = new OCTET_STRING(this.si.getEncryptedDigest());
    }

    private void decodeED() throws Exception {
        SET ris = this.sded.getRecipientInfos();
        if (ris.size() == 0) {
            throw new Exception("RecipientInfos is empty");
        }
        this.ri = (RecipientInfo)ris.elementAt(0);
        this.eci = this.sded.getEncryptedContentInfo();
        if (this.eci.getContentEncryptionAlgorithm().getOID().equals((Object)DES_EDE3_CBC_ENCRYPTION)) {
            this.encryptionAlgorithm = "DES3";
        } else if (this.eci.getContentEncryptionAlgorithm().getOID().equals((Object)AES_128_CBC_ENCRYPTION)) {
            this.encryptionAlgorithm = "AES";
        } else if (this.eci.getContentEncryptionAlgorithm().getOID().equals((Object)DES_CBC_ENCRYPTION)) {
            this.encryptionAlgorithm = "DES";
        } else {
            throw new Exception("P10 encrypted alg is not supported (not DES): " + this.eci.getContentEncryptionAlgorithm().getOID());
        }
        this.ec = this.eci.getEncryptedContent().toByteArray();
        OCTET_STRING.Template ost = new OCTET_STRING.Template();
        OCTET_STRING os = (OCTET_STRING)ost.decode((InputStream)new ByteArrayInputStream(((ANY)this.eci.getContentEncryptionAlgorithm().getParameters()).getEncoded()));
        this.iv = os.toByteArray();
        this.decodeRI();
    }

    private void decodeRI() throws Exception {
        this.riAlgid = this.ri.getKeyEncryptionAlgorithmID();
        if (!this.riAlgid.getOID().equals((Object)RSA_ENCRYPTION) && !this.riAlgid.getOID().equals((Object)RSAES_OAEP_ENCRYPTION)) {
            throw new Exception("Request is protected by a key which we can't decrypt");
        }
        this.riKey = this.ri.getEncryptedKey().toByteArray();
    }

    private void decodeAA() throws InvalidBERException, IOException {
        this.aa = this.si.getAuthenticatedAttributes();
        for (int count = 0; count < this.aa.size(); ++count) {
            PrintableString ps;
            Attribute a = (Attribute)this.aa.elementAt(count);
            SET s = a.getValues();
            ANY f = (ANY)s.elementAt(0);
            PrintableString.Template pst = new PrintableString.Template();
            OCTET_STRING.Template ost = new OCTET_STRING.Template();
            OBJECT_IDENTIFIER oid = a.getType();
            if (oid.equals((Object)CRS_MESSAGETYPE)) {
                ps = (PrintableString)pst.decode((InputStream)new ByteArrayInputStream(f.getEncoded()));
                this.messageType = ps.toString();
                continue;
            }
            if (oid.equals((Object)CRS_PKISTATUS)) {
                ps = (PrintableString)pst.decode((InputStream)new ByteArrayInputStream(f.getEncoded()));
                this.pkiStatus = ps.toString();
                continue;
            }
            if (oid.equals((Object)CRS_FAILINFO)) {
                ps = (PrintableString)pst.decode((InputStream)new ByteArrayInputStream(f.getEncoded()));
                this.failInfo = ps.toString();
                continue;
            }
            if (oid.equals((Object)CRS_SENDERNONCE)) {
                OCTET_STRING oss = (OCTET_STRING)ost.decode((InputStream)new ByteArrayInputStream(f.getEncoded()));
                this.senderNonce = oss.toByteArray();
                continue;
            }
            if (oid.equals((Object)CRS_RECIPIENTNONCE)) {
                OCTET_STRING osr = (OCTET_STRING)ost.decode((InputStream)new ByteArrayInputStream(f.getEncoded()));
                this.recipientNonce = osr.toByteArray();
                continue;
            }
            if (!oid.equals((Object)CRS_TRANSID)) continue;
            ps = (PrintableString)pst.decode((InputStream)new ByteArrayInputStream(f.getEncoded()));
            this.transactionID = ps.toString();
        }
    }

    public String getMessageTypeString() {
        if (this.messageType == null) {
            return null;
        }
        if (this.messageType.equals(mType_PKCSReq)) {
            return "PKCSReq";
        }
        if (this.messageType.equals("3")) {
            return "CertRep";
        }
        if (this.messageType.equals(mType_GetCertInitial)) {
            return "GetCertInitial";
        }
        if (this.messageType.equals(mType_GetCert)) {
            return "GetCert";
        }
        if (this.messageType.equals(mType_GetCRL)) {
            return "GetCRL";
        }
        return null;
    }
}

