/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.apdu;

import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.main.TPSBuffer;

public class ExternalAuthenticateAPDUGP211
extends APDU {
    public ExternalAuthenticateAPDUGP211(TPSBuffer theData, SecurityLevel securityLevel) {
        this.setCLA((byte)-124);
        this.setINS((byte)-126);
        this.setP1(ExternalAuthenticateAPDUGP211.securityLevelToByte(securityLevel));
        this.setP2((byte)0);
        this.setData(theData);
    }

    public TPSBuffer getHostCryptogram() {
        return this.getData();
    }

    @Override
    public APDU.Type getType() {
        return APDU.Type.APDU_EXTERNAL_AUTHENTICATE;
    }

    public static byte securityLevelToByte(SecurityLevel level) {
        return switch (level) {
            case SecurityLevel.SECURE_MSG_NONE -> 0;
            case SecurityLevel.CMAC -> 1;
            case SecurityLevel.CDEC_CMAC -> 3;
            case SecurityLevel.RMAC -> 16;
            case SecurityLevel.CMAC_RMAC -> 17;
            case SecurityLevel.CDEC_CMAC_RMAC -> 19;
            default -> 0;
        };
    }

    public static SecurityLevel byteToSecurityLevel(byte level) {
        return switch (level) {
            case 0 -> SecurityLevel.SECURE_MSG_NONE;
            case 1 -> SecurityLevel.CMAC;
            case 3 -> SecurityLevel.CDEC_CMAC;
            case 16 -> SecurityLevel.RMAC;
            case 19 -> SecurityLevel.CDEC_CMAC_RMAC;
            default -> SecurityLevel.SECURE_MSG_NONE;
        };
    }

    public static enum SecurityLevel {
        SECURE_MSG_NONE,
        CMAC,
        CDEC_CMAC,
        RMAC,
        CMAC_RMAC,
        CDEC_CMAC_RMAC;

    }
}

