/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.x509.CRLNumberExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSCRLNumberExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSCRLNumberExtension.class);

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        BigInteger crlNumber = null;
        CRLNumberExtension crlNumberExt = null;
        try {
            crlNumber = (BigInteger)((CRLNumberExtension)ext).get("value");
            crlNumberExt = new CRLNumberExtension(Boolean.valueOf(critical), crlNumber);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_CRL_NUMBER_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return crlNumberExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        CRLNumberExtension crlNumberExt = null;
        CRLIssuingPoint crlIssuingPoint = (CRLIssuingPoint)ip;
        try {
            crlNumberExt = new CRLNumberExtension(Boolean.valueOf(critical), crlIssuingPoint.getNextCRLNumber());
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_CRL_NUMBER_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return crlNumberExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.CRLNumber_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable CRL Number extension.", "critical;boolean;Set criticality for CRL Number extension.", "HELP_TOKEN;configuration-ca-edit-crlextension-crlnumber", "HELP_TEXT;The CRL number is a non-critical CRL extension which conveys a monotonically increasing sequence number for each CRL issued by a CA"};
        return params;
    }
}

