/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.HoldInstructionExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSHoldInstructionExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSHoldInstructionExtension.class);
    public static final String PROP_INSTR = "instruction";
    public static final String PROP_INSTR_NONE = "none";
    public static final String PROP_INSTR_CALLISSUER = "callissuer";
    public static final String PROP_INSTR_REJECT = "reject";

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        HoldInstructionExtension holdInstrExt = null;
        try {
            ObjectIdentifier holdInstr = ((HoldInstructionExtension)ext).getHoldInstructionCode();
            holdInstrExt = new HoldInstructionExtension(Boolean.valueOf(critical), holdInstr);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_HOLD_INSTR_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return holdInstrExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        HoldInstructionExtension holdInstrExt = null;
        String instruction = null;
        try {
            instruction = config.getString(PROP_INSTR);
        }
        catch (EPropertyNotFound e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_HOLD_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_HOLD_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        ObjectIdentifier holdInstr = HoldInstructionExtension.NONE_HOLD_INSTR_OID;
        if (instruction != null) {
            if (instruction.equalsIgnoreCase(PROP_INSTR_CALLISSUER)) {
                holdInstr = HoldInstructionExtension.CALL_ISSUER_HOLD_INSTR_OID;
            } else if (instruction.equalsIgnoreCase(PROP_INSTR_REJECT)) {
                holdInstr = HoldInstructionExtension.REJECT_HOLD_INSTR_OID;
            }
        }
        try {
            holdInstrExt = new HoldInstructionExtension(Boolean.valueOf(critical), holdInstr);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_HOLD_INSTR_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return holdInstrExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.HoldInstructionCode_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
        String instruction = null;
        try {
            instruction = config.getString(PROP_INSTR);
        }
        catch (EPropertyNotFound e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_HOLD_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_HOLD_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (instruction != null) {
            if (!(instruction.equalsIgnoreCase(PROP_INSTR_NONE) || instruction.equalsIgnoreCase(PROP_INSTR_CALLISSUER) || instruction.equalsIgnoreCase(PROP_INSTR_REJECT))) {
                instruction = PROP_INSTR_NONE;
            }
        } else {
            instruction = PROP_INSTR_NONE;
        }
        nvp.put((Object)PROP_INSTR, (Object)instruction);
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Hold Instruction CRL entry extension.", "critical;boolean;Set criticality for Hold Instruction CRL entry extension.", "instruction;choice(none,callissuer,reject);Select hold instruction code.", "HELP_TOKEN;configuration-ca-edit-crlextension-holdinstruction", "HELP_TEXT;The hold instruction code is a non-critical CRL entry extension that provides a registered instruction identifier which indicates the action to be taken after encountering a certificate that has been placed on hold."};
        return params;
    }
}

