/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAValidityDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(CAValidityDefault.class);
    public static final String CONFIG_RANGE = "range";
    public static final String CONFIG_RANGE_UNIT = "rangeUnit";
    public static final String CONFIG_START_TIME = "startTime";
    public static final String CONFIG_BYPASS_CA_NOTAFTER = "bypassCAnotafter";
    public static final String VAL_NOT_BEFORE = "notBefore";
    public static final String VAL_NOT_AFTER = "notAfter";
    public static final String VAL_BYPASS_CA_NOTAFTER = "bypassCAnotafter";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public CAValidityDefault() {
        this.addConfigName(CONFIG_RANGE);
        this.addConfigName(CONFIG_RANGE_UNIT);
        this.addConfigName(CONFIG_START_TIME);
        this.addConfigName("bypassCAnotafter");
        this.addValueName(VAL_NOT_BEFORE);
        this.addValueName(VAL_NOT_AFTER);
        this.addValueName("bypassCAnotafter");
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals(CONFIG_RANGE)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE}));
            }
        }
        if (name.equals(CONFIG_START_TIME)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_START_TIME}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_RANGE)) {
            return new Descriptor("string", null, "7305", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_RANGE_UNIT)) {
            return new Descriptor("string", null, "day", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE_UNIT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_START_TIME)) {
            return new Descriptor("string", null, "60", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_START_TIME", (String[])new String[0]));
        }
        if (name.equals("bypassCAnotafter")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_BYPASS_CA_NOTAFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NOT_BEFORE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_BEFORE", (String[])new String[0]));
        }
        if (name.equals(VAL_NOT_AFTER)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_AFTER", (String[])new String[0]));
        }
        if (name.equals("bypassCAnotafter")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_BYPASS_CA_NOTAFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (value == null || value.equals("")) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        logger.debug("CAValidityDefault: setValue name= " + name);
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ParsePosition pos = new ParsePosition(0);
            Date date = formatter.parse(value, pos);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                validity.set(VAL_NOT_BEFORE, (Object)date);
            }
            catch (Exception e) {
                logger.error("CAValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ParsePosition pos = new ParsePosition(0);
            Date date = formatter.parse(value, pos);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                validity.set(VAL_NOT_AFTER, (Object)date);
            }
            catch (Exception e) {
                logger.error("CAValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("bypassCAnotafter")) {
            X509CertImpl signingCert;
            logger.debug("CAValidityDefault: setValue: " + value);
            boolean bypassCAvalidity = this.getConfigBoolean("bypassCAnotafter");
            logger.debug("CAValidityDefault: setValue: bypassCAvalidity=" + bypassCAvalidity);
            BasicConstraintsExtension ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
            if (ext == null) {
                logger.warn("CAValidityDefault: setValue: this default cannot be applied to non-CA cert.");
                return;
            }
            try {
                Boolean isCA = (Boolean)ext.get("is_ca");
                if (!isCA.booleanValue()) {
                    logger.warn("CAValidityDefault: setValue: this default cannot be aplied to non-CA cert.");
                    return;
                }
            }
            catch (Exception e) {
                logger.warn("CAValidityDefault: setValue: this default cannot be aplied to non-CA cert." + e.getMessage(), (Throwable)e);
                return;
            }
            CertificateValidity validity = null;
            Date notAfter = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                notAfter = (Date)validity.get(VAL_NOT_AFTER);
            }
            catch (Exception e) {
                logger.error("CAValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            try {
                signingCert = this.getSigningCert();
            }
            catch (Exception e) {
                throw new EPropertyException("Unable to get CA signing certificate: " + e.getMessage(), (Throwable)e);
            }
            Date caNotAfter = signingCert.getNotAfter();
            if (notAfter.after(caNotAfter)) {
                if (!bypassCAvalidity) {
                    notAfter = caNotAfter;
                    logger.debug("CAValidityDefault: setValue: bypassCAvalidity off. reset notAfter to caNotAfter. reset ");
                } else {
                    logger.debug("CAValidityDefault: setValue: bypassCAvalidity on.  notAfter is after caNotAfter. no reset");
                }
            }
            try {
                validity.set(VAL_NOT_AFTER, (Object)notAfter);
            }
            catch (Exception e) {
                logger.error("CAValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        logger.debug("CAValidityDefault: getValue: name= " + name);
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                return formatter.format((Date)validity.get(VAL_NOT_BEFORE));
            }
            catch (Exception e) {
                logger.error("CAValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                return formatter.format((Date)validity.get(VAL_NOT_AFTER));
            }
            catch (Exception e) {
                logger.error("CAValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("bypassCAnotafter")) {
            return "false";
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_RANGE), this.getConfig("bypassCAnotafter")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_VALIDITY", (String[])params);
    }

    public int convertRangeUnit(String unit) throws Exception {
        if (unit.equals("year")) {
            return 1;
        }
        if (unit.equals("month")) {
            return 2;
        }
        if (unit.equals("day") || unit.equals("")) {
            return 6;
        }
        if (unit.equals("hour")) {
            return 11;
        }
        if (unit.equals("minute")) {
            return 12;
        }
        throw new Exception("Invalid range unit: " + unit);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        X509CertImpl signingCert;
        int rangeUnit;
        int range;
        String method = "CAValidityDefault: populate: ";
        String startTimeStr = this.getConfig(CONFIG_START_TIME);
        logger.debug(method + " start time: " + startTimeStr);
        try {
            startTimeStr = this.mapPattern(request, startTimeStr);
        }
        catch (IOException e) {
            logger.warn(method + " populate " + e.getMessage(), (Throwable)e);
        }
        if (startTimeStr == null || startTimeStr.equals("")) {
            startTimeStr = "60";
        }
        long startTime = Long.parseLong(startTimeStr);
        Date notBefore = new Date(new Date().getTime() + 1000L * startTime);
        logger.debug(method + " not before: " + notBefore);
        String rangeStr = this.getConfig(CONFIG_RANGE, "7305");
        logger.debug(method + " range: " + rangeStr);
        try {
            rangeStr = this.mapPattern(request, rangeStr);
            range = Integer.parseInt(rangeStr);
        }
        catch (IOException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE}));
        }
        String rangeUnitStr = this.getConfig(CONFIG_RANGE_UNIT, "day");
        logger.debug(method + " range unit: " + rangeUnitStr);
        try {
            rangeUnit = this.convertRangeUnit(rangeUnitStr);
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE_UNIT}));
        }
        Calendar date = Calendar.getInstance();
        date.setTime(notBefore);
        date.add(rangeUnit, range);
        Date notAfter = date.getTime();
        logger.debug(method + " not after: " + notAfter);
        boolean bypassCAvalidity = this.getConfigBoolean("bypassCAnotafter");
        logger.debug(method + " populate: bypassCAvalidity=" + bypassCAvalidity);
        try {
            signingCert = this.getSigningCert();
        }
        catch (Exception e) {
            throw new EProfileException("Unable to get CA signing certificate: " + e.getMessage(), (Throwable)e);
        }
        Date caNotAfter = null;
        if (signingCert != null) {
            caNotAfter = signingCert.getNotAfter();
        }
        if (caNotAfter != null && notAfter.after(caNotAfter)) {
            if (!bypassCAvalidity) {
                notAfter = caNotAfter;
                logger.debug(method + " populate: bypassCAvalidity off. reset notAfter to caNotAfter. reset ");
            } else {
                logger.debug(method + " populate: bypassCAvalidity on.  notAfter is after caNotAfter. no reset");
            }
        }
        CertificateValidity validity = new CertificateValidity(notBefore, notAfter);
        try {
            info.set("validity", (Object)validity);
        }
        catch (Exception e) {
            logger.error(method + " populate " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{"validity"}));
        }
    }
}

