/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.GenPendingTemplateFiller;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Locale;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkix.cmc.CMCStatusInfoV2;
import org.mozilla.jss.pkix.cmc.OtherInfo;
import org.mozilla.jss.pkix.cmc.PendInfo;
import org.mozilla.jss.pkix.cmc.ResponseBody;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;

public class CAGenPendingTemplateFiller
extends GenPendingTemplateFiller {
    public static String FULL_RESPONSE = "cmcFullEnrollmentResponse";

    public CMSTemplateParams getTemplateParams(CMSRequest cmsReq, IAuthority authority, Locale locale, Exception e) {
        byte[] dig;
        if (cmsReq == null) {
            return null;
        }
        CMSTemplateParams params = super.getTemplateParams(cmsReq, authority, locale, e);
        Request req = cmsReq.getRequest();
        if (req == null) {
            return params;
        }
        ArgBlock httpParams = cmsReq.getHttpParams();
        if (!CAGenPendingTemplateFiller.doFullResponse(httpParams)) {
            return params;
        }
        SEQUENCE controlSeq = new SEQUENCE();
        int bpid = 1;
        RequestId reqId = req.getRequestId();
        PendInfo pendInfo = new PendInfo(reqId.toString(), new Date());
        OtherInfo otherInfo = new OtherInfo(OtherInfo.PEND, null, pendInfo);
        SEQUENCE bpids = new SEQUENCE();
        String[] reqIdArray = req.getExtDataInStringArray("cmcReqIds");
        for (int i = 0; i < reqIdArray.length; ++i) {
            bpids.addElement((ASN1Value)new INTEGER(reqIdArray[i]));
        }
        CMCStatusInfoV2 cmcStatusInfo = new CMCStatusInfoV2(3, bpids, (String)null, otherInfo);
        TaggedAttribute ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfo);
        controlSeq.addElement((ASN1Value)ta);
        SET ids = new SET();
        String[] transIds = req.getExtDataInStringArray("transactionId");
        for (int i = 0; i < transIds.length; ++i) {
            ids.addElement((ASN1Value)new INTEGER(transIds[i]));
        }
        ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_transactionId, ids);
        controlSeq.addElement((ASN1Value)ta);
        SET nonces = new SET();
        String[] senderNonce = req.getExtDataInStringArray("senderNonce");
        for (int i = 0; i < senderNonce.length; ++i) {
            nonces.addElement((ASN1Value)new OCTET_STRING(senderNonce[i].getBytes()));
        }
        ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_recipientNonce, nonces);
        controlSeq.addElement((ASN1Value)ta);
        req.setExtData("recipientNonce", senderNonce);
        Date date = new Date();
        String salt = "lala123" + date.toString();
        try {
            MessageDigest SHA2Digest = MessageDigest.getInstance("SHA256");
            dig = SHA2Digest.digest(salt.getBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn("Unable to generate message digest: " + ex.getMessage(), (Throwable)ex);
            dig = salt.getBytes();
        }
        String b64E = Utils.base64encode((byte[])dig, (boolean)true);
        String[] newNonce = new String[]{b64E};
        ta = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_senderNonce, (ASN1Value)new OCTET_STRING(newNonce[0].getBytes()));
        controlSeq.addElement((ASN1Value)ta);
        req.setExtData("senderNonce", newNonce);
        ResponseBody rb = new ResponseBody(controlSeq, new SEQUENCE(), new SEQUENCE());
        EncapsulatedContentInfo ci = new EncapsulatedContentInfo(OBJECT_IDENTIFIER.id_cct_PKIResponse, (ASN1Value)rb);
        X509Certificate x509cert = null;
        if (authority instanceof CertificateAuthority) {
            x509cert = ((CertificateAuthority)authority).getCaX509Cert();
        }
        if (x509cert == null) {
            return params;
        }
        try {
            X509CertImpl cert = new X509CertImpl(x509cert.getEncoded());
            ByteArrayInputStream issuer1 = new ByteArrayInputStream(cert.getIssuerName().getEncoded());
            Name issuer = (Name)Name.getTemplate().decode((InputStream)issuer1);
            IssuerAndSerialNumber ias = new IssuerAndSerialNumber(issuer, new INTEGER(cert.getSerialNumber().toString()));
            SignerIdentifier si = new SignerIdentifier(SignerIdentifier.ISSUER_AND_SERIALNUMBER, ias, null);
            DigestAlgorithm digestAlg = null;
            SignatureAlgorithm signAlg = null;
            PrivateKey privKey = CryptoManager.getInstance().findPrivKeyByCert(x509cert);
            PrivateKey.Type keyType = privKey.getType();
            if (keyType.equals(PrivateKey.RSA)) {
                signAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
            } else if (keyType.equals(PrivateKey.EC)) {
                signAlg = SignatureAlgorithm.ECSignatureWithSHA256Digest;
            } else {
                logger.warn("Unsupported key type: " + keyType);
                return null;
            }
            MessageDigest SHADigest = null;
            byte[] digest = null;
            try {
                SHADigest = MessageDigest.getInstance("SHA256");
                digestAlg = DigestAlgorithm.SHA256;
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                rb.encode((OutputStream)ostream);
                digest = SHADigest.digest(ostream.toByteArray());
            }
            catch (NoSuchAlgorithmException ex) {
                logger.warn("Unable to generate message digest: " + ex.getMessage(), (Throwable)ex);
            }
            SignerInfo signInfo = new SignerInfo(si, null, null, OBJECT_IDENTIFIER.id_cct_PKIResponse, digest, signAlg, privKey);
            SET signInfos = new SET();
            signInfos.addElement((ASN1Value)signInfo);
            SET digestAlgs = new SET();
            if (digestAlg != null) {
                AlgorithmIdentifier ai = new AlgorithmIdentifier(digestAlg.toOID(), null);
                digestAlgs.addElement((ASN1Value)ai);
            }
            SignedData fResponse = new SignedData(digestAlgs, ci, null, null, signInfos);
            ContentInfo fullResponse = new ContentInfo(ContentInfo.SIGNED_DATA, (ASN1Value)fResponse);
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            fullResponse.encode((OutputStream)ostream);
            byte[] fr = ostream.toByteArray();
            ArgBlock fixed = params.getFixed();
            fixed.set(FULL_RESPONSE, (Object)Utils.base64encode((byte[])fr, (boolean)true));
        }
        catch (Exception ex) {
            logger.warn("Unable to generate full response: " + ex.getMessage(), (Throwable)ex);
        }
        return params;
    }

    public static boolean doFullResponse(ArgBlock httpParams) {
        return httpParams.getValueAsBoolean("fullResponse", false);
    }
}

