/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;

public class KeyAlgorithmConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    private Vector<String> mAlgorithms;
    private static final String DEF_KEY_ALGORITHM = "RSA,DSA";
    private static final String PROP_ALGORITHMS = "algorithms";
    private static final String[] supportedAlgorithms = new String[]{"RSA", "DSA", "DH"};
    private static final Vector<String> defConfParams = new Vector();

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"algorithms;choice(RSA\\,DSA,RSA,DSA);Certificate's key can be one of these algorithms", "HELP_TOKEN;configuration-policyrules-keyalgorithmconstraints", "HELP_TEXT;Rejects the request if the key in the certificate is not of the type specified"};
        return params;
    }

    public KeyAlgorithmConstraints() {
        this.NAME = "KeyAlgorithmConstraints";
        this.DESC = "Enforces Key Algorithm Constraints.";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EPolicyException {
        this.mAlgorithms = new Vector();
        if (config == null || config.size() == 0) {
            this.mAlgorithms.addElement(DEF_KEY_ALGORITHM);
            return;
        }
        String algNames = null;
        try {
            algNames = config.getString(PROP_ALGORITHMS, null);
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])params));
        }
        if (algNames == null) {
            this.mAlgorithms.addElement(DEF_KEY_ALGORITHM);
            return;
        }
        StringTokenizer tok = new StringTokenizer(algNames, ",");
        while (tok.hasMoreTokens()) {
            String alg = tok.nextToken().trim().toUpperCase();
            if (alg.length() == 0) continue;
            this.mAlgorithms.addElement(alg);
        }
        Enumeration<String> e = this.mAlgorithms.elements();
        while (e.hasMoreElements()) {
            int i;
            String configuredAlg = e.nextElement();
            for (i = 0; i < supportedAlgorithms.length && !configuredAlg.equals(supportedAlgorithms[i]); ++i) {
            }
            if (i != supportedAlgorithms.length) continue;
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_UNSUPPORTED_KEY_ALG", (String[])new String[]{this.getInstanceName(), configuredAlg}));
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] certInfo = req.getExtDataInCertInfoArray("CERT_INFO");
            if (certInfo == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfo.length; ++i) {
                CertificateX509Key certKey = (CertificateX509Key)certInfo[i].get("key");
                X509Key key = (X509Key)certKey.get("value");
                String alg = key.getAlgorithmId().getName().toUpperCase();
                if (this.mAlgorithms.contains(alg)) continue;
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_KEY_ALG_VIOLATION", (String[])new String[]{this.getInstanceName(), alg}), "");
                result = PolicyResult.REJECTED;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        Enumeration<String> e = this.mAlgorithms.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        v.addElement("algorithms=" + sb.toString());
        return v;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    static {
        defConfParams.addElement("algorithms=RSA,DSA");
    }
}

