/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityKeyIdentifierExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(AuthorityKeyIdentifierExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_ALT_KEYID_TYPE = "AltKeyIdType";
    protected static final String ALT_KEYID_TYPE_SPKISHA1 = "SpkiSHA1";
    protected static final String ALT_KEYID_TYPE_NONE = "None";
    protected static final String ALT_KEYID_TYPE_EMPTY = "Empty";
    protected static final boolean DEF_CRITICAL = false;
    protected static final String DEF_ALT_KEYID_TYPE = "SpkiSHA1";
    protected boolean mEnabled = false;
    protected ConfigStore mConfig;
    protected boolean mCritical = false;
    protected String mAltKeyIdType = "SpkiSHA1";
    protected AuthorityKeyIdentifierExtension mTheExtension = null;
    protected Vector<String> mInstanceParams = new Vector();
    protected static Vector<String> mDefaultParams = new Vector();

    public AuthorityKeyIdentifierExt() {
        this.NAME = "AuthorityKeyIdentifierExt";
        this.DESC = "Adds Authority Key Idenifier Extension to certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mAltKeyIdType = this.mConfig.getString(PROP_ALT_KEYID_TYPE, "SpkiSHA1");
        if (this.mAltKeyIdType.equalsIgnoreCase("SpkiSHA1")) {
            this.mAltKeyIdType = "SpkiSHA1";
        } else if (this.mAltKeyIdType.equalsIgnoreCase(ALT_KEYID_TYPE_NONE)) {
            this.mAltKeyIdType = ALT_KEYID_TYPE_NONE;
        } else {
            logger.error(this.NAME + CMS.getLogMessage((String)"CA_UNKNOWN_ALT_KEY_ID_TYPE", (Object[])new Object[]{this.mAltKeyIdType}));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_ALT_KEYID_TYPE, "value must be one of SpkiSHA1, None"}));
        }
        CertificateAuthority certAuthority = (CertificateAuthority)owner.getAuthority();
        if (certAuthority == null) {
            String msg = this.NAME + ": Cannot find the Certificate Manager or Registration Manager";
            logger.error(CMS.getLogMessage((String)"CA_CANT_FIND_MANAGER", (Object[])new Object[0]));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{msg}));
        }
        X509CertImpl caCert = certAuthority.getCACert();
        CAEngine engine = CAEngine.getInstance();
        if (caCert == null || engine.isPreOpMode()) {
            logger.warn("AuthorityKeyIdentifierExt.init(): Abort due to missing CA certificate or in pre-op-mode");
            return;
        }
        KeyIdentifier keyId = this.formKeyIdentifier(caCert);
        if (keyId != null) {
            try {
                this.mTheExtension = new AuthorityKeyIdentifierExtension(this.mCritical, keyId, null, null);
            }
            catch (IOException e) {
                String msg = this.NAME + ": Error forming Authority Key Identifier extension: " + e;
                logger.error(CMS.getLogMessage((String)"POLICY_ERROR_AUTHORITY_KEY_ID_1", (Object[])new Object[]{this.NAME}), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{msg}), (Throwable)e);
            }
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("AltKeyIdType=" + this.mAltKeyIdType);
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.NAME}), "");
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certResult = this.applyCert(req, ci[i]);
            if (certResult != PolicyResult.REJECTED) continue;
            return certResult;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            AuthorityKeyIdentifierExtension authorityKeyIdExt = null;
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            try {
                if (extensions != null) {
                    authorityKeyIdExt = (AuthorityKeyIdentifierExtension)extensions.get("AuthorityKeyIdentifier");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (authorityKeyIdExt != null) {
                if (this.agentApproved(req)) {
                    logger.debug("AuthorityKeyIdentifierKeyExt: agent approved request id " + req.getRequestId() + " already has authority key id extension with value " + authorityKeyIdExt);
                    return PolicyResult.ACCEPTED;
                }
                logger.debug("AuthorityKeyIdentifierKeyExt: request id from user " + req.getRequestId() + " had authority key identifier - deleted");
                extensions.delete("AuthorityKeyIdentifier");
            }
            if (this.mTheExtension == null) {
                return PolicyResult.ACCEPTED;
            }
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            extensions.set("AuthorityKeyIdentifier", (Object)this.mTheExtension);
            logger.debug("AuthorityKeyIdentifierKeyExt: added authority key id ext to request " + req.getRequestId());
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_UNEXPECTED_POLICY_ERROR", (Object[])new Object[]{this.NAME, e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[]{this.NAME, e.getMessage()}), "");
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_CERT", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[]{this.NAME, "Certificate Info Error"}), "");
            return PolicyResult.REJECTED;
        }
    }

    protected KeyIdentifier formKeyIdentifier(X509CertImpl caCertImpl) throws EBaseException {
        KeyIdentifier keyId = null;
        X509CertInfo certInfo = null;
        try {
            certInfo = (X509CertInfo)caCertImpl.get("x509.info");
            if (certInfo == null) {
                String msg = "Bad CA certificate encountered. TBS Certificate missing.";
                logger.error(CMS.getLogMessage((String)"BASE_INVALID_CERT_FORMAT", (Object[])new Object[0]));
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{this.NAME + ": " + msg}));
            }
        }
        catch (CertificateException e) {
            logger.error(this.NAME + ": " + CMS.getLogMessage((String)"BASE_DECODE_CERT_FAILED_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{this.NAME + " Error decoding the CA Certificate: " + e}), (Throwable)e);
        }
        keyId = this.getKeyIdentifier(certInfo);
        if (keyId != null) {
            return keyId;
        }
        if (this.mAltKeyIdType == "SpkiSHA1") {
            keyId = this.formSpkiSHA1KeyId(certInfo);
        } else if (this.mAltKeyIdType == ALT_KEYID_TYPE_NONE) {
            keyId = null;
        } else {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{this.mAltKeyIdType, "Unknown Alternate Key Identifier type."}));
        }
        return keyId;
    }

    protected KeyIdentifier getKeyIdentifier(X509CertInfo certInfo) throws EBaseException {
        CertificateExtensions exts = null;
        SubjectKeyIdentifierExtension subjKeyIdExt = null;
        KeyIdentifier keyId = null;
        try {
            exts = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException e) {
            logger.error(this.NAME + ": No extensions found: " + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (CertificateException e) {
            logger.error(this.NAME + ": No extensions found: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (exts == null) {
            return null;
        }
        try {
            subjKeyIdExt = (SubjectKeyIdentifierExtension)exts.get("SubjectKeyIdentifier");
        }
        catch (IOException e) {
            logger.error("AuthorityKeyIdentifierKeyExt: No Subject Key Identifier Extension found: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (subjKeyIdExt == null) {
            return null;
        }
        try {
            keyId = (KeyIdentifier)subjKeyIdExt.get("key_id");
        }
        catch (IOException e) {
            String msg = this.NAME + ": Bad Subject Key Identifier Extension found. Error: " + e;
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_AUTHORITY_KEY_ID_1", (Object[])new Object[]{this.NAME}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{msg}), (Throwable)e);
        }
        return keyId;
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefaultParams;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;RFC 2459 recommendation: MUST NOT be marked critical.", "AltKeyIdType;choice(SpkiSHA1,None);Specifies whether to use a SHA1 hash of the CA's subject public key info for key identifier or leave out the authority key identifier extension if the CA certificate does not have a Subject Key Identifier extension.", "HELP_TOKEN;configuration-policyrules-authkeyid", "HELP_TEXT;Adds Authority Key Identifier Extension. See RFC 2459 (4.2.1.1)"};
        return params;
    }

    static {
        mDefaultParams.addElement("critical=false");
        mDefaultParams.addElement("AltKeyIdType=SpkiSHA1");
    }
}

