/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.certsrv.key.KeyInfoCollection;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSKeyCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.util.logging.PKILogger;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.symkey.SessionKey;

public class NSSKeyFindCLI
extends CommandCLI {
    public NSSKeyCLI keyCLI;

    public NSSKeyFindCLI(NSSKeyCLI keyCLI) {
        super("find", "Find keys in NSS database", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "nickname", true, "Certificate nickname");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json.");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        ArrayList<PK11SymKey> symmetricKeys;
        List<Object> privateKeys;
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        String nickname = cmd.getOptionValue("nickname");
        if (nickname != null) {
            CryptoManager cm = CryptoManager.getInstance();
            privateKeys = new ArrayList();
            for (X509Certificate x509Certificate : cm.findCertsByNickname(nickname)) {
                try {
                    PrivateKey privateKey = cm.findPrivKeyByCert(x509Certificate);
                    privateKeys.add(privateKey);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
            symmetricKeys = new ArrayList<PK11SymKey>();
        } else {
            String tokenName = this.getConfig().getTokenName();
            CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
            CryptoStore cryptoStore = token.getCryptoStore();
            privateKeys = Arrays.asList(cryptoStore.getPrivateKeys());
            logger.info("Private keys: " + privateKeys);
            symmetricKeys = new ArrayList();
            String nicknames = SessionKey.ListSymmetricKeys((String)tokenName);
            logger.info("Symmetric keys: " + nicknames);
            for (String n : nicknames.split(",")) {
                if (StringUtils.isEmpty((CharSequence)n)) continue;
                PK11SymKey symmetricKey = SessionKey.GetSymKeyByName((String)tokenName, (String)n);
                symmetricKeys.add(symmetricKey);
            }
        }
        KeyInfoCollection keyInfoCollection = new KeyInfoCollection();
        for (PrivateKey privateKey : privateKeys) {
            KeyInfo keyInfo = new KeyInfo();
            String string = "0x" + Utils.HexEncode((byte[])privateKey.getUniqueID());
            keyInfo.setKeyId(new KeyId(string));
            keyInfo.setType(privateKey.getType().toString());
            keyInfo.setAlgorithm(privateKey.getAlgorithm());
            keyInfoCollection.addEntry((Object)keyInfo);
        }
        for (SymmetricKey symmetricKey : symmetricKeys) {
            KeyInfo keyInfo = new KeyInfo();
            keyInfo.setNickname(symmetricKey.getNickName());
            keyInfo.setType(symmetricKey.getType().toString());
            keyInfo.setAlgorithm(symmetricKey.getAlgorithm());
            keyInfoCollection.addEntry((Object)keyInfo);
        }
        keyInfoCollection.setTotal(keyInfoCollection.getEntries().size());
        String outputFormat = cmd.getOptionValue("output-format", "text");
        if (outputFormat.equalsIgnoreCase("json")) {
            System.out.println(keyInfoCollection.toJSON());
        } else if (outputFormat.equalsIgnoreCase("text")) {
            boolean bl = true;
            for (KeyInfo keyInfo : keyInfoCollection.getEntries()) {
                boolean bl2;
                if (bl2) {
                    bl2 = false;
                } else {
                    System.out.println();
                }
                NSSKeyCLI.printKeyInfo(keyInfo);
            }
        } else {
            throw new Exception("Unsupported output format: " + outputFormat);
        }
    }
}

