/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.pkcs12.PKCS12CLI;
import com.netscape.cmstools.pkcs12.PKCS12CertAddCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertExportCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertFindCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertImportCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertModCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertRemoveCLI;
import org.dogtagpki.cli.CLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12CertInfo;
import org.mozilla.jss.netscape.security.util.Utils;

public class PKCS12CertCLI
extends CLI {
    public PKCS12CLI pkcs12CLI;

    public PKCS12CertCLI(PKCS12CLI pkcs12CLI) {
        super("cert", "PKCS #12 certificate management commands", (CLI)pkcs12CLI);
        this.pkcs12CLI = pkcs12CLI;
        this.addModule((CLI)new PKCS12CertAddCLI(this));
        this.addModule((CLI)new PKCS12CertExportCLI(this));
        this.addModule((CLI)new PKCS12CertImportCLI(this));
        this.addModule((CLI)new PKCS12CertFindCLI(this));
        this.addModule((CLI)new PKCS12CertModCLI(this));
        this.addModule((CLI)new PKCS12CertRemoveCLI(this));
    }

    public static void printCertInfo(PKCS12 pkcs12, PKCS12CertInfo certInfo) throws Exception {
        byte[] keyID;
        String hexCertID = "0x" + Utils.HexEncode((byte[])certInfo.getID());
        System.out.println("  Certificate ID: " + hexCertID);
        System.out.println("  Serial Number: " + new CertId(certInfo.getCert().getSerialNumber()).toHexString());
        System.out.println("  Friendly Name: " + certInfo.getFriendlyName());
        System.out.println("  Subject DN: " + certInfo.getCert().getSubjectName());
        System.out.println("  Issuer DN: " + certInfo.getCert().getIssuerName());
        if (certInfo.getTrustFlags() != null) {
            System.out.println("  Trust Flags: " + certInfo.getTrustFlags());
        }
        System.out.println("  Has Key: " + ((keyID = certInfo.getKeyID()) != null));
        if (keyID != null) {
            String hexKeyID = "0x" + Utils.HexEncode((byte[])keyID);
            System.out.println("  Key ID: " + hexKeyID);
        }
    }
}

