/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.logging;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogSource;
import java.text.MessageFormat;

public class LogEvent {
    Object[] mParams;
    String mEventType;
    String mMessage;
    int mLevel = -1;
    int mNTEventType = -1;
    LogSource mSource;
    boolean mMultiline = false;
    long mTimeStamp = System.currentTimeMillis();

    public LogEvent() {
    }

    public LogEvent(String msgFormat) {
        this.mMessage = msgFormat;
        this.mParams = null;
    }

    public LogEvent(String msgFormat, String param) {
        this(msgFormat);
        this.mParams = new String[1];
        this.mParams[0] = param;
    }

    public LogEvent(String msgFormat, Exception exception) {
        this(msgFormat);
        this.mParams = new Exception[1];
        this.mParams[0] = exception;
    }

    public LogEvent(Exception e) {
        this(e.getMessage());
        if (e instanceof EBaseException) {
            this.mParams = ((EBaseException)((Object)e)).getParameters();
        } else {
            this.mParams = new Exception[1];
            this.mParams[0] = e;
        }
    }

    public LogEvent(String msgFormat, Object[] params) {
        this(msgFormat);
        this.mParams = params;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public Object[] getParameters() {
        return this.mParams;
    }

    public void setParameters(Object[] params) {
        this.mParams = params;
    }

    public LogSource getSource() {
        return this.mSource;
    }

    public void setSource(LogSource source) {
        this.mSource = source;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public int getNTEventType() {
        return this.mNTEventType;
    }

    public void setLevel(int level) {
        this.mLevel = level;
        switch (level) {
            case 0: 
            case 1: {
                this.mNTEventType = 4;
                break;
            }
            case 2: {
                this.mNTEventType = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mNTEventType = 1;
                break;
            }
            default: {
                System.err.println("Invalid log level: " + level);
            }
        }
    }

    public boolean getMultiline() {
        return this.mMultiline;
    }

    public void setMultiline(boolean multiline) {
        this.mMultiline = multiline;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public String getEventType() {
        return this.mEventType;
    }

    public void setEventType(String eventType) {
        this.mEventType = eventType;
    }

    public String toString() {
        MessageFormat detailMessage = new MessageFormat(this.mMessage);
        return detailMessage.format(this.mParams);
    }
}

