/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authorization;

import com.netscape.certsrv.acls.ACLEntry;
import com.netscape.certsrv.acls.EACLsException;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzInternalError;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cms.authorization.ACL;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthorizationConfig;
import org.dogtagpki.server.authorization.AuthzManager;
import org.dogtagpki.server.authorization.AuthzManagerConfig;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAclAuthz
extends AuthzManager {
    public static final Logger logger = LoggerFactory.getLogger(AAclAuthz.class);
    protected static final String PROP_CLASS = "class";
    protected static final String PROP_IMPL = "impl";
    protected static final String PROP_EVAL = "accessEvaluator";
    protected static final String ACLS_ATTR = "aclResources";
    private Map<String, ACL> mACLs = new HashMap<String, ACL>();
    private Hashtable<String, AccessEvaluator> mEvaluators = new Hashtable();
    protected static Vector<String> mExtendedPluginInfo = null;
    protected static String[] mConfigParams = null;

    protected AAclAuthz() {
    }

    @Override
    public void init(String name, String implName, AuthzManagerConfig config) throws EBaseException {
        this.name = name;
        this.implName = implName;
        this.config = config;
        logger.debug("AAclAuthz: init begins");
        EngineConfig mainConfig = this.engine.getConfig();
        ConfigStore evalConfig = mainConfig.getSubStore(PROP_EVAL, ConfigStore.class);
        ConfigStore i = evalConfig.getSubStore(PROP_IMPL, ConfigStore.class);
        AccessEvaluator evaluator = null;
        Enumeration<String> mImpls = i.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String type = mImpls.nextElement();
            String evalClassPath = null;
            try {
                evalClassPath = i.getString(type + ".class");
            }
            catch (Exception e) {
                logger.error("AAclAuthz: failed to get config class info", (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", type + ".class"));
            }
            try {
                evaluator = (AccessEvaluator)Class.forName(evalClassPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new EACLsException(CMS.getUserMessage("CMS_ACL_CLASS_LOAD_FAIL", evalClassPath));
            }
            if (evaluator != null) {
                evaluator.setCMSEngine(this.engine);
                evaluator.init();
                this.registerEvaluator(type, evaluator);
                continue;
            }
            logger.warn("AAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_NULL", type));
        }
        logger.info("AAclAuthz: initialization done");
    }

    public void addACLs(String resACLs) throws EACLsException {
        ACL acl = ACL.parseACL(resACLs);
        if (acl == null) {
            logger.warn("AAclAuthz: parseACL failed");
            return;
        }
        this.addACLs(acl);
    }

    public void addACLs(ACL acl) throws EACLsException {
        ACL curACL = this.mACLs.get(acl.getName());
        if (curACL == null) {
            this.mACLs.put(acl.getName(), acl);
        } else {
            curACL.merge(acl);
        }
    }

    @Override
    public void accessInit(String accessInfo) throws EBaseException {
        this.addACLs(accessInfo);
    }

    @Override
    public ACL getACL(String target) throws EACLsException {
        return this.mACLs.get(target);
    }

    protected Set<String> getTargetNames() throws EACLsException {
        return this.mACLs.keySet();
    }

    @Override
    public Collection<ACL> getACLs() throws EACLsException {
        return this.mACLs.values();
    }

    public String[] getExtendedPluginInfo() {
        return Utils.getStringArrayFromVector(mExtendedPluginInfo);
    }

    @Override
    public String[] getConfigParams() {
        return mConfigParams;
    }

    @Override
    public void registerEvaluator(String type, AccessEvaluator evaluator) {
        this.mEvaluators.put(type, evaluator);
        logger.info("AAclAuthz: " + type + " evaluator registered");
    }

    protected synchronized void checkPermission(String name, String perm) throws EACLsException {
        Object resource = "";
        StringTokenizer st = new StringTokenizer(name, ".");
        while (st.hasMoreTokens()) {
            String node = st.nextToken();
            resource = !"".equals(resource) ? (String)resource + "." + node : node;
            boolean passed = false;
            try {
                passed = this.checkACLs((String)resource, perm);
            }
            catch (EACLsException e) {
                Object[] params = new Object[]{name, perm};
                logger.error(CMS.getLogMessage("AUTHZ_EVALUATOR_ACCESS_DENIED", name, perm), (Throwable)((Object)e));
                throw new EACLsException(CMS.getUserMessage("CMS_ACL_NO_PERMISSION", (String[])params));
            }
            if (!passed) continue;
            logger.info("AAclAuthz: Granting " + perm + " permission for " + name);
            return;
        }
    }

    protected boolean checkACLs(String name, String perm) throws EACLsException {
        ACL acl = this.mACLs.get(name);
        if (acl == null) {
            String infoMsg = "checkACLs(): no acl for" + name + "...pass down to next node";
            logger.info("AAclAuthz: " + infoMsg);
            return false;
        }
        Enumeration<ACLEntry> e = acl.entries();
        if (e == null || !e.hasMoreElements()) {
            String infoMsg = " AAclAuthz.checkACLs(): no acis for " + name + " acl entry...pass down to next node";
            logger.info("AAclAuthz: " + infoMsg);
            return false;
        }
        while (e.hasMoreElements()) {
            ACLEntry entry = e.nextElement();
            if (!entry.containPermission(perm)) continue;
            if (this.evaluateExpressions(entry.getAttributeExpressions())) {
                if (entry.checkPermission(perm)) continue;
                logger.error("AAclAuthz: checkACLs(): permission denied");
                throw new EACLsException(CMS.getUserMessage("CMS_ACL_PERMISSION_DENIED", new String[0]));
            }
            if (entry.getType() != ACLEntry.Type.ALLOW) continue;
            logger.error("AAclAuthz: checkACLs(): permission denied");
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_PERMISSION_DENIED", new String[0]));
        }
        return true;
    }

    private boolean evaluateExpressions(String s) {
        logger.debug("evaluating expressions: " + s);
        Vector<Object> v = new Vector<Object>();
        while (s.length() > 0) {
            boolean passed;
            String s1;
            int orIndex = s.indexOf("||");
            int andIndex = s.indexOf("&&");
            if (orIndex == -1 && andIndex == -1) {
                boolean passed2 = this.evaluateExpression(s.trim());
                v.addElement(passed2);
                break;
            }
            if (andIndex == -1 || orIndex != -1 && orIndex < andIndex) {
                s1 = s.substring(0, orIndex);
                passed = this.evaluateExpression(s1.trim());
                v.addElement(passed);
                v.addElement("||");
                s = s.substring(orIndex + 2);
                continue;
            }
            s1 = s.substring(0, andIndex);
            passed = this.evaluateExpression(s1.trim());
            v.addElement(passed);
            v.addElement("&&");
            s = s.substring(andIndex + 2);
        }
        if (v.size() == 1) {
            Boolean bool = (Boolean)v.remove(0);
            return bool;
        }
        boolean left = false;
        String op = "";
        boolean right = false;
        while (!v.isEmpty()) {
            if (op.equals("")) {
                left = (Boolean)v.remove(0);
            }
            op = (String)v.remove(0);
            right = (Boolean)v.remove(0);
            left = this.evaluateExp(left, op, right);
        }
        return left;
    }

    private boolean evaluateExpression(String expression) {
        int i = expression.indexOf("=");
        String type = expression.substring(0, i);
        String value = expression.substring(i + 1);
        AccessEvaluator evaluator = this.mEvaluators.get(type);
        if (evaluator == null) {
            logger.warn("AAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_NOT_FOUND", type));
            return false;
        }
        return evaluator.evaluate(type, "=", value);
    }

    public synchronized void checkPermission(AuthToken authToken, String name, String perm) throws EACLsException {
        logger.debug("AAclAuthz.checkPermission(" + name + ", " + perm + ")");
        Vector<String> nodes = this.getNodes(name);
        EvaluationOrder order = this.getOrder();
        boolean permitted = false;
        if (order == EvaluationOrder.DENY_ALLOW) {
            this.checkDenyEntries(authToken, nodes, perm);
            permitted = this.checkAllowEntries(authToken, nodes, perm);
        } else if (order == EvaluationOrder.ALLOW_DENY) {
            permitted = this.checkAllowEntries(authToken, nodes, perm);
            this.checkDenyEntries(authToken, nodes, perm);
        }
        if (!permitted) {
            String[] params = new String[]{name, perm};
            logger.error(CMS.getLogMessage("AUTHZ_EVALUATOR_ACCESS_DENIED", name, perm));
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_NO_PERMISSION", params));
        }
        logger.info("AAclAuthz: Granting " + perm + " permission for " + name);
    }

    protected boolean checkAllowEntries(AuthToken authToken, Iterable<String> nodes, String perm) throws EACLsException {
        for (ACLEntry entry : this.getEntries(ACLEntry.Type.ALLOW, nodes, perm)) {
            logger.debug("checkAllowEntries(): expressions: " + entry.getAttributeExpressions());
            if (!this.evaluateExpressions(authToken, entry.getAttributeExpressions())) continue;
            return true;
        }
        return false;
    }

    protected void checkDenyEntries(AuthToken authToken, Iterable<String> nodes, String perm) throws EACLsException {
        for (ACLEntry entry : this.getEntries(ACLEntry.Type.DENY, nodes, perm)) {
            logger.debug("checkDenyEntries(): expressions: " + entry.getAttributeExpressions());
            if (!this.evaluateExpressions(authToken, entry.getAttributeExpressions())) continue;
            logger.error("AAclAuthz: checkPermission(): permission denied");
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_PERMISSION_DENIED", new String[0]));
        }
    }

    protected Iterable<ACLEntry> getEntries(ACLEntry.Type entryType, Iterable<String> nodes, String operation) throws EACLsException {
        Vector<ACLEntry> v = new Vector<ACLEntry>();
        for (String name : nodes) {
            ACL acl = this.mACLs.get(name);
            if (acl == null) continue;
            Enumeration<ACLEntry> e = acl.entries();
            while (e.hasMoreElements()) {
                ACLEntry entry = e.nextElement();
                if (entry.getType() != entryType || !entry.containPermission(operation)) continue;
                v.addElement(entry);
            }
        }
        return v;
    }

    private boolean evaluateExpressions(AuthToken authToken, String s) {
        logger.debug("evaluating expressions: " + s);
        Vector<Object> v = new Vector<Object>();
        while (s.length() > 0) {
            boolean passed;
            String s1;
            int orIndex = s.indexOf("||");
            int andIndex = s.indexOf("&&");
            if (orIndex == -1 && andIndex == -1) {
                boolean passed2 = this.evaluateExpression(authToken, s.trim());
                logger.debug("evaluated expression: " + s.trim() + " to be " + passed2);
                v.addElement(passed2);
                break;
            }
            if (andIndex == -1 || orIndex != -1 && orIndex < andIndex) {
                s1 = s.substring(0, orIndex);
                passed = this.evaluateExpression(authToken, s1.trim());
                logger.debug("evaluated expression: " + s1.trim() + " to be " + passed);
                v.addElement(passed);
                v.addElement("||");
                s = s.substring(orIndex + 2);
                continue;
            }
            s1 = s.substring(0, andIndex);
            passed = this.evaluateExpression(authToken, s1.trim());
            logger.debug("evaluated expression: " + s1.trim() + " to be " + passed);
            v.addElement(passed);
            v.addElement("&&");
            s = s.substring(andIndex + 2);
        }
        if (v.isEmpty()) {
            return false;
        }
        if (v.size() == 1) {
            Boolean bool = (Boolean)v.remove(0);
            return bool;
        }
        boolean left = false;
        String op = "";
        boolean right = false;
        while (!v.isEmpty()) {
            if (op.equals("")) {
                left = (Boolean)v.remove(0);
            }
            op = (String)v.remove(0);
            right = (Boolean)v.remove(0);
            left = this.evaluateExp(left, op, right);
        }
        return left;
    }

    public Vector<String> getNodes(String resourceID) {
        Vector<String> v = new Vector<String>();
        if (resourceID == null || resourceID.equals("")) {
            return v;
        }
        v.addElement(resourceID);
        int index = resourceID.lastIndexOf(".");
        String name = resourceID;
        while (index != -1) {
            name = name.substring(0, index);
            v.addElement(name);
            index = name.lastIndexOf(".");
        }
        return v;
    }

    private boolean evaluateExpression(AuthToken authToken, String expression) {
        AccessEvaluator evaluator;
        String op = this.getOp(expression);
        String type = "";
        String value = "";
        if (!op.equals("")) {
            int len = op.length();
            int i = expression.indexOf(op);
            type = expression.substring(0, i).trim();
            value = expression.substring(i + len).trim();
        }
        if ((evaluator = this.mEvaluators.get(type)) == null) {
            logger.warn("AAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_NOT_FOUND", type));
            return false;
        }
        return evaluator.evaluate(authToken, type, op, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getOp(String exp) {
        int i = exp.indexOf("!=");
        if (i != -1) return "!=";
        i = exp.indexOf("=");
        if (i != -1) return "=";
        i = exp.indexOf(">");
        if (i != -1) return ">";
        i = exp.indexOf("<");
        if (i != -1) {
            return "<";
        }
        logger.warn("AAclAuthz: " + CMS.getLogMessage("AUTHZ_OP_NOT_SUPPORTED", exp));
        return "";
    }

    private boolean evaluateExp(boolean left, String op, boolean right) {
        if (op.equals("||")) {
            return left || right;
        }
        if (op.equals("&&")) {
            return left && right;
        }
        return false;
    }

    @Override
    public void updateACLs(String id, String rights, String strACLs, String desc) throws EACLsException {
        Object resourceACLs = id;
        if (rights != null) {
            resourceACLs = id + ":" + rights + ":" + strACLs + ":" + desc;
        }
        ACL ac = null;
        try {
            ac = ACL.parseACL((String)resourceACLs);
        }
        catch (EBaseException ex) {
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_PARSING_ERROR_0", new String[0]));
        }
        this.mACLs.put(ac.getName(), ac);
    }

    @Override
    public Enumeration<AccessEvaluator> aclEvaluatorElements() {
        return this.mEvaluators.elements();
    }

    @Override
    public Hashtable<String, AccessEvaluator> getAccessEvaluators() {
        return this.mEvaluators;
    }

    public boolean isTypeUnique(String type) throws EACLsException {
        return !this.mACLs.containsKey(type);
    }

    @Override
    public AuthzToken authorize(AuthToken authToken, String resource, String operation) throws EAuthzInternalError, EAuthzAccessDenied {
        try {
            this.checkPermission(authToken, resource, operation);
            AuthzToken authzToken = new AuthzToken(this);
            authzToken.set("authzRes", resource);
            authzToken.set("authzOp", operation);
            authzToken.set("status", "statusSuccess");
            logger.debug(this.name + ": authorization passed");
            return authzToken;
        }
        catch (EACLsException e) {
            logger.error("AAclAuthz: " + CMS.getLogMessage("AUTHZ_EVALUATOR_AUTHORIZATION_FAILED", new Object[0]), (Throwable)((Object)e));
            logger.error("AAclAuthz: " + CMS.getLogMessage("AUTHZ_AUTHZ_ACCESS_DENIED_2", resource, operation));
            throw new EAuthzAccessDenied(CMS.getUserMessage("CMS_AUTHORIZATION_ERROR", new String[0]));
        }
    }

    @Override
    public AuthzToken authorize(AuthToken authToken, String expression) throws EAuthzAccessDenied {
        if (this.evaluateACLs(authToken, expression)) {
            return new AuthzToken(this);
        }
        String[] params = new String[]{expression};
        throw new EAuthzAccessDenied(CMS.getUserMessage("CMS_AUTHORIZATION_AUTHZ_ACCESS_DENIED", params));
    }

    public EvaluationOrder getOrder() {
        EngineConfig cs = this.engine.getConfig();
        AuthorizationConfig authzConfig = cs.getAuthorizationConfig();
        try {
            String order = authzConfig.getString("evaluateOrder", "");
            return order.startsWith("allow") ? EvaluationOrder.ALLOW_DENY : EvaluationOrder.DENY_ALLOW;
        }
        catch (Exception e) {
            return EvaluationOrder.DENY_ALLOW;
        }
    }

    public boolean evaluateACLs(AuthToken authToken, String exp) {
        return this.evaluateExpressions(authToken, exp);
    }

    static {
        mExtendedPluginInfo = new Vector();
    }

    public static enum EvaluationOrder {
        DENY_ALLOW,
        ALLOW_DENY;

    }
}

