/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cms.password.PasswordChecker;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsrGrpAdminServlet
extends AdminServlet {
    public static final Logger logger = LoggerFactory.getLogger(UsrGrpAdminServlet.class);
    private static final long serialVersionUID = -4341817607402387714L;
    private static final String INFO = "UsrGrpAdminServlet";
    private static final String SYSTEM_USER = "$System$";
    private static final String BACK_SLASH = "\\";
    private UGSubsystem mMgr = null;
    private static String[] mMultiRoleGroupEnforceList = null;
    private static final String MULTI_ROLE_ENABLE = "multiroles.enable";
    private static final String MULTI_ROLE_ENFORCE_GROUP_LIST = "multiroles.false.groupEnforceList";

    public UsrGrpAdminServlet() {
        CMSEngine engine = this.getCMSEngine();
        this.mAuthz = engine.getAuthzSubsystem();
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CMSEngine engine = this.getCMSEngine();
        this.mMgr = engine.getUGSubsystem();
    }

    public String getServletInfo() {
        return INFO;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        String scope = super.getParameter(req, "OP_SCOPE");
        String op = super.getParameter(req, "OP_TYPE");
        if (op == null) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_INVALID_PROTOCOL", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_PROTOCOL", new String[0]), null, resp);
            return;
        }
        Locale clientLocale = super.getLocale(req);
        try {
            super.authenticate(req);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_FAIL_AUTHS", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHS_FAILED", new String[0]), null, resp);
            return;
        }
        String subsystemPath = this.getServletContext().getContextPath();
        String subsystemID = subsystemPath.substring(1);
        AUTHZ_RES_NAME = "certServer." + subsystemID + ".group";
        try {
            if (scope == null) {
                return;
            }
            if (scope.equals("userType")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                this.getUserType(req, resp);
                return;
            }
            if (op.equals("OP_READ")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("groups")) {
                    this.findGroup(req, resp);
                } else if (scope.equals("users")) {
                    this.findUser(req, resp);
                } else if (scope.equals("certs")) {
                    this.findUserCerts(req, resp, clientLocale);
                }
            } else if (op.equals("OP_MODIFY")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("groups")) {
                    this.modifyGroup(req, resp);
                } else if (scope.equals("users")) {
                    this.modifyUser(req, resp);
                } else if (scope.equals("certs")) {
                    this.modifyUserCert(req, resp);
                }
            } else if (op.equals("OP_ADD")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("groups")) {
                    this.addGroup(req, resp);
                } else if (scope.equals("users")) {
                    this.addUser(req, resp);
                } else if (scope.equals("certs")) {
                    this.addUserCert(req, resp);
                }
            } else if (op.equals("OP_DELETE")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("groups")) {
                    this.removeGroup(req, resp);
                } else if (scope.equals("users")) {
                    this.removeUser(req, resp);
                }
            } else if (op.equals("OP_SEARCH")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                    return;
                }
                if (scope.equals("groups")) {
                    this.findGroups(req, resp);
                } else if (scope.equals("users")) {
                    this.findUsers(req, resp);
                } else {
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_INVALID_OP_SCOPE", new Object[0]));
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                }
            }
        }
        catch (EBaseException e) {
            logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
        }
        catch (Exception e) {
            logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
            logger.error(CMS.getLogMessage(" ADMIN_SRVLT_FAIL_PERFORM", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_PERFORM_FAILED", new String[0]), null, resp);
        }
    }

    private void getUserType(HttpServletRequest req, HttpServletResponse resp) throws IOException, EBaseException {
        String id = super.getParameter(req, "RS_ID");
        User user = this.mMgr.getUser(id);
        String val = user.getUserType();
        if (val == null || val.equals("")) {
            val = "noType";
        }
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"userType", (Object)val);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void findUsers(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<User> e = null;
        try {
            e = this.mMgr.listUsers("*");
        }
        catch (Exception ex) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_INTERNAL_ERROR", new String[0]), null, resp);
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (e.hasMoreElements()) {
            User user = e.nextElement();
            if (i > 0) {
                sb.append(";");
                sb.append(user.getUserID());
                sb.append(":");
                sb.append(user.getFullName());
            } else {
                sb.append(user.getUserID());
                sb.append(":");
                sb.append(user.getFullName());
            }
            ++i;
        }
        params.put((Object)"userInfo", (Object)sb.toString());
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void findUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = super.getParameter(req, "RS_ID");
        if (id == null) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        NameValuePairs params = new NameValuePairs();
        User user = null;
        try {
            user = this.mMgr.getUser(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_INTERNAL_ERROR", new String[0]), null, resp);
            return;
        }
        if (user != null) {
            params.put((Object)"fullname", (Object)user.getFullName());
            params.put((Object)"email", (Object)user.getEmail());
            params.put((Object)"phone", (Object)user.getPhone());
            params.put((Object)"state", (Object)user.getState());
            Enumeration<Group> e = null;
            try {
                e = this.mMgr.findGroups("*");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_INTERNAL_ERROR", new String[0]), null, resp);
                return;
            }
            StringBuffer grpString = new StringBuffer();
            while (e.hasMoreElements()) {
                Group group = e.nextElement();
                if (!group.isMember(id)) continue;
                if (grpString.length() != 0) {
                    grpString.append(",");
                }
                grpString.append(group.getGroupID());
            }
            params.put((Object)"groups", (Object)grpString.toString());
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_USER_NOT_EXIST", new String[0]), null, resp);
    }

    private synchronized void findUserCerts(HttpServletRequest req, HttpServletResponse resp, Locale clientLocale) throws Exception {
        String id = super.getParameter(req, "RS_ID");
        if (id == null) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        NameValuePairs params = new NameValuePairs();
        User user = null;
        try {
            user = this.mMgr.getUser(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_USER_NOT_EXIST", new String[0]), null, resp);
            return;
        }
        if (user == null) {
            logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_USER_NOT_EXIST", new String[0]), null, resp);
            return;
        }
        java.security.cert.X509Certificate[] certs = user.getX509Certificates();
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                CertPrettyPrint print = new CertPrettyPrint((Certificate)certs[i]);
                String base64 = CertUtil.toPEM((java.security.cert.X509Certificate)certs[i]);
                params.put((Object)this.getCertificateString(certs[i]), (Object)(print.toString(clientLocale) + "\n" + base64));
            }
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    protected String getCertificateString(java.security.cert.X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return cert.getVersion() + ";" + cert.getSerialNumber().toString() + ";" + cert.getIssuerDN() + ";" + cert.getSubjectDN();
    }

    private synchronized void findGroups(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<Group> e = null;
        try {
            e = this.mMgr.listGroups(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_INTERNAL_ERROR", new String[0]), null, resp);
            return;
        }
        while (e.hasMoreElements()) {
            Group group = e.nextElement();
            String desc = group.getDescription();
            if (desc == null) {
                params.put((Object)group.getGroupID(), (Object)"");
                continue;
            }
            params.put((Object)group.getGroupID(), (Object)desc);
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void findGroup(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        NameValuePairs params = new NameValuePairs();
        String id = super.getParameter(req, "RS_ID");
        if (id == null) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        Enumeration<Group> e = null;
        try {
            e = this.mMgr.findGroups(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_INTERNAL_ERROR", new String[0]), null, resp);
            return;
        }
        if (e.hasMoreElements()) {
            Group group = e.nextElement();
            params.put((Object)"group", (Object)group.getGroupID());
            params.put((Object)"desc", (Object)group.getDescription());
            Enumeration<String> members = group.getMemberNames();
            StringBuffer membersString = new StringBuffer();
            if (members != null) {
                while (members.hasMoreElements()) {
                    if (membersString.length() != 0) {
                        membersString.append(", ");
                    }
                    String mn = members.nextElement();
                    membersString.append(mn);
                }
            }
            params.put((Object)"user", (Object)membersString.toString());
            this.sendResponse(SUCCESS, null, params, resp);
        } else {
            logger.error(CMS.getLogMessage("USRGRP_SRVLT_GROUP_NOT_EXIST", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_GROUP_NOT_EXIST", new String[0]), null, resp);
        }
    }

    private synchronized void addUser(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        block27: {
            CMSEngine engine = this.getCMSEngine();
            Auditor auditor = engine.getAuditor();
            String auditSubjectID = this.auditSubjectID();
            try {
                String id = super.getParameter(req, "RS_ID");
                if (id == null) {
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                    return;
                }
                if (id.indexOf(BACK_SLASH) != -1) {
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_RS_ID_BS", new Object[0]));
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_RS_ID_BS", new String[0]), null, resp);
                    return;
                }
                if (id.equals(SYSTEM_USER)) {
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_SPECIAL_ID", id));
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_SPECIAL_ID", id), null, resp);
                    return;
                }
                User user = this.mMgr.createUser(id);
                String fname = super.getParameter(req, "fullname");
                if (fname == null || fname.length() == 0) {
                    String msg = CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_ADD_FAILED_1", "full name");
                    logger.error(msg);
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    this.sendResponse(ERROR, msg, null, resp);
                    return;
                }
                user.setFullName(fname);
                String email = super.getParameter(req, "email");
                if (email == null) {
                    user.setEmail("");
                } else {
                    user.setEmail(email);
                }
                String pword = super.getParameter(req, "password");
                if (pword == null || pword.equals("")) {
                    user.setPassword("");
                } else {
                    PasswordChecker passwdCheck = engine.getPasswordChecker();
                    if (!passwdCheck.isGoodPassword(pword)) {
                        auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                        throw new EUsrGrpException(passwdCheck.getReason(pword));
                    }
                    user.setPassword(pword);
                }
                String phone = super.getParameter(req, "phone");
                if (phone == null) {
                    user.setPhone("");
                } else {
                    user.setPhone(phone);
                }
                String userType = super.getParameter(req, "userType");
                if (userType == null) {
                    user.setUserType("");
                } else {
                    user.setUserType(userType);
                }
                String userState = super.getParameter(req, "state");
                if (userState != null) {
                    user.setState(userState);
                }
                try {
                    this.mMgr.addUser(user);
                    String groupName = super.getParameter(req, "groups");
                    if (groupName != null) {
                        Enumeration<Group> e = null;
                        try {
                            e = this.mMgr.findGroups(groupName);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_ADD_FAILED", new String[0]), null, resp);
                            return;
                        }
                        if (e.hasMoreElements()) {
                            Group group = e.nextElement();
                            group.addMemberName(id);
                            try {
                                this.mMgr.modifyGroup(group);
                            }
                            catch (Exception ex) {
                                logger.error("UsrGrpAdminServlet: " + ex.getMessage(), e);
                                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_ADD_FAILED", new String[0]), null, resp);
                                return;
                            }
                        }
                        SessionContext sContext = SessionContext.getContext();
                        String adminId = (String)sContext.get((Object)"userid");
                        logger.info("Admin UID: {} added User UID: {} to group: {}", new Object[]{adminId, id, groupName});
                    }
                    NameValuePairs params = new NameValuePairs();
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                    this.sendResponse(SUCCESS, null, params, resp);
                }
                catch (EUsrGrpException e) {
                    logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    if (user.getUserID() == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_ADD_FAILED_1", "uid"), null, resp);
                        break block27;
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_ADD_FAILED", new String[0]), null, resp);
                }
                catch (Exception e) {
                    logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_ADD_FAILED", new String[0]), null, resp);
                }
            }
            catch (EBaseException eAudit1) {
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                throw eAudit1;
            }
            catch (IOException eAudit2) {
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                throw eAudit2;
            }
        }
    }

    private synchronized void addUserCert(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = super.getParameter(req, "RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            User user = this.mMgr.createUser(id);
            String certS = super.getParameter(req, "cert");
            String certsString = Cert.stripBrackets((String)certS);
            if (certsString == null) {
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
                return;
            }
            java.security.cert.X509Certificate[] certs = null;
            try {
                byte[] bCert = Utils.base64decode((String)certsString);
                X509CertImpl cert = new X509CertImpl(bCert);
                certs = new java.security.cert.X509Certificate[]{cert};
            }
            catch (CertificateException e) {
                boolean assending = true;
                logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_IS_PK_BLOB", new Object[0]));
                byte[] p7Cert = Utils.base64decode((String)certsString);
                try {
                    CryptoManager manager = CryptoManager.getInstance();
                    PKCS7 pkcs7 = new PKCS7(p7Cert);
                    java.security.cert.X509Certificate[] p7certs = pkcs7.getCertificates();
                    if (p7certs.length == 0) {
                        auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_CERT_ERROR", new String[0]), null, resp);
                        return;
                    }
                    certs = new java.security.cert.X509Certificate[p7Cert.length];
                    if (p7certs[0].getSubjectDN().toString().equals(p7certs[0].getIssuerDN().toString()) && p7certs.length == 1) {
                        certs[0] = p7certs[0];
                        logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_SINGLE_CERT_IMPORT", new Object[0]));
                    } else if (p7certs[0].getIssuerDN().toString().equals(p7certs[1].getSubjectDN().toString())) {
                        certs[0] = p7certs[0];
                        logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_CHAIN_ACEND_ORD", new Object[0]));
                    } else if (p7certs[1].getIssuerDN().toString().equals(p7certs[0].getSubjectDN().toString())) {
                        assending = false;
                        logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_CHAIN_DESC_ORD", new Object[0]));
                        certs[0] = p7certs[p7certs.length - 1];
                    } else {
                        logger.error("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_BAD_CHAIN", new Object[0]));
                        auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_CERT_ERROR", new String[0]), null, resp);
                        return;
                    }
                    logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_CHAIN_STORED_DB", String.valueOf(p7certs.length)));
                    int j = 0;
                    int jBegin = 0;
                    int jEnd = 0;
                    if (assending) {
                        jBegin = 1;
                        jEnd = p7certs.length;
                    } else {
                        jBegin = 0;
                        jEnd = p7certs.length - 1;
                    }
                    for (j = jBegin; j < jEnd; ++j) {
                        logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_IN_CHAIN", String.valueOf(j), String.valueOf(p7certs[j].getSubjectDN())));
                        X509Certificate leafCert = null;
                        leafCert = manager.importCACertPackage(p7certs[j].getEncoded());
                        if (leafCert == null) {
                            logger.error(CMS.getLogMessage("ADMIN_SRVLT_LEAF_CERT_NULL", new Object[0]));
                        } else {
                            logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_LEAF_CERT_NON_NULL", new Object[0]));
                        }
                        if (leafCert instanceof InternalCertificate) {
                            InternalCertificate ic = (InternalCertificate)leafCert;
                            ic.setSSLTrust(152);
                            continue;
                        }
                        logger.error(CMS.getLogMessage("ADMIN_SRVLT_NOT_INTERNAL_CERT", String.valueOf(p7certs[j].getSubjectDN())));
                    }
                }
                catch (Exception ex) {
                    logger.error(CMS.getLogMessage("USRGRP_SRVLT_CERT_ERROR", ex.toString()), (Throwable)ex);
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_CERT_ERROR", new String[0]), null, resp);
                    return;
                }
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_CERT_O_ERROR", e.toString()), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_CERT_O_ERROR", new String[0]), null, resp);
                return;
            }
            try {
                logger.debug("UsrGrpAdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_BEFORE_VALIDITY", new Object[0]));
                certs[0].checkValidity();
                user.setX509Certificates(certs);
                this.mMgr.addUserCert(id, certs[0]);
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
            }
            catch (CertificateExpiredException e) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_ADD_CERT_EXPIRED", String.valueOf(certs[0].getSubjectDN())), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_CERT_EXPIRED", new String[0]), null, resp);
            }
            catch (CertificateNotYetValidException e) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_CERT_NOT_YET_VALID", String.valueOf(certs[0].getSubjectDN())), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_CERT_NOT_YET_VALID", new String[0]), null, resp);
            }
            catch (ConflictingOperationException e) {
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_USER_CERT_EXISTS", new String[0]), null, resp);
            }
            catch (Exception e) {
                logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_MOD_FAILED", new String[0]), null, resp);
            }
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void modifyUserCert(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = super.getParameter(req, "RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            String certDN = super.getParameter(req, "cert");
            if (certDN == null) {
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
                return;
            }
            try {
                this.mMgr.removeUserCert(id, certDN);
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
            }
            catch (Exception e) {
                logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_MOD_FAILED", new String[0]), null, resp);
            }
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void removeUser(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = super.getParameter(req, "RS_ID");
            boolean mustDelete = false;
            int index = 0;
            index = id.lastIndexOf(":true");
            if (index != -1) {
                id = id.substring(0, index);
                mustDelete = true;
            }
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            Enumeration<Group> e = null;
            try {
                e = this.mMgr.findGroups("*");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_INTERNAL_ERROR", new String[0]), null, resp);
                return;
            }
            while (e.hasMoreElements()) {
                Group group = e.nextElement();
                if (!group.isMember(id)) continue;
                if (mustDelete) {
                    this.mMgr.removeUserFromGroup(group, id);
                    continue;
                }
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_FAIL_USER_RMV_G", new String[0]), null, resp);
                return;
            }
            try {
                this.mMgr.removeUser(id);
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
            }
            catch (Exception ex) {
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_SRVLT_FAIL_USER_RMV", new String[0]), null, resp);
            }
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void addGroup(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String members;
            String id = super.getParameter(req, "RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            Group group = this.mMgr.createGroup(id);
            String description = super.getParameter(req, "desc");
            if (description != null && !description.equals("")) {
                group.set("description", description);
            }
            if ((members = super.getParameter(req, "user")) != null) {
                StringTokenizer st = new StringTokenizer(members, ",");
                while (st.hasMoreTokens()) {
                    group.addMemberName(st.nextToken());
                }
            }
            try {
                this.mMgr.addGroup(group);
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
            }
            catch (Exception e) {
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_GROUP_ADD_FAILED", new String[0]), null, resp);
            }
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void removeGroup(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = super.getParameter(req, "RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            this.mMgr.removeGroup(id);
            NameValuePairs params = new NameValuePairs();
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
            this.sendResponse(SUCCESS, null, params, resp);
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private synchronized void modifyGroup(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String members;
            String id = super.getParameter(req, "RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            Group group = this.mMgr.getGroupFromName(id);
            String description = super.getParameter(req, "desc");
            if (description != null) {
                if (description.equals("")) {
                    group.delete("description");
                } else {
                    group.set("description", description);
                }
            }
            if ((members = super.getParameter(req, "user")) != null) {
                group.delete("uniquemember");
                StringTokenizer st = new StringTokenizer(members, ",");
                String groupName = group.getName();
                boolean multiRole = true;
                try {
                    multiRole = this.mConfig.getBoolean(MULTI_ROLE_ENABLE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (st.hasMoreTokens()) {
                    String memberName = st.nextToken();
                    if (multiRole) {
                        group.addMemberName(memberName);
                        continue;
                    }
                    if (this.isGroupInMultiRoleEnforceList(groupName)) {
                        if (!this.isDuplicate(groupName, memberName)) {
                            group.addMemberName(memberName);
                            continue;
                        }
                        auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                        throw new EBaseException(CMS.getUserMessage("CMS_BASE_DUPLICATE_ROLES", memberName));
                    }
                    group.addMemberName(memberName);
                }
            }
            try {
                this.mMgr.modifyGroup(group);
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
            }
            catch (Exception e) {
                logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_GROUP_MODIFY_FAILED", new String[0]), null, resp);
            }
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }

    private boolean isGroupInMultiRoleEnforceList(String groupName) {
        String groupList = null;
        if (groupName == null || groupName.equals("")) {
            return true;
        }
        if (mMultiRoleGroupEnforceList == null) {
            try {
                groupList = this.mConfig.getString(MULTI_ROLE_ENFORCE_GROUP_LIST);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (groupList != null && !groupList.equals("")) {
                mMultiRoleGroupEnforceList = groupList.split(",");
                for (int j = 0; j < mMultiRoleGroupEnforceList.length; ++j) {
                    UsrGrpAdminServlet.mMultiRoleGroupEnforceList[j] = mMultiRoleGroupEnforceList[j].trim();
                }
            }
        }
        if (mMultiRoleGroupEnforceList == null) {
            return true;
        }
        for (int i = 0; i < mMultiRoleGroupEnforceList.length; ++i) {
            if (!groupName.equals(mMultiRoleGroupEnforceList[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicate(String groupName, String memberName) {
        Enumeration<Group> groups = null;
        boolean isMember = false;
        try {
            isMember = this.mMgr.isMemberOf(memberName, groupName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isMember) {
            return false;
        }
        try {
            groups = this.mMgr.listGroups(null);
            while (groups.hasMoreElements()) {
                Group group = groups.nextElement();
                String name = group.getName();
                Enumeration<Group> g = this.mMgr.findGroups(name);
                Group g1 = g.nextElement();
                if (name.equals(groupName) || !this.isGroupInMultiRoleEnforceList(name)) continue;
                Enumeration<String> members = g1.getMemberNames();
                while (members.hasMoreElements()) {
                    String m1 = members.nextElement();
                    if (!m1.equals(memberName)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private synchronized void modifyUser(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        try {
            String userState;
            String phone;
            String pword;
            String id = super.getParameter(req, "RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            User user = this.mMgr.createUser(id);
            String fname = super.getParameter(req, "fullname");
            if (fname == null || fname.length() == 0) {
                String msg = CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_MOD_FAILED", "full name");
                logger.error(msg);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, msg, null, resp);
                return;
            }
            user.setFullName(fname);
            String email = super.getParameter(req, "email");
            if (email != null) {
                user.setEmail(email);
            }
            if ((pword = super.getParameter(req, "password")) != null && !pword.equals("")) {
                PasswordChecker passwdCheck = engine.getPasswordChecker();
                if (!passwdCheck.isGoodPassword(pword)) {
                    auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                    throw new EUsrGrpException(passwdCheck.getReason(pword));
                }
                user.setPassword(pword);
            }
            if ((phone = super.getParameter(req, "phone")) != null) {
                user.setPhone(phone);
            }
            if ((userState = super.getParameter(req, "state")) != null) {
                user.setState(userState);
            }
            try {
                this.mMgr.modifyUser(user);
                NameValuePairs params = new NameValuePairs();
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", this.auditParams(req)));
                this.sendResponse(SUCCESS, null, params, resp);
            }
            catch (Exception e) {
                logger.error("UsrGrpAdminServlet: " + e.getMessage(), (Throwable)e);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_USRGRP_USER_MOD_FAILED", new String[0]), null, resp);
            }
        }
        catch (EBaseException eAudit1) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", this.auditParams(req)));
            throw eAudit2;
        }
    }
}

