/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.base;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimpleProperties
extends Hashtable<String, String> {
    private static final long serialVersionUID = -6129810287662322712L;
    protected SimpleProperties defaults;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";

    public SimpleProperties() {
        this((SimpleProperties)null);
    }

    public SimpleProperties(SimpleProperties defaults) {
        this.defaults = defaults;
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        Object line;
        while ((line = in.readLine()) != null) {
            int valueIndex;
            int separatorIndex;
            int keyStart;
            char firstChar;
            if (((String)line).length() <= 0 || (firstChar = ((String)line).charAt(0)) == '#' || firstChar == '!') continue;
            while (this.continueLine((String)line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = ((String)line).substring(0, ((String)line).length() - 1);
                int startIndex = 0;
                for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = loppedLine + nextLine;
            }
            int len = ((String)line).length();
            for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(((String)line).charAt(keyStart)) != -1; ++keyStart) {
            }
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = ((String)line).charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(((String)line).charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(((String)line).charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(((String)line).charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = ((String)line).substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? ((String)line).substring(valueIndex, len) : "";
            this.put(key, value);
        }
        return;
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    @Deprecated
    public synchronized void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            SimpleProperties.writeln(awriter, "#" + header);
        }
        SimpleProperties.writeln(awriter, "#" + new Date().toString());
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.get(key);
            SimpleProperties.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public synchronized String getProperty(String key) {
        String oval = (String)super.get(key);
        return oval == null && this.defaults != null ? this.defaults.getProperty(key) : oval;
    }

    public synchronized String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration<String> propertyNames() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        this.enumerate(h);
        return h.keys();
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        Hashtable<String, String> h = new Hashtable<String, String>();
        this.enumerate(h);
        Enumeration<String> e = h.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = h.get(key);
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Hashtable<String, String> h = new Hashtable<String, String>();
        this.enumerate(h);
        Enumeration<String> e = h.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object val = h.get(key);
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    private synchronized void enumerate(Hashtable<String, String> h) {
        if (this.defaults != null) {
            this.defaults.enumerate(h);
        }
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            h.put(key, (String)this.get(key));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defaults == null ? 0 : this.defaults.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleProperties other = (SimpleProperties)obj;
        return !(this.defaults == null ? other.defaults != null : !this.defaults.equals(other.defaults));
    }
}

