/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.AttributeNameHelper;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.DBSUtil;
import com.netscape.cmscore.dbs.DateMapper;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertImplMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(X509CertImplMapper.class);

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        Vector<String> v = new Vector<String>();
        v.addElement("notBefore");
        v.addElement("notAfter");
        v.addElement("duration");
        v.addElement("extension");
        v.addElement("subjectName");
        v.addElement("issuerName");
        v.addElement("userCertificate");
        v.addElement("version");
        v.addElement("algorithmId");
        v.addElement("signingAlgorithmId");
        v.addElement("publicKeyData");
        return v.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        try {
            Set critSet;
            X509CertImpl cert = (X509CertImpl)obj;
            logger.debug("X509CertImplMapper: Mapping " + name + " to notBefore");
            Date notBefore = cert.getNotBefore();
            attrs.add(new LDAPAttribute("notBefore", DateMapper.dateToDB(notBefore)));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  notAfter");
            Date notAfter = cert.getNotAfter();
            attrs.add(new LDAPAttribute("notAfter", DateMapper.dateToDB(notAfter)));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  duration");
            attrs.add(new LDAPAttribute("duration", DBSUtil.longToDB(notAfter.getTime() - notBefore.getTime())));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  subjectName");
            attrs.add(new LDAPAttribute("subjectName", cert.getSubjectName().getName()));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  issuerName");
            attrs.add(new LDAPAttribute("issuerName", cert.getIssuerName().getName()));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  publicKeyData");
            attrs.add(new LDAPAttribute("publicKeyData", cert.getPublicKey().getEncoded()));
            Set nonCritSet = cert.getNonCriticalExtensionOIDs();
            ArrayList<String> extensions = new ArrayList<String>();
            if (nonCritSet != null) {
                for (Object oid : nonCritSet) {
                    String extVal;
                    if (((String)oid).equals("2.16.840.1.113730.1.1")) {
                        extVal = this.getCertTypeExtensionInfo(cert);
                        if (extVal != null) {
                            oid = (String)oid + ";" + extVal;
                        }
                    } else if (((String)oid).equals("2.5.29.19") && (extVal = this.getBasicConstraintsExtensionInfo(cert)) != null) {
                        oid = (String)oid + ";" + extVal;
                    }
                    extensions.add((String)oid);
                }
            }
            if ((critSet = cert.getCriticalExtensionOIDs()) != null) {
                for (Object oid : critSet) {
                    String extVal;
                    if (((String)oid).equals("2.16.840.1.113730.1.1")) {
                        extVal = this.getCertTypeExtensionInfo(cert);
                        if (extVal != null) {
                            oid = (String)oid + ";" + extVal;
                        }
                    } else if (((String)oid).equals("2.5.29.19") && (extVal = this.getBasicConstraintsExtensionInfo(cert)) != null) {
                        oid = (String)oid + ";" + extVal;
                    }
                    extensions.add((String)oid);
                }
            }
            if (!extensions.isEmpty()) {
                logger.debug("X509CertImplMapper: Mapping " + name + " to  extension");
                attrs.add(new LDAPAttribute("extension", extensions.toArray(new String[extensions.size()])));
            }
            logger.debug("X509CertImplMapper: Mapping " + name + " to  userCertificate;binary");
            attrs.add(new LDAPAttribute("userCertificate;binary", cert.getEncoded()));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  version");
            attrs.add(new LDAPAttribute("version", Integer.toString(cert.getVersion())));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  algorithmId");
            X509Key pubKey = (X509Key)cert.getPublicKey();
            attrs.add(new LDAPAttribute("algorithmId", pubKey.getAlgorithmId().getOID().toString()));
            logger.debug("X509CertImplMapper: Mapping " + name + " to  signingAlgorithmId");
            attrs.add(new LDAPAttribute("signingAlgorithmId", cert.getSigAlgOID()));
        }
        catch (CertificateEncodingException e) {
            throw new EDBException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
    }

    private String getCertTypeExtensionInfo(X509CertImpl cert) {
        try {
            Extension ext = cert.getExtension("2.16.840.1.113730.1.1");
            if (ext == null && (ext = cert.getExtension("NSCertType")) == null) {
                return null;
            }
            NSCertTypeExtension nsExt = (NSCertTypeExtension)ext;
            Object result = "";
            Boolean sslServer = (Boolean)nsExt.get("ssl_server");
            result = (String)result + "SSLServer=" + sslServer.toString() + ",";
            Boolean sslClient = (Boolean)nsExt.get("ssl_client");
            result = (String)result + "SSLClient=" + sslClient.toString() + ",";
            Boolean email = (Boolean)nsExt.get("email");
            result = (String)result + "Email=" + email.toString() + ",";
            Boolean sslCA = (Boolean)nsExt.get("ssl_ca");
            result = (String)result + "SSLCA=" + sslCA.toString() + ",";
            Boolean mailCA = (Boolean)nsExt.get("email_ca");
            result = (String)result + "EmailCA=" + mailCA.toString() + ",";
            Boolean objectSigning = (Boolean)nsExt.get("object_signing");
            result = (String)result + "objectSigning=" + objectSigning.toString();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getBasicConstraintsExtensionInfo(X509CertImpl cert) {
        try {
            Extension ext = cert.getExtension("2.5.29.19");
            if (ext == null && (ext = cert.getExtension("BasicConstraints")) == null) {
                return null;
            }
            BasicConstraintsExtension bcExt = (BasicConstraintsExtension)ext;
            Object result = "";
            Boolean isCA = (Boolean)bcExt.get("is_ca");
            result = (String)result + "isCA=" + isCA.toString() + ",";
            Integer pathLen = (Integer)bcExt.get("path_len");
            result = (String)result + "pathLen=" + pathLen.toString();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        try {
            LDAPAttribute attr = attrs.getAttribute("userCertificate");
            if (attr == null) {
                attr = attrs.getAttribute("userCertificate;binary");
            }
            if (attr != null) {
                byte[] der = (byte[])attr.getByteValues().nextElement();
                X509CertImpl impl = new X509CertImpl(der);
                parent.set(name, impl);
            }
        }
        catch (CertificateException e) {
            parent.set(name, null);
        }
        catch (Exception e) {
            parent.set(name, null);
        }
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        AttributeNameHelper h = new AttributeNameHelper(name);
        String suffix = h.getSuffix();
        if (suffix.equalsIgnoreCase("notBefore")) {
            name = "notBefore";
            try {
                value = DateMapper.dateToDB(new Date(Long.parseLong((String)value)));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (suffix.equalsIgnoreCase("notAfter")) {
            name = "notAfter";
            try {
                value = DateMapper.dateToDB(new Date(Long.parseLong((String)value)));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (suffix.equalsIgnoreCase("subject")) {
            name = "subjectName";
        } else if (suffix.equalsIgnoreCase("issuer")) {
            name = "issuerName";
        } else if (suffix.equalsIgnoreCase("publicKeyData")) {
            name = "publicKeyData";
        } else if (suffix.equalsIgnoreCase("duration")) {
            name = "duration";
            value = DBSUtil.longToDB(Long.parseLong((String)value));
        } else if (suffix.equalsIgnoreCase("version")) {
            name = "version";
        } else if (suffix.equalsIgnoreCase("algorithm")) {
            name = "algorithmId";
        } else if (suffix.equalsIgnoreCase("signingAlgorithm")) {
            name = "signingAlgorithmId";
        } else if (suffix.equalsIgnoreCase("serialNumber")) {
            name = "certRecordId";
        } else if (suffix.equalsIgnoreCase("extension")) {
            name = "extension";
        } else if (suffix.equalsIgnoreCase("certRevoInfo")) {
            name = "revInfo";
            value = "*;CRLReasonExtension=" + (String)value;
        } else if (suffix.equalsIgnoreCase("nsExtension.SSLClient")) {
            name = "extension";
            value = ((String)value).equals("on") ? "2.16.840.1.113730.1.1;*SSLClient=true*" : "2.16.840.1.113730.1.1;*SSLClient=false*";
        } else if (suffix.equalsIgnoreCase("nsExtension.SSLServer")) {
            name = "extension";
            value = ((String)value).equals("on") ? "2.16.840.1.113730.1.1;*SSLServer=true*" : "2.16.840.1.113730.1.1;*SSLServer=false*";
        } else if (suffix.equalsIgnoreCase("nsExtension.SecureEmail")) {
            name = "extension";
            value = ((String)value).equals("on") ? "2.16.840.1.113730.1.1;*Email=true*" : "2.16.840.1.113730.1.1;*Email=false*";
        } else if (suffix.equalsIgnoreCase("nsExtension.SubordinateSSLCA")) {
            name = "extension";
            value = ((String)value).equals("on") ? "2.16.840.1.113730.1.1;*SSLCA=true*" : "2.16.840.1.113730.1.1;*SSLCA=false*";
        } else if (suffix.equalsIgnoreCase("nsExtension.SubordinateEmailCA")) {
            name = "extension";
            value = ((String)value).equals("on") ? "2.16.840.1.113730.1.1;*EmailCA=true*" : "2.16.840.1.113730.1.1;*EmailCA=false*";
        } else if (suffix.equalsIgnoreCase("BasicConstraints.isCA")) {
            name = "extension";
            value = ((String)value).equals("on") ? "2.5.29.19;*isCA=true*" : "2.5.29.19;*isCA=false*";
        }
        return name + op + (String)value;
    }
}

