/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.jobs.CronRange;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronItem {
    public static Logger logger = LoggerFactory.getLogger(CronItem.class);
    protected static final String ALL = "*";
    protected static final String DELIM = ",";
    protected static final String RANGE = "-";
    int mMin;
    int mMax;
    protected Vector<CronRange> mElements = new Vector();

    public CronItem(int min, int max) {
        this.mMin = min;
        this.mMax = max;
    }

    public void set(String sItem) throws EBaseException {
        if (sItem.equals(ALL)) {
            CronRange cr = new CronRange();
            cr.setBegin(this.mMin);
            cr.setEnd(this.mMax);
            this.mElements.addElement(cr);
        } else {
            StringTokenizer st = new StringTokenizer(sItem, DELIM);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int r = tok.indexOf(RANGE);
                if (r != -1) {
                    String sBegin = tok.substring(0, r);
                    int begin = 0;
                    int end = 0;
                    try {
                        begin = Integer.parseInt(sBegin);
                    }
                    catch (NumberFormatException e) {
                        logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_TOKEN", tok, e.toString()), (Throwable)e);
                        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
                    }
                    String sEnd = tok.substring(r + 1, tok.length());
                    try {
                        end = Integer.parseInt(sEnd);
                    }
                    catch (NumberFormatException e) {
                        logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_TOKEN", tok, e.toString()), (Throwable)e);
                        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
                    }
                    CronRange cr = new CronRange();
                    cr.setBegin(begin);
                    cr.setEnd(end);
                    if (!cr.isValidRange(this.mMin, this.mMax)) {
                        logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_RANGE", tok));
                        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]));
                    }
                    this.mElements.addElement(cr);
                    continue;
                }
                try {
                    CronRange cr = new CronRange();
                    int num = Integer.parseInt(tok);
                    cr.setBegin(num);
                    cr.setEnd(num);
                    if (!cr.isValidRange(this.mMin, this.mMax)) {
                        logger.error(CMS.getLogMessage("CMSCORE_JOBS_INVALID_MIN_MAX_RANGE", Integer.toString(this.mMin), Integer.toString(this.mMax)));
                        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]));
                    }
                    this.mElements.addElement(cr);
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid item in cron: " + tok, (Throwable)e);
                    throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_JOB_CRON", new String[0]), (Throwable)e);
                }
            }
        }
    }

    public Vector<CronRange> getElements() {
        return this.mElements;
    }
}

