/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.cmscore.apps.CMS;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.AndExpression;
import org.dogtagpki.legacy.core.policy.OrExpression;
import org.dogtagpki.legacy.core.policy.PredicateTokenizer;
import org.dogtagpki.legacy.core.policy.SimpleExpression;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyPredicateParser {
    public static Logger logger = LoggerFactory.getLogger(PolicyPredicateParser.class);
    public static final int OP_AND = 1;
    public static final int OP_OR = 2;
    public static final int EXPRESSION = 0;
    public static final String AND = "AND";
    public static final String OR = "OR";
    private static final char COMMA = ',';

    public static IExpression parse(String predicateExpression) throws EPolicyException {
        int size;
        if (predicateExpression == null || predicateExpression.length() == 0) {
            return null;
        }
        PredicateTokenizer pt = new PredicateTokenizer(predicateExpression);
        if (pt == null || !pt.hasMoreTokens()) {
            return null;
        }
        String token = pt.nextToken();
        if (PolicyPredicateParser.getOP(token) != 0) {
            logger.error("Malformed expression: " + predicateExpression);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_BAD_POLICY_EXPRESSION", predicateExpression));
        }
        IExpression current = PolicyPredicateParser.parseExpression(token);
        boolean malformed = false;
        Vector<IExpression> expSet = new Vector<IExpression>();
        int prevType = 0;
        while (pt.hasMoreTokens()) {
            token = pt.nextToken();
            int curType = PolicyPredicateParser.getOP(token);
            if (prevType != 0 && curType != 0 || prevType == 0 && curType == 0) {
                malformed = true;
                break;
            }
            if (curType != 0) {
                prevType = curType;
                continue;
            }
            if (prevType == 2) {
                expSet.addElement(current);
                current = PolicyPredicateParser.parseExpression(token);
                prevType = curType;
                continue;
            }
            if (prevType != 1) continue;
            current = new AndExpression(current, PolicyPredicateParser.parseExpression(token));
            prevType = curType;
        }
        if (malformed) {
            logger.error("Malformed expression: " + predicateExpression);
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_BAD_POLICY_EXPRESSION", predicateExpression));
        }
        if (current != null) {
            expSet.addElement(current);
        }
        if ((size = expSet.size()) == 0) {
            return null;
        }
        OrExpression orExp = new OrExpression((IExpression)expSet.elementAt(0), null);
        for (int i = 1; i < size; ++i) {
            orExp = new OrExpression(orExp, (IExpression)expSet.elementAt(i));
        }
        return orExp;
    }

    private static int getOP(String token) {
        if (token.equalsIgnoreCase(AND)) {
            return 1;
        }
        if (token.equalsIgnoreCase(OR)) {
            return 2;
        }
        return 0;
    }

    private static IExpression parseExpression(String input) throws EPolicyException {
        SimpleExpression exp;
        int commaIndex = input.indexOf(44);
        if (commaIndex < 0) {
            return SimpleExpression.parse(input);
        }
        int currentIndex = 0;
        Vector<SimpleExpression> expVector = new Vector<SimpleExpression>();
        while (commaIndex > 0) {
            exp = (SimpleExpression)SimpleExpression.parse(input.substring(currentIndex, commaIndex));
            expVector.addElement(exp);
            currentIndex = commaIndex + 1;
            commaIndex = input.indexOf(44, currentIndex);
        }
        if (currentIndex < input.length() - 1) {
            exp = (SimpleExpression)SimpleExpression.parse(input.substring(currentIndex));
            expVector.addElement(exp);
        }
        int size = expVector.size();
        SimpleExpression exp1 = (SimpleExpression)expVector.elementAt(0);
        SimpleExpression exp2 = (SimpleExpression)expVector.elementAt(1);
        AndExpression andExp = new AndExpression(exp1, exp2);
        for (int i = 2; i < size; ++i) {
            andExp = new AndExpression(andExp, (IExpression)expVector.elementAt(i));
        }
        return andExp;
    }

    public static void main(String[] args) {
    }
}

