/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.certsrv.system.DomainInfo;
import com.netscape.certsrv.system.SecurityDomainHost;
import com.netscape.certsrv.system.SecurityDomainSubsystem;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.server.cli.SDSubsystemCLI;

public class SDSubsystemFindCLI
extends CommandCLI {
    public SDSubsystemFindCLI(CLI parent) {
        super("find", "Find security domain subsystems", parent);
    }

    public DomainInfo getDomainInfo(LdapBoundConnection conn, LDAPConfig ldapConfig) throws Exception {
        String domainDN = "ou=Security Domain," + ldapConfig.getBaseDN();
        LDAPEntry domainEntry = conn.read(domainDN);
        String domainName = (String)domainEntry.getAttribute("name").getStringValues().nextElement();
        DomainInfo domainInfo = new DomainInfo();
        domainInfo.setName(domainName);
        String securityGroupFilter = "(objectclass=pkiSecurityGroup)";
        String subsystemFilter = "(objectclass=pkiSubsystem)";
        LDAPSearchResults subsystemTypeEntries = conn.search(domainDN, 1, securityGroupFilter, null, true, null);
        while (subsystemTypeEntries.hasMoreElements()) {
            String securityGroupDN = subsystemTypeEntries.next().getDN();
            String listName = securityGroupDN.substring(3, securityGroupDN.indexOf(","));
            String subsystemType = listName.substring(0, listName.indexOf("List"));
            LDAPSearchResults subsystemEntries = conn.search(securityGroupDN, 1, subsystemFilter, null, false, null);
            while (subsystemEntries.hasMoreElements()) {
                LDAPEntry subsystemEntry = subsystemEntries.next();
                SecurityDomainHost host = new SecurityDomainHost();
                LDAPAttributeSet attrSet = subsystemEntry.getAttributeSet();
                Enumeration attrs = attrSet.getAttributes();
                while (attrs.hasMoreElements()) {
                    LDAPAttribute attr = (LDAPAttribute)attrs.nextElement();
                    String attrName = attr.getName();
                    Enumeration attrValues = attr.getStringValues();
                    while (attrValues.hasMoreElements()) {
                        String attrValue = (String)attrValues.nextElement();
                        if ("Host".equalsIgnoreCase(attrName)) {
                            host.setHostname(attrValue);
                            continue;
                        }
                        if ("UnSecurePort".equalsIgnoreCase(attrName)) {
                            host.setPort(attrValue);
                            continue;
                        }
                        if ("SecurePort".equalsIgnoreCase(attrName)) {
                            host.setSecurePort(attrValue);
                            continue;
                        }
                        if ("SecureEEClientAuthPort".equalsIgnoreCase(attrName)) {
                            host.setSecureEEClientAuthPort(attrValue);
                            continue;
                        }
                        if ("SecureAgentPort".equalsIgnoreCase(attrName)) {
                            host.setSecureAgentPort(attrValue);
                            continue;
                        }
                        if ("SecureAdminPort".equalsIgnoreCase(attrName)) {
                            host.setSecureAdminPort(attrValue);
                            continue;
                        }
                        if ("Clone".equalsIgnoreCase(attrName)) {
                            host.setClone(attrValue);
                            continue;
                        }
                        if ("SubsystemName".equalsIgnoreCase(attrName)) {
                            host.setSubsystemName(attrValue);
                            continue;
                        }
                        if (!"DomainManager".equalsIgnoreCase(attrName)) continue;
                        host.setDomainManager(attrValue);
                    }
                }
                String port = host.getSecurePort();
                if (port == null) {
                    port = host.getSecureEEClientAuthPort();
                }
                host.setId(subsystemType + " " + host.getHostname() + " " + port);
                domainInfo.addHost(subsystemType, host);
            }
        }
        return domainInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String instanceDir = CMS.getInstanceDir();
        TomcatJSS tomcatjss = TomcatJSS.getInstance();
        tomcatjss.loadConfig();
        tomcatjss.init();
        String subsystem = this.parent.getParent().getParent().getName();
        String subsystemDir = instanceDir + File.separator + subsystem;
        String subsystemConfDir = subsystemDir + File.separator + "conf";
        String configFile = subsystemConfDir + File.separator + "CS.cfg";
        logger.info("Loading " + configFile);
        FileConfigStorage storage = new FileConfigStorage(configFile);
        EngineConfig cs = new EngineConfig(storage);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LDAPAuthenticationConfig authConfig = ldapConfig.getAuthenticationConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = new LdapAuthInfo();
        authInfo.setPasswordStore(passwordStore);
        authInfo.init(authConfig, connInfo.getHost(), connInfo.getPort(), connInfo.getSecure());
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            socketFactory.setClientCertNickname(authInfo.getClientCertNickname());
        }
        socketFactory.init(socketConfig);
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        try {
            DomainInfo domainInfo = this.getDomainInfo(conn, ldapConfig);
            boolean first = true;
            for (SecurityDomainSubsystem sub : domainInfo.getSubsystems().values()) {
                for (SecurityDomainHost host : sub.getHosts().values()) {
                    if (first) {
                        first = false;
                    } else {
                        System.out.println();
                    }
                    SDSubsystemCLI.printSubsystem(host);
                }
            }
        }
        finally {
            conn.disconnect();
        }
    }
}

