/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.system.Feature;
import com.netscape.certsrv.system.FeatureResource;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;

public class FeatureService
extends PKIService
implements FeatureResource {
    public Response listFeatures() {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig config = engine.getConfig();
        ConfigStore cs = config.getSubStore("features", ConfigStore.class);
        ArrayList<Feature> features = new ArrayList<Feature>();
        Enumeration<String> tags = cs.getSubStoreNames().elements();
        while (tags.hasMoreElements()) {
            String tag = tags.nextElement();
            Feature feature = this.createFeature(cs, tag);
            features.add(feature);
        }
        GenericEntity<List<Feature>> entity = new GenericEntity<List<Feature>>(features){};
        return this.createOKResponse(entity);
    }

    public Response getFeature(String id) {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig config = engine.getConfig();
        ConfigStore cs = config.getSubStore("features", ConfigStore.class);
        Enumeration<String> tags = cs.getSubStoreNames().elements();
        while (tags.hasMoreElements()) {
            String tag = tags.nextElement();
            if (!tag.equals(id)) continue;
            Feature feature = this.createFeature(cs, tag);
            return this.createOKResponse(feature);
        }
        throw new ResourceNotFoundException("Feature " + id + " not supported");
    }

    private Feature createFeature(ConfigStore cs, String tag) {
        Map<String, String> props = cs.getSubStore(tag).getProperties();
        Feature feature = new Feature();
        feature.setId(tag);
        feature.setEnabled(Boolean.parseBoolean(props.get("enabled")));
        feature.setDescription(props.get("description"));
        feature.setVersion(props.get("version"));
        return feature;
    }
}

