/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.xml.parser;

import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.xml.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLMetadataParser
implements ContentHandler {
    private Element[] m_elements = new Element[0];

    public Element[] getMetadata() throws ParseException {
        return this.m_elements[0].getElements();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Element lastElement = this.removeLastElement();
        if (!lastElement.getName().equalsIgnoreCase(qName) && !lastElement.getNameSpace().equalsIgnoreCase(namespaceURI)) {
            throw new SAXException("Parse error when ending an element : " + qName + " [" + namespaceURI + "]");
        }
        if (this.m_elements.length != 0) {
            Element newQueue = this.m_elements[this.m_elements.length - 1];
            newQueue.addElement(lastElement);
        } else {
            this.addElement(lastElement);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element elem = new Element(localName, namespaceURI);
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String ns = atts.getURI(i);
            String value = atts.getValue(i);
            Attribute att = new Attribute(name, ns, value);
            elem.addAttribute(att);
        }
        this.addElement(elem);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void addElement(Element elem) {
        for (int i = 0; this.m_elements != null && i < this.m_elements.length; ++i) {
            if (this.m_elements[i] != elem) continue;
            return;
        }
        if (this.m_elements != null) {
            Element[] newElementsList = new Element[this.m_elements.length + 1];
            System.arraycopy(this.m_elements, 0, newElementsList, 0, this.m_elements.length);
            newElementsList[this.m_elements.length] = elem;
            this.m_elements = newElementsList;
        } else {
            this.m_elements = new Element[]{elem};
        }
    }

    private Element removeLastElement() {
        int idx = -1;
        idx = this.m_elements.length - 1;
        Element last = this.m_elements[idx];
        if (idx >= 0) {
            if (this.m_elements.length - 1 == 0) {
                this.m_elements = new Element[0];
            } else {
                Element[] newElementsList = new Element[this.m_elements.length - 1];
                System.arraycopy(this.m_elements, 0, newElementsList, 0, idx);
                this.m_elements = newElementsList;
            }
        }
        return last;
    }
}

