/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.trigger;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.util.List;
import java.util.Vector;

public abstract class GpioTriggerBase
implements GpioTrigger {
    private List<PinState> states = new Vector<PinState>();

    public GpioTriggerBase() {
        this.addPinState(PinState.allStates());
    }

    public GpioTriggerBase(PinState state) {
        this.addPinState(state);
    }

    public GpioTriggerBase(PinState[] states) {
        this.addPinState(states);
    }

    public GpioTriggerBase(List<PinState> states) {
        this.addPinState(states);
    }

    @Override
    public void addPinState(PinState ... state) {
        if (state == null || state.length == 0) {
            throw new IllegalArgumentException("Missing pin state argument.");
        }
        for (PinState s : state) {
            if (this.states.contains((Object)s)) continue;
            this.states.add(s);
        }
    }

    @Override
    public void addPinState(List<? extends PinState> states) {
        for (PinState pinState : states) {
            this.addPinState(pinState);
        }
    }

    @Override
    public boolean hasPinState(PinState state) {
        return this.states.contains((Object)state);
    }

    @Override
    public abstract void invoke(GpioPin var1, PinState var2);
}

