/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.instance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.instance.InvokeMethod;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ComponentDescriptionProp;
import org.eclipse.equinox.ds.model.ReferenceDescription;
import org.eclipse.equinox.ds.resolver.Reference;
import org.eclipse.equinox.ds.service.ComponentContextImpl;
import org.eclipse.equinox.ds.service.ComponentInstanceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class BuildDispose {
    private InvokeMethod invoke = new InvokeMethod(this);
    private int stackCount;
    private List delayedBindList;
    private Activator main;
    static /* synthetic */ Class class$0;

    BuildDispose(Activator main) {
        this.main = main;
        this.stackCount = 0;
        this.delayedBindList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        BuildDispose buildDispose = this;
        synchronized (buildDispose) {
            this.invoke = null;
            this.main = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ComponentInstance buildComponentConfigInstance(Bundle usingBundle, ComponentDescriptionProp cdp) throws ComponentException {
        BuildDispose buildDispose = this;
        synchronized (buildDispose) {
            ComponentInstanceImpl componentInstance;
            block8: {
                ++this.stackCount;
                componentInstance = null;
                try {
                    try {
                        ComponentDescription componentDescription = cdp.getComponentDescription();
                        Object instance = this.createInstance(componentDescription);
                        componentInstance = this.instantiate(cdp, instance);
                        this.createComponentContext(usingBundle, componentInstance);
                        this.bind(componentInstance);
                        this.activate(componentInstance);
                        cdp.addInstance(componentInstance);
                    }
                    catch (ComponentException e) {
                        Log.log(1, "[SCR] Error attempting to build component ", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    --this.stackCount;
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                    --this.stackCount;
                    if (this.stackCount != 0 || this.delayedBindList.isEmpty()) break block8;
                    this.main.resolver.instanceProcess.workQueue.enqueueWork(this.main.resolver, 3, ((ArrayList)this.delayedBindList).clone());
                    this.delayedBindList.clear();
                }
            }
            return componentInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeComponentConfig(ComponentDescriptionProp cdp) {
        BuildDispose buildDispose = this;
        synchronized (buildDispose) {
            ServiceRegistration serviceRegistration = cdp.getServiceRegistration();
            if (serviceRegistration != null) {
                try {
                    serviceRegistration.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            Iterator it = cdp.getInstances().iterator();
            while (it.hasNext()) {
                this.disposeComponentInstance((ComponentInstanceImpl)it.next());
            }
            cdp.removeAllInstances();
            it = cdp.getReferences().iterator();
            while (it.hasNext()) {
                Reference reference = (Reference)it.next();
                reference.clearServiceReferences();
            }
            cdp.clearDelayActivateCDPNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponentInstance(ComponentInstance ci) {
        BuildDispose buildDispose = this;
        synchronized (buildDispose) {
            ComponentInstanceImpl componentInstance = (ComponentInstanceImpl)ci;
            this.deactivate(componentInstance);
            this.unbind(componentInstance);
            ComponentDescriptionProp cdp = componentInstance.getComponentDescriptionProp();
            if (cdp.getInstances().isEmpty()) {
                BundleContext context = cdp.getComponentDescription().getBundleContext();
                Iterator referenceItr = cdp.getReferences().iterator();
                while (referenceItr.hasNext()) {
                    Reference reference = (Reference)referenceItr.next();
                    Iterator serviceReferenceItr = reference.getServiceReferences().iterator();
                    while (serviceReferenceItr.hasNext()) {
                        context.ungetService((ServiceReference)serviceReferenceItr.next());
                    }
                }
            }
            componentInstance = null;
        }
    }

    private Object createInstance(ComponentDescription cd) throws ComponentException {
        Object instance = null;
        String classname = cd.getImplementation().getClassname();
        try {
            instance = cd.getBundleContext().getBundle().loadClass(classname).newInstance();
        }
        catch (IllegalAccessException e) {
            Log.log(1, "[SCR] IllegalAccessException attempting to create instance ", e);
            throw new ComponentException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Log.log(1, "[SCR] ClassNotFoundException attempting to create instance. ", e);
            throw new ComponentException(e.getMessage());
        }
        catch (InstantiationException e) {
            Log.log(1, "[SCR] InstantiationException attempting to create instance. ", e);
            throw new ComponentException(e.getMessage());
        }
        return instance;
    }

    private ComponentInstanceImpl instantiate(ComponentDescriptionProp cdp, Object instance) {
        return new ComponentInstanceImpl(this.main, cdp, instance);
    }

    private void bind(ComponentInstanceImpl componentInstance) {
        List references = componentInstance.getComponentDescriptionProp().getReferences();
        Iterator itr = references.iterator();
        while (itr.hasNext()) {
            Reference reference = (Reference)itr.next();
            if (reference.getReferenceDescription().getBind() == null) continue;
            this.bindReference(reference, componentInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindReference(Reference reference, ComponentInstanceImpl componentInstance) {
        BuildDispose buildDispose = this;
        synchronized (buildDispose) {
            Object[] serviceReferences = null;
            try {
                serviceReferences = componentInstance.getComponentContext().getBundleContext().getServiceReferences(reference.getReferenceDescription().getInterfacename(), reference.getTarget());
            }
            catch (InvalidSyntaxException e) {
                Log.log(1, "[SCR] InvalidSyntaxException attempting to bindReference ", e);
            }
            if (!reference.getReferenceDescription().isRequired() && serviceReferences == null) {
                return;
            }
            Arrays.sort(serviceReferences);
            if (reference.getReferenceDescription().getCardinalityHigh() == 1) {
                this.bindServiceToReference(reference, (ServiceReference)serviceReferences[0], componentInstance);
            } else {
                int j = 0;
                while (j < serviceReferences.length) {
                    this.bindServiceToReference(reference, (ServiceReference)serviceReferences[j], componentInstance);
                    ++j;
                }
            }
        }
    }

    private void bindServiceToReference(Reference reference, ServiceReference serviceReference, ComponentInstanceImpl componentInstance) {
        ReferenceDescription rd = reference.getReferenceDescription();
        if (!reference.bindedToServiceReference(serviceReference) && rd.getBind() != null) {
            try {
                Method method = rd.getBindMethod();
                if (method == null) {
                    method = this.invoke.findBindOrUnbindMethod(componentInstance, reference, serviceReference, rd.getBind());
                    rd.setBindMethod(method);
                }
                if (method == null) {
                    return;
                }
                Object param = null;
                Class<?> clazz = method.getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.osgi.framework.ServiceReference");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    param = serviceReference;
                } else {
                    param = reference.getServiceObject(serviceReference);
                    if (param == null) {
                        param = this.getService(reference, serviceReference);
                        if (param == null) {
                            return;
                        }
                        reference.addServiceReference(serviceReference, param);
                    }
                }
                this.invoke.bindComponent(method, componentInstance.getInstance(), param);
            }
            catch (IllegalAccessException e) {
                Log.log(1, "[SCR] IllegalAccessException attempting to bind Service to Reference ", e);
            }
            catch (InvocationTargetException e) {
                Log.log(1, "[SCR] InvocationTargetException attempting to bind Service to Reference ", e);
            }
            reference.addServiceReference(serviceReference);
        }
    }

    public Object getService(Reference reference, ServiceReference serviceReference) {
        if (this.couldCauseCycle(reference, serviceReference)) {
            return null;
        }
        return reference.getComponentDescriptionProp().getComponentDescription().getBundleContext().getService(serviceReference);
    }

    private boolean couldCauseCycle(Reference reference, ServiceReference serviceReference) {
        ComponentDescriptionProp consumerCDP = reference.getComponentDescriptionProp();
        if (this.stackCount == 0) {
            return false;
        }
        String producerComponentName = (String)serviceReference.getProperty("component.name");
        if (producerComponentName == null) {
            return false;
        }
        if (!consumerCDP.getDelayActivateCDPNames().contains(producerComponentName)) {
            return false;
        }
        ComponentDescriptionProp producerCDP = null;
        Iterator it = this.main.resolver.satisfiedCDPs.iterator();
        while (it.hasNext()) {
            ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
            if (!producerComponentName.equals(cdp.getComponentDescription().getName())) continue;
            producerCDP = cdp;
            break;
        }
        if (producerCDP.getComponentDescription().getService().isServicefactory()) {
            it = producerCDP.getInstances().iterator();
            Bundle bundle = consumerCDP.getComponentDescription().getBundleContext().getBundle();
            while (it.hasNext()) {
                ComponentInstanceImpl producerComponentInstance = (ComponentInstanceImpl)it.next();
                if (!producerComponentInstance.getComponentContext().getUsingBundle().equals(bundle)) continue;
                return false;
            }
        } else if (!producerCDP.getInstances().isEmpty()) {
            return false;
        }
        if (reference.getReferenceDescription().getBind() != null && reference.getReferenceDescription().getPolicy().equalsIgnoreCase("dynamic")) {
            this.delayedBindList.add(reference);
        }
        return true;
    }

    private void unbind(ComponentInstanceImpl componentInstance) {
        List references = componentInstance.getComponentDescriptionProp().getReferences();
        ListIterator itr = references.listIterator(references.size());
        while (itr.hasPrevious()) {
            this.unbindReference((Reference)itr.previous(), componentInstance);
        }
    }

    private void unbindReference(Reference reference, ComponentInstanceImpl componentInstance) {
        Iterator itr = reference.getServiceReferences().iterator();
        while (itr.hasNext()) {
            ServiceReference serviceReference = (ServiceReference)itr.next();
            this.unbindServiceFromReference(reference, componentInstance, serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindDynamicReference(Reference reference, ComponentInstanceImpl componentInstance, ServiceReference serviceReference) {
        BuildDispose buildDispose = this;
        synchronized (buildDispose) {
            this.bindReference(reference, componentInstance);
            this.unbindServiceFromReference(reference, componentInstance, serviceReference);
        }
    }

    private void unbindServiceFromReference(Reference reference, ComponentInstanceImpl componentInstance, ServiceReference serviceReference) {
        ReferenceDescription rd = reference.getReferenceDescription();
        String unbind = rd.getUnbind();
        Object serviceObject = null;
        Method method = null;
        if (unbind != null && (method = rd.getUnbindMethod()) == null) {
            method = this.invoke.findBindOrUnbindMethod(componentInstance, reference, serviceReference, unbind);
            rd.setUnbindMethod(method);
        }
        if (method != null) {
            Object param = null;
            Class<?> clazz = method.getParameterTypes()[0];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.osgi.framework.ServiceReference");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                param = serviceReference;
            } else {
                serviceObject = reference.getServiceObject(serviceReference);
                if (serviceObject == null) {
                    serviceObject = this.getService(reference, serviceReference);
                    if (serviceObject == null) {
                        return;
                    }
                    reference.addServiceReference(serviceReference, serviceObject);
                }
                param = serviceObject;
            }
            try {
                this.invoke.unbindComponent(method, componentInstance.getInstance(), param);
            }
            catch (InvocationTargetException e) {
                Log.log(1, "[SCR] InvocationTargetException attempting to unbind reference.", e);
            }
            catch (IllegalAccessException e) {
                Log.log(1, "[SCR] IllegalAccessException attempting to unbind reference.", e);
            }
        }
        if (serviceObject != null) {
            componentInstance.getComponentContext().getBundleContext().ungetService(serviceReference);
        }
        reference.removeServiceReference(serviceReference);
    }

    private void activate(ComponentInstanceImpl componentInstance) throws ComponentException {
        try {
            this.invoke.activateComponent(componentInstance.getInstance(), componentInstance.getComponentContext());
        }
        catch (IllegalAccessException e) {
            Log.log(1, "[SCR] IllegalAccessException attempting to activate component ", e);
            throw new ComponentException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Log.log(1, "[SCR] InvocationTargetException attempting to activate component ", e);
            throw new ComponentException(e.getMessage());
        }
    }

    private void deactivate(ComponentInstanceImpl componentInstance) {
        try {
            this.invoke.deactivateComponent(componentInstance.getInstance(), componentInstance.getComponentContext());
        }
        catch (InvocationTargetException e) {
            Log.log(1, "[SCR] InvocationTargetException attempting to deactivate component.", e);
        }
        catch (IllegalAccessException e) {
            Log.log(1, "[SCR] IllegalAccessException attempting to deactivate component. ", e);
        }
    }

    private void createComponentContext(Bundle usingBundle, ComponentInstanceImpl componentInstance) {
        ComponentContextImpl context = new ComponentContextImpl(this.main, usingBundle, componentInstance);
        componentInstance.setComponentContext(context);
    }
}

