/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util.stdlibc;

import java.util.List;
import java.util.NoSuchElementException;
import org.jquantlib.math.Array;
import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.functions.DoubleFunction;
import org.jquantlib.util.stdlibc.DoubleForwardIterator;
import org.jquantlib.util.stdlibc.DoubleReference;
import org.jquantlib.util.stdlibc.DoubleReverseIterator;
import org.jquantlib.util.stdlibc.ForwardIterator;
import org.jquantlib.util.stdlibc.IntForwardIterator;
import org.jquantlib.util.stdlibc.IntReference;
import org.jquantlib.util.stdlibc.IntReverseIterator;
import org.jquantlib.util.stdlibc.MutableDoubleForwardIterator;
import org.jquantlib.util.stdlibc.MutableDoubleReverseIterator;
import org.jquantlib.util.stdlibc.MutableIntForwardIterator;
import org.jquantlib.util.stdlibc.MutableIntReverseIterator;
import org.jquantlib.util.stdlibc.ObjectForwardIterator;
import org.jquantlib.util.stdlibc.ReverseIterator;

public final class Std {
    public static List<Double> adjacent_difference(List<Double> inputList, int begin, List<Double> diffList) {
        for (int i = begin; i < inputList.size(); ++i) {
            double curr = inputList.get(i);
            if (i == 0) {
                diffList.add(inputList.get(i));
                continue;
            }
            double prev = inputList.get(i - 1);
            diffList.add(curr - prev);
        }
        return diffList;
    }

    public static void apply(Array array, DoubleFunction func) {
        Std.apply(array, 0, array.size(), func);
    }

    public static void apply(Array array, int startIndex, int endIndex, DoubleFunction func) {
        for (int i = 0; i < array.size(); ++i) {
            array.set(i, func.apply(array.at(i)));
        }
    }

    public static double min_element(int from, int to, List<Double> list) {
        double value = Double.POSITIVE_INFINITY;
        for (double temp : list) {
            if (!(temp < value)) continue;
            value = temp;
        }
        return value;
    }

    public static int lower_bound(double[] list, double val) {
        return Std.lower_bound(list, 0, list.length - 1, val);
    }

    private static int lower_bound(double[] list, int first, int last, double val) {
        int len = last - first;
        while (len > 0) {
            int half = len >> 1;
            int middle = first;
            if (list[middle += half] < val) {
                first = middle;
                ++first;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return first;
    }

    public static int upper_bound(double[] list, double val) {
        return Std.upper_bound(list, 0, list.length - 1, val);
    }

    private static int upper_bound(double[] list, int first, int last, double val) {
        int len = last - first;
        while (len > 0) {
            int half = len >> 1;
            int middle = first;
            if (val < list[middle += half]) {
                len = half;
                continue;
            }
            first = middle;
            ++first;
            len = len - half - 1;
        }
        return first;
    }

    public static final void transform(Array array, Array result, UnaryFunctionDouble func) {
        double[] a = array.getData();
        double[] r = result.getData();
        for (int i = 0; i < a.length; ++i) {
            r[i] = func.evaluate(a[i]);
        }
    }

    public static IntForwardIterator forwardIterator(int[] list) {
        return new IntForwardIteratorImpl(list);
    }

    public static IntReverseIterator reverseIterator(int[] list) {
        return new IntReverseIteratorImpl(list);
    }

    public static DoubleForwardIterator forwardIterator(double[] list) {
        return new DoubleForwardIteratorImpl(list);
    }

    public static DoubleReverseIterator reverseIterator(double[] list) {
        return new DoubleReverseIteratorImpl(list);
    }

    public static ObjectForwardIterator forwardIterator(Object[] list) {
        return new ObjectForwardIteratorImpl(list);
    }

    public static MutableIntForwardIterator mutableForwardIterator(int[] list) {
        return new MutableIntForwardIteratorImpl(list);
    }

    public static MutableIntReverseIterator mutableReverseIterator(int[] list) {
        return new MutableIntReverseIteratorImpl(list);
    }

    public static MutableDoubleForwardIterator mutableForwardIterator(double[] list) {
        return new MutableDoubleForwardIteratorImpl(list);
    }

    public static MutableDoubleReverseIterator mutableReverseIterator(double[] list) {
        return new MutableDoubleReverseIteratorImpl(list);
    }

    private static class MutableDoubleReverseIteratorImpl
    extends DoubleReverseIteratorImpl
    implements MutableDoubleReverseIterator {
        public MutableDoubleReverseIteratorImpl(double[] list) {
            super(list);
        }

        @Override
        public DoubleReference previousReference() throws NoSuchElementException {
            return new DoubleReference(this.list, this.index);
        }
    }

    private static class MutableDoubleForwardIteratorImpl
    extends DoubleForwardIteratorImpl
    implements MutableDoubleForwardIterator {
        public MutableDoubleForwardIteratorImpl(double[] list) {
            super(list);
        }

        @Override
        public DoubleReference nextReference() throws NoSuchElementException {
            return new DoubleReference(this.list, this.index);
        }
    }

    private static class MutableIntReverseIteratorImpl
    extends IntReverseIteratorImpl
    implements MutableIntReverseIterator {
        public MutableIntReverseIteratorImpl(int[] list) {
            super(list);
        }

        @Override
        public IntReference previousReference() throws NoSuchElementException {
            return new IntReference(this.list, this.index);
        }
    }

    private static class MutableIntForwardIteratorImpl
    extends IntForwardIteratorImpl
    implements MutableIntForwardIterator {
        public MutableIntForwardIteratorImpl(int[] list) {
            super(list);
        }

        @Override
        public IntReference nextReference() throws NoSuchElementException {
            return new IntReference(this.list, this.index);
        }
    }

    private static class ObjectForwardIteratorImpl
    extends ForwardIteratorImpl
    implements ObjectForwardIterator {
        protected Object[] list;

        public ObjectForwardIteratorImpl(Object[] list) {
            super(list == null ? 0 : list.length);
            this.list = list;
        }

        public Object next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.list[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    private static class DoubleReverseIteratorImpl
    extends ReverseIteratorImpl
    implements DoubleReverseIterator {
        protected double[] list;

        public DoubleReverseIteratorImpl(double[] list) {
            super(list == null ? 0 : list.length);
            this.list = list;
        }

        @Override
        public double previous() throws NoSuchElementException {
            if (this.hasPrevious()) {
                return this.list[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    private static class DoubleForwardIteratorImpl
    extends ForwardIteratorImpl
    implements DoubleForwardIterator {
        protected double[] list;

        public DoubleForwardIteratorImpl(double[] list) {
            super(list == null ? 0 : list.length);
            this.list = list;
        }

        @Override
        public double next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.list[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    private static class IntReverseIteratorImpl
    extends ReverseIteratorImpl
    implements IntReverseIterator {
        protected int[] list;

        public IntReverseIteratorImpl(int[] list) {
            super(list == null ? 0 : list.length);
            this.list = list;
        }

        @Override
        public int previous() throws NoSuchElementException {
            if (this.hasPrevious()) {
                return this.list[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    private static class IntForwardIteratorImpl
    extends ForwardIteratorImpl
    implements IntForwardIterator {
        protected int[] list;

        public IntForwardIteratorImpl(int[] list) {
            super(list == null ? 0 : list.length);
            this.list = list;
        }

        @Override
        public int next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.list[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    private static abstract class ReverseIteratorImpl
    implements ReverseIterator {
        protected int index;

        protected ReverseIteratorImpl(int size) {
            this.index = size - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.index >= 0;
        }

        @Override
        public int back(int backstep) {
            int jump = this.index - backstep >= 0 ? backstep : this.index;
            this.index -= jump;
            return jump;
        }
    }

    private static abstract class ForwardIteratorImpl
    implements ForwardIterator {
        private final int size;
        protected int index;

        protected ForwardIteratorImpl(int size) {
            this.size = size;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public int skip(int skipsize) {
            int jump = this.index + skipsize < this.size ? skipsize : this.size - this.index - 1;
            this.index += jump;
            return jump;
        }
    }
}

