/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import java.io.Serializable;
import java.util.Iterator;
import org.jquantlib.util.Date;
import org.jquantlib.util.TimeSeries;
import org.jquantlib.util.TimeSeriesDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class IntervalPrice
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(IntervalPrice.class);
    private double open;
    private double close;
    private double high;
    private double low;

    public IntervalPrice(double open, double close, double high, double low) {
        this.setValues(open, close, high, low);
    }

    public double open() {
        return this.open;
    }

    public double close() {
        return this.close;
    }

    public double high() {
        return this.high;
    }

    public double low() {
        return this.low;
    }

    public double value(Type type) {
        switch (type) {
            case Open: {
                return this.open;
            }
            case Close: {
                return this.close;
            }
            case High: {
                return this.high;
            }
            case Low: {
                return this.low;
            }
        }
        throw new IllegalArgumentException("Unknown price type");
    }

    public void setValue(Type type, double value) {
        switch (type) {
            case Open: {
                this.open = value;
                break;
            }
            case Close: {
                this.close = value;
                break;
            }
            case High: {
                this.high = value;
                break;
            }
            case Low: {
                this.low = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown price type");
            }
        }
    }

    public void setValues(double open, double close, double high, double low) {
        this.open = open;
        this.close = close;
        this.high = high;
        this.low = low;
    }

    public static TimeSeries<IntervalPrice> makeSeries(Date[] d, double[] open, double[] close, double[] high, double[] low) {
        int dsize = d.length;
        if (open.length != dsize || close.length != dsize || high.length != dsize || low.length != dsize) {
            String msg = MessageFormatter.arrayFormat((String)"size mismatch({}, {}, {}, {}, {})", (Object[])new Object[]{dsize, open.length, close.length, high.length, low.length});
            logger.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        TimeSeries<IntervalPrice> retval = new TimeSeries<IntervalPrice>();
        for (int i = 0; i < dsize; ++i) {
            retval.add(d[i], new IntervalPrice(open[i], close[i], high[i], low[i]));
        }
        return retval;
    }

    public static double[] extractValues(TimeSeries<IntervalPrice> ts, Type type) {
        double[] result = new double[ts.size()];
        Iterator<IntervalPrice> it = ts.values().iterator();
        for (int i = 0; i < ts.size(); ++i) {
            result[i] = it.next().value(type);
        }
        return result;
    }

    public static TimeSeriesDouble extractComponent(TimeSeries<IntervalPrice> ts, Type type) {
        Date[] dates = ts.dates();
        double[] values = IntervalPrice.extractValues(ts, type);
        return new TimeSeriesDouble(dates, values);
    }

    public static enum Type {
        Open,
        Close,
        High,
        Low;

    }
}

