/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Frequency;

public class Greeks {
    public static double blackScholesTheta(GeneralizedBlackScholesProcess p, double value, double delta, double gamma) {
        double u = p.stateVariable().getLink().evaluate();
        double r = p.riskFreeRate().getLink().zeroRate(0.0, Compounding.CONTINUOUS, Frequency.ANNUAL, false).rate();
        double q = p.dividendYield().getLink().zeroRate(0.0, Compounding.CONTINUOUS, Frequency.ANNUAL, false).rate();
        double v = p.localVolatility().getLink().localVol(0.0, u);
        return r * value - (r - q) * u * delta - 0.5 * v * v * u * u * gamma;
    }

    public static double defaultThetaPerDay(double theta) {
        return theta / 365.0;
    }
}

