/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.StartLine;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

class MessageReader {
    private static final int START = 0;
    private static final int HEADER = 1;
    private static final int CONTENT = 2;
    private static final int DONE = 3;
    private static final byte[] sink = new byte[256];
    private final InputStream in;
    private final boolean noContent;
    private int state = 0;
    private StartLine sline;
    private InputStream cin;

    MessageReader(InputStream in, boolean noContent) {
        this.in = in;
        this.noContent = noContent;
    }

    StartLine readStartLine() throws IOException {
        this.updateState(0, 1);
        this.sline = new StartLine(this.in);
        return this.sline;
    }

    Header readHeader() throws IOException {
        this.updateState(1, 2);
        Header header = new Header(this.in);
        if (!this.noContent && MessageReader.contentIndicated(this.sline, header)) {
            if (header.containsValue("Transfer-Encoding", "chunked", true)) {
                this.cin = new ChunkedInputStream();
            } else {
                String clen = header.getField("Content-Length");
                if (clen != null) {
                    int len;
                    try {
                        len = Integer.parseInt(clen);
                    }
                    catch (Exception ex) {
                        throw new HttpParseException("invalid content length");
                    }
                    if (len < 0) {
                        throw new HttpParseException("invalid content length");
                    }
                    this.cin = new BoundedInputStream(len);
                } else {
                    if (this.sline.isRequest) {
                        throw new HttpParseException("request length undeclared");
                    }
                    this.cin = this.in;
                }
            }
        } else {
            this.cin = new BoundedInputStream(0);
        }
        return header;
    }

    int readContent(byte[] b, int off, int len) throws IOException {
        this.updateState(2, 2);
        return this.cin.read(b, off, len);
    }

    int availableContent() throws IOException {
        this.updateState(2, 2);
        return this.cin.available();
    }

    Header readTrailer() throws IOException {
        this.updateState(2, 2);
        while (this.cin.read(sink) != -1) {
        }
        this.updateState(2, 3);
        if (this.cin instanceof ChunkedInputStream) {
            Header trailer = new Header(this.in);
            return trailer.size() > 0 ? trailer : null;
        }
        return null;
    }

    static String readLine(InputStream in) throws IOException {
        int c = in.read();
        if (c == -1) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        do {
            if (c == 13) {
                c = in.read();
                if (c == 10) break;
                sbuf.append('\r');
                continue;
            }
            sbuf.append((char)c);
            c = in.read();
        } while (c != -1);
        return sbuf.toString();
    }

    private void updateState(int oldState, int newState) {
        if (this.state != oldState) {
            throw new IllegalStateException();
        }
        this.state = newState;
    }

    private static boolean contentIndicated(StartLine sline, Header header) {
        if (!(sline.isRequest || sline.status / 100 != 1 && sline.status != 204 && sline.status != 304)) {
            return false;
        }
        if (header.getField("Transfer-Encoding") != null || header.getField("Content-Length") != null) {
            return true;
        }
        return !sline.isRequest;
    }

    private class ChunkedInputStream
    extends InputStream {
        private byte[] buf;
        private int pos = 0;
        private int lim = 0;

        ChunkedInputStream() {
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) != -1 ? b[0] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            while (this.pos >= this.lim) {
                this.refill();
            }
            if (this.pos < 0) {
                return -1;
            }
            int n = Math.min(this.lim - this.pos, len);
            System.arraycopy(this.buf, this.pos, b, off, n);
            this.pos += n;
            return n;
        }

        public int available() throws IOException {
            while (this.pos >= this.lim) {
                this.refill();
            }
            return this.pos >= 0 ? this.lim - this.pos : 0;
        }

        private void refill() throws IOException {
            int newlim = 0;
            try {
                String line = MessageReader.readLine(MessageReader.this.in);
                StringTokenizer tok = new StringTokenizer(line, " ;\t");
                newlim = Integer.parseInt(tok.nextToken(), 16);
            }
            catch (Exception ex) {
                throw new HttpParseException("error parsing chunk length");
            }
            if (newlim < 0) {
                throw new HttpParseException("illegal chunk length");
            }
            if (newlim == 0) {
                this.pos = -1;
            } else {
                int n;
                if (this.buf == null || newlim > this.buf.length) {
                    this.buf = new byte[newlim];
                }
                for (int i = 0; i < newlim; i += n) {
                    n = MessageReader.this.in.read(this.buf, i, newlim - i);
                    if (n >= 0) continue;
                    throw new EOFException("incomplete chunk");
                }
                String blank = MessageReader.readLine(MessageReader.this.in);
                if (blank == null || blank.length() > 0) {
                    throw new HttpParseException("illegal chunk tail");
                }
                this.pos = 0;
                this.lim = newlim;
            }
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private int bound;

        BoundedInputStream(int bound) {
            this.bound = bound;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) != -1 ? b[0] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.bound == 0) {
                return -1;
            }
            int n = MessageReader.this.in.read(b, off, Math.min(this.bound, len));
            if (n != -1) {
                this.bound -= n;
            }
            return n;
        }

        public int available() throws IOException {
            return Math.min(this.bound, MessageReader.this.in.available());
        }
    }
}

