/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundleShapeAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.util.NLS;

public class FeaturesAction
extends AbstractPublisherAction {
    public static final String INSTALL_FEATURES_FILTER = "(org.eclipse.update.install.features=true)";
    private static final String UPDATE_FEATURE_APPLICATION_PROP = "org.eclipse.update.feature.application";
    private static final String UPDATE_FEATURE_PLUGIN_PROP = "org.eclipse.update.feature.plugin";
    private static final String UPDATE_FEATURE_EXCLUSIVE_PROP = "org.eclipse.update.feature.exclusive";
    private static final String UPDATE_FEATURE_PRIMARY_PROP = "org.eclipse.update.feature.primary";
    protected Feature[] features;
    private File[] locations;

    public static IArtifactKey createFeatureArtifactKey(String id, String version) {
        return new ArtifactKey("org.eclipse.update.feature", id, Version.parseVersion((String)version));
    }

    public static IInstallableUnit createFeatureJarIU(Feature feature, IPublisherInfo info) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = FeaturesAction.getTransformedId(feature.getId(), false, false);
        iu.setId(id);
        Version version = Version.parseVersion((String)feature.getVersion());
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicense(MetadataFactory.createLicense((URI)FeaturesAction.toURIOrNull(feature.getLicenseURL()), (String)feature.getLicense()));
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)FeaturesAction.toURIOrNull(feature.getCopyrightURL()), (String)feature.getCopyright()));
        }
        if (feature.getApplication() != null) {
            iu.setProperty(UPDATE_FEATURE_APPLICATION_PROP, feature.getApplication());
        }
        if (feature.getPlugin() != null) {
            iu.setProperty(UPDATE_FEATURE_PLUGIN_PROP, feature.getPlugin());
        }
        if (feature.isExclusive()) {
            iu.setProperty(UPDATE_FEATURE_EXCLUSIVE_PROP, Boolean.TRUE.toString());
        }
        if (feature.isPrimary()) {
            iu.setProperty(UPDATE_FEATURE_PRIMARY_PROP, Boolean.TRUE.toString());
        }
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        iu.setFilter(INSTALL_FEATURES_FILTER);
        iu.setSingleton(true);
        if (feature.getInstallHandler() != null && feature.getInstallHandler().trim().length() > 0) {
            String installHandlerProperty = "handler=" + feature.getInstallHandler();
            if (feature.getInstallHandlerLibrary() != null) {
                installHandlerProperty = String.valueOf(installHandlerProperty) + ", library=" + feature.getInstallHandlerLibrary();
            }
            if (feature.getInstallHandlerURL() != null) {
                installHandlerProperty = String.valueOf(installHandlerProperty) + ", url=" + feature.getInstallHandlerURL();
            }
            iu.setProperty("org.eclipse.update.installHandler", installHandlerProperty);
        }
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability(id, version));
        providedCapabilities.add(PublisherHelper.FEATURE_CAPABILITY);
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.update.feature", (String)feature.getId(), (Version)version));
        iu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(id, version), PublisherHelper.FEATURE_CAPABILITY, MetadataFactory.createProvidedCapability((String)"org.eclipse.update.feature", (String)feature.getId(), (Version)version)});
        iu.setArtifacts(new IArtifactKey[]{FeaturesAction.createFeatureArtifactKey(feature.getId(), version.toString())});
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("zipped", "true");
        iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(id, locale));
            }
        }
        FeaturesAction.processInstallableUnitPropertiesAdvice(iu, info);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private static String getTransformedId(String original, boolean isPlugin, boolean isGroup) {
        return isPlugin ? original : String.valueOf(original) + (isGroup ? ".feature.group" : ".feature.jar");
    }

    private static URI toURIOrNull(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URIUtil.fromString((String)url);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public FeaturesAction(Feature[] features) {
        this.features = features;
    }

    public FeaturesAction(File[] locations) {
        this.locations = locations;
    }

    private File[] attachFiles(MetadataFactory.InstallableUnitDescription iu, FileSetDescriptor descriptor, File location) {
        String fileList = descriptor.getFiles();
        String[] fileSpecs = FeaturesAction.getArrayFromString(fileList, ",");
        File[] files = new File[fileSpecs.length];
        if (fileSpecs.length > 0) {
            int i = 0;
            while (i < fileSpecs.length) {
                String spec = fileSpecs[i];
                if (spec.startsWith("file:")) {
                    spec = spec.substring(5);
                }
                files[i] = new File(location, spec);
                ++i;
            }
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>(2);
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        ArtifactKey key = new ArtifactKey("binary", iu.getId(), iu.getVersion());
        iu.setArtifacts(new IArtifactKey[]{key});
        return files;
    }

    private void createAdviceFileAdvice(Feature feature, IPublisherInfo publisherInfo) {
        String groupId;
        AdviceFileAdvice advice;
        String location = feature.getLocation();
        if (location != null && (advice = new AdviceFileAdvice(groupId = FeaturesAction.getTransformedId(feature.getId(), false, true), Version.parseVersion((String)feature.getVersion()), (IPath)new Path(location), (IPath)new Path("p2.inf"))).containsAdvice()) {
            publisherInfo.addAdvice(advice);
        }
    }

    private void createBundleShapeAdvice(Feature feature, IPublisherInfo publisherInfo) {
        FeatureEntry[] entries = feature.getEntries();
        int i = 0;
        while (i < entries.length) {
            FeatureEntry entry = entries[i];
            if (entry.isUnpack() && entry.isPlugin() && !entry.isRequires()) {
                publisherInfo.addAdvice(new BundleShapeAdvice(entry.getId(), Version.parseVersion((String)entry.getVersion()), "dir"));
            }
            ++i;
        }
    }

    protected Object[] createFeatureRootFileIU(String featureId, String featureVersion, File location, FileSetDescriptor descriptor) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(true);
        String id = String.valueOf(featureId) + '_' + descriptor.getKey();
        iu.setId(id);
        Version version = Version.parseVersion((String)featureVersion);
        iu.setVersion(version);
        iu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(id, version)});
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        String configSpec = descriptor.getConfigSpec();
        if (configSpec != null && configSpec.length() > 0) {
            iu.setFilter(this.createFilterSpec(configSpec));
        }
        File[] fileResult = this.attachFiles(iu, descriptor, location);
        this.setupLinks(iu, descriptor);
        this.setupPermissions(iu, descriptor);
        IInstallableUnit iuResult = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        return new Object[]{iuResult, fileResult};
    }

    protected IInstallableUnit createGroupIU(Feature feature, List childIUs, IPublisherInfo publisherInfo) {
        if (this.isPatch(feature)) {
            return this.createPatchIU(feature, childIUs, publisherInfo);
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = this.getGroupId(feature.getId());
        iu.setId(id);
        Version version = Version.fromOSGiVersion((org.osgi.framework.Version)new org.osgi.framework.Version(feature.getVersion()));
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicense(MetadataFactory.createLicense((URI)FeaturesAction.toURIOrNull(feature.getLicenseURL()), (String)feature.getLicense()));
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)FeaturesAction.toURIOrNull(feature.getCopyrightURL()), (String)feature.getCopyright()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)BundlesAction.computeUpdateRange(new org.osgi.framework.Version(feature.getVersion())), (int)0, null));
        FeatureEntry[] entries = feature.getEntries();
        ArrayList<IRequiredCapability> required = new ArrayList<IRequiredCapability>(entries.length + (childIUs == null ? 0 : childIUs.size()));
        int i = 0;
        while (i < entries.length) {
            VersionRange range = this.getVersionRange(entries[i]);
            String requiredId = FeaturesAction.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true);
            required.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)requiredId, (VersionRange)range, (String)this.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false));
            ++i;
        }
        if (childIUs != null) {
            i = 0;
            while (i < childIUs.size()) {
                IInstallableUnit child = (IInstallableUnit)childIUs.get(i);
                required.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)child.getId(), (VersionRange)new VersionRange(child.getVersion(), true, child.getVersion(), true), (String)child.getFilter(), (boolean)false, (boolean)false));
                ++i;
            }
        }
        iu.setRequiredCapabilities(required.toArray(new IRequiredCapability[required.size()]));
        iu.setTouchpointType(ITouchpointType.NONE);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        FeaturesAction.processTouchpointAdvice(iu, null, publisherInfo);
        FeaturesAction.processInstallableUnitPropertiesAdvice(iu, publisherInfo);
        FeatureEntry entry = new FeatureEntry("fake", "0.0.0", false);
        entry.setEnvironment(feature.getOS(), feature.getWS(), feature.getArch(), feature.getNL());
        String filter = this.getFilter(entry);
        if (filter != null) {
            iu.setFilter(filter);
        }
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(this.createSelfCapability(id, version));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        FeaturesAction.processCapabilityAdvice(iu, publisherInfo);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    protected String getGroupId(String featureId) {
        return FeaturesAction.getTransformedId(featureId, false, true);
    }

    private IInstallableUnit createPatchIU(Feature feature, List childIUs, IPublisherInfo publisherInfo) {
        MetadataFactory.InstallableUnitPatchDescription iu = new MetadataFactory.InstallableUnitPatchDescription();
        String id = FeaturesAction.getTransformedId(feature.getId(), false, true);
        iu.setId(id);
        Version version = Version.parseVersion((String)feature.getVersion());
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicense(MetadataFactory.createLicense((URI)FeaturesAction.toURIOrNull(feature.getLicenseURL()), (String)feature.getLicense()));
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)FeaturesAction.toURIOrNull(feature.getCopyrightURL()), (String)feature.getCopyright()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)BundlesAction.computeUpdateRange(new org.osgi.framework.Version(feature.getVersion())), (int)0, null));
        FeatureEntry[] entries = feature.getEntries();
        ArrayList<IRequiredCapability> applicabilityScope = new ArrayList<IRequiredCapability>();
        ArrayList<IRequiredCapability> patchRequirements = new ArrayList<IRequiredCapability>();
        ArrayList<IRequirementChange> requirementChanges = new ArrayList<IRequirementChange>();
        int i = 0;
        while (i < entries.length) {
            VersionRange range = this.getVersionRange(entries[i]);
            IRequiredCapability req = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)FeaturesAction.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)range, (String)this.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
            if (entries[i].isRequires()) {
                applicabilityScope.add(req);
            } else if (entries[i].isPlugin()) {
                IRequiredCapability from = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)FeaturesAction.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)VersionRange.emptyRange, (String)this.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
                requirementChanges.add(MetadataFactory.createRequirementChange((IRequiredCapability)from, (IRequiredCapability)req));
            } else {
                patchRequirements.add(req);
            }
            ++i;
        }
        if (childIUs != null) {
            i = 0;
            while (i < childIUs.size()) {
                IInstallableUnit child = (IInstallableUnit)childIUs.get(i);
                patchRequirements.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)child.getId(), (VersionRange)new VersionRange(child.getVersion(), true, child.getVersion(), true), (String)child.getFilter(), (boolean)false, (boolean)false));
                ++i;
            }
        }
        iu.setRequiredCapabilities(patchRequirements.toArray(new IRequiredCapability[patchRequirements.size()]));
        iu.setApplicabilityScope((IRequiredCapability[][])new IRequiredCapability[][]{applicabilityScope.toArray(new IRequiredCapability[applicabilityScope.size()])});
        iu.setRequirementChanges(requirementChanges.toArray(new IRequirementChange[requirementChanges.size()]));
        IRequiredCapability lifeCycle = null;
        if (applicabilityScope.size() > 0) {
            IRequiredCapability req = (IRequiredCapability)applicabilityScope.get(0);
            lifeCycle = MetadataFactory.createRequiredCapability((String)req.getNamespace(), (String)req.getName(), (VersionRange)req.getRange(), null, (boolean)false, (boolean)false, (boolean)false);
            iu.setLifeCycle(lifeCycle);
        }
        iu.setTouchpointType(ITouchpointType.NONE);
        FeaturesAction.processTouchpointAdvice((MetadataFactory.InstallableUnitDescription)iu, null, publisherInfo);
        FeaturesAction.processInstallableUnitPropertiesAdvice((MetadataFactory.InstallableUnitDescription)iu, publisherInfo);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.setProperty("org.eclipse.equinox.p2.type.patch", Boolean.TRUE.toString());
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(this.createSelfCapability(id, version));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        FeaturesAction.processCapabilityAdvice((MetadataFactory.InstallableUnitDescription)iu, publisherInfo);
        return MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iu);
    }

    private File[] expandLocations(File[] list) {
        ArrayList result = new ArrayList();
        this.expandLocations(list, result);
        return result.toArray(new File[result.size()]);
    }

    private void expandLocations(File[] list, ArrayList result) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File location = list[i];
            if (location.isDirectory()) {
                if (new File(location, "feature.xml").exists()) {
                    result.add(location);
                } else {
                    this.expandLocations(location.listFiles(), result);
                }
            } else {
                result.add(location);
            }
            ++i;
        }
    }

    protected void generateFeatureIUs(Feature[] featureList, IPublisherResult result) {
        int i = 0;
        while (i < featureList.length) {
            IInstallableUnit groupIU;
            Feature feature = featureList[i];
            this.createBundleShapeAdvice(feature, this.info);
            this.createAdviceFileAdvice(feature, this.info);
            ArrayList<IInstallableUnit> childIUs = new ArrayList<IInstallableUnit>();
            IInstallableUnit featureJarIU = this.queryForIU(result, FeaturesAction.getTransformedId(feature.getId(), false, false), Version.parseVersion((String)feature.getVersion()));
            if (featureJarIU == null) {
                featureJarIU = this.generateFeatureJarIU(feature, this.info);
            }
            if (featureJarIU != null) {
                this.publishFeatureArtifacts(feature, featureJarIU, this.info);
                result.addIU(featureJarIU, "non_root");
                childIUs.add(featureJarIU);
            }
            if ((groupIU = this.queryForIU(result, this.getGroupId(feature.getId()), Version.parseVersion((String)feature.getVersion()))) == null) {
                childIUs.addAll(this.generateRootFileIUs(feature, result, this.info));
                groupIU = this.createGroupIU(feature, childIUs, this.info);
            }
            if (groupIU != null) {
                result.addIU(groupIU, "root");
                MetadataFactory.InstallableUnitDescription[] others = FeaturesAction.processAdditionalInstallableUnitsAdvice(groupIU, this.info);
                int iuIndex = 0;
                while (others != null && iuIndex < others.length) {
                    result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)others[iuIndex]), "root");
                    ++iuIndex;
                }
            }
            this.generateSiteReferences(feature, result, this.info);
            ++i;
        }
    }

    protected IInstallableUnit generateFeatureJarIU(Feature feature, IPublisherInfo publisherInfo) {
        return FeaturesAction.createFeatureJarIU(feature, publisherInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IInstallableUnit generateRootFileIU(String featureId, String featureVersion, File location, FileSetDescriptor rootFile, IPublisherResult result, IPublisherInfo publisherInfo) {
        IInstallableUnit iInstallableUnit;
        block9: {
            File tempLocation = null;
            try {
                if (location.isFile()) {
                    try {
                        tempLocation = File.createTempFile("p2.generator", "");
                        tempLocation.delete();
                        tempLocation.mkdirs();
                        FileUtils.unzipFile((File)location, (File)tempLocation);
                    }
                    catch (IOException e) {
                        LogHelper.log((IStatus)new Status(4, Activator.ID, e.getMessage()));
                        if (tempLocation != null) {
                            FileUtils.deleteAll((File)tempLocation);
                        }
                        return null;
                    }
                    location = tempLocation;
                }
                Object[] iuAndFiles = this.createFeatureRootFileIU(featureId, featureVersion, location, rootFile);
                IInstallableUnit iuResult = (IInstallableUnit)iuAndFiles[0];
                File[] fileResult = (File[])iuAndFiles[1];
                if (fileResult != null && fileResult.length > 0) {
                    IArtifactKey artifact = iuResult.getArtifacts()[0];
                    ArtifactDescriptor descriptor = new ArtifactDescriptor(artifact);
                    this.publishArtifact((IArtifactDescriptor)descriptor, fileResult, null, publisherInfo, FileUtils.createDynamicPathComputer((int)1));
                }
                result.addIU(iuResult, "non_root");
                iInstallableUnit = iuResult;
                if (tempLocation == null) break block9;
            }
            catch (Throwable throwable) {
                if (tempLocation != null) {
                    FileUtils.deleteAll(tempLocation);
                }
                throw throwable;
            }
            FileUtils.deleteAll((File)tempLocation);
        }
        return iInstallableUnit;
    }

    protected ArrayList generateRootFileIUs(Feature feature, IPublisherResult result, IPublisherInfo publisherInfo) {
        File location = new File(feature.getLocation());
        Properties props = FeaturesAction.loadProperties(location, "build.properties");
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        FileSetDescriptor[] rootFileDescriptors = this.getRootFileDescriptors(props);
        int i = 0;
        while (i < rootFileDescriptors.length) {
            IInstallableUnit iu = this.generateRootFileIU(feature.getId(), feature.getVersion(), location, rootFileDescriptors[i], result, publisherInfo);
            if (iu != null) {
                ius.add(iu);
            }
            ++i;
        }
        return ius;
    }

    private void generateSiteReference(String location, String nickname, String featureId, IMetadataRepository metadataRepo) {
        if (location == null) {
            String message = featureId == null ? NLS.bind((String)Messages.exception_invalidSiteReference, (Object)location) : NLS.bind((String)Messages.exception_invalidSiteReferenceInFeature, (Object)location, (Object)featureId);
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
            return;
        }
        try {
            URI associateLocation = new URI(location);
            metadataRepo.addReference(associateLocation, nickname, 0, 0);
            metadataRepo.addReference(associateLocation, nickname, 1, 0);
        }
        catch (URISyntaxException uRISyntaxException) {
            String message = featureId == null ? NLS.bind((String)Messages.exception_invalidSiteReference, (Object)location) : NLS.bind((String)Messages.exception_invalidSiteReferenceInFeature, (Object)location, (Object)featureId);
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
        }
    }

    protected void generateSiteReferences(Feature feature, IPublisherResult result, IPublisherInfo publisherInfo) {
        URLEntry updateURL = feature.getUpdateSite();
        if (updateURL != null) {
            this.generateSiteReference(updateURL.getURL(), updateURL.getAnnotation(), feature.getId(), publisherInfo.getMetadataRepository());
        }
        URLEntry[] discoverySites = feature.getDiscoverySites();
        int i = 0;
        while (i < discoverySites.length) {
            this.generateSiteReference(discoverySites[i].getURL(), discoverySites[i].getAnnotation(), feature.getId(), publisherInfo.getMetadataRepository());
            ++i;
        }
    }

    protected Feature[] getFeatures(File[] featureLocations) {
        ArrayList<Feature> result = new ArrayList<Feature>(featureLocations.length);
        int i = 0;
        while (i < featureLocations.length) {
            Feature feature = new FeatureParser().parse(featureLocations[i]);
            if (feature != null) {
                feature.setLocation(featureLocations[i].getAbsolutePath());
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new Feature[result.size()]);
    }

    private String getFilter(FeatureEntry entry) {
        StringBuffer result = new StringBuffer();
        result.append("(&");
        if (entry.getFilter() != null) {
            result.append(entry.getFilter());
        }
        this.expandFilter(entry.getOS(), "osgi.os", result);
        this.expandFilter(entry.getWS(), "osgi.ws", result);
        this.expandFilter(entry.getArch(), "osgi.arch", result);
        this.expandFilter(entry.getNL(), "osgi.nl", result);
        if (result.length() == 2) {
            return null;
        }
        result.append(')');
        return result.toString();
    }

    private void expandFilter(String filter, String osgiFilterValue, StringBuffer result) {
        if (filter != null) {
            StringTokenizer token = new StringTokenizer(filter, ",");
            if (token.countTokens() == 1) {
                result.append(String.valueOf('(') + osgiFilterValue + '=' + filter + ')');
            } else {
                result.append("(|");
                while (token.hasMoreElements()) {
                    result.append(String.valueOf('(') + osgiFilterValue + '=' + token.nextToken() + ')');
                }
                result.append(')');
            }
        }
    }

    protected FileSetDescriptor[] getRootFileDescriptors(Properties props) {
        HashMap<String, FileSetDescriptor> result = new HashMap<String, FileSetDescriptor>();
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            FileSetDescriptor descriptor;
            String property = (String)i.next();
            if (!property.startsWith("root") || property.length() != 4 && property.charAt(4) != '.') continue;
            String[] spec = FeaturesAction.getArrayFromString(property, ".");
            String descriptorKey = spec[0];
            String configSpec = null;
            if (spec.length > 3) {
                configSpec = FeaturesAction.createConfigSpec(spec[2], spec[1], spec[3]);
                descriptorKey = String.valueOf(descriptorKey) + "." + this.createIdString(configSpec);
            }
            if ((descriptor = (FileSetDescriptor)result.get(descriptorKey)) == null) {
                descriptor = new FileSetDescriptor(descriptorKey, configSpec);
                result.put(descriptorKey, descriptor);
            }
            if (spec.length == 1) {
                descriptor.setFiles(props.getProperty(property));
                continue;
            }
            if (spec[spec.length - 1] == "link") {
                descriptor.setLinks(props.getProperty(property));
                continue;
            }
            if (spec[spec.length - 2].equals("permissions")) {
                descriptor.addPermissions(new String[]{spec[spec.length - 1], props.getProperty(property)});
                continue;
            }
            descriptor.setFiles(props.getProperty(property));
        }
        Collection values = result.values();
        return values.toArray(new FileSetDescriptor[values.size()]);
    }

    private VersionRange getVersionRange(FeatureEntry entry) {
        String versionSpec = entry.getVersion();
        if (versionSpec == null) {
            return VersionRange.emptyRange;
        }
        Version version = Version.parseVersion((String)versionSpec);
        if (version.equals((Object)Version.emptyVersion)) {
            return VersionRange.emptyRange;
        }
        if (!entry.isRequires()) {
            return new VersionRange(version, true, version, true);
        }
        String match = entry.getMatch();
        if (match == null) {
            return null;
        }
        if (match.equals("perfect")) {
            return new VersionRange(version, true, version, true);
        }
        if (match.equals("equivalent")) {
            Version upper = Version.createOSGi((int)version.getMajor(), (int)(version.getMinor() + 1), (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("compatible")) {
            Version upper = Version.createOSGi((int)(version.getMajor() + 1), (int)0, (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("greaterOrEqual")) {
            return new VersionRange(version, true, new VersionRange(null).getMaximum(), true);
        }
        return null;
    }

    private boolean isPatch(Feature feature) {
        FeatureEntry[] entries = feature.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Properties loadProperties(File location, String file) {
        Properties props;
        block14: {
            props = new Properties();
            try {
                if (!location.isDirectory()) {
                    JarFile jar = null;
                    try {
                        jar = new JarFile(location);
                        JarEntry entry = jar.getJarEntry(file);
                        if (entry != null) {
                            FeaturesAction.parseProperties(jar.getInputStream(entry), props, String.valueOf(location.toString()) + '#' + file);
                        }
                        break block14;
                    }
                    finally {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                }
                try {
                    InputStream in = null;
                    try {
                        File propsFile = new File(location, file);
                        in = new FileInputStream(propsFile);
                        FeaturesAction.parseProperties(in, props, propsFile.toString());
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, Messages.exception_errorPublishingArtifacts, (Throwable)e));
            }
        }
        return props;
    }

    private static void parseProperties(InputStream in, Properties props, String file) {
        try {
            props.load(new BufferedInputStream(in));
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.exception_errorLoadingProperties, (Object)file), (Throwable)e));
        }
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.features == null && this.locations == null) {
            throw new IllegalStateException(Messages.exception_noFeaturesOrLocations);
        }
        this.info = publisherInfo;
        if (this.features == null) {
            this.features = this.getFeatures(this.expandLocations(this.locations));
        }
        this.generateFeatureIUs(this.features, results);
        return Status.OK_STATUS;
    }

    protected void publishFeatureArtifacts(Feature feature, IInstallableUnit featureIU, IPublisherInfo publisherInfo) {
        IArtifactKey[] artifacts = featureIU.getArtifacts();
        int j = 0;
        while (j < artifacts.length) {
            File file = new File(feature.getLocation());
            ArtifactDescriptor ad = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor(artifacts[j], file);
            FeaturesAction.processArtifactPropertiesAdvice(featureIU, ad, publisherInfo);
            ad.setProperty("download.contentType", "application/zip");
            if (file.isDirectory()) {
                this.publishArtifact((IArtifactDescriptor)ad, new File[]{file}, null, publisherInfo, this.createRootPrefixComputer(file));
            } else {
                this.publishArtifact((IArtifactDescriptor)ad, file, publisherInfo);
            }
            ++j;
        }
    }

    private void setupLinks(MetadataFactory.InstallableUnitDescription iu, FileSetDescriptor descriptor) {
        String[] links = FeaturesAction.getArrayFromString(descriptor.getLinks(), ",");
        StringBuffer linkActions = new StringBuffer();
        int i = 0;
        while (i < links.length) {
            String target = links[i++];
            if (i >= links.length) continue;
            String name = links[i++];
            linkActions.append("ln(linkTarget:" + target);
            linkActions.append(",targetDir:${installFolder},linkName:" + name);
            linkActions.append(");");
        }
        if (linkActions.length() > 0) {
            HashMap<String, String> touchpointData = new HashMap<String, String>();
            touchpointData.put("configure", linkActions.toString());
            iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        }
    }

    private void setupPermissions(MetadataFactory.InstallableUnitDescription iu, FileSetDescriptor descriptor) {
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String[][] permsList = descriptor.getPermissions();
        int i = 0;
        while (i < permsList.length) {
            String[] permSpec = permsList[i];
            String configurationData = " chmod(targetDir:${installFolder}, targetFile:" + permSpec[1] + ", permissions:" + permSpec[0] + ");";
            touchpointData.put("install", configurationData);
            iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
            ++i;
        }
    }
}

