/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.framework.BundleInfo;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.SystemBundleArchive;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IContentLoader;
import org.apache.felix.moduleloader.IModuleDefinition;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.ISearchPolicy;
import org.apache.felix.moduleloader.IURLPolicy;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

class ExtensionManager
extends URLStreamHandler
implements IModuleDefinition,
IContentLoader,
IContent {
    static final ExtensionManager m_extensionManager;
    private Logger m_logger = null;
    private BundleInfo m_systemBundleInfo = null;
    private ICapability[] m_capabilities = null;
    private Set m_exportNames = null;
    private ISearchPolicy m_searchPolicy = null;
    private IURLPolicy m_urlPolicy = null;
    private Object m_securityContext = null;
    private final List m_extensions;
    private final Set m_names;
    private final Map m_sourceToExtensions;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;

    private ExtensionManager() {
        this.m_extensions = new ArrayList();
        this.m_names = new HashSet();
        this.m_sourceToExtensions = new HashMap();
    }

    ExtensionManager(Logger logger, Map configMap, BundleInfo systemBundleInfo) {
        this.m_extensions = null;
        this.m_names = null;
        this.m_sourceToExtensions = null;
        this.m_logger = logger;
        this.m_systemBundleInfo = systemBundleInfo;
        Map map = ((SystemBundleArchive)this.m_systemBundleInfo.getArchive()).getManifestHeader(0);
        map.put("Bundle-Version", configMap.get("felix.version"));
        map.put("Bundle-SymbolicName", "org.apache.felix.framework");
        map.put("Bundle-Name", "System Bundle");
        map.put("Bundle-Description", "This bundle is system specific; it implements various system services.");
        map.put("Export-Service", "org.osgi.service.packageadmin.PackageAdmin,org.osgi.service.startlevel.StartLevel,org.osgi.service.url.URLHandlers");
        try {
            this.setCapabilities(ManifestParser.parseExportHeader((String)configMap.get("org.osgi.framework.system.packages")));
        }
        catch (Exception ex) {
            this.m_capabilities = new ICapability[0];
            this.m_logger.log(1, "Error parsing system bundle export statement: " + configMap.get("org.osgi.framework.system.packages"), ex);
        }
    }

    public synchronized Object getSecurityContext() {
        return this.m_securityContext;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_securityContext = securityContext;
    }

    boolean isExtensionBundle(Map headers) {
        R4Directive dir = ManifestParser.parseExtensionBundleHeader((String)headers.get("Fragment-Host"));
        return dir != null && ("framework".equals(dir.getValue()) || "bootclasspath".equals(dir.getValue()));
    }

    void addExtensionBundle(Felix felix, FelixBundle bundle) throws SecurityException, BundleException, Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, "extensionLifecycle"));
        }
        if (!((BundleProtectionDomain)bundle.getInfo().getProtectionDomain()).impliesDirect(new AllPermission())) {
            throw new SecurityException("Extension Bundles must have AllPermission");
        }
        R4Directive dir = ManifestParser.parseExtensionBundleHeader((String)bundle.getInfo().getCurrentHeader().get("Fragment-Host"));
        if (!"framework".equals(dir.getValue())) {
            throw new BundleException("Unsupported Extension Bundle type: " + dir.getValue(), new UnsupportedOperationException("Unsupported Extension Bundle type!"));
        }
        felix.acquireBundleLock(felix);
        try {
            bundle.getInfo().setExtension(true);
            SystemBundleArchive systemArchive = (SystemBundleArchive)felix.getInfo().getArchive();
            Object headers = null;
            ICapability[] exports = null;
            try {
                exports = ManifestParser.parseExportHeader((String)bundle.getInfo().getCurrentHeader().get("Export-Package"));
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Error parsing extension bundle export statement: " + bundle.getInfo().getCurrentHeader().get("Export-Package"), ex);
                felix.releaseBundleLock(felix);
                return;
            }
            if (m_extensionManager == null) {
                this.m_logger.log(2, "Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
                throw new UnsupportedOperationException("Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
            }
            m_extensionManager.addExtension(felix, bundle);
            ICapability[] temp = new ICapability[this.getCapabilities().length + exports.length];
            System.arraycopy(this.getCapabilities(), 0, temp, 0, this.getCapabilities().length);
            System.arraycopy(exports, 0, temp, this.getCapabilities().length, exports.length);
            this.setCapabilities(temp);
        }
        catch (Exception ex) {
            bundle.getInfo().setExtension(false);
            throw ex;
        }
        finally {
            felix.releaseBundleLock(felix);
        }
        bundle.getInfo().setState(4);
    }

    void startExtensionBundle(Felix felix, FelixBundle bundle) {
        String activatorClass = (String)bundle.getInfo().getCurrentHeader().get("Felix-Activator");
        if (activatorClass != null) {
            try {
                BundleActivator activator = (BundleActivator)felix.getClass().getClassLoader().loadClass(activatorClass.trim()).newInstance();
                felix.m_activatorList.add(activator);
                BundleContext context = this.m_systemBundleInfo.getBundleContext();
                bundle.getInfo().setBundleContext(context);
                if (felix.getInfo().getState() == 32) {
                    Felix.m_secureAction.startActivator(activator, context);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.m_logger.log(2, "Unable to start Felix Extension Activator", ex);
            }
        }
    }

    void removeExtensions(Felix felix) {
        if (m_extensionManager != null) {
            m_extensionManager._removeExtensions(felix);
        }
    }

    public ICapability[] getCapabilities() {
        return this.m_capabilities;
    }

    void setCapabilities(ICapability[] capabilities) {
        this.m_capabilities = capabilities;
        Map map = ((SystemBundleArchive)this.m_systemBundleInfo.getArchive()).getManifestHeader(0);
        map.put("Export-Package", this.convertCapabilitiesToHeaders(map));
        ((SystemBundleArchive)this.m_systemBundleInfo.getArchive()).setManifestHeader(map);
    }

    public IRequirement[] getDynamicRequirements() {
        return null;
    }

    public R4Library[] getLibraries() {
        return null;
    }

    public IRequirement[] getRequirements() {
        return null;
    }

    private String convertCapabilitiesToHeaders(Map headers) {
        StringBuffer exportSB = new StringBuffer("");
        HashSet<String> exportNames = new HashSet<String>();
        for (int i = 0; this.m_capabilities != null && i < this.m_capabilities.length; ++i) {
            if (i > 0) {
                exportSB.append(", ");
            }
            exportSB.append(((Capability)this.m_capabilities[i]).getPackageName());
            exportSB.append("; version=\"");
            exportSB.append(((Capability)this.m_capabilities[i]).getPackageVersion().toString());
            exportSB.append("\"");
            exportNames.add(((Capability)this.m_capabilities[i]).getPackageName());
        }
        this.m_exportNames = exportNames;
        return exportSB.toString();
    }

    public void open() {
    }

    public void close() {
    }

    public IContent getContent() {
        return this;
    }

    public ISearchPolicy getSearchPolicy() {
        return this.m_searchPolicy;
    }

    public void setSearchPolicy(ISearchPolicy searchPolicy) {
        this.m_searchPolicy = searchPolicy;
    }

    public IURLPolicy getURLPolicy() {
        return this.m_urlPolicy;
    }

    public void setURLPolicy(IURLPolicy urlPolicy) {
        this.m_urlPolicy = urlPolicy;
    }

    public Class getClass(String name) {
        if (!this.m_exportNames.contains(Util.getClassPackage(name))) {
            return null;
        }
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            return null;
        }
    }

    public URL getResource(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    public Enumeration getResources(String name) {
        try {
            return this.getClass().getClassLoader().getResources(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public URL getResourceFromContent(String name) {
        return null;
    }

    public boolean hasInputStream(int index, String urlPath) {
        return this.getClass().getClassLoader().getResource(urlPath) != null;
    }

    public InputStream getInputStream(int index, String urlPath) {
        return this.getClass().getClassLoader().getResourceAsStream(urlPath);
    }

    public String findLibrary(String name) {
        return null;
    }

    protected synchronized URLConnection openConnection(URL url) throws IOException {
        String path = url.getPath();
        if (path.trim().equals("/")) {
            return new URLHandlersBundleURLConnection(url);
        }
        Iterator iter = this.m_extensions.iterator();
        while (iter.hasNext()) {
            URL result = ((FelixBundle)iter.next()).getInfo().getCurrentModule().getContentLoader().getResourceFromContent(path);
            if (result == null) continue;
            return result.openConnection();
        }
        throw new IOException("Resource not provided by any extension!");
    }

    protected InetAddress getHostAddress(URL u) {
        return null;
    }

    private synchronized void addExtension(Object source, Bundle extension) {
        ArrayList<Bundle> sourceExtensions = (ArrayList<Bundle>)this.m_sourceToExtensions.get(source);
        if (sourceExtensions == null) {
            sourceExtensions = new ArrayList<Bundle>();
            this.m_sourceToExtensions.put(source, sourceExtensions);
        }
        sourceExtensions.add(extension);
        this._add(extension.getSymbolicName(), extension);
    }

    private synchronized void _removeExtensions(Object source) {
        if (this.m_sourceToExtensions.remove(source) == null) {
            return;
        }
        this.m_extensions.clear();
        this.m_names.clear();
        Iterator iter = this.m_sourceToExtensions.values().iterator();
        while (iter.hasNext()) {
            List extensions = (List)iter.next();
            Iterator extIter = extensions.iterator();
            while (extIter.hasNext()) {
                Bundle bundle = (Bundle)extIter.next();
                this._add(bundle.getSymbolicName(), bundle);
            }
        }
    }

    private void _add(String name, Bundle extension) {
        if (!this.m_names.contains(name)) {
            this.m_names.add(name);
            this.m_extensions.add(extension);
        }
    }

    public Enumeration getEntries() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        };
    }

    public boolean hasEntry(String name) {
        return false;
    }

    public byte[] getEntryAsBytes(String name) {
        return null;
    }

    public InputStream getEntryAsStream(String name) throws IOException {
        return null;
    }

    public IContent getEntryAsContent(String name) {
        return null;
    }

    public String getEntryAsNativeLibrary(String name) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ExtensionManager extensionManager = new ExtensionManager();
        try {
            Felix.m_secureAction.addURLToURLClassLoader(Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "felix:", extensionManager), "felix://extensions/", extensionManager), (class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = ExtensionManager.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getClassLoader());
        }
        catch (Exception ex) {
            extensionManager = null;
        }
        m_extensionManager = extensionManager;
    }
}

