/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.xml.sax;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl {
    private static final String EMPTY = "";
    private final Attributes emptyAtts = new AttributesImpl();
    private Map<String, String> prefixTable;
    private Hashtable<String, Boolean> forcedDeclTable;
    private Map<String, String> doneDeclTable;
    private int elementLevel = 0;
    private Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter = 0;

    public XMLWriter() {
        this.init(null);
    }

    public XMLWriter(Writer writer) {
        this.init(writer);
    }

    public XMLWriter(XMLReader xmlreader) {
        super(xmlreader);
        this.init(null);
    }

    public XMLWriter(XMLReader xmlreader, Writer writer) {
        super(xmlreader);
        this.init(writer);
    }

    private void init(Writer writer) {
        this.setOutput(writer);
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable<String, String>();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable<String, String>();
    }

    public void reset() {
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String uri, String prefix) {
        this.prefixTable.put(uri, prefix);
    }

    public String getPrefix(String uri) {
        return this.prefixTable.get(uri);
    }

    public void forceNSDecl(String uri) {
        this.forcedDeclTable.put(uri, Boolean.TRUE);
    }

    public void forceNSDecl(String uri, String prefix) {
        this.setPrefix(uri, prefix);
        this.forceNSDecl(uri);
    }

    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n\n");
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.elementLevel;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(uri, localName, qName, true);
        this.writeAttributes(atts);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.write("</");
        this.writeName(uri, localName, qName, true);
        this.write('>');
        if (this.elementLevel == 1) {
            this.write('\n');
        }
        super.endElement(uri, localName, qName);
        this.nsSupport.popContext();
        --this.elementLevel;
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.writeEsc(ch, start, len, false);
        super.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeEsc(ch, start, length, false);
        super.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.write("<?");
        this.write(target);
        this.write(' ');
        this.write(data);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(target, data);
    }

    public void emptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(uri, localName, qName, true);
        this.writeAttributes(atts);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(uri, localName, qName, atts);
        super.endElement(uri, localName, qName);
    }

    public void startElement(String uri, String localName) throws SAXException {
        this.startElement(uri, localName, EMPTY, this.emptyAtts);
    }

    public void startElement(String localName) throws SAXException {
        this.startElement(EMPTY, localName, EMPTY, this.emptyAtts);
    }

    public void endElement(String uri, String localName) throws SAXException {
        this.endElement(uri, localName, EMPTY);
    }

    public void endElement(String localName) throws SAXException {
        this.endElement(EMPTY, localName, EMPTY);
    }

    public void emptyElement(String uri, String localName) throws SAXException {
        this.emptyElement(uri, localName, EMPTY, this.emptyAtts);
    }

    public void emptyElement(String localName) throws SAXException {
        this.emptyElement(EMPTY, localName, EMPTY, this.emptyAtts);
    }

    public void dataElement(String uri, String localName, String qName, Attributes atts, String content) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.characters(content);
        this.endElement(uri, localName, qName);
    }

    public void dataElement(String uri, String localName, String content) throws SAXException {
        this.dataElement(uri, localName, EMPTY, this.emptyAtts, content);
    }

    public void dataElement(String localName, String content) throws SAXException {
        this.dataElement(EMPTY, localName, EMPTY, this.emptyAtts, content);
    }

    public void characters(String data) throws SAXException {
        char[] ch = data.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    private void forceNSDecls() {
        Enumeration<String> prefixes = this.forcedDeclTable.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            this.doPrefix(prefix, null, true);
        }
    }

    private String doPrefix(String uri, String qName, boolean isElement) {
        String defaultNS = this.nsSupport.getURI(EMPTY);
        if (EMPTY.equals(uri)) {
            if (isElement && defaultNS != null) {
                this.nsSupport.declarePrefix(EMPTY, EMPTY);
            }
            return null;
        }
        String prefix = isElement && defaultNS != null && uri.equals(defaultNS) ? EMPTY : this.nsSupport.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.doneDeclTable.get(uri);
        if (prefix != null && ((!isElement || defaultNS != null) && EMPTY.equals(prefix) || this.nsSupport.getURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && (prefix = this.prefixTable.get(uri)) != null && ((!isElement || defaultNS != null) && EMPTY.equals(prefix) || this.nsSupport.getURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && qName != null && !EMPTY.equals(qName)) {
            int i = qName.indexOf(58);
            if (i == -1) {
                if (isElement && defaultNS == null) {
                    prefix = EMPTY;
                }
            } else {
                prefix = qName.substring(0, i);
            }
        }
        while (prefix == null || this.nsSupport.getURI(prefix) != null) {
            prefix = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix(prefix, uri);
        this.doneDeclTable.put(uri, prefix);
        return prefix;
    }

    private void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(String s) throws SAXException {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeAttributes(Attributes atts) throws SAXException {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            char[] ch = atts.getValue(i).toCharArray();
            this.write(' ');
            this.writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
            this.write("=\"");
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws SAXException {
        block6: for (int i = start; i < start + length; ++i) {
            switch (ch[i]) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                default: {
                    if (ch[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(ch[i]));
                        this.write(';');
                        continue block6;
                    }
                    this.write(ch[i]);
                }
            }
        }
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> prefixes = this.nsSupport.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = this.nsSupport.getURI(prefix);
            if (uri == null) {
                uri = EMPTY;
            }
            char[] ch = uri.toCharArray();
            this.write(' ');
            if (EMPTY.equals(prefix)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(prefix);
                this.write("=\"");
            }
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    private void writeName(String uri, String localName, String qName, boolean isElement) throws SAXException {
        String prefix = this.doPrefix(uri, qName, isElement);
        if (prefix != null && !EMPTY.equals(prefix)) {
            this.write(prefix);
            this.write(':');
        }
        this.write(localName);
    }
}

