/*
 * $Header: /home/pkriens/repo/aQute.lib/src/aQute/bean/Reflector.java,v 1.1 2006/05/30 02:45:22 pkriens Exp $
 * 
 * Copyright (c) The OSGi Alliance (2006). All Rights Reserved.
 * 
 * Implementation of certain elements of the OSGi Specification may be subject
 * to third party intellectual property rights, including without limitation,
 * patent rights (such a third party may or may not be a member of the OSGi
 * Alliance). The OSGi Alliance is not responsible and shall not be held
 * responsible in any manner for identifying or failing to identify any or all
 * such third party intellectual property rights.
 * 
 * This document and the information contained herein are provided on an "AS IS"
 * basis and THE OSGI ALLIANCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
 * HEREIN WILL NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE
 * OSGI ALLIANCE BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF
 * USE OF DATA, INTERRUPTION OF BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR
 * EXEMPLARY, INCIDENTIAL, PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN
 * CONNECTION WITH THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package aQute.bean;

import java.lang.reflect.*;

public class Reflector {
	Object	model;
	
	public Reflector(Object model) {
		this.model = model;
	}

	Object get( String path[], int start ) throws Exception {
		Object model = this.model;
		for (int i=0; i<path.length; i++ ) {
			model = get(model,path[i]);
		}
		return model;
	}
	
	void set( String path[], int start, Object target ) throws Exception {
		Object model = this.model;
		for (int i=0; i<path.length-1; i++ ) {
			model = get(model,path[i]);
		}
		set(model,path[path.length-1],target);
	}
	
	private void set(Object model, String simple, Object target) throws Exception {
		String name = "set" + Character.toUpperCase(simple.charAt(0)) + simple.substring(1);
		Method method = model.getClass().getMethod(name, new Class[] { target.getClass() });	
		method.invoke(model, new Object[] {target});
	}

	Object get(String simple) throws Exception {
		return get(model,simple);
	}
	
	Object get( Object object, String simple ) throws Exception {
		String name = "get" + Character.toUpperCase(simple.charAt(0)) + simple.substring(1);
		Method method = object.getClass().getMethod(name,null);
		return method.invoke(object, null);
	}
}
