package aQute.lib.filterbuilder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FF {
	final static String EQ = "=";
	final static String LT = "<";
	final static String GT = ">";
	final static String LTE = "<=";
	final static String GTE = ">=";
	final static String APPR = "~=";

	final static int AND = 1;
	final static int OR = 2;
	final static int NOT = 3;

	FF parent;
	int type;
	List members = new ArrayList();

	public FF(FF parent, int type) {
		this.parent = parent;
		this.type = type;
	}

	public FF op(String name, String op, String value) {
		if ( members.size() == 1 && type == NOT )
			throw new RuntimeException("A NOT has only one member");
		members.add("(" + name + op + F.escape(value) + ")");
		return this;
	}

	public FF eq(String name, String value) {
		return op(name, EQ, F.escape(value));
	}

	public FF eq(String name, int value) {
		return op(name, EQ, Integer.toString(value));
	}

	public FF lte(String name, String value) {
		return op(name, LTE, F.escape(value));
	}

	public FF lte(String name, int value) {
		return op(name, LTE, Integer.toString(value));
	}

	public FF gte(String name, String value) {
		return op(name, GTE, F.escape(value));
	}

	public FF gte(String name, int value) {
		return op(name, GTE, Integer.toString(value));
	}

	public FF appr(String name, String value) {
		return op(name, APPR, F.escape(value));
	}

	public FF appr(String name, int value) {
		return op(name, APPR, Integer.toString(value));
	}

	public FF and() {
		FF child = new FF(this, AND);
		members.add(child);
		return child;
	}

	public FF or() {
		FF child = new FF(this, OR);
		members.add(child);
		return child;
	}

	public FF not() {
		FF child = new FF(this, NOT);
		members.add(child);
		return child;
	}

	public FF dna() {
		assert (parent.type == AND);
		return parent;
	}

	public FF ro() {
		assert (parent.type == OR);
		return parent;
	}

	public FF ton() {
		assert (parent.type == NOT);
		return parent;
	}

	public FF close() {
		while (parent != null)
			parent.close();
		return this;
	}

	public String toString() {
		close();
		StringBuffer sb = new StringBuffer();
		print(sb);
		return sb.toString();
	}

	void print(StringBuffer sb) {
		sb.append("(");
		switch (type) {
		case AND:
			sb.append("&");
			break;
		case OR:
			sb.append("|");
			break;
		case NOT:
			sb.append("!");
			break;
		}
		for (Iterator i = members.iterator(); i.hasNext();) {
			Object o = i.next();
			if (o instanceof FF) {
				FF member = (FF) o;
				member.print(sb);
			} else {
				sb.append(o);
			}
		}
		sb.append(")");
	}
}
