import { UAParser } from 'ua-parser-js';
export const browserMeta = () => {
    const parser = new UAParser();
    const { name, version } = parser.getBrowser();
    const { name: osName, version: osVersion } = parser.getOS();
    const mobile = navigator.userAgent.includes('Mobi');
    const unknown = 'unknown';
    return {
        browser: {
            name: name !== null && name !== void 0 ? name : unknown,
            version: version !== null && version !== void 0 ? version : unknown,
            os: `${osName !== null && osName !== void 0 ? osName : unknown} ${osVersion !== null && osVersion !== void 0 ? osVersion : unknown}`,
            mobile,
        },
    };
};
//# sourceMappingURL=index.js.map