"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginUpdateTask = void 0;
const tslib_1 = require("tslib");
const fs = require("fs");
const path = require("path");
const useSpinner_1 = require("../utils/useSpinner");
const task_1 = require("./task");
const updateCiConfig = () => (0, useSpinner_1.useSpinner)('Updating CircleCI config', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const ciConfigPath = path.join(process.cwd(), '.circleci');
    if (!fs.existsSync(ciConfigPath)) {
        fs.mkdirSync(ciConfigPath);
    }
    const sourceFile = require.resolve('@grafana/toolkit/config/circleci/config.yml');
    const destFile = path.join(ciConfigPath, 'config.yml');
    fs.copyFileSync(sourceFile, destFile);
}));
const pluginUpdateRunner = () => updateCiConfig();
exports.pluginUpdateTask = new task_1.Task('Update Plugin', pluginUpdateRunner);
//# sourceMappingURL=plugin.update.js.map