/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Hashtable;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;

public class PKCS9Attribute
implements DerEncoder {
    private static final String RSADSI_str = "1.2.840.113549";
    private static final String PKCS_str = "1.2.840.113549.1";
    private static final String PKCS9_str = "1.2.840.113549.1.9";
    static final ObjectIdentifier[] PKCS9_OIDS = new ObjectIdentifier[15];
    public static final ObjectIdentifier EMAIL_ADDRESS_OID;
    public static final ObjectIdentifier UNSTRUCTURED_NAME_OID;
    public static final ObjectIdentifier CONTENT_TYPE_OID;
    public static final ObjectIdentifier MESSAGE_DIGEST_OID;
    public static final ObjectIdentifier SIGNING_TIME_OID;
    public static final ObjectIdentifier COUNTERSIGNATURE_OID;
    public static final ObjectIdentifier CHALLENGE_PASSWORD_OID;
    public static final ObjectIdentifier UNSTRUCTURED_ADDRESS_OID;
    public static final ObjectIdentifier EXTENDED_CERTIFICATE_ATTRIBUTES_OID;
    public static final ObjectIdentifier ISSUER_AND_SERIALNUMBER_OID;
    public static final ObjectIdentifier PASSWORD_CHECK_OID;
    public static final ObjectIdentifier PUBLIC_KEY_OID;
    public static final ObjectIdentifier SIGNING_DESCRIPTION_OID;
    public static final ObjectIdentifier EXTENSION_REQUEST_OID;
    public static final String EMAIL_ADDRESS_STR = "EmailAddress";
    public static final String UNSTRUCTURED_NAME_STR = "UnstructuredName";
    public static final String CONTENT_TYPE_STR = "ContentType";
    public static final String MESSAGE_DIGEST_STR = "MessageDigest";
    public static final String SIGNING_TIME_STR = "SigningTime";
    public static final String COUNTERSIGNATURE_STR = "Countersignature";
    public static final String CHALLENGE_PASSWORD_STR = "ChallengePassword";
    public static final String UNSTRUCTURED_ADDRESS_STR = "UnstructuredAddress";
    public static final String EXTENDED_CERTIFICATE_ATTRIBUTES_STR = "ExtendedCertificateAttributes";
    public static final String ISSUER_AND_SERIALNUMBER_STR = "IssuerAndSerialNumber";
    public static final String PASSWORD_CHECK_STR = "PasswordCheck";
    public static final String PUBLIC_KEY_STR = "PublicKey";
    public static final String SIGNING_DESCRIPTION_STR = "SigningDescription";
    public static final String EXTENSION_REQUEST_STR = "ExtensionRequest";
    private static final Hashtable<String, ObjectIdentifier> NAME_OID_TABLE;
    private static final Hashtable<ObjectIdentifier, String> OID_NAME_TABLE;
    private static final Byte[][] PKCS9_VALUE_TAGS;
    private static final Class<?>[] VALUE_CLASSES;
    private static final boolean[] SINGLE_VALUED;
    private int index;
    private Object value;

    public PKCS9Attribute(ObjectIdentifier oid, Object value) throws IllegalArgumentException {
        this.init(oid, value);
    }

    public PKCS9Attribute(String name, Object value) throws IllegalArgumentException {
        ObjectIdentifier oid = PKCS9Attribute.getOID(name);
        if (oid == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + name + " constructing PKCS9Attribute.");
        }
        this.init(oid, value);
    }

    private void init(ObjectIdentifier oid, Object value) throws IllegalArgumentException {
        this.index = PKCS9Attribute.indexOf(oid, PKCS9_OIDS, 1);
        if (this.index == -1) {
            throw new IllegalArgumentException("Unsupported OID " + oid + " constructing PKCS9Attribute.");
        }
        if (!VALUE_CLASSES[this.index].isInstance(value)) {
            throw new IllegalArgumentException("Wrong value class  for attribute " + oid + " constructing PKCS9Attribute; was " + value.getClass().toString() + ", should be " + VALUE_CLASSES[this.index].toString());
        }
        this.value = value;
    }

    public PKCS9Attribute(DerValue derVal) throws IOException {
        this.decode(derVal);
    }

    private void decode(DerValue derVal) throws IOException {
        DerInputStream derIn = new DerInputStream(derVal.toByteArray());
        DerValue[] val = derIn.getSequence(2);
        if (derIn.available() != 0) {
            throw new IOException("Excess data parsing PKCS9Attribute");
        }
        if (val.length != 2) {
            throw new IOException("PKCS9Attribute doesn't have two components");
        }
        ObjectIdentifier oid = val[0].getOID();
        this.index = PKCS9Attribute.indexOf(oid, PKCS9_OIDS, 1);
        if (this.index == -1) {
            throw new IOException("Invalid OID for PKCS9 attribute: " + oid);
        }
        DerValue[] elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        if (SINGLE_VALUED[this.index] && elems.length > 1) {
            this.throwSingleValuedException();
        }
        for (int i = 0; i < elems.length; ++i) {
            Byte tag = elems[i].tag;
            if (PKCS9Attribute.indexOf(tag, PKCS9_VALUE_TAGS[this.index], 0) != -1) continue;
            this.throwTagException(tag);
        }
        switch (this.index) {
            case 1: 
            case 2: 
            case 8: {
                String[] values = new String[elems.length];
                for (int i = 0; i < elems.length; ++i) {
                    values[i] = elems[i].getAsString();
                }
                this.value = values;
                break;
            }
            case 3: {
                this.value = elems[0].getOID();
                break;
            }
            case 4: {
                this.value = elems[0].getOctetString();
                break;
            }
            case 5: {
                this.value = new DerInputStream(elems[0].toByteArray()).getUTCTime();
                break;
            }
            case 6: {
                SignerInfo[] values = new SignerInfo[elems.length];
                for (int i = 0; i < elems.length; ++i) {
                    values[i] = new SignerInfo(elems[i].toDerInputStream());
                }
                this.value = values;
                break;
            }
            case 7: {
                this.value = elems[0].getAsString();
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumber attribute not supported.");
            }
            case 11: {
                throw new IOException("PKCS9 passwordCheck attribute not supported.");
            }
            case 12: {
                throw new IOException("PKCS9 PublicKey attribute not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 SigningDescription attribute not supported.");
            }
            case 14: {
                this.value = new CertificateExtensions(elems[0].toDerInputStream());
                break;
            }
            default: {
                throw new IOException("Invalid PKCS9 attribute index: " + this.index);
            }
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        try (DerOutputStream temp = new DerOutputStream();
             DerOutputStream temp2 = new DerOutputStream();
             DerOutputStream derOut = new DerOutputStream();){
            temp.putOID(this.getOID());
            switch (this.index) {
                case 1: 
                case 2: {
                    String[] values = (String[])this.value;
                    DerEncoder[] temps = new DerOutputStream[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        temps[i] = new DerOutputStream();
                        ((DerOutputStream)temps[i]).putIA5String(values[i]);
                    }
                    temp.putOrderedSetOf((byte)49, temps);
                    break;
                }
                case 3: {
                    temp2.putOID((ObjectIdentifier)this.value);
                    temp.write((byte)49, temp2.toByteArray());
                    break;
                }
                case 4: {
                    temp2.putOctetString((byte[])this.value);
                    temp.write((byte)49, temp2.toByteArray());
                    break;
                }
                case 5: {
                    temp2.putUTCTime((Date)this.value);
                    temp.write((byte)49, temp2.toByteArray());
                    break;
                }
                case 6: {
                    temp.putOrderedSetOf((byte)49, (DerEncoder[])this.value);
                    break;
                }
                case 7: {
                    temp2.putPrintableString((String)this.value);
                    temp.write((byte)49, temp2.toByteArray());
                    break;
                }
                case 8: {
                    String[] values = (String[])this.value;
                    DerEncoder[] temps = new DerOutputStream[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        temps[i] = new DerOutputStream();
                        ((DerOutputStream)temps[i]).putPrintableString(values[i]);
                    }
                    temp.putOrderedSetOf((byte)49, temps);
                    break;
                }
                case 9: {
                    throw new IOException("PKCS9 extended-certificate attribute not supported.");
                }
                case 10: {
                    throw new IOException("PKCS9 IssuerAndSerialNumber attribute not supported.");
                }
                case 11: {
                    throw new IOException("PKCS9 passwordCheck attribute not supported.");
                }
                case 12: {
                    throw new IOException("PKCS9 PublicKey attribute not supported.");
                }
                case 13: {
                    throw new IOException("PKCS9 SigningDescription attribute not supported.");
                }
                case 14: {
                    try {
                        ((CertificateExtensions)this.value).encode(temp2);
                        temp.write((byte)48, temp2.toByteArray());
                        break;
                    }
                    catch (CertificateException e) {
                        throw new IOException("PKCS9 extension attributes not encoded");
                    }
                }
                default: {
                    throw new IOException("Invalid PKCS9 attribute index: " + this.index);
                }
            }
            derOut.write((byte)48, temp.toByteArray());
            out.write(derOut.toByteArray());
        }
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSingleValued() {
        return SINGLE_VALUED[this.index];
    }

    public ObjectIdentifier getOID() {
        return PKCS9_OIDS[this.index];
    }

    public String getName() {
        return OID_NAME_TABLE.get(PKCS9_OIDS[this.index]);
    }

    public static ObjectIdentifier getOID(String name) {
        return NAME_OID_TABLE.get(name.toLowerCase());
    }

    public static String getName(ObjectIdentifier oid) {
        return OID_NAME_TABLE.get(oid);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("[");
        buf.append(OID_NAME_TABLE.get(PKCS9_OIDS[this.index]));
        buf.append(": ");
        if (SINGLE_VALUED[this.index]) {
            if (this.value instanceof byte[]) {
                PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
                String valuebits = pp.toHexString((byte[])this.value);
                buf.append(valuebits);
            } else {
                buf.append(this.value.toString());
            }
            buf.append("]");
            return buf.toString();
        }
        boolean first = true;
        Object[] values = (Object[])this.value;
        for (int j = 0; j < values.length; ++j) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(values[j].toString());
        }
        return buf.toString();
    }

    static int indexOf(Object obj, Object[] a, int start) {
        for (int i = start; i < a.length; ++i) {
            if (!obj.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    private void throwSingleValuedException() throws IOException {
        throw new IOException("Single-value attribute " + this.getOID() + " (" + this.getName() + ") has multiple values.");
    }

    private void throwTagException(Byte tag) throws IOException {
        Byte[] expectedTags = PKCS9_VALUE_TAGS[this.index];
        StringBuffer msg = new StringBuffer(100);
        msg.append("Value of attribute ");
        msg.append(this.getOID().toString());
        msg.append(" (");
        msg.append(this.getName());
        msg.append(") has wrong tag: ");
        msg.append(tag.toString());
        msg.append(".  Expected tags: ");
        msg.append(expectedTags[0].toString());
        for (int i = 1; i < expectedTags.length; ++i) {
            msg.append(", ");
            msg.append(expectedTags[i].toString());
        }
        msg.append(".");
        throw new IOException(msg.toString());
    }

    static {
        for (int i = 1; i < PKCS9_OIDS.length; ++i) {
            PKCS9Attribute.PKCS9_OIDS[i] = new ObjectIdentifier("1.2.840.113549.1.9." + i);
        }
        EMAIL_ADDRESS_OID = PKCS9_OIDS[1];
        UNSTRUCTURED_NAME_OID = PKCS9_OIDS[2];
        CONTENT_TYPE_OID = PKCS9_OIDS[3];
        MESSAGE_DIGEST_OID = PKCS9_OIDS[4];
        SIGNING_TIME_OID = PKCS9_OIDS[5];
        COUNTERSIGNATURE_OID = PKCS9_OIDS[6];
        CHALLENGE_PASSWORD_OID = PKCS9_OIDS[7];
        UNSTRUCTURED_ADDRESS_OID = PKCS9_OIDS[8];
        EXTENDED_CERTIFICATE_ATTRIBUTES_OID = PKCS9_OIDS[9];
        ISSUER_AND_SERIALNUMBER_OID = PKCS9_OIDS[10];
        PASSWORD_CHECK_OID = PKCS9_OIDS[11];
        PUBLIC_KEY_OID = PKCS9_OIDS[12];
        SIGNING_DESCRIPTION_OID = PKCS9_OIDS[13];
        EXTENSION_REQUEST_OID = PKCS9_OIDS[14];
        NAME_OID_TABLE = new Hashtable(28);
        NAME_OID_TABLE.put("emailaddress", PKCS9_OIDS[1]);
        NAME_OID_TABLE.put("unstructuredname", PKCS9_OIDS[2]);
        NAME_OID_TABLE.put("contenttype", PKCS9_OIDS[3]);
        NAME_OID_TABLE.put("messagedigest", PKCS9_OIDS[4]);
        NAME_OID_TABLE.put("signingtime", PKCS9_OIDS[5]);
        NAME_OID_TABLE.put("countersignature", PKCS9_OIDS[6]);
        NAME_OID_TABLE.put("challengepassword", PKCS9_OIDS[7]);
        NAME_OID_TABLE.put("unstructuredaddress", PKCS9_OIDS[8]);
        NAME_OID_TABLE.put("extendedcertificateattributes", PKCS9_OIDS[9]);
        NAME_OID_TABLE.put("issuerandserialNumber", PKCS9_OIDS[10]);
        NAME_OID_TABLE.put("passwordcheck", PKCS9_OIDS[11]);
        NAME_OID_TABLE.put("publickey", PKCS9_OIDS[12]);
        NAME_OID_TABLE.put("signingdescription", PKCS9_OIDS[13]);
        NAME_OID_TABLE.put("extensionrequest", PKCS9_OIDS[14]);
        OID_NAME_TABLE = new Hashtable(14);
        OID_NAME_TABLE.put(PKCS9_OIDS[1], EMAIL_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[2], UNSTRUCTURED_NAME_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[3], CONTENT_TYPE_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[4], MESSAGE_DIGEST_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[5], SIGNING_TIME_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[6], COUNTERSIGNATURE_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[7], CHALLENGE_PASSWORD_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[8], UNSTRUCTURED_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[9], EXTENDED_CERTIFICATE_ATTRIBUTES_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[10], ISSUER_AND_SERIALNUMBER_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[11], PASSWORD_CHECK_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[12], PUBLIC_KEY_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[13], SIGNING_DESCRIPTION_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[14], EXTENSION_REQUEST_STR);
        PKCS9_VALUE_TAGS = new Byte[][]{null, {(byte)22}, {(byte)22}, {(byte)6}, {(byte)4}, {(byte)23}, {(byte)48}, {(byte)19, (byte)20}, {(byte)19, (byte)20}, {(byte)49}, null, null, null, null, {(byte)48}};
        VALUE_CLASSES = new Class[15];
        PKCS9Attribute.VALUE_CLASSES[0] = null;
        PKCS9Attribute.VALUE_CLASSES[1] = String[].class;
        PKCS9Attribute.VALUE_CLASSES[2] = String[].class;
        PKCS9Attribute.VALUE_CLASSES[3] = ObjectIdentifier.class;
        PKCS9Attribute.VALUE_CLASSES[4] = byte[].class;
        PKCS9Attribute.VALUE_CLASSES[5] = Date.class;
        PKCS9Attribute.VALUE_CLASSES[6] = SignerInfo[].class;
        PKCS9Attribute.VALUE_CLASSES[7] = String.class;
        PKCS9Attribute.VALUE_CLASSES[8] = String[].class;
        PKCS9Attribute.VALUE_CLASSES[9] = null;
        PKCS9Attribute.VALUE_CLASSES[10] = null;
        PKCS9Attribute.VALUE_CLASSES[11] = null;
        PKCS9Attribute.VALUE_CLASSES[12] = null;
        PKCS9Attribute.VALUE_CLASSES[13] = null;
        PKCS9Attribute.VALUE_CLASSES[14] = CertificateExtensions.class;
        SINGLE_VALUED = new boolean[]{false, false, false, true, true, true, false, true, false, false, true, true, true, true, true};
    }
}

