; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -mattr=+aix-small-local-exec-tls < %s \
; RUN:      | FileCheck %s --check-prefix=SMALL-LOCAL-EXEC-SMALLCM64
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff --code-model=large \
; RUN:      -mattr=+aix-small-local-exec-tls < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL-LOCAL-EXEC-LARGECM64

; Test disassembly of object.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=+aix-small-local-exec-tls \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -xcoff-traceback-table=false \
; RUN:      --code-model=large -filetype=obj -o %t.o < %s
; RUN: llvm-objdump -D -r --symbol-description %t.o | FileCheck --check-prefix=DIS %s

@mySmallLocalExecTLSv1 = thread_local(localexec) global [8187 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS2 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS3 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS4 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS5 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLSv2 = thread_local(localexec) global [9000 x i32] zeroinitializer, align 4
declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull) #1

; All accesses use a "faster" local-exec sequence directly off the thread pointer.
define signext i32 @StoreArrays1() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: StoreArrays1:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, mySmallLocalExecTLSv1[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 1
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r5, 4
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, mySmallLocalExecTLSv1[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r4, mySmallLocalExecTLS2[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r5, 24(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 2
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, 320(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, mySmallLocalExecTLS3[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, 324(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, mySmallLocalExecTLS4[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 88
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r5, 328(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, mySmallLocalExecTLS5[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, 332(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: StoreArrays1:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLSv1[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 1
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r5, 4
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, mySmallLocalExecTLSv1[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r4, mySmallLocalExecTLS2[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r5, 24(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 2
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, 320(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLS3[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, 324(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLS4[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 88
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r5, 328(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLS5[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, 332(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLSv1)
  store i32 1, ptr %0, align 4
  %arrayidx1 = getelementptr inbounds [8187 x i32], ptr %0, i64 0, i64 6
  store i32 4, ptr %arrayidx1, align 4
  %1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS2)
  %arrayidx2 = getelementptr inbounds [4000 x i32], ptr %1, i64 0, i64 80
  store i32 2, ptr %arrayidx2, align 4
  %2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS3)
  %arrayidx3 = getelementptr inbounds [4000 x i32], ptr %2, i64 0, i64 81
  store i32 3, ptr %arrayidx3, align 4
  %3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS4)
  %arrayidx4 = getelementptr inbounds [4000 x i32], ptr %3, i64 0, i64 82
  store i32 4, ptr %arrayidx4, align 4
  %4 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS5)
  %arrayidx5 = getelementptr inbounds [4000 x i32], ptr %4, i64 0, i64 83
  store i32 88, ptr %arrayidx5, align 4
  %5 = load i32, ptr %0, align 4
  %6 = load i32, ptr %arrayidx1, align 4
  %7 = load i32, ptr %arrayidx2, align 4
  %8 = load i32, ptr %arrayidx3, align 4
  %9 = load i32, ptr %arrayidx4, align 4
  %add = add i32 %5, 88
  %add9 = add i32 %add, %6
  %add11 = add i32 %add9, %7
  %add13 = add i32 %add11, %8
  %add15 = add i32 %add13, %9
  ret i32 %add15
}

; Example of one access using the regular local-exec access from the TOC.
define signext i32 @StoreArrays2() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: StoreArrays2:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tprel) @mySmallLocalExecTLSv2
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 1
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r5, 4
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    add r3, r13, r3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, 0(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r4, mySmallLocalExecTLS2[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r5, 24(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 2
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, 320(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, mySmallLocalExecTLS3[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, 324(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r3, mySmallLocalExecTLS4[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    la r4, mySmallLocalExecTLS5[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r5, 328(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 88
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, 332(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: StoreArrays2:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addis r4, L..C0@u(r2)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 1
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r5, 4
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r4, L..C0@l(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    add r4, r13, r4
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, 0(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLS2[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r5, 24(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 2
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, 320(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLS3[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, 324(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r3, mySmallLocalExecTLS4[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    la r4, mySmallLocalExecTLS5[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r5, 328(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 88
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, 332(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLSv2)
  store i32 1, ptr %0, align 4
  %arrayidx1 = getelementptr inbounds [9000 x i32], ptr %0, i64 0, i64 6
  store i32 4, ptr %arrayidx1, align 4
  %1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS2)
  %arrayidx2 = getelementptr inbounds [4000 x i32], ptr %1, i64 0, i64 80
  store i32 2, ptr %arrayidx2, align 4
  %2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS3)
  %arrayidx3 = getelementptr inbounds [4000 x i32], ptr %2, i64 0, i64 81
  store i32 3, ptr %arrayidx3, align 4
  %3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS4)
  %arrayidx4 = getelementptr inbounds [4000 x i32], ptr %3, i64 0, i64 82
  store i32 4, ptr %arrayidx4, align 4
  %4 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS5)
  %arrayidx5 = getelementptr inbounds [4000 x i32], ptr %4, i64 0, i64 83
  store i32 88, ptr %arrayidx5, align 4
  %5 = load i32, ptr %0, align 4
  %6 = load i32, ptr %arrayidx1, align 4
  %7 = load i32, ptr %arrayidx2, align 4
  %8 = load i32, ptr %arrayidx3, align 4
  %9 = load i32, ptr %arrayidx4, align 4
  %add = add i32 %5, 88
  %add9 = add i32 %add, %6
  %add11 = add i32 %add9, %7
  %add13 = add i32 %add11, %8
  %add15 = add i32 %add13, %9
  ret i32 %add15
}

; DIS:      {{.*}}aix-small-local-exec-tls-largeaccess.ll.tmp.o:	file format aix5coff64-rs6000
; DIS:      Disassembly of section .text:
; DIS:      0000000000000000 (idx: 3) .StoreArrays1:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 15) mySmallLocalExecTLSv1[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 1
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 5, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 0(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 15) mySmallLocalExecTLSv1[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 4, 13, 32748
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 17) mySmallLocalExecTLS2[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 5, 24(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 2
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 320(4)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, -16788
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 19) mySmallLocalExecTLS3[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 324(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, -788
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 21) mySmallLocalExecTLS4[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 88
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 5, 328(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, 15212
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 23) mySmallLocalExecTLS5[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 332(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 102
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      0000000000000050 (idx: 5) .StoreArrays2:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 4, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: 13) mySmallLocalExecTLSv2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 1
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 5, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 4, 0(4)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: 13) mySmallLocalExecTLSv2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 4, 13, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 0(4)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, 32748
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 17) mySmallLocalExecTLS2[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 5, 24(4)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 2
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 320(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, -16788
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 19) mySmallLocalExecTLS3[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 324(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 3, 13, -788
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 21) mySmallLocalExecTLS4[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 4, 13, 15212
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: 23) mySmallLocalExecTLS5[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 5, 328(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 88
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 332(4)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 102
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      Disassembly of section .data:
; DIS:      00000000000000a0 (idx: 7) StoreArrays1[DS]:
; DIS-NEXT:       a0: 00 00 00 00
; DIS-NEXT: 00000000000000a0:  R_POS	(idx: 3) .StoreArrays1
; DIS-NEXT:       a4: 00 00 00 00
; DIS-NEXT:       a8: 00 00 00 00
; DIS-NEXT: 00000000000000a8:  R_POS        (idx: 11) TOC[TC0]
; DIS-NEXT:       ac: 00 00 00 d0

; DIS:      00000000000000b8 (idx: 9) StoreArrays2[DS]:
; DIS-NEXT:       b8: 00 00 00 00
; DIS-NEXT: 00000000000000b8:  R_POS	(idx: 5) .StoreArrays2
; DIS-NEXT:       bc: 00 00 00 50
; DIS-NEXT:       c0: 00 00 00 00
; DIS-NEXT: 00000000000000c0:  R_POS        (idx: 11) TOC[TC0]
; DIS-NEXT:       c4: 00 00 00 d0

; DIS:      00000000000000d0 (idx: 13) mySmallLocalExecTLSv2[TE]:
; DIS-NEXT:       d0: 00 00 00 00
; DIS-NEXT: 00000000000000d0:  R_TLS_LE     (idx: 25) mySmallLocalExecTLSv2[TL]
; DIS-NEXT:       d4: 00 01 79 ec
