/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PatchedAccessPolicy type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchedAccessPolicy{}

// PatchedAccessPolicy Serializer for AccessPolicy.
type PatchedAccessPolicy struct {
	// List of callables that define the new permissions to be created for new objects.This is deprecated. Use `creation_hooks` instead.
	PermissionsAssignment []map[string]interface{} `json:"permissions_assignment,omitempty"`
	// List of callables that may associate user roles for new objects.
	CreationHooks []map[string]interface{} `json:"creation_hooks,omitempty"`
	// List of policy statements defining the policy.
	Statements []map[string]interface{} `json:"statements,omitempty"`
	// A callable for performing queryset scoping. See plugin documentation for valid callables. Set to blank to turn off queryset scoping.
	QuerysetScoping map[string]interface{} `json:"queryset_scoping,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatchedAccessPolicy PatchedAccessPolicy

// NewPatchedAccessPolicy instantiates a new PatchedAccessPolicy object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchedAccessPolicy() *PatchedAccessPolicy {
	this := PatchedAccessPolicy{}
	return &this
}

// NewPatchedAccessPolicyWithDefaults instantiates a new PatchedAccessPolicy object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchedAccessPolicyWithDefaults() *PatchedAccessPolicy {
	this := PatchedAccessPolicy{}
	return &this
}

// GetPermissionsAssignment returns the PermissionsAssignment field value if set, zero value otherwise.
func (o *PatchedAccessPolicy) GetPermissionsAssignment() []map[string]interface{} {
	if o == nil || IsNil(o.PermissionsAssignment) {
		var ret []map[string]interface{}
		return ret
	}
	return o.PermissionsAssignment
}

// GetPermissionsAssignmentOk returns a tuple with the PermissionsAssignment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedAccessPolicy) GetPermissionsAssignmentOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.PermissionsAssignment) {
		return nil, false
	}
	return o.PermissionsAssignment, true
}

// HasPermissionsAssignment returns a boolean if a field has been set.
func (o *PatchedAccessPolicy) HasPermissionsAssignment() bool {
	if o != nil && !IsNil(o.PermissionsAssignment) {
		return true
	}

	return false
}

// SetPermissionsAssignment gets a reference to the given []map[string]interface{} and assigns it to the PermissionsAssignment field.
func (o *PatchedAccessPolicy) SetPermissionsAssignment(v []map[string]interface{}) {
	o.PermissionsAssignment = v
}

// GetCreationHooks returns the CreationHooks field value if set, zero value otherwise.
func (o *PatchedAccessPolicy) GetCreationHooks() []map[string]interface{} {
	if o == nil || IsNil(o.CreationHooks) {
		var ret []map[string]interface{}
		return ret
	}
	return o.CreationHooks
}

// GetCreationHooksOk returns a tuple with the CreationHooks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedAccessPolicy) GetCreationHooksOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.CreationHooks) {
		return nil, false
	}
	return o.CreationHooks, true
}

// HasCreationHooks returns a boolean if a field has been set.
func (o *PatchedAccessPolicy) HasCreationHooks() bool {
	if o != nil && !IsNil(o.CreationHooks) {
		return true
	}

	return false
}

// SetCreationHooks gets a reference to the given []map[string]interface{} and assigns it to the CreationHooks field.
func (o *PatchedAccessPolicy) SetCreationHooks(v []map[string]interface{}) {
	o.CreationHooks = v
}

// GetStatements returns the Statements field value if set, zero value otherwise.
func (o *PatchedAccessPolicy) GetStatements() []map[string]interface{} {
	if o == nil || IsNil(o.Statements) {
		var ret []map[string]interface{}
		return ret
	}
	return o.Statements
}

// GetStatementsOk returns a tuple with the Statements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedAccessPolicy) GetStatementsOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.Statements) {
		return nil, false
	}
	return o.Statements, true
}

// HasStatements returns a boolean if a field has been set.
func (o *PatchedAccessPolicy) HasStatements() bool {
	if o != nil && !IsNil(o.Statements) {
		return true
	}

	return false
}

// SetStatements gets a reference to the given []map[string]interface{} and assigns it to the Statements field.
func (o *PatchedAccessPolicy) SetStatements(v []map[string]interface{}) {
	o.Statements = v
}

// GetQuerysetScoping returns the QuerysetScoping field value if set, zero value otherwise.
func (o *PatchedAccessPolicy) GetQuerysetScoping() map[string]interface{} {
	if o == nil || IsNil(o.QuerysetScoping) {
		var ret map[string]interface{}
		return ret
	}
	return o.QuerysetScoping
}

// GetQuerysetScopingOk returns a tuple with the QuerysetScoping field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatchedAccessPolicy) GetQuerysetScopingOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.QuerysetScoping) {
		return map[string]interface{}{}, false
	}
	return o.QuerysetScoping, true
}

// HasQuerysetScoping returns a boolean if a field has been set.
func (o *PatchedAccessPolicy) HasQuerysetScoping() bool {
	if o != nil && !IsNil(o.QuerysetScoping) {
		return true
	}

	return false
}

// SetQuerysetScoping gets a reference to the given map[string]interface{} and assigns it to the QuerysetScoping field.
func (o *PatchedAccessPolicy) SetQuerysetScoping(v map[string]interface{}) {
	o.QuerysetScoping = v
}

func (o PatchedAccessPolicy) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchedAccessPolicy) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PermissionsAssignment) {
		toSerialize["permissions_assignment"] = o.PermissionsAssignment
	}
	if !IsNil(o.CreationHooks) {
		toSerialize["creation_hooks"] = o.CreationHooks
	}
	if !IsNil(o.Statements) {
		toSerialize["statements"] = o.Statements
	}
	if !IsNil(o.QuerysetScoping) {
		toSerialize["queryset_scoping"] = o.QuerysetScoping
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchedAccessPolicy) UnmarshalJSON(bytes []byte) (err error) {
	varPatchedAccessPolicy := _PatchedAccessPolicy{}

	if err = json.Unmarshal(bytes, &varPatchedAccessPolicy); err == nil {
		*o = PatchedAccessPolicy(varPatchedAccessPolicy)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "permissions_assignment")
		delete(additionalProperties, "creation_hooks")
		delete(additionalProperties, "statements")
		delete(additionalProperties, "queryset_scoping")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchedAccessPolicy struct {
	value *PatchedAccessPolicy
	isSet bool
}

func (v NullablePatchedAccessPolicy) Get() *PatchedAccessPolicy {
	return v.value
}

func (v *NullablePatchedAccessPolicy) Set(val *PatchedAccessPolicy) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchedAccessPolicy) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchedAccessPolicy) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchedAccessPolicy(val *PatchedAccessPolicy) *NullablePatchedAccessPolicy {
	return &NullablePatchedAccessPolicy{value: val, isSet: true}
}

func (v NullablePatchedAccessPolicy) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchedAccessPolicy) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


