// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/pkg/errors"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for AzureUploadOptionsHyperVGeneration.
const (
	AzureUploadOptionsHyperVGenerationV1 AzureUploadOptionsHyperVGeneration = "V1"

	AzureUploadOptionsHyperVGenerationV2 AzureUploadOptionsHyperVGeneration = "V2"
)

// Defines values for BlueprintCustomizationsPartitioningMode.
const (
	BlueprintCustomizationsPartitioningModeAutoLvm BlueprintCustomizationsPartitioningMode = "auto-lvm"

	BlueprintCustomizationsPartitioningModeLvm BlueprintCustomizationsPartitioningMode = "lvm"

	BlueprintCustomizationsPartitioningModeRaw BlueprintCustomizationsPartitioningMode = "raw"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for CustomizationsPartitioningMode.
const (
	CustomizationsPartitioningModeAutoLvm CustomizationsPartitioningMode = "auto-lvm"

	CustomizationsPartitioningModeLvm CustomizationsPartitioningMode = "lvm"

	CustomizationsPartitioningModeRaw CustomizationsPartitioningMode = "raw"
)

// Defines values for ImageSBOMPipelinePurpose.
const (
	ImageSBOMPipelinePurposeBuildroot ImageSBOMPipelinePurpose = "buildroot"

	ImageSBOMPipelinePurposeImage ImageSBOMPipelinePurpose = "image"
)

// Defines values for ImageSBOMSbomType.
const (
	ImageSBOMSbomTypeSpdx ImageSBOMSbomType = "spdx"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureEap7Rhui ImageTypes = "azure-eap7-rhui"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesAzureSapRhui ImageTypes = "azure-sap-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotBootableContainer ImageTypes = "iot-bootable-container"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesIotSimplifiedInstaller ImageTypes = "iot-simplified-installer"

	ImageTypesLiveInstaller ImageTypes = "live-installer"

	ImageTypesMinimalRaw ImageTypes = "minimal-raw"

	ImageTypesOci ImageTypes = "oci"

	ImageTypesVsphere ImageTypes = "vsphere"

	ImageTypesVsphereOva ImageTypes = "vsphere-ova"

	ImageTypesWsl ImageTypes = "wsl"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"

	UploadTypesLocal UploadTypes = "local"

	UploadTypesOciObjectstorage UploadTypes = "oci.objectstorage"

	UploadTypesPulpOstree UploadTypes = "pulp.ostree"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Choose the VM Image HyperV generation, different features on Azure are available
	// depending on the HyperV generation.
	HyperVGeneration *AzureUploadOptionsHyperVGeneration `json:"hyper_v_generation,omitempty"`

	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// Choose the VM Image HyperV generation, different features on Azure are available
// depending on the HyperV generation.
type AzureUploadOptionsHyperVGeneration string

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// Blueprint defines model for Blueprint.
type Blueprint struct {
	// Container images to embed into the final artfact
	Containers     *[]Container             `json:"containers,omitempty"`
	Customizations *BlueprintCustomizations `json:"customizations,omitempty"`
	Description    *string                  `json:"description,omitempty"`

	// The distribution to use for the compose. If left empty the host
	// distro will be used.
	Distro *string `json:"distro,omitempty"`

	// Package groups to be installed
	Groups *[]PackageGroup `json:"groups,omitempty"`

	// An alias for packages, retained for backwards compatability
	Modules *[]Package `json:"modules,omitempty"`
	Name    string     `json:"name"`

	// Packages to be installed
	Packages *[]Package `json:"packages,omitempty"`

	// A semver version number
	Version *string `json:"version,omitempty"`
}

// BlueprintCustomizations defines model for BlueprintCustomizations.
type BlueprintCustomizations struct {
	Cacerts *CACertsCustomization `json:"cacerts,omitempty"`

	// Directories to create in the final artifact
	Directories *[]Directory `json:"directories,omitempty"`

	// FIDO device onboard configuration
	Fdo *FDO `json:"fdo,omitempty"`

	// Files to create in the final artifact
	Files *[]BlueprintFile `json:"files,omitempty"`

	// List of filesystem mountpoints to create
	Filesystem *[]BlueprintFilesystem `json:"filesystem,omitempty"`

	// Enable FIPS mode
	Fips *bool `json:"fips,omitempty"`

	// Firewalld configuration
	Firewall *BlueprintFirewall `json:"firewall,omitempty"`

	// List of groups to create
	Group *[]Group `json:"group,omitempty"`

	// Configures the hostname
	Hostname *string `json:"hostname,omitempty"`

	// Ignition configuration
	Ignition *Ignition `json:"ignition,omitempty"`

	// Name of the installation device, currently only useful for the edge-simplified-installer type
	InstallationDevice *string    `json:"installation_device,omitempty"`
	Installer          *Installer `json:"installer,omitempty"`
	Kernel             *Kernel    `json:"kernel,omitempty"`

	// Locale configuration
	Locale   *Locale            `json:"locale,omitempty"`
	Openscap *BlueprintOpenSCAP `json:"openscap,omitempty"`

	// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
	// there are one or more mountpoints in which case it will use LVM. 'lvm' always
	// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
	// even when there are one or more mountpoints.
	PartitioningMode *BlueprintCustomizationsPartitioningMode `json:"partitioning_mode,omitempty"`

	// Repositories to write to /etc/yum.repos.d/ in the final image. Note
	// that these are not used at build time.
	Repositories *[]BlueprintRepository `json:"repositories,omitempty"`
	Rhsm         *RHSMCustomization     `json:"rhsm,omitempty"`
	Rpm          *RPMCustomization      `json:"rpm,omitempty"`
	Services     *Services              `json:"services,omitempty"`

	// List of ssh keys
	Sshkey *[]SSHKey `json:"sshkey,omitempty"`

	// Timezone configuration
	Timezone *Timezone `json:"timezone,omitempty"`

	// List of users to create
	User *[]BlueprintUser `json:"user,omitempty"`
}

// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
// there are one or more mountpoints in which case it will use LVM. 'lvm' always
// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
// even when there are one or more mountpoints.
type BlueprintCustomizationsPartitioningMode string

// A custom file to create in the final artifact.
type BlueprintFile struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// BlueprintFilesystem defines model for BlueprintFilesystem.
type BlueprintFilesystem struct {
	// size of the filesystem in bytes
	Minsize    uint64 `json:"minsize"`
	Mountpoint string `json:"mountpoint"`
}

// Firewalld configuration
type BlueprintFirewall struct {
	// List of ports (or port ranges) and protocols to open
	Ports *[]string `json:"ports,omitempty"`

	// Firewalld services to enable or disable
	Services *FirewallServices `json:"services,omitempty"`
	Zones    *[]FirewallZones  `json:"zones,omitempty"`
}

// BlueprintOpenSCAP defines model for BlueprintOpenSCAP.
type BlueprintOpenSCAP struct {
	Datastream    *string                `json:"datastream,omitempty"`
	JsonTailoring *OpenSCAPJSONTailoring `json:"json_tailoring,omitempty"`

	// Puts a specified policy ID in the RHSM facts, so that any instances registered to
	// insights will be automatically connected to the compliance policy in the console.
	PolicyId  *string            `json:"policy_id,omitempty"`
	ProfileId string             `json:"profile_id"`
	Tailoring *OpenSCAPTailoring `json:"tailoring,omitempty"`
}

// BlueprintRepository defines model for BlueprintRepository.
type BlueprintRepository struct {
	Baseurls   *[]string `json:"baseurls,omitempty"`
	Enabled    *bool     `json:"enabled,omitempty"`
	Filename   *string   `json:"filename,omitempty"`
	Gpgcheck   *bool     `json:"gpgcheck,omitempty"`
	Gpgkeys    *[]string `json:"gpgkeys,omitempty"`
	Id         string    `json:"id"`
	Metalink   *string   `json:"metalink,omitempty"`
	Mirrorlist *string   `json:"mirrorlist,omitempty"`

	// Disables modularity filtering for this repository.
	ModuleHotfixes *bool   `json:"module_hotfixes,omitempty"`
	Name           *string `json:"name,omitempty"`
	Priority       *int    `json:"priority,omitempty"`
	RepoGpgcheck   *bool   `json:"repo_gpgcheck,omitempty"`
	Sslverify      *bool   `json:"sslverify,omitempty"`
}

// BlueprintUser defines model for BlueprintUser.
type BlueprintUser struct {
	Description *string `json:"description,omitempty"`

	// Group id to use instead of the default
	Gid *int `json:"gid,omitempty"`

	// A list of additional groups to add the user to
	Groups *[]string `json:"groups,omitempty"`

	// The user's home directory
	Home *string `json:"home,omitempty"`

	// ssh public key
	Key  *string `json:"key,omitempty"`
	Name string  `json:"name"`

	// If the password starts with $6$, $5$, or $2b$ it will be stored as
	// an encrypted password. Otherwise it will be treated as a plain text
	// password.
	Password *string `json:"password,omitempty"`

	// Login shell to use
	Shell *string `json:"shell,omitempty"`

	// User id to use instead of the default
	Uid *int `json:"uid,omitempty"`
}

// CACertsCustomization defines model for CACertsCustomization.
type CACertsCustomization struct {
	PemCerts []string `json:"pem_certs"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeList defines model for ComposeList.
type ComposeList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []ComposeStatus `json:"items"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Blueprint      *Blueprint      `json:"blueprint,omitempty"`
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeSBOMs defines model for ComposeSBOMs.
type ComposeSBOMs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// The SBOM documents for each image built in the compose.
	Items [][]ImageSBOM `json:"items"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name *string `json:"name,omitempty"`

	// Reference to the container to embed
	Source string `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// CustomRepository defines model for CustomRepository.
type CustomRepository struct {
	Baseurl        *[]string `json:"baseurl,omitempty"`
	CheckGpg       *bool     `json:"check_gpg,omitempty"`
	CheckRepoGpg   *bool     `json:"check_repo_gpg,omitempty"`
	Enabled        *bool     `json:"enabled,omitempty"`
	Filename       *string   `json:"filename,omitempty"`
	Gpgkey         *[]string `json:"gpgkey,omitempty"`
	Id             string    `json:"id"`
	Metalink       *string   `json:"metalink,omitempty"`
	Mirrorlist     *string   `json:"mirrorlist,omitempty"`
	ModuleHotfixes *bool     `json:"module_hotfixes,omitempty"`
	Name           *string   `json:"name,omitempty"`
	Priority       *int      `json:"priority,omitempty"`
	SslVerify      *bool     `json:"ssl_verify,omitempty"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Cacerts    *CACertsCustomization `json:"cacerts,omitempty"`
	Containers *[]Container          `json:"containers,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will be used to depsolve and retrieve packages. Additionally,
	// these packages will be saved and imported to the `/etc/yum.repos.d/` directory
	// on the image
	CustomRepositories *[]CustomRepository `json:"custom_repositories,omitempty"`
	Directories        *[]Directory        `json:"directories,omitempty"`

	// FIDO device onboard configuration
	Fdo        *FDO          `json:"fdo,omitempty"`
	Files      *[]File       `json:"files,omitempty"`
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`

	// System FIPS mode setup
	Fips *FIPS `json:"fips,omitempty"`

	// Firewalld configuration
	Firewall *FirewallCustomization `json:"firewall,omitempty"`

	// List of groups to create
	Groups *[]Group `json:"groups,omitempty"`

	// Configures the hostname
	Hostname *string `json:"hostname,omitempty"`

	// Ignition configuration
	Ignition *Ignition `json:"ignition,omitempty"`

	// Name of the installation device, currently only useful for the edge-simplified-installer type
	InstallationDevice *string    `json:"installation_device,omitempty"`
	Installer          *Installer `json:"installer,omitempty"`
	Kernel             *Kernel    `json:"kernel,omitempty"`

	// Locale configuration
	Locale   *Locale   `json:"locale,omitempty"`
	Openscap *OpenSCAP `json:"openscap,omitempty"`
	Packages *[]string `json:"packages,omitempty"`

	// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
	// there are one or more mountpoints in which case it will use LVM. 'lvm' always
	// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
	// even when there are one or more mountpoints.
	PartitioningMode *CustomizationsPartitioningMode `json:"partitioning_mode,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository      `json:"payload_repositories,omitempty"`
	Rhsm                *RHSMCustomization `json:"rhsm,omitempty"`
	Rpm                 *RPMCustomization  `json:"rpm,omitempty"`
	Services            *Services          `json:"services,omitempty"`
	Subscription        *Subscription      `json:"subscription,omitempty"`

	// Timezone configuration
	Timezone *Timezone `json:"timezone,omitempty"`
	Users    *[]User   `json:"users,omitempty"`
}

// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
// there are one or more mountpoints in which case it will use LVM. 'lvm' always
// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
// even when there are one or more mountpoints.
type CustomizationsPartitioningMode string

// DNFPluginConfig defines model for DNFPluginConfig.
type DNFPluginConfig struct {
	Enabled *bool `json:"enabled,omitempty"`
}

// DepsolveRequest defines model for DepsolveRequest.
type DepsolveRequest struct {
	Architecture string        `json:"architecture"`
	Blueprint    Blueprint     `json:"blueprint"`
	Distribution string        `json:"distribution"`
	Repositories *[]Repository `json:"repositories,omitempty"`
}

// DepsolveResponse defines model for DepsolveResponse.
type DepsolveResponse struct {
	// Package list including NEVRA
	Packages []PackageMetadata `json:"packages"`
}

// A custom directory to create in the final artifact.
type Directory struct {
	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the directory as a group name or a gid
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the directory in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the directory
	Path string `json:"path"`

	// Owner of the directory as a user name or a uid
	User *interface{} `json:"user,omitempty"`
}

// DistributionList defines model for DistributionList.
type DistributionList struct {
	// Distribution name
	Map *DistributionList_Map `json:"map,omitempty"`
}

// Distribution name
type DistributionList_Map struct {
	AdditionalProperties map[string]interface{} `json:"-"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// FIDO device onboard configuration
type FDO struct {
	DiMfgStringTypeMacIface *string `json:"di_mfg_string_type_mac_iface,omitempty"`
	DiunPubKeyHash          *string `json:"diun_pub_key_hash,omitempty"`
	DiunPubKeyInsecure      *string `json:"diun_pub_key_insecure,omitempty"`
	DiunPubKeyRootCerts     *string `json:"diun_pub_key_root_certs,omitempty"`
	ManufacturingServerUrl  *string `json:"manufacturing_server_url,omitempty"`
}

// System FIPS mode setup
type FIPS struct {
	// Enables the system FIPS mode
	Enabled *bool `json:"enabled,omitempty"`
}

// A custom file to create in the final artifact.
type File struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	// size of the filesystem in bytes
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// Firewalld configuration
type FirewallCustomization struct {
	// List of ports (or port ranges) and protocols to open
	Ports *[]string `json:"ports,omitempty"`

	// Firewalld services to enable or disable
	Services *FirewallServices `json:"services,omitempty"`
}

// Firewalld services to enable or disable
type FirewallServices struct {
	// List of services to disable
	Disabled *[]string `json:"disabled,omitempty"`

	// List of services to enable
	Enabled *[]string `json:"enabled,omitempty"`
}

// Bind a list of network sources to a zone to restrict traffic from
// those sources based on the settings of the zone.
type FirewallZones struct {
	// name of the zone, if left empty the sources will apply to
	// the default zone.
	Name *string `json:"name,omitempty"`

	// List of sources for the zone
	Sources *[]string `json:"sources,omitempty"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// Group defines model for Group.
type Group struct {
	// Group id of the group to create (optional)
	Gid *int `json:"gid,omitempty"`

	// Name of the group to create
	Name string `json:"name"`
}

// Ignition configuration
type Ignition struct {
	Embedded  *IgnitionEmbedded  `json:"embedded,omitempty"`
	Firstboot *IgnitionFirstboot `json:"firstboot,omitempty"`
}

// IgnitionEmbedded defines model for IgnitionEmbedded.
type IgnitionEmbedded struct {
	Config string `json:"config"`
}

// IgnitionFirstboot defines model for IgnitionFirstboot.
type IgnitionFirstboot struct {
	// Provisioning URL
	Url string `json:"url"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// Size of image, in bytes. When set to 0 the image size is a minimum
	// defined by the image type.
	Size *uint64 `json:"size,omitempty"`

	// Options for a given upload destination.
	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`

	// The type and options for multiple upload targets. Each item defines
	// a separate upload destination with its own options. Multiple
	// different targets as well as multiple targets of the same kind are
	// supported.
	UploadTargets *[]UploadTarget `json:"upload_targets,omitempty"`
}

// ImageSBOM defines model for ImageSBOM.
type ImageSBOM struct {
	// The name of the osbuild pipeline which has the packages described
	// in the SBOM installed.
	PipelineName string `json:"pipeline_name"`

	// The purpose of the pipeline. The `buildroot` pipeline was used for
	// the build environment dueing the image build. The `image` pipeline
	// represents the actual content of the image. Due to the nature of
	// some image types, there may be multiple pipelines of the same
	// purpose.
	PipelinePurpose ImageSBOMPipelinePurpose `json:"pipeline_purpose"`

	// The SBOM document in the 'sbom_type' format.
	Sbom interface{} `json:"sbom"`

	// The type of the SBOM document. Currently only SPDX is supported.
	SbomType ImageSBOMSbomType `json:"sbom_type"`
}

// The purpose of the pipeline. The `buildroot` pipeline was used for
// the build environment dueing the image build. The `image` pipeline
// represents the actual content of the image. Due to the nature of
// some image types, there may be multiple pipelines of the same
// purpose.
type ImageSBOMPipelinePurpose string

// The type of the SBOM document. Currently only SPDX is supported.
type ImageSBOMSbomType string

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error          *ComposeStatusError `json:"error,omitempty"`
	Status         ImageStatusValue    `json:"status"`
	UploadStatus   *UploadStatus       `json:"upload_status,omitempty"`
	UploadStatuses *[]UploadStatus     `json:"upload_statuses,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// ImportKeys defines model for ImportKeys.
type ImportKeys struct {
	Files *[]string `json:"files,omitempty"`
}

// Installer defines model for Installer.
type Installer struct {
	SudoNopasswd *[]string `json:"sudo-nopasswd,omitempty"`
	Unattended   *bool     `json:"unattended,omitempty"`
}

// Kernel defines model for Kernel.
type Kernel struct {
	// Appends arguments to the bootloader kernel command line
	Append *string `json:"append,omitempty"`

	// Name of the kernel to use
	Name *string `json:"name,omitempty"`
}

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// LocalUploadOptions defines model for LocalUploadOptions.
type LocalUploadOptions map[string]interface{}

// LocalUploadStatus defines model for LocalUploadStatus.
type LocalUploadStatus struct {
	ArtifactPath string `json:"artifact_path"`
}

// Locale configuration
type Locale struct {
	// Sets the keyboard layout
	Keyboard *string `json:"keyboard,omitempty"`

	// List of locales to be installed, the first one becomes primary, subsequent ones are secondary
	Languages *[]string `json:"languages,omitempty"`
}

// OCIUploadOptions defines model for OCIUploadOptions.
type OCIUploadOptions map[string]interface{}

// OCIUploadStatus defines model for OCIUploadStatus.
type OCIUploadStatus struct {
	Url string `json:"url"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// OpenSCAP defines model for OpenSCAP.
type OpenSCAP struct {
	JsonTailoring *OpenSCAPJSONTailoring `json:"json_tailoring,omitempty"`

	// Puts a specified policy ID in the RHSM facts, so that any instances registered to
	// insights will be automatically connected to the compliance policy in the console.
	PolicyId  *string            `json:"policy_id,omitempty"`
	ProfileId string             `json:"profile_id"`
	Tailoring *OpenSCAPTailoring `json:"tailoring,omitempty"`
}

// OpenSCAPJSONTailoring defines model for OpenSCAPJSONTailoring.
type OpenSCAPJSONTailoring struct {
	Filepath  string `json:"filepath"`
	ProfileId string `json:"profile_id"`
}

// OpenSCAPTailoring defines model for OpenSCAPTailoring.
type OpenSCAPTailoring struct {
	Selected   *[]string `json:"selected,omitempty"`
	Unselected *[]string `json:"unselected,omitempty"`
}

// Package defines model for Package.
type Package struct {
	// Name of the package to install. File globbing is supported,
	// eg. 'openssh-*'
	Name string `json:"name"`

	// Optional version of the package to install. If left blank the
	// latest available version will be used. Wildcards are supported
	// eg. '4.11.*'
	Version *string `json:"version,omitempty"`
}

// PackageDetails defines model for PackageDetails.
type PackageDetails struct {
	Arch        string  `json:"arch"`
	Buildtime   *string `json:"buildtime,omitempty"`
	Description *string `json:"description,omitempty"`
	Epoch       *string `json:"epoch,omitempty"`
	License     *string `json:"license,omitempty"`
	Name        string  `json:"name"`
	Release     string  `json:"release"`
	Summary     *string `json:"summary,omitempty"`
	Url         *string `json:"url,omitempty"`
	Version     string  `json:"version"`
}

// PackageGroup defines model for PackageGroup.
type PackageGroup struct {
	// Package group name
	Name string `json:"name"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch string `json:"arch"`

	// Optional package checksum using ALGO:HASH form
	Checksum  *string `json:"checksum,omitempty"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    *string `json:"sigmd5,omitempty"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// PulpOSTreeUploadOptions defines model for PulpOSTreeUploadOptions.
type PulpOSTreeUploadOptions struct {
	// Basepath for distributing the repository
	Basepath string `json:"basepath"`

	// Repository to import the ostree commit to
	Repository    *string `json:"repository,omitempty"`
	ServerAddress *string `json:"server_address,omitempty"`
}

// PulpOSTreeUploadStatus defines model for PulpOSTreeUploadStatus.
type PulpOSTreeUploadStatus struct {
	RepoUrl string `json:"repo_url"`
}

// RHSMConfig defines model for RHSMConfig.
type RHSMConfig struct {
	DnfPlugins          *SubManDNFPluginsConfig `json:"dnf_plugins,omitempty"`
	SubscriptionManager *SubManConfig           `json:"subscription_manager,omitempty"`
}

// RHSMCustomization defines model for RHSMCustomization.
type RHSMCustomization struct {
	Config *RHSMConfig `json:"config,omitempty"`
}

// RPMCustomization defines model for RPMCustomization.
type RPMCustomization struct {
	ImportKeys *ImportKeys `json:"import_keys,omitempty"`
}

// Repository configuration.
// At least one of the 'baseurl', 'mirrorlist', 'metalink' properties must
// be specified. If more of them are specified, the order of precedence is
// the same as listed above.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// Enables gpg verification of the repository metadata
	CheckRepoGpg *bool `json:"check_repo_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Disables modularity filtering for this repository.
	ModuleHotfixes *bool `json:"module_hotfixes,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// SSHKey defines model for SSHKey.
type SSHKey struct {
	// Adds the key to the user's authorized_keys file
	Key string `json:"key"`

	// User to configure the ssh key for
	User string `json:"user"`
}

// SearchPackagesRequest defines model for SearchPackagesRequest.
type SearchPackagesRequest struct {
	Architecture string `json:"architecture"`
	Distribution string `json:"distribution"`

	// Array of package names to search for. Supports * wildcards for
	// names, but not for versions.
	Packages     []string      `json:"packages"`
	Repositories *[]Repository `json:"repositories,omitempty"`
}

// SearchPackagesResponse defines model for SearchPackagesResponse.
type SearchPackagesResponse struct {
	// Detailed package information from DNF
	Packages []PackageDetails `json:"packages"`
}

// Services defines model for Services.
type Services struct {
	// List of services to disable by default
	Disabled *[]string `json:"disabled,omitempty"`

	// List of services to enable by default
	Enabled *[]string `json:"enabled,omitempty"`

	// List of services to mask by default
	Masked *[]string `json:"masked,omitempty"`
}

// SubManConfig defines model for SubManConfig.
type SubManConfig struct {
	Rhsm      *SubManRHSMConfig      `json:"rhsm,omitempty"`
	Rhsmcertd *SubManRHSMCertdConfig `json:"rhsmcertd,omitempty"`
}

// SubManDNFPluginsConfig defines model for SubManDNFPluginsConfig.
type SubManDNFPluginsConfig struct {
	ProductId           *DNFPluginConfig `json:"product_id,omitempty"`
	SubscriptionManager *DNFPluginConfig `json:"subscription_manager,omitempty"`
}

// SubManRHSMCertdConfig defines model for SubManRHSMCertdConfig.
type SubManRHSMCertdConfig struct {
	AutoRegistration *bool `json:"auto_registration,omitempty"`
}

// SubManRHSMConfig defines model for SubManRHSMConfig.
type SubManRHSMConfig struct {
	ManageRepos *bool `json:"manage_repos,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`

	// Optional flag to use rhc to register the system, which also always enables Insights.
	Rhc       *bool  `json:"rhc,omitempty"`
	ServerUrl string `json:"server_url"`
}

// Timezone configuration
type Timezone struct {
	// List of ntp servers
	Ntpservers *[]string `json:"ntpservers,omitempty"`

	// Name of the timezone, defaults to UTC
	Timezone *string `json:"timezone,omitempty"`
}

// Options for a given upload destination.
// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTarget defines model for UploadTarget.
type UploadTarget struct {
	Type UploadTypes `json:"type"`

	// Options for a given upload destination.
	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions UploadOptions `json:"upload_options"`
}

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`

	// If the password starts with $6$, $5$, or $2b$ it will be stored as
	// an encrypted password. Otherwise it will be treated as a plain text
	// password.
	Password *string `json:"password,omitempty"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// PostDepsolveBlueprintJSONBody defines parameters for PostDepsolveBlueprint.
type PostDepsolveBlueprintJSONBody DepsolveRequest

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostSearchPackagesJSONBody defines parameters for PostSearchPackages.
type PostSearchPackagesJSONBody SearchPackagesRequest

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// PostDepsolveBlueprintJSONRequestBody defines body for PostDepsolveBlueprint for application/json ContentType.
type PostDepsolveBlueprintJSONRequestBody PostDepsolveBlueprintJSONBody

// PostSearchPackagesJSONRequestBody defines body for PostSearchPackages for application/json ContentType.
type PostSearchPackagesJSONRequestBody PostSearchPackagesJSONBody

// Getter for additional properties for DistributionList_Map. Returns the specified
// element and whether it was found
func (a DistributionList_Map) Get(fieldName string) (value interface{}, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for DistributionList_Map
func (a *DistributionList_Map) Set(fieldName string, value interface{}) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]interface{})
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for DistributionList_Map to handle AdditionalProperties
func (a *DistributionList_Map) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]interface{})
		for fieldName, fieldBuf := range object {
			var fieldVal interface{}
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return errors.Wrap(err, fmt.Sprintf("error unmarshaling field %s", fieldName))
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for DistributionList_Map to handle AdditionalProperties
func (a DistributionList_Map) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, errors.Wrap(err, fmt.Sprintf("error marshaling '%s'", fieldName))
		}
	}
	return json.Marshal(object)
}

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The list of composes
	// (GET /composes/)
	GetComposeList(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Download the artifact for a compose.
	// (GET /composes/{id}/download)
	GetComposeDownload(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get the SBOMs for a compose.
	// (GET /composes/{id}/sboms)
	GetComposeSBOMs(ctx echo.Context, id string) error
	// Depsolve one or more blueprints
	// (POST /depsolve/blueprint)
	PostDepsolveBlueprint(ctx echo.Context) error
	// Get all of the supported distribution repository details
	// (GET /distributions)
	GetDistributionList(ctx echo.Context) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
	// Search for detailed information on a list of package names
	// (POST /search/packages)
	PostSearchPackages(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeList converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeList(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeDownload converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeDownload(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeDownload(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetComposeSBOMs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeSBOMs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeSBOMs(ctx, id)
	return err
}

// PostDepsolveBlueprint converts echo context to params.
func (w *ServerInterfaceWrapper) PostDepsolveBlueprint(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostDepsolveBlueprint(ctx)
	return err
}

// GetDistributionList converts echo context to params.
func (w *ServerInterfaceWrapper) GetDistributionList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetDistributionList(ctx)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// PostSearchPackages converts echo context to params.
func (w *ServerInterfaceWrapper) PostSearchPackages(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostSearchPackages(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/", wrapper.GetComposeList)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/download", wrapper.GetComposeDownload)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/composes/:id/sboms", wrapper.GetComposeSBOMs)
	router.POST(baseURL+"/depsolve/blueprint", wrapper.PostDepsolveBlueprint)
	router.GET(baseURL+"/distributions", wrapper.GetDistributionList)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)
	router.POST(baseURL+"/search/packages", wrapper.PostSearchPackages)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPbOLL4V0HpN1WZvOi+7aqpfbJ8ybZ8yUfsVcoLkZAEiwQYAJQsz8t3/xUOUqRE",
	"XXEys9n1H7sTizgaDXSjb/yZsqjrUYKI4KndP1MeZNBFAjHz1wDJ/9qIWwx7AlOS2k1dwgECmNjoJZVO",
	"oRfoeg6KNR9Dx0ep3VQh9e1bOoVln68+YtNUOkWgK7+olukUt4bIhbKLmHrydy4YJgPVjePXhLnPfbeH",
	"GKB9gAVyOcAEIGgNgRkwCk0wQAhNPr8UHtV2FTzfgo9q6MZ956BZbDqUoKZEH1cTQdvGEkzoXDLqISaw",
	"BKQPHY7SKS/y058phgZqPQsTpVN8CBl6mmAxfIKWRX2zMWZlqd1/pgrFUrlSrdV38oVi6ks6pTCROJb5",
	"ATIGp2rtDH31MUO2HMbA8CVsRnvPyBKyn17fredQaF8o1PPvXmAIeAr5mQniIlNIpf/KZadTnECPD6l4",
	"0rsdhcmdZoKvi1AlIywZ1nVo7AgofE0lMURBF8chgi7O5K16KV/bKdVqlcpOxS73kjC2JYrnFiPnTa85",
	"A53SW46A5/ccbGkS7kPfEWG7OEm3+oAjAQQF6jP4XQwRMF2AIt6PaQCBQ8kgDWiv73MLCmSD2+uzLsEc",
	"MCR8RpCdBS3BAXrxMINyaODiwVCAHgKcUoIYEENIQJ8yQMUQMeCrtXWJgGyABM92SZfMYBHMR3JaPqRM",
	"ICZnA5HJACR2l+D4hJgDCTuHLgKQq6nk39HpwGy22Rb1KHUQJG/f1M22c9lR9JmTzIqjU8hGieO/+gy9",
	"5bgMpx5iT+OnASJI4zN2dFJ3cvnxk9McUsqRwvFdG7RceS8dy2HuwGyUNLBxv48YIgL0ERQ+QxxQAhTA",
	"AMr/jSF2YM9BXWIjDxEbk4FsIcddGE5vHCK+K7GhgLorRjAyo08s4QlZztw1Jo8I7asp9MFANlAd5CkG",
	"rs/VwfUJ/urLu1Y1HOAxIoAhTn1mITBg1Pey6szKSeTpoy4WkjT6jLqqi9w5xIU8yAwSm7qAEgR6kCNb",
	"rhCC29vWPsC8S8wKkW0WGOWQCrAkFuRQK7JT0QWemS/BIj1Gx1guMgD/SYGfBpMhYnoL1SyS3nzHVosP",
	"8AKJ7DbAXCCm4DumE0miDuYCQMcBARh8t0uGQnh8N5ezqcWzLrYY5bQvshZ1c4hkfJ6zHJyDcu9zhnf/",
	"Y4zR5A/1U8ZycMaBAnHx/+BrwNyf5ERP4SQfFMolxMFPEvWECsA9ZOE+RnYaYCF/tJHtW7ENWYKHeaRL",
	"eke+pI9kzh/tu/p0xY/LBuieB+WG+hYk12aYIzVj0v3t90IQnrC9CFRrX4IUbfYdwJRRxa73ilYG9orl",
	"TLlcKGV28lYlUy0US/kqqud3UDEJOoEIJGIFXBII3WgzqMwR7GNiq73WFKp5yiVlAjqbnMXgHAo8Rhkb",
	"M2QJyqa5vk9s6CIioMMXvmaGdJIRNCOnzmiQ55BUsWqoX+lVMwWr1M+UbZjPwGqxmMn38tV8sbRj1+za",
	"2qtkhrHFvV04gWsuhGUXTpxDbsJy5oCMDJAEwp7jI49hIra8iixKBMTEKEFzd07wTZ8OLk8BcnuSfRMp",
	"NgyRPBTQAZCJPrSkVBkKqr8x1E/tpv5fbqZz5YxWkQvHTRJgLZ8L6uJXGF6sq4YKl92Md/s2d38mSM42",
	"5oLRxVXfSJFMfsM9X5GuoMDnKBRxLK0FZUGrDxzUFwC5npiqT0PKRZfogcEEO46iJL5I231kUwYzpZ0k",
	"AlbnjCfpotZIEqn+LsHqyfuSC+g4yN4U+WYUzdwS8O9S2zdaZXz6BgHQwUbW8/QoPC2lRLmXtvq5B63R",
	"BDKbKyxBAXvYwWKqVr8NdEmABbSzgK8AlqUYeyuukqAZI8YTpYEG4MgdIwZMC0CUGh/b/lq2lq3l15L8",
	"emJvLhDLNqQPLcTEemptNGWz2FSafjSXxkmY3599lMi3GIIiFO5CpoG34RrBkNOk7ejbdF3/w/0L1RIn",
	"nu5D+fOPAjXcHzlqIrhytikXyE0QJ6WoR/tg1ga4UjTzKCYiAuJ3AWMmTQQpieccEKksgMPWZQe41EaJ",
	"ilwfMzSBjrMFJKZDwO2WY2HG7LZb9VL+Jnl0sqLSpKSPB0pnCpi5apik7wwIDi6WVVC0gnbKFqe4j6Kf",
	"JxuNsbVGWYp2ALpDGlg+k+qdMwWUOFN5ufR9J7ybkD1AGY5dz1GyeSbgeAzIJcxdQjkbjXPchokLDDqu",
	"XWHY8Fs6NUKMoLXH4FS3MjqVg9a1P9OtvqVT1EOEW9Db+KBdeIh0mo1LfU0woTYDk8GTOssxnRv6gmac",
	"sbugeXeQgywBhlIK1qLByEjLwQ0fjozsLPgQDPRBf5eiA4MT4BMHcd4lQoncUheX6illwKUMxSgcS20B",
	"W0NgQY6kxB2Oc3bXzoIPamzoTOCUd4nPEZe/pwGSGvNkiBTjMlMQCtCLYDA6fhZ8YHDyAaieErIQfN4l",
	"SYMsgTNuHWBwkkqnNP5CVH5JVOg8yvGye+M68lUS/YRhgeQ/ckhYuanvZlX/rJ2Lc2hjTzinAkkUQyG/",
	"8QAJQglhAArQ87FjA4FdlN1cKAmPUwhd4h3EhtxdN9T1cae9cJMyb32/y8VuHDHJE9aC3wnayT58OELT",
	"5eyW8yEYoSnfFDWdzvEpSsSGxPErJWup+yZo9y2d8rlmOMmwya9vuf9ueZLG8W2VfKXu7wQRTysp6ope",
	"JzPocxaXvGwoYLK6JSEP+L8aHXLgOVCOjF7EUm1hcTB1/82PBMEA25KWoTGRmPttdicwqpwDlKCLfmr3",
	"n4vSdvgLJgINJEK/aKUhyXmGmIu5FII50AOEF5WCCBNALQHV9eVCEQMkXy2Xk5brQTFMEvTFEIQqqRNf",
	"k2Id7tT8vjBi8qG7mBDte4vjzw/wJ3v9IPTNSf1qhV/WncqZ9Bg/Wi4myd5E+Wt0PUa0xAT0pgLx6DKK",
	"hXKtXC9Vy/V06iUzoBkDio+JqJa1khhcA3FrRm4M2Vq1JtI5HcK7ZsEzAXOlgjMv0+tuNrCMaKd554L3",
	"hho1KJnvqM/gd6n1UiYAg2SA+EdlqvUYFdSijmJLUjqJovGfqWJxV1heKp2q580/sAs99c/tnHobcvpg",
	"wVGOL3mrtkBtwiyDER5Vr+2YZShsLRxKye+4YAi6ict95pQ8CYgdqn5ZA2IwzUnn4vwm7CRZA3WwNU00",
	"fF76QlJvaLQGui1o7QdMW17MQPJrngZcMhIoACRTLYQTS4pKoVkeCNol8twOhoKHUqCUelwosAUdZypP",
	"HEHKHm7YklyJg+VQweRmZosSTh0jjxhOuJvyfWV8XOR/jErqNatcPDnbYjGCwXk+NJtpJXFGhKKFje9B",
	"jnzmxM/fjF0ERmPLJlmG7CHUBmNLX4Q5G3ORY0Pk1HP13Eu9+lQt5+SIlOcoz8WwxXCiKXyOjpDSZqOY",
	"i2mxDlpqYxp4A2uIrFFy14E3UEJTdJVrgVmygy4S0MFklIwpFzNGGc9qA6LHqNyOLGWDXNDvH1JA/iMw",
	"MBa7fj5frEJmDf/QGNwAbXoSB3OxCEQIg/yctRARlKv5/8GQgyBHf9QzmtQjM0P5/9Wy/kXBtwc5uuhs",
	"AosyRz4Nqejjl2RLE5ebyoFqCRkWU3m/CRSRN5QzOzily9zRy+2LDFM5bORjeHtrfeZp9fHg3BkjhvvT",
	"pM/zZv411HZrpJUt7HzrDOGDJI6p5UdsB9ZvyQcRtAMJItCb0wkYWWa/bmgvJu2DGfAR+w60be0jlpKV",
	"oFHxfnYEVfPCJrQ+pEk2nhszwQcOZAMQupqShkzUlKSGpMM9pKIUk/44H2aQXaxUCjug0Wg0mqXzV9gs",
	"OI/7rcL5zUFF/tY6Z0enB6z9gD+127cT/xheN07c6zPaer3uF7/uF+39ymt+7+YlV31JgmnRgySXU0gW",
	"lTmfUJbkBzSOatMAcAGZusnEEPxW/S0Nfqv8lpZy7m/F3m+hBaKHABdU3n+QdwkkABGLTT15xwUjZcGF",
	"GCI2wRHDRQ8BofQjW4vQM3WmS8J+UZqMBkohLfTNO9wHmAD10RzPRLk+6VhL8vmeU72pZT7RWL5lLBFy",
	"n0LDfESYzGQyewdHrXPQPLi+aR22mo2bg0wm0+2SdqvVzO83m40eHjQmrb3GoHXbymaz3S7JZDIH5/tz",
	"Xd4QSDcDLnH1kSjBPWor6pnpQqvEkYQoQ6VYRn+5RtyjxMQfOs4Go14oyK6RComxkNK/5tyydpyYCsUS",
	"KleqtQyq7/QyhaJdysBypZopF6vVSqVczufz+fVi2iY8PVzdzGP8/Yta1T7ml9bTany27P8gTOolnRmZ",
	"ZbNFqdYJKwlIY0Nntpo5wO8a+tFDrl4DHfAfujEqcEAZPhMlVANCXNWXjI/1oYX+/JZ0uY7oM15r5qfP",
	"WK0lOZLBALQSFW1IcB9x8UPx4UYHfTsy5o0b4eirV4YEDKyAP2phVMrd6MmirotFYvDP70PIhx+D207u",
	"gACmefo7/OpansPEcnwVR3h+cHfd2NK3HiJiA1tDBH/XOthv7dVKqNAh2rMdmgswSad6YejMl2/zl3Ev",
	"GlazkZV5+xiWhNCVSPhJnKtKbThTTy0NwWQzvKz02snGAQ7nO2/O++aH+V42sUBFMQREtr2zd9H+scwx",
	"WOaimiDnAja1fFcZ5aUmqdIvtO9PE09owtEhQdGzv9GAs1BX48A6mM3gc19ZkoZK2hZAatcCiAlVA/G0",
	"8ssFg2i/FiJjzCiR4yvzZKRFl0BL+NABxrgSOpnVvJsSrdpwOX2ix+eNF9+PEISSrj4ejrt+aeEtHu2K",
	"tqSIZbKAJogN4ZF0MRtosz4xRN6pXKD5fTADxRe4yb4cMEZZgmkXCYiVgW/epBWzkUCeaHxYFO/CxgsA",
	"6PVIbmhczty3LMTlWvoQOz6TWqAJaZcLiujlYcMFrjkLRVxY2Ypo9oWIwCBOMox9XhpGrmNJkxzf5hjP",
	"7MXBoEHUZdzTpKzRbJo1PynDqZp1V8BBooHE4U8zM9Si65FRB9ycdYBqg/vYCpwl4aQqT2SdAcssMFE9",
	"DJb0ltyJFdsS7ocxN1jx+NW58BfKFdNMRBUcJLBwONhyBh1dn6jUrMNNhBduYejDA3P3z5tI5e8Bxw8k",
	"1IWcjNliTEJIcMaSjTMmhWbO5Xa1f56c7DGHm68+nGYxzblTk3mQM/uxuwJr88k56WDJiadNiVUbeCf+",
	"TZwTyoD8NPAGyUZk/TmwNie3eZN/w1g73x0YP92B8cN8D5w7T2/1LPydIcTx5IMflTvwtDrE7EAFxEXb",
	"xCLaI05iTEBck8uCmyHiqEtivaOB/vKytpHHqTNGJplLMIzGKBw/Cxohfp1pWgUE8tnnmakdjk0+GHY9",
	"yiKe5H8txML9a+bH6BLDvGdMdzO8znPLBPTORXz/LVHbG0YxbBJ2vfFQ64OmV47QuuxsEyUdhGAsUMsy",
	"v9q/Vah0NLPpPYL6l42gjgdOz+yAEX+UR7kYMMS3C2V6j8L+t4jC9uBUCud/y1WpyG7j+7JLAtK86AAs",
	"OHL6qmzCVA9GqMoeD/Pa5yxijFIBKOsSSKamOIFEdNQErqL4LMT5RwVzMPETR4KDPkaOHYy5sBzMAR4Q",
	"yoIEv43Y7X9AEHkkR3Ztv2jbN4SFb375bx7mvX9+eOn4A0z0dbaoIK7QpxLHMwd5U+fEXHUUZg2xQJbw",
	"2VyER6j3LJDx97knvse9MM8o3nzU57ST2Urm4EvHEfMlhudZQMBcDMXf7rqKR3QbaJL0r5mAvDzPIJTu",
	"vyfZABHuM/TkQRYUvlpdo+ZAtQdBEg3QHUFE+AfoBUctNNFIyA2yEWar0SkJYSaCyUzA9t+SkjADa2Ve",
	"Qq1S+b68hGio2UJygo3Zd+YmzGEzzEswaQo/ApmbJijsR+g2iMSY9717y7niWz8vySSbakEjjATV6fm7",
	"kqvsKglSu/l/bC7YnOtdCaqyDYjrQwHuFno0Ijxv0z5R9C/r8y2dCh05P8rLZhlKW6ywEPUNyR4wUjEl",
	"4YbZzElk6TRk03xu4GRHllry3xAbpFH9Ftfo4f7Ftkkvrf0Lo+sCSnoUsnXpLzZ+cvuDJ43uJwnEkwut",
	"J3mhLNlX7JMnz+89jdD0aQj5cH0rTDiyjGCzuqXkULP4x0VzKiS+vOl8BayUXhF7WlrNa4FFKWPMdgjt",
	"6ESpMAUecCRUXaClsuK6+1XHq6vyaXNjp9IbCZq/QFriT5Q61vgj31Mi/3tSItdkQj79aqmQT0tzIZOt",
	"wu/5kFvmQ35bgdpOZNTvwmoAlorY0IVTKJPypvxnwrXLIzdGYjJ+ZLzZKBF8CuQQJLbDXeyeWjerbhyf",
	"tC/kxhHhbZlGsBTvj0GG6hZI38PEBjBMKCJITCgbAR18otOJwCsl6hpkSEJlCSAY7PexpaJ0ukQMKUdh",
	"j7BOpLqWkRCYDMIrT46UdGEmO0dIxAMhe6YBXqgUFkyrbJjQ85ypSiqNloOdTbokiGgFiQbDB3eLsqQt",
	"DU7s+vl8ydJ91L/RP3P6Nxfykf7ly//pX9qNpv7h/7DHkdjVv6p/69/XhzoknYWj5uVbgoJ6vjVCYrkz",
	"CBItPcj7tnPTON9vXO+DjqBM6mWWAzkHe2qI7Hw9UPNHxsywZe3Tm6HW3uYjxkKXrmSaqsSyDZrU9XyB",
	"wAEZYBIEZnbJTVicUQ00Vy51gsXQyHdHzUtg4inSxnWBudJ94yZ0HVyqK/TO3MuqnF2ssGdYR7VLPpgA",
	"V5aBHs7oLfd9bOsd/xBIMmY6KRaIGNTb1FmdVQVeRKVcov4eqVwZrilwBEX95RH8Sqo3+FSVlkNUQvk3",
	"ttXoQZnTLOggBMIQIIf6dnZA6cAE2nF9dFS1y1xYLdUUqI1XR1UhV74jcMZAHlZStRzKEReBkGboj/xu",
	"ipgGx1MfzLDbR4lmS/IuEk85n0cy8reoPZ7MRgxe1LpB0FzCq0aJn+Sk46uOZ7ZLVFSzOSQK6ybwI5KS",
	"HwqWZhplLcmCOwWBFoY5gAztdgkAGfBBCpu7fyIXYgfb3z7sggYB6i8AbZshzrUqwZDHEFfqSziXJYcA",
	"c8vKgkPKgMFeGnyADrbQ/0aCKz9kzczmfmzoflvCoKc2Qyyb251mlKsqAz3vf6HncY+K7MB0CvpEQVKa",
	"y7bYMOsPavJKuOZQYLuY8EQc2NSFmOz+qf8rJ1TkCTo+FgjoX8HvHsMuZNOPi5M7jp4wyPc1Ny0Upu88",
	"Rmak90GKVB/mYEqmutVHM6hjrJmDSn2FZNolAX67c7KrOnALpyIVCqPBedh081JGT91dRHMqnTIIjv74",
	"U14/CO/dH1e3Vt3Ncvyn+ZRAyC1EbEhEpscgtjOlfKlSKK1VkiLDpdeVwT0KVP8thIfV+e+GLWnjwMyo",
	"8jv19PAfE3Pg15dCnxvw+4uBtiKRNFtI0EG3Nbqgijy3tb6wSZzOQdBeRzxx0aNUbNr5MOyQKCQuzLF1",
	"qWPj5V1nYFbtVuH6MLqyLUBIjJm+ZHSMuQ6JAbfXZxuFPidCF03H+vnOZ02K+ucNsmJupp4OH9B5imsj",
	"kDo3stXPcD1HH9wxNsn8gtXX2IjUItOhbSgL7oeIBA9n5KOl02UHLC9WFxPs+m6X2KivKiP3ppF2Sq6J",
	"Xy7l4k55p1or7lSXGZm0uP5EvY0SCuOa1Ky7eY8jWbZW3imVNKb7KV1FCa6eg+Zf9DB5agK5QC+SdwkE",
	"HHmQSeZoWttIalxa2FUXLBYc0AkJpsiCthm/S2YPV5g5pBYxQVI75jMwgm+Gh6rXR0bKFMBQl3Df0zf+",
	"FtE4Glc3aty1F2mMSmIEMHdKvwTUqHLlFsMTsIccTNZqjWaZJjMCBN2Mdjc0elYYjqVH6UmFz+iEKuUw",
	"LHudTbysA1g8nwWvOy2CYz6GT1yYTjpi6l8KPEap+FcERshDx6s2bCzmKNo+kjxvRhyqiRlU/TIbUIVe",
	"BQKkVhSW5zOCfT9MpCLqHRRA+13CqRslQ5428XUuVAFp4TEL5owdtC4xSMhGAu7ClQfHITHajveou0FO",
	"aOCp+SDbq3P1wag+2QVX7soM9bD/ClI3K4sBkAXNeHBs53L/s2RqM8qKrJ179kvCcufzwXpaSg5BSs8d",
	"/4QjOCOfJVIpCnzYG2dDhq7YrbNBTR5lyEU3GyBedWOu8xb32Pw4K/lTkM0ZR99WiZNpfaT1PzXQ+t9B",
	"+TuTXblwxiN3fGQqOJHTwAnPDGGGDX1s/or8k0Mv/PNVA6MfqEHQq8W+xP+I9FNB22EhA/NXkCdifpjF",
	"Y6dTA+V7GFjhAAMpMoUKjY4KiXbAVGSkuAd7Tnxo+SGcWP8R/zg/CoOT2TxUJIaap9IpB4/jECihAjoZ",
	"HeFLLQn1mHuSfc3+laFjmEqnJtxZskWSiE9Npbo4RS0mWHyHFbcVjXmPj899m2YIVQWf7O3yzHwChUDE",
	"3jwQ8zSMot9GBPYkDSS41dXvHEA2MJn75mKRB0JlODKgw/ZVLQ0pQklmFrPFEcpd8UefMgutKuq1XFs0",
	"E4TVrmZD6y8ZG/X8wWappqemKsN3JN3Opj3U+XlNh/p2Zg/yJbZclVEX71nMF/P5nXwtm0+0T6qIjuTc",
	"wRF9xgmJg/Lnod/bJOUS8tG8VaJcTNLfI897zOAorX+VzoA/m8ps7mzEGVa+LNmboADQvCFGEq/Jsyeq",
	"wMtCIBHRbEi3XDb8sjtV8f1NsJN0ppLD/aRovuTJlgFaktJoNLPFL4IK6CR9msOCmjQdPruqXzvVndNL",
	"Y63S6hU3Zzsf1Koxlr6BaeJvnoKojTVPV8aaL4UbbWn80Z3WmH5GaKrCxxY5UwcZGTxoAhw4pX48XMVP",
	"LLjgQDLwk0OzA6+DzmlaeLQnbeI1mGxFEOghi7qIA2NlTqv31tBXXykDUnaHDAGOLEpsaHLYI+ZcRJ5u",
	"O9nbm8NM/a1+7Itm643nJhzhpzxXaSwpu38mPP2FiEi0STXUI6BKz1Tua45EOvTv9SkDfSSsoVTezChZ",
	"0JKCDDKehn/5zPmX0hyQCDT5dJdoxTWWMKvMDCaSXikdS3zeOiAsITwNEjkWwiq5B5p6VuB3s9e7IF+s",
	"5su9og2raKdS7tmlcq/eqxdhvVRBFVir2cVeNd/vw49pHcbUY5BYw4yDRwiwsCrHbDw2RM4s5V/Klh/n",
	"PG+LLZIvx/5i8sUG3UyC0Opwun0kEHOVCjsZIoMa7c6LPUvoQgIHiIHfLUhsB3mYfATYRkRgMdVvwOrz",
	"paIToFIbFurpgiYl3HcRA5Y8XKpyyHxaNOTAcrAkzXibISJdEp6l8BxIISo4WEvK9W4e8zkfwbxACEOz",
	"FYsWzuTba8m1llTMxlxGaoZE2lxaM/29KPovWBQ9eRsSla0l9/+axSwHJz0bdRVkK6DiKsUWba2dfU+/",
	"JDoNXtv7YfWAAmOlSfkSNBAmsuAQOwgMHNrrmcCV0MKV7hI0yIIPKlOaDzP/82GOuwvXT6zMvPRFwAvj",
	"KQxfBFwBV/CmZM+BZKTrtul6OJEM12CY2AOT4B47tqWeXlRyT7Acs5pytlDILiyllC3B73c8mv3aD7M8",
	"EnxKiUdBaRoCu8uyRlaXK0ceXTKugy1k0gGXqtirdNSEh35dKVomfku+f2LHYAO8JumFOuNxFcq/x8ud",
	"TCexN0UXg7chgUp+zghKHf7moxKterrhWVFlj7jvriCrgI6CpsDnkqgbZ0cXu8eNzrGyoccLtQ9hsVLd",
	"rRQrtXrdRiXbLpfLOzWrWLPLhVqxUq2XqtVeMV+q52G1V63la/08LOzU8uVaCZVt+Y8qLPcT8x6Wns7v",
	"O4F44NqVZZ+0a2MFu33L+TTG+rXHVG6v73hay3hTECfkKDmXYc98UcrCLDvYuI5moujKxOXpyhxByYSV",
	"3cR43ARDKNAl1GMESyxVTybASl3rK81P8wnPwWoT6WUOocv0QlUObCPlMGyZNJ0qKLAkB94m/SdPZcnz",
	"DXL925CEWfXcDDn/YrrROTYbLRjj2zKw5/MhlsV8rC2osGqiy3Xz6LPzFLwCs9q1FFrhkyfb7MDGbDfZ",
	"LmkEFWJVoRAtYXwwFe4+pMGHWdEz9ZcptvYBzNahQjO7pIdmKoESSFTJET2iq4WLeJwdZbYO3/QYspCt",
	"1GWsa6xoDz3kKlBfqoE9Ok6MpI+U4vvrKvBtXXFvs8S+gTcwRTRNoK/ZjRknChXdJbrtrBrfXFDa5REY",
	"oWlYOUVeATP3v1Kd4qp57NbLZMInJC6PLsHl7d5ZqwlODx7A3tlF81R97pIuca9a53tHDatj0b2Dxv5Z",
	"v/5wPEKvJ1VoO+2HSQ0eHbWcE+iI+slz8SW3Vzz9NGz1W/7LkfDunmuoS86uB/u3teozvKl4d/sV97B9",
	"UvJGiKDrnHXjfv16NTqfXvHh5yK9+jw5eL3t9ArN83az3zwajD7Xr4pd8vo4Yi2ryQ7zV8UJO+050LeH",
	"t5/wHSSNfe4W6g8HX3mv0rgt1Wxxy9qlqwf7frBz/ekzvuzf1a+75HTv+SZfGt/tXdjtDn8o7ZzBJqm2",
	"vMLF2Ku3DmiuhQ7uHgpf3ebFZQOe5nsnxyW/Pyg3fTTin246XTK5ur9BzbMX//GsetH+TC8uTyfj9lX/",
	"pTcofN6vj/3H/Kl4zlnnx8UX6OdfXN7wd45PPDQaX1xevzhdMv0qnqePfUbvMDqcepPHwfhqIghp13OD",
	"zoGfO7m7YQ/5StE9uL2pNa1erTyyjg9vDvvtkUNGR7kuyfdvy41rWMmXj0svz/mR6KHS+NS6/EwvL/zT",
	"vTt+3Bnn87dHD43pJfKnn+o16zb3cDBs10alzt3pc5dUUetxMMXti/zEKTwc7V+fWr4zGfGdxiffGQ0K",
	"9KZX5qVX93F8ma8d0ZuX+3LxGZ5W7jufzoePCHVJvZr/TO+GPatw6nU+Pfcf6TNnB+Kxftm7ffz0MD6s",
	"X3vMvm+w5+Peyah44l2fNl5uhi/8qsH3hkeFLsmf+S/Fe9jeyw+Krcql1bZPctbXZ5qvWxZ73vvs45d7",
	"hivY32l/9upfb3L9zuu5y+3WgNRzXx9PuwTXr3yn79dq/tfhfW4iij1BsBhc86/Pw5e2//xwW37slYcj",
	"cVgfnt7mPn+ulYtfh2eV00njunHV2OsSsX949Hh/Pbbcg8Hpfrtw2mnUH927Ua90Mjy7aRfOPu9N4X1h",
	"aBGnEfxuHZ+MoXv3bDcr4y6xXOsTvjq52Ntr7zUbjfIhPjhAx1WXDQ+Pa/4dvzprt4v5h4r1OCQvD/XD",
	"hqtoqHk0qR82J6NWl+xNWkeHV/Sk2eDNvb2HZmNy0DweHDQPy41GczC6mvX+dP7QyNX2HryBM+00Hh+O",
	"h8/T02GX5D71q6+X/btx77iYP/haGrVqF4d753ly9vnT3m3B9cedT19v/E7p/oztldzSke8I7/T64OT0",
	"TLiVg/0uKbCj188NelOYejsPrfpZY99uN5sX0+fGM6f3t/Xaw63f/JTrkWd2g66LZ9cXzf70slmr3u/U",
	"K/jirkvcSudTj1/tT2rN4hlz7Ea73N736fSx0MHiCD6WT6/O7sSnmwNYKGP+0DlqPr/S2uVD/a50cjGq",
	"5Ltk8PV+UC+e53pu8eC1U7upl+4P9nsFZ/xcbjnjl0Hr6ykaFAqvnx9eXPbQeTw5afbHr/1Pznmn6r8M",
	"jrvk+SV3kp86j8Uz3Dti1aNGY3qxc3vPGo+dSaedP7Ceb+qTgyZ5GXX2/elX935yNz7f++wftO7qF6j0",
	"0CVtfFvon5zXuV3b9/jhS6X96bNN2uSq8+mYPd9cnu6X3HvmNGxycDO0H+7qz48j7364P+Wl3M4OuuiS",
	"4SjPzsg0/3w+GUG/n8O39Qur+nncHj2fXbdPBpXbnbvT6Yl/fy9eJ5/Jc/u8cn99uPf1tMwfqdtud0lf",
	"9G6OC58q0971fa5RGu/14Mv1fVHUbl/Pn61XNOo8HmB4dr5zlju2Tpqt68LVYb1aL+7bDefgcMfuklFx",
	"cIUfOlcNCE/yJyeN1+Px9ej65OxscFp8uHrAx+d306IonUwP+5xBtzLpNO8v+sNL1Jqe7d08nnTJmHnn",
	"zmUP9fnNTqV20y/unbf8wesja1buXvY7p6PHwfWwcHc07rSuSHP6OrqaVg9ui18vPXxf2ZE8anjZ+vzI",
	"Tql1Wjo96+zk8OvJ1c21I57bjT+65I/L/k1NPUSknyJacfUsqRNIGXri3Em+pN+rza5/Lm+lo+BHPZ8X",
	"LZuWaI+T4wWquq6tptwtEakIcinQcKBUrki+jirZ1iW/B3FiHxPLty1kbATlvemWJQp/rIcl7kQBS3wo",
	"GxZ+MM9tb6dXJ4qSDdsOXbiBNd48jAd9MaQMvyJb6TOL1QM2eueu0bnHYnRxXL6t18oHNt+7JVPRK/Um",
	"4+vB4Ni5cnoPn50aKeTHO0vqiycWIbjVrwOG6o/OQjPPlssjFbdf2S4m6+PpuQrZkHhK0o47SNKjMWHx",
	"vy6+/nvKtC0vfNaQx1tpaYYGCXS1k52r9UncZUFH2405+B8wCQ3KKoJXNU+Dni9U3pQkXmMT4nPh1usJ",
	"7CfXkguRsL6U3Pzebl9QTpu/1RuIGq+YaCYtiV+9B7F/frhlZbnApP6mwnIblzP4AWUJQG8aeTwxoZh+",
	"UPzYTr5ASUt3KfyQegVroSF9FcnJtwbGhXy0KSyy7VpIdAWHbbGSeDVEzWWLhsINyorqEaK2MH0XWogJ",
	"e4vOsvkqa9oSM+EizTFq+2Ea4coi43OFPL/T4rgwzHLo5xe66NDwBX0yD2jAOV/W6it+fhcSiugR/VqX",
	"R/kWo8a8anPAWgKPdQ01IyzEEj05shgSGf3cbSiBhs/LJtUlhRw9JdrzFs15G0i1QVhBbLhl1Z8oG0AS",
	"MdRGI0/L+VKxnBxVY60X+UKPU9+Bg6CkAxtausiIDoSIlPUKqjBAh1NTKdowKA5aZkVzQuuyNcXrnEVf",
	"Nppta1bSagSxa/E6d5nE8JaePxMxGCIbHNmcpEvoJlLud4v4xKDbmghFIjwN1YpoQiI8EDSKqQf5LKFM",
	"DDPQRQxbMOtR6mSJ8KR6lkqnCqs+b6VPREseL49SCFqlgwtDXSK3N82YQHvbyR1Aec7IZrHei/44Mt34",
	"Od75PMK1fTql7bosVH1ZO8erz9B2XZY8OrWuW0I48LouC3Gg6zosc5t++5LMeQKVWb8YuJhkqaqbYA74",
	"kPqODRhSQVc9VTv+oq9E98VN0jmrKnZWqCS5hL3PAjWuiyAx8Z3QcUBCQ6BPHu8SyJBmfFolXpgXhm0N",
	"lxxjqiJdtEtJAtwlzHeQriTPUJ8ylAYTBIZwHNbTUacZqBw+uboeAnACgzKCWADMyQfRJR7lHPd0UUQX",
	"v6jwQhcKa6h9W2Y/gKADpchLphzSzjLXayQXd5snrufyuTYmqQ17zNdz2IKgNuyR/FDZxrSxYfslDvAt",
	"qDb64PX2KXth0t8m6e0mh1jnty97b9GEUwTH5svcAdsySY/5hCzLxIulNC+c260X9Mbs8+Sokrkhvyy9",
	"upZnFGZ5KUzlCxIHo9l31MJZw2J0JSWJQN/xsqb+gHk8JRmFxva0TRWR8HWeBDVPfSxs8grcgvy9kbHt",
	"nB2dHrD2A/7Ubt9O/GN43Thxr89o6/W6X/y6X7T3K6/5vZuXXPVlVf5ZNHkDsUKygclI/YvvSwdRjboB",
	"4AIyFQkshuC36m9p8FvlNxVi/1ux91v4oEoPAbk9KkS8SyABiFhs6gllUNEjZcGF5MoTHHmHpYeAMG8w",
	"qiKks2K0XRL2iwcPL9dXNotiU2K45TMsph151PW27yHI9FnpqX8dBtOd3N9IoVm1lMK8bheOKnUhXY8b",
	"kz5NSrHRJaIENVZuVapNh4nqFHaeTcVCHvUmphoetIYIFFV6nVIYQm/IZDLJQvVZuSBMX547azUPzjsH",
	"mWI2nx0K19FCq1AH4aKzp6Y3ydQMqFpoAHo4EhS2myoGjwvJD7upUjafLaR0aVqFppzlUIJ47k9sf1PU",
	"klSt7wjp6CvNM1XdPmAYnTw3KlgcieBBSW1cg+Hjy0b40W86RKzylCmD5azIgCq4gykBisUiW2e1h2XE",
	"W7YGpSkh7gTs24MMukgoVeOfCU+rB6VCAuAFBQNVLxATdfbEMIil2w2euQ1OnFb6NPuMU2GhWELlSrWW",
	"QfWdXqZQtEsZWK5UM+VitVqplMv5fD6/Pj5eipPMWDbVZhTz+Uj+j8l9dUy0Su7ZVGGfAbRSHIhg6dti",
	"TfooTuQRKf/AqU1K/+KkLaKFTnMyALb11IWfP3XDV1WXR0g5frAGRM9e+vmz35KZ70aeQA8xeTZAeLY1",
	"JOW/ApIRoRMytwWVv2L3bwl68XSWiSoTAailnnyzYyxcUXHAvP/5RdJIGO2timREmZBiXuF5UuPkgj9U",
	"veSkV3ebulAYBARNgq5p4FG5dBykw3BTlFTZjseIwYC5K35vVDz17Lz20WEWVfj4IuO6pFwYXm2YDOJi",
	"j9rTH0fxevTw2f/49SmZ2bcFflP40bO37KStNx9VZRwlfiD7b2M6LMDPO+d55zwbcx7DNJI4Dc+tFZyC",
	"cthBD2U6mQbljUL5KR0+zZ3uEqUEOVP93qySz/vKn5ksE+mBz/RDDD9PqIhMk4Dn+WW+09g7jW15uy8e",
	"oRil/Rg1ZQvNJMDkGpUkWtFqM6UkHPi/TC2JYSrhHMXx8q6avDOvX1Q1SZQUJP/SJpeofpKgKcgmM3Vh",
	"A34SYVb/RlzkJ2g5Ecyogf9qPScyfxiWlnCkVK1QNJkVNe+pkpq6qPQS7UegF5FTFtM4PPOo3Zh7lX/U",
	"BEm0+S0mH0u0xJ7zWEEANp0QKecuvcn3TQN1qsOn0TRh9THBfBi5xVdcyME4213JggJ71vGXu5CpJZAw",
	"wevxbQ7n6WECk7Jyk49xWP0leK1E+7lD/L/f0e939C9xR8fYSshVdOzG7DQv8ivHFP77Hq1jgV2BlToH",
	"FjNVI61sjSpYQ5JgLIAZ9qgvTPYq9x2x0iogwX9XStabNSSelvBAeQSS+Z+qQU+oyoXBlu9AZmpDg9/F",
	"kPqDoYm0OelcnH/M/sdd/EfqCaQB34CMXEhwH3GxnpbClhuQ0zUSPiNcpdcH/RQwyjpvxC9iSEXJo6ZK",
	"ftjYooqwwvqxZvuCVwKgAFFHrSn6rpPVIMmZvzPBcNnKClJshyh4p8e19DhD1jLBJLrdmwomvzitxclj",
	"A6KLlPZZTXNhrcdEKVs/0IZe5I0ZvYiYIj9kAxvpcsw0RmthUIB6XmMVZQRwvhPGesIIcPUusL8L7P/J",
	"AvsCb1rP73iPussFjEBYgEBHVcef2eBr5IYumWsOWdhGvcgxexRkqYtg76K95eUvYdKh2JrNgWCM/xJX",
	"gVrtEk6nPv63Xf+zRc+Tgo08Tp0xyvUcH3nMvH2+3My8b9rvhc1/jtE2mGer2JT8T5h+ub02aDPLF1aF",
	"I/7qqzLYwfcwlcUL85cxMwV7qCq+MZ3LElKkcWlHE+Cj99XCxbEfafiz4zsW5koilEgbEKsY8IsJFtBx",
	"wmfEgqq8wE5c3RTYQea/3Ds168pNU7Cb3Zq76pOWPGuSU89jLEunibRT72f81Pt3toYkdhFGahhkvPOp",
	"v0ew1xTw64n1MDxAkg7DRMDgNM3IbH3MDyRh4fuAoDVkswr6vSlQ8msyoW7uYUem+ZtE79JfLEgv3Ur1",
	"AUR/e6fidyrehorR4gmSlBsmHC2/IS9Mkzee+/lcsIWFGlAUL5C6uhzC6Om/oiVk5XIk6nXRqFy0LtJy",
	"/S9eZeknKX/JZbr+YhVwST2phM3SLUEAic6TDHRCe1YA6i9VC3kA1LtS+IsqhZ2wmJs5RMiO+VEoiYhE",
	"sVJwGqCwnsqCdNKGmIDfTVEmTMlHED52GE8zhR7OqtdThrivS/xAD+f0o6rKh4lYxtiTWG5cVFrIHG0I",
	"OMBksGoCLuAAvXEaSz92DGzqQlUmUE+zbpwv3/5/AAAA//9po7E9SuYAAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
